/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.misc;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import sun.reflect.Reflection;

public final class ReflectUtil {
    public static final String PROXY_PACKAGE = "com.sun.proxy";

    private ReflectUtil() {
    }

    public static Class forName(String name) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(name);
        return Class.forName(name);
    }

    public static Object newInstance(Class cls) throws InstantiationException, IllegalAccessException {
        ReflectUtil.checkPackageAccess(cls);
        return cls.newInstance();
    }

    public static void ensureMemberAccess(Class currentClass, Class memberClass, Object target, int modifiers) throws IllegalAccessException {
        if (target == null && Modifier.isProtected(modifiers)) {
            int mods = modifiers;
            mods &= 0xFFFFFFFB;
            Reflection.ensureMemberAccess(currentClass, memberClass, target, mods |= 1);
            try {
                Reflection.ensureMemberAccess(currentClass, memberClass, target, mods &= 0xFFFFFFFE);
                return;
            }
            catch (IllegalAccessException e) {
                if (ReflectUtil.isSubclassOf(currentClass, memberClass)) {
                    return;
                }
                throw e;
            }
        }
        Reflection.ensureMemberAccess(currentClass, memberClass, target, modifiers);
    }

    private static boolean isSubclassOf(Class queryClass, Class ofClass) {
        while (queryClass != null) {
            if (queryClass == ofClass) {
                return true;
            }
            queryClass = queryClass.getSuperclass();
        }
        return false;
    }

    public static void checkPackageAccess(Class<?> clazz) {
        ReflectUtil.checkPackageAccess(clazz.getName());
        if (ReflectUtil.isNonPublicProxyClass(clazz)) {
            ReflectUtil.checkProxyPackageAccess(clazz);
        }
    }

    public static void checkPackageAccess(String name) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int i;
            int b;
            String cname = name.replace('/', '.');
            if (cname.startsWith("[") && (b = cname.lastIndexOf(91) + 2) > 1 && b < cname.length()) {
                cname = cname.substring(b);
            }
            if ((i = cname.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(cname.substring(0, i));
            }
        }
    }

    public static boolean isPackageAccessible(Class clazz) {
        try {
            ReflectUtil.checkPackageAccess(clazz);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    private static boolean isAncestor(ClassLoader p, ClassLoader cl) {
        ClassLoader acl = cl;
        do {
            if (p != (acl = acl.getParent())) continue;
            return true;
        } while (acl != null);
        return false;
    }

    public static boolean needsPackageAccessCheck(ClassLoader from, ClassLoader to) {
        if (from == null || from == to) {
            return false;
        }
        if (to == null) {
            return true;
        }
        return !ReflectUtil.isAncestor(from, to);
    }

    public static void checkProxyPackageAccess(Class<?> clazz) {
        SecurityManager s = System.getSecurityManager();
        if (s != null && Proxy.isProxyClass(clazz)) {
            for (Class<?> intf : clazz.getInterfaces()) {
                ReflectUtil.checkPackageAccess(intf);
            }
        }
    }

    public static void checkProxyPackageAccess(ClassLoader ccl, Class<?> ... interfaces) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (Class<?> intf : interfaces) {
                ClassLoader cl = intf.getClassLoader();
                if (!ReflectUtil.needsPackageAccessCheck(ccl, cl)) continue;
                ReflectUtil.checkPackageAccess(intf);
            }
        }
    }

    public static boolean isNonPublicProxyClass(Class<?> cls) {
        String name = cls.getName();
        int i = name.lastIndexOf(46);
        String pkg = i != -1 ? name.substring(0, i) : "";
        return Proxy.isProxyClass(cls) && !pkg.equals(PROXY_PACKAGE);
    }
}

