/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.print.CustomMediaSizeName;
import sun.print.DialogOwner;
import sun.print.PeekGraphics;
import sun.print.ProxyPrintGraphics;
import sun.print.SunMinMaxPage;
import sun.print.SunPageSelection;

public class PrintJob2D
extends PrintJob
implements Printable,
Runnable {
    private static final PageAttributes.MediaType[] SIZES = new PageAttributes.MediaType[]{PageAttributes.MediaType.ISO_4A0, PageAttributes.MediaType.ISO_2A0, PageAttributes.MediaType.ISO_A0, PageAttributes.MediaType.ISO_A1, PageAttributes.MediaType.ISO_A2, PageAttributes.MediaType.ISO_A3, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A5, PageAttributes.MediaType.ISO_A6, PageAttributes.MediaType.ISO_A7, PageAttributes.MediaType.ISO_A8, PageAttributes.MediaType.ISO_A9, PageAttributes.MediaType.ISO_A10, PageAttributes.MediaType.ISO_B0, PageAttributes.MediaType.ISO_B1, PageAttributes.MediaType.ISO_B2, PageAttributes.MediaType.ISO_B3, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.ISO_B5, PageAttributes.MediaType.ISO_B6, PageAttributes.MediaType.ISO_B7, PageAttributes.MediaType.ISO_B8, PageAttributes.MediaType.ISO_B9, PageAttributes.MediaType.ISO_B10, PageAttributes.MediaType.JIS_B0, PageAttributes.MediaType.JIS_B1, PageAttributes.MediaType.JIS_B2, PageAttributes.MediaType.JIS_B3, PageAttributes.MediaType.JIS_B4, PageAttributes.MediaType.JIS_B5, PageAttributes.MediaType.JIS_B6, PageAttributes.MediaType.JIS_B7, PageAttributes.MediaType.JIS_B8, PageAttributes.MediaType.JIS_B9, PageAttributes.MediaType.JIS_B10, PageAttributes.MediaType.ISO_C0, PageAttributes.MediaType.ISO_C1, PageAttributes.MediaType.ISO_C2, PageAttributes.MediaType.ISO_C3, PageAttributes.MediaType.ISO_C4, PageAttributes.MediaType.ISO_C5, PageAttributes.MediaType.ISO_C6, PageAttributes.MediaType.ISO_C7, PageAttributes.MediaType.ISO_C8, PageAttributes.MediaType.ISO_C9, PageAttributes.MediaType.ISO_C10, PageAttributes.MediaType.ISO_DESIGNATED_LONG, PageAttributes.MediaType.EXECUTIVE, PageAttributes.MediaType.FOLIO, PageAttributes.MediaType.INVOICE, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_LEGAL, PageAttributes.MediaType.QUARTO, PageAttributes.MediaType.A, PageAttributes.MediaType.B, PageAttributes.MediaType.C, PageAttributes.MediaType.D, PageAttributes.MediaType.E, PageAttributes.MediaType.NA_10X15_ENVELOPE, PageAttributes.MediaType.NA_10X14_ENVELOPE, PageAttributes.MediaType.NA_10X13_ENVELOPE, PageAttributes.MediaType.NA_9X12_ENVELOPE, PageAttributes.MediaType.NA_9X11_ENVELOPE, PageAttributes.MediaType.NA_7X9_ENVELOPE, PageAttributes.MediaType.NA_6X9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_10_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_11_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_12_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_14_ENVELOPE, PageAttributes.MediaType.INVITE_ENVELOPE, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.MONARCH_ENVELOPE, PageAttributes.MediaType.PERSONAL_ENVELOPE};
    private static final MediaSizeName[] JAVAXSIZES = new MediaSizeName[]{null, null, MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, null, null, null, null, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.EXECUTIVE, MediaSizeName.FOLIO, MediaSizeName.INVOICE, MediaSizeName.LEDGER, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.QUARTO, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, null, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE};
    private static final int[] WIDTHS = new int[]{4768, 3370, 2384, 1684, 1191, 842, 595, 420, 298, 210, 147, 105, 74, 2835, 2004, 1417, 1001, 709, 499, 354, 249, 176, 125, 88, 2920, 2064, 1460, 1032, 729, 516, 363, 258, 181, 128, 91, 2599, 1837, 1298, 918, 649, 459, 323, 230, 162, 113, 79, 312, 522, 612, 396, 792, 612, 612, 609, 612, 792, 1224, 1584, 2448, 720, 720, 720, 648, 648, 504, 432, 279, 297, 324, 342, 360, 624, 312, 279, 261};
    private static final int[] LENGTHS = new int[]{6741, 4768, 3370, 2384, 1684, 1191, 842, 595, 420, 298, 210, 147, 105, 4008, 2835, 2004, 1417, 1001, 729, 499, 354, 249, 176, 125, 4127, 2920, 2064, 1460, 1032, 729, 516, 363, 258, 181, 128, 3677, 2599, 1837, 1298, 918, 649, 459, 323, 230, 162, 113, 624, 756, 936, 612, 1224, 792, 1008, 780, 792, 1224, 1584, 2448, 3168, 1080, 1008, 936, 864, 792, 648, 648, 639, 684, 747, 792, 828, 624, 652, 540, 468};
    private Frame frame;
    private String docTitle = "";
    private JobAttributes jobAttributes;
    private PageAttributes pageAttributes;
    private PrintRequestAttributeSet attributes;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private MessageQ graphicsToBeDrawn = new MessageQ("tobedrawn");
    private MessageQ graphicsDrawn = new MessageQ("drawn");
    private Graphics2D currentGraphics;
    private int pageIndex = -1;
    private static final String DEST_PROP = "awt.print.destination";
    private static final String PRINTER = "printer";
    private static final String FILE = "file";
    private static final String PRINTER_PROP = "awt.print.printer";
    private static final String FILENAME_PROP = "awt.print.fileName";
    private static final String NUMCOPIES_PROP = "awt.print.numCopies";
    private static final String OPTIONS_PROP = "awt.print.options";
    private static final String ORIENT_PROP = "awt.print.orientation";
    private static final String PORTRAIT = "portrait";
    private static final String LANDSCAPE = "landscape";
    private static final String PAPERSIZE_PROP = "awt.print.paperSize";
    private static final String LETTER = "letter";
    private static final String LEGAL = "legal";
    private static final String EXECUTIVE = "executive";
    private static final String A4 = "a4";
    private Properties props;
    private String options = "";
    private Thread printerJobThread;

    public PrintJob2D(Frame frame, String doctitle, Properties props) {
        this.props = props;
        this.jobAttributes = new JobAttributes();
        this.pageAttributes = new PageAttributes();
        this.translateInputProps();
        this.initPrintJob2D(frame, doctitle, this.jobAttributes, this.pageAttributes);
    }

    public PrintJob2D(Frame frame, String doctitle, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        this.initPrintJob2D(frame, doctitle, jobAttributes, pageAttributes);
    }

    private void initPrintJob2D(Frame frame, String doctitle, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        if (frame == null && (jobAttributes == null || jobAttributes.getDialog() == JobAttributes.DialogType.NATIVE)) {
            throw new NullPointerException("Frame must not be null");
        }
        this.frame = frame;
        this.docTitle = doctitle == null ? "" : doctitle;
        this.jobAttributes = jobAttributes != null ? jobAttributes : new JobAttributes();
        this.pageAttributes = pageAttributes != null ? pageAttributes : new PageAttributes();
        int[][] pageRanges = this.jobAttributes.getPageRanges();
        int first = pageRanges[0][0];
        int last = pageRanges[pageRanges.length - 1][1];
        this.jobAttributes.setPageRanges(new int[][]{{first, last}});
        this.jobAttributes.setToPage(last);
        this.jobAttributes.setFromPage(first);
        int[] res = this.pageAttributes.getPrinterResolution();
        if (res[0] != res[1]) {
            throw new IllegalArgumentException("Differing cross feed and feed resolutions not supported.");
        }
        JobAttributes.DestinationType dest = this.jobAttributes.getDestination();
        if (dest == JobAttributes.DestinationType.FILE) {
            this.throwPrintToFile();
            String destStr = jobAttributes.getFileName();
            if (destStr != null && jobAttributes.getDialog() == JobAttributes.DialogType.NONE) {
                File f = new File(destStr);
                try {
                    if (f.createNewFile()) {
                        f.delete();
                    }
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Cannot write to file:" + destStr);
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                File pFile = f.getParentFile();
                if (f.exists() && (!f.isFile() || !f.canWrite()) || pFile != null && (!pFile.exists() || pFile.exists() && !pFile.canWrite())) {
                    throw new IllegalArgumentException("Cannot write to file:" + destStr);
                }
            }
        }
    }

    public boolean printDialog() {
        boolean proceedWithPrint = false;
        this.printerJob = PrinterJob.getPrinterJob();
        if (this.printerJob == null) {
            return false;
        }
        JobAttributes.DialogType d = this.jobAttributes.getDialog();
        PrintService pServ = this.printerJob.getPrintService();
        if (pServ == null && d == JobAttributes.DialogType.NONE) {
            return false;
        }
        this.copyAttributes(pServ);
        JobAttributes.DefaultSelectionType select = this.jobAttributes.getDefaultSelection();
        if (select == JobAttributes.DefaultSelectionType.RANGE) {
            this.attributes.add(SunPageSelection.RANGE);
        } else if (select == JobAttributes.DefaultSelectionType.SELECTION) {
            this.attributes.add(SunPageSelection.SELECTION);
        } else {
            this.attributes.add(SunPageSelection.ALL);
        }
        if (this.frame != null) {
            this.attributes.add(new DialogOwner(this.frame));
        }
        if (d == JobAttributes.DialogType.NONE) {
            proceedWithPrint = true;
        } else {
            if (d == JobAttributes.DialogType.NATIVE) {
                this.attributes.add(DialogTypeSelection.NATIVE);
            } else {
                this.attributes.add(DialogTypeSelection.COMMON);
            }
            proceedWithPrint = this.printerJob.printDialog(this.attributes);
            if (proceedWithPrint) {
                if (pServ == null && (pServ = this.printerJob.getPrintService()) == null) {
                    return false;
                }
                this.updateAttributes();
                this.translateOutputProps();
            }
        }
        if (proceedWithPrint) {
            JobName jname = (JobName)this.attributes.get(JobName.class);
            if (jname != null) {
                this.printerJob.setJobName(jname.toString());
            }
            this.pageFormat = new PageFormat();
            Media media = (Media)this.attributes.get(Media.class);
            MediaSize mediaSize = null;
            if (media != null && media instanceof MediaSizeName) {
                mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
            }
            Paper p = this.pageFormat.getPaper();
            if (mediaSize != null) {
                p.setSize((double)mediaSize.getX(25400) * 72.0, (double)mediaSize.getY(25400) * 72.0);
            }
            if (this.pageAttributes.getOrigin() == PageAttributes.OriginType.PRINTABLE) {
                p.setImageableArea(18.0, 18.0, p.getWidth() - 36.0, p.getHeight() - 36.0);
            } else {
                p.setImageableArea(0.0, 0.0, p.getWidth(), p.getHeight());
            }
            this.pageFormat.setPaper(p);
            OrientationRequested orient = (OrientationRequested)this.attributes.get(OrientationRequested.class);
            if (orient != null && orient == OrientationRequested.REVERSE_LANDSCAPE) {
                this.pageFormat.setOrientation(2);
            } else if (orient == OrientationRequested.LANDSCAPE) {
                this.pageFormat.setOrientation(0);
            } else {
                this.pageFormat.setOrientation(1);
            }
            this.printerJob.setPrintable(this, this.pageFormat);
        }
        return proceedWithPrint;
    }

    private void updateAttributes() {
        PageAttributes.MediaType mType;
        Copies c = (Copies)this.attributes.get(Copies.class);
        this.jobAttributes.setCopies(c.getValue());
        SunPageSelection sel = (SunPageSelection)this.attributes.get(SunPageSelection.class);
        if (sel == SunPageSelection.RANGE) {
            this.jobAttributes.setDefaultSelection(JobAttributes.DefaultSelectionType.RANGE);
        } else if (sel == SunPageSelection.SELECTION) {
            this.jobAttributes.setDefaultSelection(JobAttributes.DefaultSelectionType.SELECTION);
        } else {
            this.jobAttributes.setDefaultSelection(JobAttributes.DefaultSelectionType.ALL);
        }
        Destination dest = (Destination)this.attributes.get(Destination.class);
        if (dest != null) {
            this.jobAttributes.setDestination(JobAttributes.DestinationType.FILE);
            this.jobAttributes.setFileName(dest.getURI().getPath());
        } else {
            this.jobAttributes.setDestination(JobAttributes.DestinationType.PRINTER);
        }
        PrintService serv = this.printerJob.getPrintService();
        if (serv != null) {
            this.jobAttributes.setPrinter(serv.getName());
        }
        PageRanges range = (PageRanges)this.attributes.get(PageRanges.class);
        int[][] members = range.getMembers();
        this.jobAttributes.setPageRanges(members);
        SheetCollate collation = (SheetCollate)this.attributes.get(SheetCollate.class);
        if (collation == SheetCollate.COLLATED) {
            this.jobAttributes.setMultipleDocumentHandling(JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES);
        } else {
            this.jobAttributes.setMultipleDocumentHandling(JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
        }
        Sides sides = (Sides)this.attributes.get(Sides.class);
        if (sides == Sides.TWO_SIDED_LONG_EDGE) {
            this.jobAttributes.setSides(JobAttributes.SidesType.TWO_SIDED_LONG_EDGE);
        } else if (sides == Sides.TWO_SIDED_SHORT_EDGE) {
            this.jobAttributes.setSides(JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE);
        } else {
            this.jobAttributes.setSides(JobAttributes.SidesType.ONE_SIDED);
        }
        Chromaticity color = (Chromaticity)this.attributes.get(Chromaticity.class);
        if (color == Chromaticity.COLOR) {
            this.pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        } else {
            this.pageAttributes.setColor(PageAttributes.ColorType.MONOCHROME);
        }
        OrientationRequested orient = (OrientationRequested)this.attributes.get(OrientationRequested.class);
        if (orient == OrientationRequested.LANDSCAPE) {
            this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.LANDSCAPE);
        } else {
            this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
        }
        PrintQuality qual = (PrintQuality)this.attributes.get(PrintQuality.class);
        if (qual == PrintQuality.DRAFT) {
            this.pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.DRAFT);
        } else if (qual == PrintQuality.HIGH) {
            this.pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        } else {
            this.pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
        }
        Media msn = (Media)this.attributes.get(Media.class);
        if (msn != null && msn instanceof MediaSizeName && (mType = PrintJob2D.unMapMedia((MediaSizeName)msn)) != null) {
            this.pageAttributes.setMedia(mType);
        }
        this.debugPrintAttributes(false, false);
    }

    private void debugPrintAttributes(boolean ja, boolean pa) {
        if (ja) {
            System.out.println("new Attributes\ncopies = " + this.jobAttributes.getCopies() + "\nselection = " + this.jobAttributes.getDefaultSelection() + "\ndest " + this.jobAttributes.getDestination() + "\nfile " + this.jobAttributes.getFileName() + "\nfromPage " + this.jobAttributes.getFromPage() + "\ntoPage " + this.jobAttributes.getToPage() + "\ncollation " + this.jobAttributes.getMultipleDocumentHandling() + "\nPrinter " + this.jobAttributes.getPrinter() + "\nSides2 " + this.jobAttributes.getSides());
        }
        if (pa) {
            System.out.println("new Attributes\ncolor = " + this.pageAttributes.getColor() + "\norientation = " + this.pageAttributes.getOrientationRequested() + "\nquality " + this.pageAttributes.getPrintQuality() + "\nMedia2 " + this.pageAttributes.getMedia());
        }
    }

    private void copyAttributes(PrintService printServ) {
        PageAttributes.PrintQualityType qType;
        JobAttributes.DestinationType dest;
        this.attributes = new HashPrintRequestAttributeSet();
        this.attributes.add(new JobName(this.docTitle, null));
        PrintService pServ = printServ;
        String printerName = this.jobAttributes.getPrinter();
        if (printerName != null && printerName != "" && !printerName.equals(pServ.getName())) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            try {
                for (int i = 0; i < services.length; ++i) {
                    if (!printerName.equals(services[i].getName())) continue;
                    this.printerJob.setPrintService(services[i]);
                    pServ = services[i];
                    break;
                }
            }
            catch (PrinterException pe) {
                // empty catch block
            }
        }
        if ((dest = this.jobAttributes.getDestination()) == JobAttributes.DestinationType.FILE && pServ.isAttributeCategorySupported(Destination.class)) {
            Destination defaultDest;
            String fileName = this.jobAttributes.getFileName();
            if (fileName == null && (defaultDest = (Destination)pServ.getDefaultAttributeValue(Destination.class)) != null) {
                this.attributes.add(defaultDest);
            } else {
                URI uri = null;
                try {
                    if (fileName != null) {
                        if (fileName.equals("")) {
                            fileName = ".";
                        }
                    } else {
                        fileName = "out.prn";
                    }
                    uri = new File(fileName).toURI();
                }
                catch (SecurityException se) {
                    try {
                        fileName = fileName.replace('\\', '/');
                        uri = new URI("file:" + fileName);
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                }
                if (uri != null) {
                    this.attributes.add(new Destination(uri));
                }
            }
        }
        this.attributes.add(new SunMinMaxPage(this.jobAttributes.getMinPage(), this.jobAttributes.getMaxPage()));
        JobAttributes.SidesType sType = this.jobAttributes.getSides();
        if (sType == JobAttributes.SidesType.TWO_SIDED_LONG_EDGE) {
            this.attributes.add(Sides.TWO_SIDED_LONG_EDGE);
        } else if (sType == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE) {
            this.attributes.add(Sides.TWO_SIDED_SHORT_EDGE);
        } else if (sType == JobAttributes.SidesType.ONE_SIDED) {
            this.attributes.add(Sides.ONE_SIDED);
        }
        JobAttributes.MultipleDocumentHandlingType hType = this.jobAttributes.getMultipleDocumentHandling();
        if (hType == JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES) {
            this.attributes.add(SheetCollate.COLLATED);
        } else {
            this.attributes.add(SheetCollate.UNCOLLATED);
        }
        this.attributes.add(new Copies(this.jobAttributes.getCopies()));
        this.attributes.add(new PageRanges(this.jobAttributes.getFromPage(), this.jobAttributes.getToPage()));
        if (this.pageAttributes.getColor() == PageAttributes.ColorType.COLOR) {
            this.attributes.add(Chromaticity.COLOR);
        } else {
            this.attributes.add(Chromaticity.MONOCHROME);
        }
        this.pageFormat = this.printerJob.defaultPage();
        if (this.pageAttributes.getOrientationRequested() == PageAttributes.OrientationRequestedType.LANDSCAPE) {
            this.pageFormat.setOrientation(0);
            this.attributes.add(OrientationRequested.LANDSCAPE);
        } else {
            this.pageFormat.setOrientation(1);
            this.attributes.add(OrientationRequested.PORTRAIT);
        }
        PageAttributes.MediaType media = this.pageAttributes.getMedia();
        MediaSizeName msn = PrintJob2D.mapMedia(media);
        if (msn != null) {
            this.attributes.add(msn);
        }
        if ((qType = this.pageAttributes.getPrintQuality()) == PageAttributes.PrintQualityType.DRAFT) {
            this.attributes.add(PrintQuality.DRAFT);
        } else if (qType == PageAttributes.PrintQualityType.NORMAL) {
            this.attributes.add(PrintQuality.NORMAL);
        } else if (qType == PageAttributes.PrintQualityType.HIGH) {
            this.attributes.add(PrintQuality.HIGH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graphics getGraphics() {
        ProxyPrintGraphics printGraphics = null;
        PrintJob2D printJob2D = this;
        synchronized (printJob2D) {
            ++this.pageIndex;
            if (this.pageIndex == 0 && !this.graphicsToBeDrawn.isClosed()) {
                this.startPrinterJobThread();
            }
            this.notify();
        }
        if (this.currentGraphics != null) {
            this.graphicsDrawn.append(this.currentGraphics);
            this.currentGraphics = null;
        }
        this.currentGraphics = this.graphicsToBeDrawn.pop();
        if (this.currentGraphics instanceof PeekGraphics) {
            ((PeekGraphics)this.currentGraphics).setAWTDrawingOnly();
            this.graphicsDrawn.append(this.currentGraphics);
            this.currentGraphics = this.graphicsToBeDrawn.pop();
        }
        if (this.currentGraphics != null) {
            this.currentGraphics.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
            double awtScale = 72.0 / this.getPageResolutionInternal();
            this.currentGraphics.scale(awtScale, awtScale);
            printGraphics = new ProxyPrintGraphics(this.currentGraphics.create(), this);
        }
        return printGraphics;
    }

    @Override
    public Dimension getPageDimension() {
        double hgt;
        double wid;
        if (this.pageAttributes != null && this.pageAttributes.getOrigin() == PageAttributes.OriginType.PRINTABLE) {
            wid = this.pageFormat.getImageableWidth();
            hgt = this.pageFormat.getImageableHeight();
        } else {
            wid = this.pageFormat.getWidth();
            hgt = this.pageFormat.getHeight();
        }
        double scale = this.getPageResolutionInternal() / 72.0;
        return new Dimension((int)(wid * scale), (int)(hgt * scale));
    }

    private double getPageResolutionInternal() {
        if (this.pageAttributes != null) {
            int[] res = this.pageAttributes.getPrinterResolution();
            if (res[2] == 3) {
                return res[0];
            }
            return (double)res[0] * 2.54;
        }
        return 72.0;
    }

    @Override
    public int getPageResolution() {
        return (int)this.getPageResolutionInternal();
    }

    @Override
    public boolean lastPageFirst() {
        return false;
    }

    @Override
    public synchronized void end() {
        this.graphicsToBeDrawn.close();
        if (this.currentGraphics != null) {
            this.graphicsDrawn.append(this.currentGraphics);
        }
        this.graphicsDrawn.closeWhenEmpty();
        if (this.printerJobThread != null && this.printerJobThread.isAlive()) {
            try {
                this.printerJobThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void finalize() {
        this.end();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.graphicsToBeDrawn.append((Graphics2D)graphics);
        int result = this.graphicsDrawn.pop() != null ? 0 : 1;
        return result;
    }

    private void startPrinterJobThread() {
        this.printerJobThread = new Thread(this, "printerJobThread");
        this.printerJobThread.start();
    }

    @Override
    public void run() {
        try {
            this.printerJob.print(this.attributes);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        this.graphicsToBeDrawn.closeWhenEmpty();
        this.graphicsDrawn.close();
    }

    private static int[] getSize(PageAttributes.MediaType mType) {
        int[] dim = new int[]{612, 792};
        for (int i = 0; i < SIZES.length; ++i) {
            if (SIZES[i] != mType) continue;
            dim[0] = WIDTHS[i];
            dim[1] = LENGTHS[i];
            break;
        }
        return dim;
    }

    public static MediaSizeName mapMedia(PageAttributes.MediaType mType) {
        MediaSizeName media = null;
        int length = Math.min(SIZES.length, JAVAXSIZES.length);
        for (int i = 0; i < length; ++i) {
            if (SIZES[i] != mType) continue;
            if (JAVAXSIZES[i] != null && MediaSize.getMediaSizeForName(JAVAXSIZES[i]) != null) {
                media = JAVAXSIZES[i];
                break;
            }
            media = new CustomMediaSizeName(SIZES[i].toString());
            float w = (float)Math.rint((double)WIDTHS[i] / 72.0);
            float h = (float)Math.rint((double)LENGTHS[i] / 72.0);
            if (!((double)w > 0.0) || !((double)h > 0.0)) break;
            new MediaSize(w, h, 25400, media);
            break;
        }
        return media;
    }

    public static PageAttributes.MediaType unMapMedia(MediaSizeName mSize) {
        PageAttributes.MediaType media = null;
        int length = Math.min(SIZES.length, JAVAXSIZES.length);
        for (int i = 0; i < length; ++i) {
            if (JAVAXSIZES[i] != mSize || SIZES[i] == null) continue;
            media = SIZES[i];
            break;
        }
        return media;
    }

    private void translateInputProps() {
        if (this.props == null) {
            return;
        }
        String str = this.props.getProperty(DEST_PROP);
        if (str != null) {
            if (str.equals(PRINTER)) {
                this.jobAttributes.setDestination(JobAttributes.DestinationType.PRINTER);
            } else if (str.equals(FILE)) {
                this.jobAttributes.setDestination(JobAttributes.DestinationType.FILE);
            }
        }
        if ((str = this.props.getProperty(PRINTER_PROP)) != null) {
            this.jobAttributes.setPrinter(str);
        }
        if ((str = this.props.getProperty(FILENAME_PROP)) != null) {
            this.jobAttributes.setFileName(str);
        }
        if ((str = this.props.getProperty(NUMCOPIES_PROP)) != null) {
            this.jobAttributes.setCopies(Integer.parseInt(str));
        }
        this.options = this.props.getProperty(OPTIONS_PROP, "");
        str = this.props.getProperty(ORIENT_PROP);
        if (str != null) {
            if (str.equals(PORTRAIT)) {
                this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
            } else if (str.equals(LANDSCAPE)) {
                this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.LANDSCAPE);
            }
        }
        if ((str = this.props.getProperty(PAPERSIZE_PROP)) != null) {
            if (str.equals(LETTER)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.LETTER.hashCode()]);
            } else if (str.equals(LEGAL)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.LEGAL.hashCode()]);
            } else if (str.equals(EXECUTIVE)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.EXECUTIVE.hashCode()]);
            } else if (str.equals(A4)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.A4.hashCode()]);
            }
        }
    }

    private void translateOutputProps() {
        int copies;
        if (this.props == null) {
            return;
        }
        this.props.setProperty(DEST_PROP, this.jobAttributes.getDestination() == JobAttributes.DestinationType.PRINTER ? PRINTER : FILE);
        String str = this.jobAttributes.getPrinter();
        if (str != null && !str.equals("")) {
            this.props.setProperty(PRINTER_PROP, str);
        }
        if ((str = this.jobAttributes.getFileName()) != null && !str.equals("")) {
            this.props.setProperty(FILENAME_PROP, str);
        }
        if ((copies = this.jobAttributes.getCopies()) > 0) {
            this.props.setProperty(NUMCOPIES_PROP, "" + copies);
        }
        if ((str = this.options) != null && !str.equals("")) {
            this.props.setProperty(OPTIONS_PROP, str);
        }
        this.props.setProperty(ORIENT_PROP, this.pageAttributes.getOrientationRequested() == PageAttributes.OrientationRequestedType.PORTRAIT ? PORTRAIT : LANDSCAPE);
        PageAttributes.MediaType media = SIZES[this.pageAttributes.getMedia().hashCode()];
        str = media == PageAttributes.MediaType.LETTER ? LETTER : (media == PageAttributes.MediaType.LEGAL ? LEGAL : (media == PageAttributes.MediaType.EXECUTIVE ? EXECUTIVE : (media == PageAttributes.MediaType.A4 ? A4 : media.toString())));
        this.props.setProperty(PAPERSIZE_PROP, str);
    }

    private void throwPrintToFile() {
        SecurityManager security = System.getSecurityManager();
        FilePermission printToFilePermission = null;
        if (security != null) {
            if (printToFilePermission == null) {
                printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            security.checkPermission(printToFilePermission);
        }
    }

    private class MessageQ {
        private String qid = "noname";
        private ArrayList queue = new ArrayList();

        MessageQ(String id) {
            this.qid = id;
        }

        synchronized void closeWhenEmpty() {
            while (this.queue != null && this.queue.size() > 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.queue = null;
            this.notifyAll();
        }

        synchronized void close() {
            this.queue = null;
            this.notifyAll();
        }

        synchronized boolean append(Graphics2D g) {
            boolean queued = false;
            if (this.queue != null) {
                this.queue.add(g);
                queued = true;
                this.notify();
            }
            return queued;
        }

        synchronized Graphics2D pop() {
            Graphics2D g = null;
            while (g == null && this.queue != null) {
                if (this.queue.size() > 0) {
                    g = (Graphics2D)this.queue.remove(0);
                    this.notify();
                    continue;
                }
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return g;
        }

        synchronized boolean isClosed() {
            return this.queue == null;
        }
    }
}

