/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.StringTokenizer;
import sun.net.www.ApplicationLaunchException;
import sun.net.www.MimeEntry;
import sun.security.action.GetPropertyAction;

class MimeLauncher
extends Thread {
    URLConnection uc;
    MimeEntry m;
    String genericTempFileTemplate;
    InputStream is;
    String execPath;

    MimeLauncher(MimeEntry M, URLConnection uc, InputStream is, String tempFileTemplate, String threadName) throws ApplicationLaunchException {
        super(threadName);
        this.m = M;
        this.uc = uc;
        this.is = is;
        this.genericTempFileTemplate = tempFileTemplate;
        String launchString = this.m.getLaunchString();
        if (!this.findExecutablePath(launchString)) {
            int index = launchString.indexOf(32);
            String appName = index != -1 ? launchString.substring(0, index) : launchString;
            throw new ApplicationLaunchException(appName);
        }
    }

    protected String getTempFileName(URL url, String template) {
        String tempFilename = template;
        int wildcard = tempFilename.lastIndexOf("%s");
        String prefix = tempFilename.substring(0, wildcard);
        String suffix = "";
        if (wildcard < tempFilename.length() - 2) {
            suffix = tempFilename.substring(wildcard + 2);
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        int argIndex = 0;
        while ((argIndex = prefix.indexOf("%s")) >= 0) {
            prefix = prefix.substring(0, argIndex) + timestamp + prefix.substring(argIndex + 2);
        }
        String filename = url.getFile();
        String extension = "";
        int dot = filename.lastIndexOf(46);
        if (dot >= 0 && dot > filename.lastIndexOf(47)) {
            extension = filename.substring(dot);
        }
        filename = "HJ" + url.hashCode();
        tempFilename = prefix + filename + timestamp + extension + suffix;
        return tempFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String ofn = this.m.getTempFileTemplate();
            if (ofn == null) {
                ofn = this.genericTempFileTemplate;
            }
            ofn = this.getTempFileName(this.uc.getURL(), ofn);
            try {
                FileOutputStream os = new FileOutputStream(ofn);
                byte[] buf = new byte[2048];
                int i = 0;
                try {
                    while ((i = this.is.read(buf)) >= 0) {
                        ((OutputStream)os).write(buf, 0, i);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    ((OutputStream)os).close();
                    this.is.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            int inx = 0;
            String c = this.execPath;
            while ((inx = c.indexOf("%t")) >= 0) {
                c = c.substring(0, inx) + this.uc.getContentType() + c.substring(inx + 2);
            }
            boolean substituted = false;
            while ((inx = c.indexOf("%s")) >= 0) {
                c = c.substring(0, inx) + ofn + c.substring(inx + 2);
                substituted = true;
            }
            if (!substituted) {
                c = c + " <" + ofn;
            }
            Runtime.getRuntime().exec(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean findExecutablePath(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int index = str.indexOf(32);
        String command = index != -1 ? str.substring(0, index) : str;
        File f = new File(command);
        if (f.isFile()) {
            this.execPath = str;
            return true;
        }
        String execPathList = AccessController.doPrivileged(new GetPropertyAction("exec.path"));
        if (execPathList == null) {
            return false;
        }
        StringTokenizer iter = new StringTokenizer(execPathList, "|");
        while (iter.hasMoreElements()) {
            String prefix = (String)iter.nextElement();
            String fullCmd = prefix + File.separator + command;
            f = new File(fullCmd);
            if (!f.isFile()) continue;
            this.execPath = prefix + File.separator + str;
            return true;
        }
        return false;
    }
}

