/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Set;
import sun.awt.SunToolkit;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XPropertyCache;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XRootWindow;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

public class XBaseWindow {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XBaseWindow");
    private static final PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XBaseWindow");
    private static final PlatformLogger eventLog = PlatformLogger.getLogger("sun.awt.X11.event.XBaseWindow");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.XBaseWindow");
    private static final PlatformLogger grabLog = PlatformLogger.getLogger("sun.awt.X11.grab.XBaseWindow");
    public static final String PARENT_WINDOW = "parent window";
    public static final String BOUNDS = "bounds";
    public static final String OVERRIDE_REDIRECT = "overrideRedirect";
    public static final String EVENT_MASK = "event mask";
    public static final String VALUE_MASK = "value mask";
    public static final String BORDER_PIXEL = "border pixel";
    public static final String COLORMAP = "color map";
    public static final String DEPTH = "visual depth";
    public static final String VISUAL_CLASS = "visual class";
    public static final String VISUAL = "visual";
    public static final String EMBEDDED = "embedded";
    public static final String DELAYED = "delayed";
    public static final String PARENT = "parent";
    public static final String BACKGROUND_PIXMAP = "pixmap";
    public static final String VISIBLE = "visible";
    public static final String SAVE_UNDER = "save under";
    public static final String BACKING_STORE = "backing store";
    public static final String BIT_GRAVITY = "bit gravity";
    private XCreateWindowParams delayedParams;
    Set<Long> children = new HashSet<Long>();
    long window;
    boolean visible;
    boolean mapped;
    boolean embedded;
    Rectangle maxBounds;
    volatile XBaseWindow parentWindow;
    private boolean disposed;
    private long screen;
    private XSizeHints hints;
    private XWMHints wmHints;
    static final int MIN_SIZE = 1;
    static final int DEF_LOCATION = 1;
    private static XAtom wm_client_leader;
    private InitialiseState initialising;
    int x;
    int y;
    int width;
    int height;
    protected StateLock state_lock;

    void awtLock() {
        XToolkit.awtLock();
    }

    void awtUnlock() {
        XToolkit.awtUnlock();
    }

    void awtLockNotifyAll() {
        XToolkit.awtLockNotifyAll();
    }

    void awtLockWait() throws InterruptedException {
        XToolkit.awtLockWait();
    }

    protected final void init(long parentWindow, Rectangle bounds) {
    }

    protected final void preInit() {
    }

    protected final void postInit() {
    }

    void instantPreInit(XCreateWindowParams params) {
        this.state_lock = new StateLock();
        this.initialising = InitialiseState.NOT_INITIALISED;
    }

    void preInit(XCreateWindowParams params) {
        this.state_lock = new StateLock();
        this.initialising = InitialiseState.NOT_INITIALISED;
        this.embedded = Boolean.TRUE.equals(params.get(EMBEDDED));
        this.visible = Boolean.TRUE.equals(params.get(VISIBLE));
        Object parent = params.get(PARENT);
        if (parent instanceof XBaseWindow) {
            this.parentWindow = (XBaseWindow)parent;
        } else {
            Long parentWindowID = (Long)params.get(PARENT_WINDOW);
            if (parentWindowID != null) {
                this.parentWindow = XToolkit.windowToXWindow(parentWindowID);
            }
        }
        Long eventMask = (Long)params.get(EVENT_MASK);
        if (eventMask != null) {
            long mask = eventMask;
            params.put(EVENT_MASK, mask |= 0x80000L);
        }
        this.screen = -1L;
    }

    void postInit(XCreateWindowParams params) {
        if (log.isLoggable(500)) {
            log.fine("WM name is " + this.getWMName());
        }
        this.updateWMName();
        this.initClientLeader();
    }

    protected final void init(XCreateWindowParams params) {
        this.awtLock();
        this.initialising = InitialiseState.INITIALISING;
        this.awtUnlock();
        try {
            if (!Boolean.TRUE.equals(params.get(DELAYED))) {
                this.preInit(params);
                this.create(params);
                this.postInit(params);
            } else {
                this.instantPreInit(params);
                this.delayedParams = params;
            }
            this.awtLock();
            this.initialising = InitialiseState.INITIALISED;
            this.awtLockNotifyAll();
            this.awtUnlock();
        }
        catch (RuntimeException re) {
            this.awtLock();
            this.initialising = InitialiseState.FAILED_INITIALISATION;
            this.awtLockNotifyAll();
            this.awtUnlock();
            throw re;
        }
        catch (Throwable t) {
            log.warning("Exception during peer initialization", t);
            this.awtLock();
            this.initialising = InitialiseState.FAILED_INITIALISATION;
            this.awtLockNotifyAll();
            this.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInitialised() {
        this.awtLock();
        try {
            switch (this.initialising) {
                case INITIALISED: {
                    boolean bl = true;
                    return bl;
                }
                case INITIALISING: {
                    try {
                        while (this.initialising != InitialiseState.INITIALISED) {
                            this.awtLockWait();
                        }
                    }
                    catch (InterruptedException ie) {
                        boolean bl = false;
                        this.awtUnlock();
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                case NOT_INITIALISED: 
                case FAILED_INITIALISATION: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.awtUnlock();
        }
    }

    XBaseWindow() {
        this(new XCreateWindowParams());
    }

    XBaseWindow(long parentWindow, Rectangle bounds) {
        this(new XCreateWindowParams(new Object[]{BOUNDS, bounds, PARENT_WINDOW, parentWindow}));
    }

    XBaseWindow(Rectangle bounds) {
        this(new XCreateWindowParams(new Object[]{BOUNDS, bounds}));
    }

    public XBaseWindow(XCreateWindowParams params) {
        this.init(params);
    }

    XBaseWindow(long parentWindow) {
        this(new XCreateWindowParams(new Object[]{PARENT_WINDOW, parentWindow, EMBEDDED, Boolean.TRUE}));
    }

    protected void checkParams(XCreateWindowParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Window creation parameters are null");
        }
        params.putIfNull((Object)PARENT_WINDOW, (Object)XToolkit.getDefaultRootWindow());
        params.putIfNull((Object)BOUNDS, new Rectangle(1, 1, 1, 1));
        params.putIfNull((Object)DEPTH, (Object)0);
        params.putIfNull((Object)VISUAL, (Object)0L);
        params.putIfNull((Object)VISUAL_CLASS, (Object)2);
        params.putIfNull((Object)VALUE_MASK, (Object)2048L);
        Rectangle bounds = (Rectangle)params.get(BOUNDS);
        bounds.width = Math.max(1, bounds.width);
        bounds.height = Math.max(1, bounds.height);
        Long eventMaskObj = (Long)params.get(EVENT_MASK);
        long eventMask = eventMaskObj != null ? eventMaskObj : 0L;
        params.put(EVENT_MASK, eventMask |= 0x1400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void create(XCreateWindowParams params) {
        XToolkit.awtLock();
        try {
            XSetWindowAttributes xattr = new XSetWindowAttributes();
            try {
                Integer bitGravity;
                Integer backingStore;
                Boolean saveUnder;
                Long background_pixmap;
                Long colormap;
                this.checkParams(params);
                long value_mask = (Long)params.get(VALUE_MASK);
                Long eventMask = (Long)params.get(EVENT_MASK);
                xattr.set_event_mask(eventMask);
                value_mask |= 0x800L;
                Long border_pixel = (Long)params.get(BORDER_PIXEL);
                if (border_pixel != null) {
                    xattr.set_border_pixel(border_pixel);
                    value_mask |= 8L;
                }
                if ((colormap = (Long)params.get(COLORMAP)) != null) {
                    xattr.set_colormap(colormap);
                    value_mask |= 0x2000L;
                }
                if ((background_pixmap = (Long)params.get(BACKGROUND_PIXMAP)) != null) {
                    xattr.set_background_pixmap(background_pixmap);
                    value_mask |= 1L;
                }
                Long parentWindow = (Long)params.get(PARENT_WINDOW);
                Rectangle bounds = (Rectangle)params.get(BOUNDS);
                Integer depth = (Integer)params.get(DEPTH);
                Integer visual_class = (Integer)params.get(VISUAL_CLASS);
                Long visual = (Long)params.get(VISUAL);
                Boolean overrideRedirect = (Boolean)params.get(OVERRIDE_REDIRECT);
                if (overrideRedirect != null) {
                    xattr.set_override_redirect(overrideRedirect);
                    value_mask |= 0x200L;
                }
                if ((saveUnder = (Boolean)params.get(SAVE_UNDER)) != null) {
                    xattr.set_save_under(saveUnder);
                    value_mask |= 0x400L;
                }
                if ((backingStore = (Integer)params.get(BACKING_STORE)) != null) {
                    xattr.set_backing_store(backingStore);
                    value_mask |= 0x40L;
                }
                if ((bitGravity = (Integer)params.get(BIT_GRAVITY)) != null) {
                    xattr.set_bit_gravity(bitGravity);
                    value_mask |= 0x10L;
                }
                if (log.isLoggable(500)) {
                    log.fine("Creating window for " + this + " with the following attributes: \n" + params);
                }
                this.window = XlibWrapper.XCreateWindow(XToolkit.getDisplay(), parentWindow, bounds.x, bounds.y, bounds.width, bounds.height, 0, depth, visual_class.intValue(), visual, value_mask, xattr.pData);
                if (this.window == 0L) {
                    throw new IllegalStateException("Couldn't create window because of wrong parameters. Run with NOISY_AWT to see details");
                }
                XToolkit.addToWinMap(this.window, this);
            }
            finally {
                xattr.dispose();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public XCreateWindowParams getDelayedParams() {
        return this.delayedParams;
    }

    protected String getWMName() {
        return XToolkit.getCorrectXIDString(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClientLeader() {
        XToolkit.awtLock();
        try {
            if (wm_client_leader == null) {
                wm_client_leader = XAtom.get("WM_CLIENT_LEADER");
            }
            wm_client_leader.setWindowProperty(this, XBaseWindow.getXAWTRootWindow());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static XRootWindow getXAWTRootWindow() {
        return XRootWindow.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        XToolkit.awtLock();
        try {
            if (this.hints != null) {
                XlibWrapper.XFree(this.hints.pData);
                this.hints = null;
            }
            XToolkit.removeFromWinMap(this.getWindow(), this);
            XlibWrapper.XDestroyWindow(XToolkit.getDisplay(), this.getWindow());
            if (XPropertyCache.isCachingSupported()) {
                XPropertyCache.clearCache(this.window);
            }
            this.window = -1L;
            if (!this.isDisposed()) {
                this.setDisposed(true);
            }
            XAwtState.getGrabWindow();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWMHints(XWMHints hints) {
        XToolkit.awtLock();
        try {
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public XWMHints getWMHints() {
        if (this.wmHints == null) {
            this.wmHints = new XWMHints(XlibWrapper.XAllocWMHints());
        }
        return this.wmHints;
    }

    public XSizeHints getHints() {
        if (this.hints == null) {
            long p_hints = XlibWrapper.XAllocSizeHints();
            this.hints = new XSizeHints(p_hints);
        }
        return this.hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeHints(long flags, int x, int y, int width, int height) {
        if (insLog.isLoggable(400)) {
            insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(flags));
        }
        XToolkit.awtLock();
        try {
            XSizeHints hints = this.getHints();
            if ((flags & 4L) != 0L) {
                hints.set_x(x);
                hints.set_y(y);
            }
            if ((flags & 8L) != 0L) {
                hints.set_width(width);
                hints.set_height(height);
            } else if ((hints.get_flags() & 8L) != 0L) {
                flags |= 8L;
            }
            if ((flags & 0x10L) != 0L) {
                hints.set_min_width(width);
                hints.set_min_height(height);
            } else if ((hints.get_flags() & 0x10L) != 0L) {
                flags |= 0x10L;
            }
            if ((flags & 0x20L) != 0L) {
                if (this.maxBounds != null) {
                    if (this.maxBounds.width != Integer.MAX_VALUE) {
                        hints.set_max_width(this.maxBounds.width);
                    } else {
                        hints.set_max_width(XToolkit.getDefaultScreenWidth());
                    }
                    if (this.maxBounds.height != Integer.MAX_VALUE) {
                        hints.set_max_height(this.maxBounds.height);
                    } else {
                        hints.set_max_height(XToolkit.getDefaultScreenHeight());
                    }
                } else {
                    hints.set_max_width(width);
                    hints.set_max_height(height);
                }
            } else if ((hints.get_flags() & 0x20L) != 0L) {
                flags |= 0x20L;
                if (this.maxBounds != null) {
                    if (this.maxBounds.width != Integer.MAX_VALUE) {
                        hints.set_max_width(this.maxBounds.width);
                    } else {
                        hints.set_max_width(XToolkit.getDefaultScreenWidth());
                    }
                    if (this.maxBounds.height != Integer.MAX_VALUE) {
                        hints.set_max_height(this.maxBounds.height);
                    } else {
                        hints.set_max_height(XToolkit.getDefaultScreenHeight());
                    }
                }
            }
            hints.set_flags(flags |= 0x200L);
            hints.set_win_gravity(1);
            if (insLog.isLoggable(400)) {
                insLog.finer("Setting hints, resulted flags " + XlibWrapper.hintsToString(flags) + ", values " + hints);
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isMinSizeSet() {
        XSizeHints hints = this.getHints();
        long flags = hints.get_flags();
        return (flags & 0x10L) == 16L;
    }

    Object getStateLock() {
        return this.state_lock;
    }

    public long getWindow() {
        return this.window;
    }

    public long getContentWindow() {
        return this.window;
    }

    public XBaseWindow getContentXWindow() {
        return XToolkit.windowToXWindow(this.getContentWindow());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFront() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xRequestFocus(long time) {
        XToolkit.awtLock();
        try {
            if (focusLog.isLoggable(400)) {
                focusLog.finer("XSetInputFocus on " + Long.toHexString(this.getWindow()) + " with time " + time);
            }
            XlibWrapper.XSetInputFocus2(XToolkit.getDisplay(), this.getWindow(), time);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xRequestFocus() {
        XToolkit.awtLock();
        try {
            if (focusLog.isLoggable(400)) {
                focusLog.finer("XSetInputFocus on " + Long.toHexString(this.getWindow()));
            }
            XlibWrapper.XSetInputFocus(XToolkit.getDisplay(), this.getWindow());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long xGetInputFocus() {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.XGetInputFocus(XToolkit.getDisplay());
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetVisible(boolean visible) {
        if (log.isLoggable(500)) {
            log.fine("Setting visible on " + this + " to " + visible);
        }
        XToolkit.awtLock();
        try {
            this.visible = visible;
            if (visible) {
                XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    boolean isMapped() {
        return this.mapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWMName() {
        String name = this.getWMName();
        XToolkit.awtLock();
        try {
            if (name == null) {
                name = " ";
            }
            XAtom nameAtom = XAtom.get(39L);
            nameAtom.setProperty(this.getWindow(), name);
            XAtom netNameAtom = XAtom.get("_NET_WM_NAME");
            netNameAtom.setPropertyUTF8(this.getWindow(), name);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWMClass(String[] cl) {
        if (cl.length != 2) {
            throw new IllegalArgumentException("WM_CLASS_NAME consists of exactly two strings");
        }
        XToolkit.awtLock();
        try {
            XAtom xa = XAtom.get(67L);
            xa.setProperty8(this.getWindow(), cl[0] + '\u0000' + cl[1]);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getScreenOfWindow(long window) {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.getScreenOfWindow(XToolkit.getDisplay(), window);
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getScreenNumber() {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.XScreenNumberOfScreen(this.getScreen());
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    long getScreen() {
        if (this.screen == -1L) {
            this.screen = XBaseWindow.getScreenOfWindow(this.window);
        }
        return this.screen;
    }

    public void xSetBounds(Rectangle bounds) {
        this.xSetBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetBounds(int x, int y, int width, int height) {
        if (this.getWindow() == 0L) {
            insLog.warning("Attempt to resize uncreated window");
            throw new IllegalStateException("Attempt to resize uncreated window");
        }
        insLog.fine("Setting bounds on " + this + " to (" + x + ", " + y + "), " + width + "x" + height);
        width = Math.max(1, width);
        height = Math.max(1, height);
        XToolkit.awtLock();
        try {
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), this.getWindow(), x, y, width, height);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static Point toOtherWindow(long src, long dst, int x, int y) {
        Point rpt = new Point(0, 0);
        XBaseWindow srcPeer = XToolkit.windowToXWindow(src);
        XBaseWindow dstPeer = XToolkit.windowToXWindow(dst);
        if (srcPeer != null && dstPeer != null) {
            rpt.x = x + srcPeer.getAbsoluteX() - dstPeer.getAbsoluteX();
            rpt.y = y + srcPeer.getAbsoluteY() - dstPeer.getAbsoluteY();
        } else if (dstPeer != null && XlibUtil.isRoot(src, dstPeer.getScreenNumber())) {
            rpt.x = x - dstPeer.getAbsoluteX();
            rpt.y = y - dstPeer.getAbsoluteY();
        } else if (srcPeer != null && XlibUtil.isRoot(dst, srcPeer.getScreenNumber())) {
            rpt.x = x + srcPeer.getAbsoluteX();
            rpt.y = y + srcPeer.getAbsoluteY();
        } else {
            rpt = XlibUtil.translateCoordinates(src, dst, new Point(x, y));
        }
        return rpt;
    }

    Rectangle toGlobal(Rectangle rec) {
        Point p = this.toGlobal(rec.getLocation());
        Rectangle newRec = new Rectangle(rec);
        if (p != null) {
            newRec.setLocation(p);
        }
        return newRec;
    }

    Point toGlobal(Point pt) {
        Point p = this.toGlobal(pt.x, pt.y);
        if (p != null) {
            return p;
        }
        return new Point(pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point toGlobal(int x, int y) {
        long root;
        XToolkit.awtLock();
        try {
            root = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
        }
        finally {
            XToolkit.awtUnlock();
        }
        Point p = XBaseWindow.toOtherWindow(this.getContentWindow(), root, x, y);
        if (p != null) {
            return p;
        }
        return new Point(x, y);
    }

    Point toLocal(Point pt) {
        Point p = this.toLocal(pt.x, pt.y);
        if (p != null) {
            return p;
        }
        return new Point(pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point toLocal(int x, int y) {
        long root;
        XToolkit.awtLock();
        try {
            root = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
        }
        finally {
            XToolkit.awtUnlock();
        }
        Point p = XBaseWindow.toOtherWindow(root, this.getContentWindow(), x, y);
        if (p != null) {
            return p;
        }
        return new Point(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grabInput() {
        grabLog.fine("Grab input on {0}", this);
        XToolkit.awtLock();
        try {
            if (XAwtState.getGrabWindow() == this && XAwtState.isManualGrab()) {
                grabLog.fine("    Already Grabbed");
                boolean bl = true;
                return bl;
            }
            XBaseWindow prevGrabWindow = XAwtState.getGrabWindow();
            int eventMask = 8316;
            boolean ownerEvents = true;
            if (!XToolkit.getSunAwtDisableGrab()) {
                int ptrGrab = XlibWrapper.XGrabPointer(XToolkit.getDisplay(), this.getContentWindow(), 1, 8316, 1, 1, 0L, XWM.isMotif() ? (long)XToolkit.arrowCursor : 0L, 0L);
                if (ptrGrab != 0) {
                    XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                    XAwtState.setGrabWindow(null);
                    grabLog.fine("    Grab Failure - mouse");
                    boolean bl = false;
                    return bl;
                }
                int keyGrab = XlibWrapper.XGrabKeyboard(XToolkit.getDisplay(), this.getContentWindow(), 1, 1, 1, 0L);
                if (keyGrab != 0) {
                    XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                    XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), 0L);
                    XAwtState.setGrabWindow(null);
                    grabLog.fine("    Grab Failure - keyboard");
                    boolean bl = false;
                    return bl;
                }
            }
            if (prevGrabWindow != null) {
                prevGrabWindow.ungrabInputImpl();
            }
            XAwtState.setGrabWindow(this);
            grabLog.fine("    Grab - success");
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ungrabInput() {
        XToolkit.awtLock();
        try {
            XBaseWindow grabWindow = XAwtState.getGrabWindow();
            grabLog.fine("UnGrab input on {0}", grabWindow);
            if (grabWindow != null) {
                grabWindow.ungrabInputImpl();
                if (!XToolkit.getSunAwtDisableGrab()) {
                    XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                    XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), 0L);
                }
                XAwtState.setGrabWindow(null);
                XlibWrapper.XFlush(XToolkit.getDisplay());
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void ungrabInputImpl() {
    }

    static void checkSecurity() {
        if (XToolkit.isSecurityWarningEnabled() && XToolkit.isToolkitThread()) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            log.warning(stack[1] + ": Security violation: calling user code on toolkit thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getChildren() {
        Object object = this.getStateLock();
        synchronized (object) {
            return new HashSet<Long>(this.children);
        }
    }

    public void handleMapNotifyEvent(XEvent xev) {
        this.mapped = true;
    }

    public void handleUnmapNotifyEvent(XEvent xev) {
        this.mapped = false;
    }

    public void handleReparentNotifyEvent(XEvent xev) {
        if (eventLog.isLoggable(400)) {
            XReparentEvent msg = xev.get_xreparent();
            eventLog.finer(msg.toString());
        }
    }

    public void handlePropertyNotify(XEvent xev) {
        XPropertyEvent msg = xev.get_xproperty();
        if (XPropertyCache.isCachingSupported()) {
            XPropertyCache.clearCache(this.window, XAtom.get(msg.get_atom()));
        }
        if (eventLog.isLoggable(400)) {
            eventLog.finer("{0}", msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDestroyNotify(XEvent xev) {
        XAnyEvent xany = xev.get_xany();
        if (xany.get_window() == this.getWindow()) {
            XToolkit.removeFromWinMap(this.getWindow(), this);
            if (XPropertyCache.isCachingSupported()) {
                XPropertyCache.clearCache(this.getWindow());
            }
        }
        if (xany.get_window() != this.getWindow()) {
            Object object = this.getStateLock();
            synchronized (object) {
                this.children.remove(xany.get_window());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateNotify(XEvent xev) {
        XAnyEvent xany = xev.get_xany();
        if (xany.get_window() != this.getWindow()) {
            Object object = this.getStateLock();
            synchronized (object) {
                this.children.add(xany.get_window());
            }
        }
    }

    public void handleClientMessage(XEvent xev) {
        if (eventLog.isLoggable(400)) {
            XClientMessageEvent msg = xev.get_xclient();
            eventLog.finer(msg.toString());
        }
    }

    public void handleVisibilityEvent(XEvent xev) {
    }

    public void handleKeyPress(XEvent xev) {
    }

    public void handleKeyRelease(XEvent xev) {
    }

    public void handleExposeEvent(XEvent xev) {
    }

    public void handleButtonPressRelease(XEvent xev) {
        XButtonEvent xbe = xev.get_xbutton();
        if (xbe.get_button() > 20) {
            return;
        }
        int buttonState = 0;
        int buttonsNumber = ((SunToolkit)Toolkit.getDefaultToolkit()).getNumberOfButtons();
        for (int i = 0; i < buttonsNumber; ++i) {
            buttonState |= xbe.get_state() & XConstants.buttonsMask[i];
        }
        switch (xev.get_type()) {
            case 4: {
                if (buttonState != 0) break;
                XAwtState.setAutoGrabWindow(this);
                break;
            }
            case 5: {
                if (!XBaseWindow.isFullRelease(buttonState, xbe.get_button())) break;
                XAwtState.setAutoGrabWindow(null);
            }
        }
    }

    public void handleMotionNotify(XEvent xev) {
    }

    public void handleXCrossingEvent(XEvent xev) {
    }

    public void handleConfigureNotifyEvent(XEvent xev) {
        XConfigureEvent xe = xev.get_xconfigure();
        insLog.finer("Configure, {0}", xe);
        this.x = xe.get_x();
        this.y = xe.get_y();
        this.width = xe.get_width();
        this.height = xe.get_height();
    }

    static boolean isFullRelease(int buttonState, int button) {
        int buttonsNumber = ((SunToolkit)Toolkit.getDefaultToolkit()).getNumberOfButtons();
        if (button < 0 || button > buttonsNumber) {
            return buttonState == 0;
        }
        return buttonState == XConstants.buttonsMask[button - 1];
    }

    static boolean isGrabbedEvent(XEvent ev, XBaseWindow target) {
        switch (ev.get_type()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 7: 
            case 8: {
                return target instanceof XWindowPeer;
            }
        }
        return false;
    }

    static void dispatchToWindow(XEvent ev) {
        XBaseWindow target = XAwtState.getGrabWindow();
        if (target == null || !XBaseWindow.isGrabbedEvent(ev, target)) {
            target = XToolkit.windowToXWindow(ev.get_xany().get_window());
        }
        if (target != null && target.checkInitialised()) {
            target.dispatchEvent(ev);
        }
    }

    public void dispatchEvent(XEvent xev) {
        if (eventLog.isLoggable(300)) {
            eventLog.finest(xev.toString());
        }
        int type = xev.get_type();
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                this.handleVisibilityEvent(xev);
                break;
            }
            case 33: {
                this.handleClientMessage(xev);
                break;
            }
            case 12: 
            case 13: {
                this.handleExposeEvent(xev);
                break;
            }
            case 4: 
            case 5: {
                this.handleButtonPressRelease(xev);
                break;
            }
            case 6: {
                this.handleMotionNotify(xev);
                break;
            }
            case 2: {
                this.handleKeyPress(xev);
                break;
            }
            case 3: {
                this.handleKeyRelease(xev);
                break;
            }
            case 7: 
            case 8: {
                this.handleXCrossingEvent(xev);
                break;
            }
            case 22: {
                this.handleConfigureNotifyEvent(xev);
                break;
            }
            case 19: {
                this.handleMapNotifyEvent(xev);
                break;
            }
            case 18: {
                this.handleUnmapNotifyEvent(xev);
                break;
            }
            case 21: {
                this.handleReparentNotifyEvent(xev);
                break;
            }
            case 28: {
                this.handlePropertyNotify(xev);
                break;
            }
            case 17: {
                this.handleDestroyNotify(xev);
                break;
            }
            case 16: {
                this.handleCreateNotify(xev);
            }
        }
    }

    protected boolean isEventDisabled(XEvent e) {
        return false;
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    void setDisposed(boolean d) {
        this.disposed = d;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public int getAbsoluteX() {
        XBaseWindow pw = this.getParentWindow();
        if (pw != null) {
            return pw.getAbsoluteX() + this.getX();
        }
        return this.getX();
    }

    public int getAbsoluteY() {
        XBaseWindow pw = this.getParentWindow();
        if (pw != null) {
            return pw.getAbsoluteY() + this.getY();
        }
        return this.getY();
    }

    public XBaseWindow getParentWindow() {
        return this.parentWindow;
    }

    public XWindowPeer getToplevelXWindow() {
        XBaseWindow bw;
        for (bw = this; bw != null && !(bw instanceof XWindowPeer); bw = bw.getParentWindow()) {
        }
        return (XWindowPeer)bw;
    }

    public String toString() {
        return super.toString() + "(" + Long.toString(this.getWindow(), 16) + ")";
    }

    public boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight();
    }

    public boolean containsGlobal(int x, int y) {
        return x >= this.getAbsoluteX() && y >= this.getAbsoluteY() && x < this.getAbsoluteX() + this.getWidth() && y < this.getAbsoluteY() + this.getHeight();
    }

    static class StateLock {
        StateLock() {
        }
    }

    static enum InitialiseState {
        INITIALISING,
        NOT_INITIALISED,
        INITIALISED,
        FAILED_INITIALISATION;

    }
}

