/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import sun.reflect.misc.ConstructorUtil;

public class DefaultFormatter
extends JFormattedTextField.AbstractFormatter
implements Cloneable,
Serializable {
    private boolean allowsInvalid = true;
    private boolean overwriteMode = true;
    private boolean commitOnEdit;
    private Class<?> valueClass;
    private NavigationFilter navigationFilter;
    private DocumentFilter documentFilter;
    transient ReplaceHolder replaceHolder;

    @Override
    public void install(JFormattedTextField ftf) {
        super.install(ftf);
        this.positionCursorAtInitialLocation();
    }

    public void setCommitsOnValidEdit(boolean commit) {
        this.commitOnEdit = commit;
    }

    public boolean getCommitsOnValidEdit() {
        return this.commitOnEdit;
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setAllowsInvalid(boolean allowsInvalid) {
        this.allowsInvalid = allowsInvalid;
    }

    public boolean getAllowsInvalid() {
        return this.allowsInvalid;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        Object value;
        Class<?> vc = this.getValueClass();
        JFormattedTextField ftf = this.getFormattedTextField();
        if (vc == null && ftf != null && (value = ftf.getValue()) != null) {
            vc = value.getClass();
        }
        if (vc != null) {
            Constructor cons;
            try {
                cons = ConstructorUtil.getConstructor(vc, new Class[]{String.class});
            }
            catch (NoSuchMethodException nsme) {
                cons = null;
            }
            if (cons != null) {
                try {
                    return cons.newInstance(string);
                }
                catch (Throwable ex) {
                    throw new ParseException("Error creating instance", 0);
                }
            }
        }
        return string;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        if (this.documentFilter == null) {
            this.documentFilter = new DefaultDocumentFilter();
        }
        return this.documentFilter;
    }

    @Override
    protected NavigationFilter getNavigationFilter() {
        if (this.navigationFilter == null) {
            this.navigationFilter = new DefaultNavigationFilter();
        }
        return this.navigationFilter;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultFormatter formatter = (DefaultFormatter)super.clone();
        formatter.navigationFilter = null;
        formatter.documentFilter = null;
        formatter.replaceHolder = null;
        return formatter;
    }

    void positionCursorAtInitialLocation() {
        JFormattedTextField ftf = this.getFormattedTextField();
        if (ftf != null) {
            ftf.setCaretPosition(this.getInitialVisualPosition());
        }
    }

    int getInitialVisualPosition() {
        return this.getNextNavigatableChar(0, 1);
    }

    boolean isNavigatable(int offset) {
        return true;
    }

    boolean isLegalInsertText(String text) {
        return true;
    }

    private int getNextNavigatableChar(int offset, int direction) {
        int max = this.getFormattedTextField().getDocument().getLength();
        while (offset >= 0 && offset < max) {
            if (this.isNavigatable(offset)) {
                return offset;
            }
            offset += direction;
        }
        return offset;
    }

    String getReplaceString(int offset, int deleteLength, String replaceString) {
        String string = this.getFormattedTextField().getText();
        String result = string.substring(0, offset);
        if (replaceString != null) {
            result = result + replaceString;
        }
        if (offset + deleteLength < string.length()) {
            result = result + string.substring(offset + deleteLength);
        }
        return result;
    }

    boolean isValidEdit(ReplaceHolder rh) {
        if (!this.getAllowsInvalid()) {
            String newString = this.getReplaceString(rh.offset, rh.length, rh.text);
            try {
                rh.value = this.stringToValue(newString);
                return true;
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return true;
    }

    void commitEdit() throws ParseException {
        JFormattedTextField ftf = this.getFormattedTextField();
        if (ftf != null) {
            ftf.commitEdit();
        }
    }

    void updateValue() {
        this.updateValue(null);
    }

    void updateValue(Object value) {
        try {
            if (value == null) {
                String string = this.getFormattedTextField().getText();
                value = this.stringToValue(string);
            }
            if (this.getCommitsOnValidEdit()) {
                this.commitEdit();
            }
            this.setEditValid(true);
        }
        catch (ParseException pe) {
            this.setEditValid(false);
        }
    }

    int getNextCursorPosition(int offset, int direction) {
        int newOffset = this.getNextNavigatableChar(offset, direction);
        int max = this.getFormattedTextField().getDocument().getLength();
        if (!this.getAllowsInvalid()) {
            if (direction == -1 && offset == newOffset) {
                if ((newOffset = this.getNextNavigatableChar(newOffset, 1)) >= max) {
                    newOffset = offset;
                }
            } else if (direction == 1 && newOffset >= max && (newOffset = this.getNextNavigatableChar(max - 1, -1)) < max) {
                ++newOffset;
            }
        }
        return newOffset;
    }

    void repositionCursor(int offset, int direction) {
        this.getFormattedTextField().getCaret().setDot(this.getNextCursorPosition(offset, direction));
    }

    int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int value = text.getUI().getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
        if (value == -1) {
            return -1;
        }
        if (!(this.getAllowsInvalid() || direction != 3 && direction != 7)) {
            int last = -1;
            while (!this.isNavigatable(value) && value != last) {
                last = value;
                value = text.getUI().getNextVisualPositionFrom(text, value, bias, direction, biasRet);
            }
            int max = this.getFormattedTextField().getDocument().getLength();
            if (last == value || value == max) {
                if (value == 0) {
                    biasRet[0] = Position.Bias.Forward;
                    value = this.getInitialVisualPosition();
                }
                if (value >= max && max > 0) {
                    biasRet[0] = Position.Bias.Forward;
                    value = this.getNextNavigatableChar(max - 1, -1) + 1;
                }
            }
        }
        return value;
    }

    boolean canReplace(ReplaceHolder rh) {
        return this.isValidEdit(rh);
    }

    void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        ReplaceHolder rh = this.getReplaceHolder(fb, offset, length, text, attrs);
        this.replace(rh);
    }

    boolean replace(ReplaceHolder rh) throws BadLocationException {
        boolean valid = true;
        int direction = 1;
        if (!(rh.length <= 0 || rh.text != null && rh.text.length() != 0 || this.getFormattedTextField().getSelectionStart() == rh.offset && rh.length <= 1)) {
            direction = -1;
        }
        if (this.getOverwriteMode() && rh.text != null && this.getFormattedTextField().getSelectedText() == null) {
            rh.length = Math.min(Math.max(rh.length, rh.text.length()), rh.fb.getDocument().getLength() - rh.offset);
        }
        if (rh.text != null && !this.isLegalInsertText(rh.text) || !this.canReplace(rh) || rh.length == 0 && (rh.text == null || rh.text.length() == 0)) {
            valid = false;
        }
        if (valid) {
            int cursor = rh.cursorPosition;
            rh.fb.replace(rh.offset, rh.length, rh.text, rh.attrs);
            if (cursor == -1) {
                cursor = rh.offset;
                if (direction == 1 && rh.text != null) {
                    cursor = rh.offset + rh.text.length();
                }
            }
            this.updateValue(rh.value);
            this.repositionCursor(cursor, direction);
            return true;
        }
        this.invalidEdit();
        return false;
    }

    void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
        fb.setDot(dot, bias);
    }

    void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
        fb.moveDot(dot, bias);
    }

    ReplaceHolder getReplaceHolder(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
        if (this.replaceHolder == null) {
            this.replaceHolder = new ReplaceHolder();
        }
        this.replaceHolder.reset(fb, offset, length, text, attrs);
        return this.replaceHolder;
    }

    private class DefaultDocumentFilter
    extends DocumentFilter
    implements Serializable {
        private DefaultDocumentFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            JFormattedTextField tc = DefaultFormatter.this.getFormattedTextField();
            if (tc.composedTextExists()) {
                fb.remove(offset, length);
            } else {
                DefaultFormatter.this.replace(fb, offset, length, null, null);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            JFormattedTextField tc = DefaultFormatter.this.getFormattedTextField();
            if (tc.composedTextExists() || Utilities.isComposedTextAttributeDefined(attr)) {
                fb.insertString(offset, string, attr);
            } else {
                DefaultFormatter.this.replace(fb, offset, 0, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
            JFormattedTextField tc = DefaultFormatter.this.getFormattedTextField();
            if (tc.composedTextExists() || Utilities.isComposedTextAttributeDefined(attr)) {
                fb.replace(offset, length, text, attr);
            } else {
                DefaultFormatter.this.replace(fb, offset, length, text, attr);
            }
        }
    }

    private class DefaultNavigationFilter
    extends NavigationFilter
    implements Serializable {
        private DefaultNavigationFilter() {
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            JFormattedTextField tc = DefaultFormatter.this.getFormattedTextField();
            if (tc.composedTextExists()) {
                fb.setDot(dot, bias);
            } else {
                DefaultFormatter.this.setDot(fb, dot, bias);
            }
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            JFormattedTextField tc = DefaultFormatter.this.getFormattedTextField();
            if (tc.composedTextExists()) {
                fb.moveDot(dot, bias);
            } else {
                DefaultFormatter.this.moveDot(fb, dot, bias);
            }
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (text.composedTextExists()) {
                return text.getUI().getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
            }
            return DefaultFormatter.this.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
        }
    }

    static class ReplaceHolder {
        DocumentFilter.FilterBypass fb;
        int offset;
        int length;
        String text;
        AttributeSet attrs;
        Object value;
        int cursorPosition;

        ReplaceHolder() {
        }

        void reset(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
            this.fb = fb;
            this.offset = offset;
            this.length = length;
            this.text = text;
            this.attrs = attrs;
            this.value = null;
            this.cursorPosition = -1;
        }
    }
}

