/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected JInternalFrame frame;
    private Handler handler;
    protected MouseInputAdapter borderListener;
    protected PropertyChangeListener propertyChangeListener;
    protected LayoutManager internalFrameLayout;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    private InternalFrameListener internalFrameListener;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected JComponent eastPane;
    protected BasicInternalFrameTitlePane titlePane;
    private static DesktopManager sharedDesktopManager;
    private boolean componentListenerAdded = false;
    private Rectangle parentBounds;
    private boolean dragging = false;
    private boolean resizing = false;
    @Deprecated
    protected KeyStroke openMenuKey;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;

    public static ComponentUI createUI(JComponent b) {
        return new BasicInternalFrameUI((JInternalFrame)b);
    }

    public BasicInternalFrameUI(JInternalFrame b) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof BasicLookAndFeel) {
            ((BasicLookAndFeel)laf).installAWTEventListener();
        }
    }

    @Override
    public void installUI(JComponent c) {
        this.frame = (JInternalFrame)c;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        LookAndFeel.installProperty(this.frame, "opaque", Boolean.TRUE);
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c != this.frame) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + c + " when it only knows about " + this.frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.updateFrameCursor();
        this.handler = null;
        this.frame = null;
    }

    protected void installDefaults() {
        Color bg;
        Container contentPane;
        Icon frameIcon = this.frame.getFrameIcon();
        if (frameIcon == null || frameIcon instanceof UIResource) {
            this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
        if ((contentPane = this.frame.getContentPane()) != null && (bg = contentPane.getBackground()) instanceof UIResource) {
            contentPane.setBackground(null);
        }
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        this.frame.setBackground(UIManager.getLookAndFeelDefaults().getColor("control"));
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
    }

    protected void installKeyboardActions() {
        this.createInternalFrameListener();
        if (this.internalFrameListener != null) {
            this.frame.addInternalFrameListener(this.internalFrameListener);
        }
        LazyActionMap.installLazyActionMap(this.frame, BasicInternalFrameUI.class, "InternalFrame.actionMap");
    }

    static void loadActionMap(LazyActionMap map) {
        map.put(new UIAction("showSystemMenu"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComponent comp;
                JInternalFrame iFrame = (JInternalFrame)evt.getSource();
                if (iFrame.getUI() instanceof BasicInternalFrameUI && (comp = ((BasicInternalFrameUI)iFrame.getUI()).getNorthPane()) instanceof BasicInternalFrameTitlePane) {
                    ((BasicInternalFrameTitlePane)comp).showSystemMenu();
                }
            }

            @Override
            public boolean isEnabled(Object sender) {
                JInternalFrame iFrame;
                if (sender instanceof JInternalFrame && (iFrame = (JInternalFrame)sender).getUI() instanceof BasicInternalFrameUI) {
                    return ((BasicInternalFrameUI)iFrame.getUI()).isKeyBindingActive();
                }
                return false;
            }
        });
        BasicLookAndFeel.installAudioActionMap(map);
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.borderListener = this.createBorderListener(this.frame);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.installMouseHandlers(this.frame);
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        if (this.glassPaneDispatcher != null) {
            this.frame.getGlassPane().addMouseListener(this.glassPaneDispatcher);
            this.frame.getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
        }
        this.componentListener = this.createComponentListener();
        if (this.frame.getParent() != null) {
            this.parentBounds = this.frame.getParent().getBounds();
        }
        if (this.frame.getParent() != null && !this.componentListenerAdded) {
            this.frame.getParent().addComponentListener(this.componentListener);
            this.componentListenerAdded = true;
        }
    }

    private WindowFocusListener getWindowFocusListener() {
        return this.getHandler();
    }

    private void cancelResize() {
        if (this.resizing && this.borderListener instanceof BorderListener) {
            ((BorderListener)this.borderListener).finishMouseReleased();
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap getInputMap(int condition) {
        if (condition == 2) {
            return this.createInputMap(condition);
        }
        return null;
    }

    InputMap createInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])DefaultLookup.get(this.frame, this, "InternalFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.frame, bindings);
        }
        return null;
    }

    protected void uninstallDefaults() {
        Icon frameIcon = this.frame.getFrameIcon();
        if (frameIcon instanceof UIResource) {
            this.frame.setFrameIcon(null);
        }
        this.internalFrameLayout = null;
        this.frame.setLayout(null);
        LookAndFeel.uninstallBorder(this.frame);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        if (this.titlePane != null) {
            this.titlePane.uninstallDefaults();
        }
        this.titlePane = null;
    }

    protected void uninstallListeners() {
        if (this.frame.getParent() != null && this.componentListenerAdded) {
            this.frame.getParent().removeComponentListener(this.componentListener);
            this.componentListenerAdded = false;
        }
        this.componentListener = null;
        if (this.glassPaneDispatcher != null) {
            this.frame.getGlassPane().removeMouseListener(this.glassPaneDispatcher);
            this.frame.getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
            this.glassPaneDispatcher = null;
        }
        this.deinstallMouseHandlers(this.frame);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.borderListener = null;
    }

    protected void uninstallKeyboardActions() {
        if (this.internalFrameListener != null) {
            this.frame.removeInternalFrameListener(this.internalFrameListener);
        }
        this.internalFrameListener = null;
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
        SwingUtilities.replaceUIActionMap(this.frame, null);
    }

    void updateFrameCursor() {
        if (this.resizing) {
            return;
        }
        Cursor s = this.frame.getLastCursor();
        if (s == null) {
            s = Cursor.getPredefinedCursor(0);
        }
        this.frame.setCursor(s);
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    @Override
    public Dimension getPreferredSize(JComponent x) {
        if (this.frame == x) {
            return this.frame.getLayout().preferredLayoutSize(x);
        }
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getMinimumSize(JComponent x) {
        if (this.frame == x) {
            return this.frame.getLayout().minimumLayoutSize(x);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this.frame.remove(currentPane);
        }
        if (newPane != null) {
            this.frame.add(newPane);
            this.installMouseHandlers(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c) {
        c.removeMouseListener(this.borderListener);
        c.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent c) {
        c.addMouseListener(this.borderListener);
        c.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new BasicInternalFrameTitlePane(w);
        return this.titlePane;
    }

    protected JComponent createSouthPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createWestPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame w) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame w) {
        return new BorderListener();
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = this.getHandler();
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean b) {
        this.keyBindingRegistered = b;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean b) {
        this.keyBindingActive = b;
    }

    protected void setupMenuOpenKey() {
        InputMap map = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.frame, 2, map);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent c) {
        if (this.northPane != null && this.northPane instanceof BasicInternalFrameTitlePane) {
            ((BasicInternalFrameTitlePane)this.northPane).uninstallListeners();
        }
        this.replacePane(this.northPane, c);
        this.northPane = c;
        if (c instanceof BasicInternalFrameTitlePane) {
            this.titlePane = (BasicInternalFrameTitlePane)c;
        }
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent c) {
        this.southPane = c;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    public void setWestPane(JComponent c) {
        this.westPane = c;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setEastPane(JComponent c) {
        this.eastPane = c;
    }

    protected DesktopManager getDesktopManager() {
        if (this.frame.getDesktopPane() != null && this.frame.getDesktopPane().getDesktopManager() != null) {
            return this.frame.getDesktopPane().getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame f) {
        BasicLookAndFeel.playSound(this.frame, "InternalFrame.closeSound");
        this.getDesktopManager().closeFrame(f);
    }

    protected void maximizeFrame(JInternalFrame f) {
        BasicLookAndFeel.playSound(this.frame, "InternalFrame.maximizeSound");
        this.getDesktopManager().maximizeFrame(f);
    }

    protected void minimizeFrame(JInternalFrame f) {
        if (!f.isIcon()) {
            BasicLookAndFeel.playSound(this.frame, "InternalFrame.restoreDownSound");
        }
        this.getDesktopManager().minimizeFrame(f);
    }

    protected void iconifyFrame(JInternalFrame f) {
        BasicLookAndFeel.playSound(this.frame, "InternalFrame.minimizeSound");
        this.getDesktopManager().iconifyFrame(f);
    }

    protected void deiconifyFrame(JInternalFrame f) {
        if (!f.isMaximum()) {
            BasicLookAndFeel.playSound(this.frame, "InternalFrame.restoreUpSound");
        }
        this.getDesktopManager().deiconifyFrame(f);
    }

    protected void activateFrame(JInternalFrame f) {
        this.getDesktopManager().activateFrame(f);
    }

    protected void deactivateFrame(JInternalFrame f) {
        this.getDesktopManager().deactivateFrame(f);
    }

    protected ComponentListener createComponentListener() {
        return this.getHandler();
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return null;
    }

    private class Handler
    implements ComponentListener,
    InternalFrameListener,
    LayoutManager,
    MouseInputListener,
    PropertyChangeListener,
    WindowFocusListener,
    SwingConstants {
        private Handler() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            BasicInternalFrameUI.this.cancelResize();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Rectangle parentNewBounds = ((Component)e.getSource()).getBounds();
            Component icon = null;
            if (BasicInternalFrameUI.this.frame != null) {
                icon = BasicInternalFrameUI.this.frame.getDesktopIcon();
                if (BasicInternalFrameUI.this.frame.isMaximum()) {
                    BasicInternalFrameUI.this.frame.setBounds(0, 0, parentNewBounds.width, parentNewBounds.height);
                }
            }
            if (icon != null) {
                Rectangle iconBounds = icon.getBounds();
                int y = iconBounds.y + (parentNewBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height);
                icon.setBounds(iconBounds.x, y, iconBounds.width, iconBounds.height);
            }
            if (!BasicInternalFrameUI.this.parentBounds.equals(parentNewBounds)) {
                BasicInternalFrameUI.this.parentBounds = parentNewBounds;
            }
            if (BasicInternalFrameUI.this.frame != null) {
                BasicInternalFrameUI.this.frame.validate();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            BasicInternalFrameUI.this.frame.removeInternalFrameListener(BasicInternalFrameUI.this.getHandler());
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            if (!BasicInternalFrameUI.this.isKeyBindingRegistered()) {
                BasicInternalFrameUI.this.setKeyBindingRegistered(true);
                BasicInternalFrameUI.this.setupMenuOpenKey();
                BasicInternalFrameUI.this.setupMenuCloseKey();
            }
            if (BasicInternalFrameUI.this.isKeyBindingRegistered()) {
                BasicInternalFrameUI.this.setKeyBindingActive(true);
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            BasicInternalFrameUI.this.setKeyBindingActive(false);
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Dimension d;
            Insets i = BasicInternalFrameUI.this.frame.getInsets();
            Dimension result = new Dimension(BasicInternalFrameUI.this.frame.getRootPane().getPreferredSize());
            result.width += i.left + i.right;
            result.height += i.top + i.bottom;
            if (BasicInternalFrameUI.this.getNorthPane() != null) {
                d = BasicInternalFrameUI.this.getNorthPane().getPreferredSize();
                result.width = Math.max(d.width, result.width);
                result.height += d.height;
            }
            if (BasicInternalFrameUI.this.getSouthPane() != null) {
                d = BasicInternalFrameUI.this.getSouthPane().getPreferredSize();
                result.width = Math.max(d.width, result.width);
                result.height += d.height;
            }
            if (BasicInternalFrameUI.this.getEastPane() != null) {
                d = BasicInternalFrameUI.this.getEastPane().getPreferredSize();
                result.width += d.width;
                result.height = Math.max(d.height, result.height);
            }
            if (BasicInternalFrameUI.this.getWestPane() != null) {
                d = BasicInternalFrameUI.this.getWestPane().getPreferredSize();
                result.width += d.width;
                result.height = Math.max(d.height, result.height);
            }
            return result;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Dimension result = new Dimension();
            if (BasicInternalFrameUI.this.getNorthPane() != null && BasicInternalFrameUI.this.getNorthPane() instanceof BasicInternalFrameTitlePane) {
                result = new Dimension(BasicInternalFrameUI.this.getNorthPane().getMinimumSize());
            }
            Insets i = BasicInternalFrameUI.this.frame.getInsets();
            result.width += i.left + i.right;
            result.height += i.top + i.bottom;
            return result;
        }

        @Override
        public void layoutContainer(Container c) {
            Dimension size;
            Insets i = BasicInternalFrameUI.this.frame.getInsets();
            int cx = i.left;
            int cy = i.top;
            int cw = BasicInternalFrameUI.this.frame.getWidth() - i.left - i.right;
            int ch = BasicInternalFrameUI.this.frame.getHeight() - i.top - i.bottom;
            if (BasicInternalFrameUI.this.getNorthPane() != null) {
                size = BasicInternalFrameUI.this.getNorthPane().getPreferredSize();
                if (DefaultLookup.getBoolean(BasicInternalFrameUI.this.frame, BasicInternalFrameUI.this, "InternalFrame.layoutTitlePaneAtOrigin", false)) {
                    cy = 0;
                    ch += i.top;
                    BasicInternalFrameUI.this.getNorthPane().setBounds(0, 0, BasicInternalFrameUI.this.frame.getWidth(), size.height);
                } else {
                    BasicInternalFrameUI.this.getNorthPane().setBounds(cx, cy, cw, size.height);
                }
                cy += size.height;
                ch -= size.height;
            }
            if (BasicInternalFrameUI.this.getSouthPane() != null) {
                size = BasicInternalFrameUI.this.getSouthPane().getPreferredSize();
                BasicInternalFrameUI.this.getSouthPane().setBounds(cx, BasicInternalFrameUI.this.frame.getHeight() - i.bottom - size.height, cw, size.height);
                ch -= size.height;
            }
            if (BasicInternalFrameUI.this.getWestPane() != null) {
                size = BasicInternalFrameUI.this.getWestPane().getPreferredSize();
                BasicInternalFrameUI.this.getWestPane().setBounds(cx, cy, size.width, ch);
                cw -= size.width;
                cx += size.width;
            }
            if (BasicInternalFrameUI.this.getEastPane() != null) {
                size = BasicInternalFrameUI.this.getEastPane().getPreferredSize();
                BasicInternalFrameUI.this.getEastPane().setBounds(cw - size.width, cy, size.width, ch);
                cw -= size.width;
            }
            if (BasicInternalFrameUI.this.frame.getRootPane() != null) {
                BasicInternalFrameUI.this.frame.getRootPane().setBounds(cx, cy, cw, ch);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            JInternalFrame f = (JInternalFrame)evt.getSource();
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if ("closed" == prop) {
                if (newValue == Boolean.TRUE) {
                    BasicInternalFrameUI.this.cancelResize();
                    if (BasicInternalFrameUI.this.frame.getParent() != null && BasicInternalFrameUI.this.componentListenerAdded) {
                        BasicInternalFrameUI.this.frame.getParent().removeComponentListener(BasicInternalFrameUI.this.componentListener);
                    }
                    BasicInternalFrameUI.this.closeFrame(f);
                }
            } else if ("maximum" == prop) {
                if (newValue == Boolean.TRUE) {
                    BasicInternalFrameUI.this.maximizeFrame(f);
                } else {
                    BasicInternalFrameUI.this.minimizeFrame(f);
                }
            } else if ("icon" == prop) {
                if (newValue == Boolean.TRUE) {
                    BasicInternalFrameUI.this.iconifyFrame(f);
                } else {
                    BasicInternalFrameUI.this.deiconifyFrame(f);
                }
            } else if ("selected" == prop) {
                if (newValue == Boolean.TRUE && oldValue == Boolean.FALSE) {
                    BasicInternalFrameUI.this.activateFrame(f);
                } else if (newValue == Boolean.FALSE && oldValue == Boolean.TRUE) {
                    BasicInternalFrameUI.this.deactivateFrame(f);
                }
            } else if (prop == "ancestor") {
                if (newValue == null) {
                    BasicInternalFrameUI.this.cancelResize();
                }
                if (BasicInternalFrameUI.this.frame.getParent() != null) {
                    BasicInternalFrameUI.this.parentBounds = f.getParent().getBounds();
                } else {
                    BasicInternalFrameUI.this.parentBounds = null;
                }
                if (BasicInternalFrameUI.this.frame.getParent() != null && !BasicInternalFrameUI.this.componentListenerAdded) {
                    f.getParent().addComponentListener(BasicInternalFrameUI.this.componentListener);
                    BasicInternalFrameUI.this.componentListenerAdded = true;
                }
            } else if ("title" == prop || prop == "closable" || prop == "iconable" || prop == "maximizable") {
                Dimension dim = BasicInternalFrameUI.this.frame.getMinimumSize();
                Dimension frame_dim = BasicInternalFrameUI.this.frame.getSize();
                if (dim.width > frame_dim.width) {
                    BasicInternalFrameUI.this.frame.setSize(dim.width, frame_dim.height);
                }
            }
        }
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        protected BasicInternalFrameListener() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameClosing(e);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameClosed(e);
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameOpened(e);
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameIconified(e);
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameDeiconified(e);
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameActivated(e);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            BasicInternalFrameUI.this.getHandler().internalFrameDeactivated(e);
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        protected GlassPaneDispatcher() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mousePressed(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mouseEntered(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mouseExited(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mouseClicked(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BasicInternalFrameUI.this.getHandler().mouseDragged(e);
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            BasicInternalFrameUI.this.getHandler().componentResized(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            BasicInternalFrameUI.this.getHandler().componentMoved(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            BasicInternalFrameUI.this.getHandler().componentShown(e);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            BasicInternalFrameUI.this.getHandler().componentHidden(e);
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease = false;
        int resizeCornerSize = 16;

        protected BorderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && e.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                if (BasicInternalFrameUI.this.frame.isIconifiable() && BasicInternalFrameUI.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameUI.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException e2) {}
                } else if (BasicInternalFrameUI.this.frame.isMaximizable()) {
                    if (!BasicInternalFrameUI.this.frame.isMaximum()) {
                        try {
                            BasicInternalFrameUI.this.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException e2) {}
                    } else {
                        try {
                            BasicInternalFrameUI.this.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        void finishMouseReleased() {
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                BasicInternalFrameUI.this.getDesktopManager().endDraggingFrame(BasicInternalFrameUI.this.frame);
                BasicInternalFrameUI.this.dragging = false;
            } else {
                Container c;
                Window windowAncestor = SwingUtilities.getWindowAncestor(BasicInternalFrameUI.this.frame);
                if (windowAncestor != null) {
                    windowAncestor.removeWindowFocusListener(BasicInternalFrameUI.this.getWindowFocusListener());
                }
                if ((c = BasicInternalFrameUI.this.frame.getTopLevelAncestor()) instanceof RootPaneContainer) {
                    Component glassPane = ((RootPaneContainer)((Object)c)).getGlassPane();
                    glassPane.setCursor(Cursor.getPredefinedCursor(0));
                    glassPane.setVisible(false);
                }
                BasicInternalFrameUI.this.getDesktopManager().endResizingFrame(BasicInternalFrameUI.this.frame);
                BasicInternalFrameUI.this.resizing = false;
                BasicInternalFrameUI.this.updateFrameCursor();
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
            this.discardRelease = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.finishMouseReleased();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            this.__x = e.getX();
            this.__y = e.getY();
            this._x = p.x;
            this._y = p.y;
            this.startingBounds = BasicInternalFrameUI.this.frame.getBounds();
            this.resizeDir = 0;
            this.discardRelease = false;
            try {
                BasicInternalFrameUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException e1) {
                // empty catch block
            }
            Insets i = BasicInternalFrameUI.this.frame.getInsets();
            Point ep = new Point(this.__x, this.__y);
            if (e.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                Point np = BasicInternalFrameUI.this.getNorthPane().getLocation();
                ep.x += np.x;
                ep.y += np.y;
            }
            if (e.getSource() == BasicInternalFrameUI.this.getNorthPane() && ep.x > i.left && ep.y > i.top && ep.x < BasicInternalFrameUI.this.frame.getWidth() - i.right) {
                BasicInternalFrameUI.this.getDesktopManager().beginDraggingFrame(BasicInternalFrameUI.this.frame);
                BasicInternalFrameUI.this.dragging = true;
                return;
            }
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (e.getSource() == BasicInternalFrameUI.this.frame || e.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                if (ep.x <= i.left) {
                    this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 8 : (ep.y > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - i.bottom ? 6 : 7);
                } else if (ep.x >= BasicInternalFrameUI.this.frame.getWidth() - i.right) {
                    this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 2 : (ep.y > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - i.bottom ? 4 : 3);
                } else if (ep.y <= i.top) {
                    this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 8 : (ep.x > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - i.right ? 2 : 1);
                } else if (ep.y >= BasicInternalFrameUI.this.frame.getHeight() - i.bottom) {
                    this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 6 : (ep.x > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - i.right ? 4 : 5);
                } else {
                    this.discardRelease = true;
                    return;
                }
                Cursor s = Cursor.getPredefinedCursor(0);
                switch (this.resizeDir) {
                    case 5: {
                        s = Cursor.getPredefinedCursor(9);
                        break;
                    }
                    case 1: {
                        s = Cursor.getPredefinedCursor(8);
                        break;
                    }
                    case 7: {
                        s = Cursor.getPredefinedCursor(10);
                        break;
                    }
                    case 3: {
                        s = Cursor.getPredefinedCursor(11);
                        break;
                    }
                    case 4: {
                        s = Cursor.getPredefinedCursor(5);
                        break;
                    }
                    case 6: {
                        s = Cursor.getPredefinedCursor(4);
                        break;
                    }
                    case 8: {
                        s = Cursor.getPredefinedCursor(6);
                        break;
                    }
                    case 2: {
                        s = Cursor.getPredefinedCursor(7);
                    }
                }
                Container c = BasicInternalFrameUI.this.frame.getTopLevelAncestor();
                if (c instanceof RootPaneContainer) {
                    Component glassPane = ((RootPaneContainer)((Object)c)).getGlassPane();
                    glassPane.setVisible(true);
                    glassPane.setCursor(s);
                }
                BasicInternalFrameUI.this.getDesktopManager().beginResizingFrame(BasicInternalFrameUI.this.frame, this.resizeDir);
                BasicInternalFrameUI.this.resizing = true;
                Window windowAncestor = SwingUtilities.getWindowAncestor(BasicInternalFrameUI.this.frame);
                if (windowAncestor != null) {
                    windowAncestor.addWindowFocusListener(BasicInternalFrameUI.this.getWindowFocusListener());
                }
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startingBounds == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            int deltaX = this._x - p.x;
            int deltaY = this._y - p.y;
            Dimension min = BasicInternalFrameUI.this.frame.getMinimumSize();
            Dimension max = BasicInternalFrameUI.this.frame.getMaximumSize();
            Insets i = BasicInternalFrameUI.this.frame.getInsets();
            if (BasicInternalFrameUI.this.dragging) {
                if (BasicInternalFrameUI.this.frame.isMaximum() || (e.getModifiers() & 0x10) != 16) {
                    return;
                }
                Dimension s = BasicInternalFrameUI.this.frame.getParent().getSize();
                int pWidth = s.width;
                int pHeight = s.height;
                int newX = this.startingBounds.x - deltaX;
                int newY = this.startingBounds.y - deltaY;
                if (newX + i.left <= -this.__x) {
                    newX = -this.__x - i.left + 1;
                }
                if (newY + i.top <= -this.__y) {
                    newY = -this.__y - i.top + 1;
                }
                if (newX + this.__x + i.right >= pWidth) {
                    newX = pWidth - this.__x - i.right - 1;
                }
                if (newY + this.__y + i.bottom >= pHeight) {
                    newY = pHeight - this.__y - i.bottom - 1;
                }
                BasicInternalFrameUI.this.getDesktopManager().dragFrame(BasicInternalFrameUI.this.frame, newX, newY);
                return;
            }
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            int newX = BasicInternalFrameUI.this.frame.getX();
            int newY = BasicInternalFrameUI.this.frame.getY();
            int newW = BasicInternalFrameUI.this.frame.getWidth();
            int newH = BasicInternalFrameUI.this.frame.getHeight();
            BasicInternalFrameUI.this.parentBounds = BasicInternalFrameUI.this.frame.getParent().getBounds();
            switch (this.resizeDir) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y - deltaY;
                    newW = this.startingBounds.width;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 2: {
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width;
                    }
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y - deltaY;
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 3: {
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width;
                    }
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height;
                    break;
                }
                case 4: {
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.width;
                    }
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height;
                    }
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 5: {
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height;
                    }
                    newW = this.startingBounds.width;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 6: {
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - ((BasicInternalFrameUI)BasicInternalFrameUI.this).parentBounds.height;
                    }
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 7: {
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height;
                    break;
                }
                case 8: {
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y - deltaY;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                default: {
                    return;
                }
            }
            BasicInternalFrameUI.this.getDesktopManager().resizeFrame(BasicInternalFrameUI.this.frame, newX, newY, newW, newH);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (e.getSource() == BasicInternalFrameUI.this.frame || e.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                Insets i = BasicInternalFrameUI.this.frame.getInsets();
                Point ep = new Point(e.getX(), e.getY());
                if (e.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                    Point np = BasicInternalFrameUI.this.getNorthPane().getLocation();
                    ep.x += np.x;
                    ep.y += np.y;
                }
                if (ep.x <= i.left) {
                    if (ep.y < this.resizeCornerSize + i.top) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (ep.y > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - i.bottom) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (ep.x >= BasicInternalFrameUI.this.frame.getWidth() - i.right) {
                    if (e.getY() < this.resizeCornerSize + i.top) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (ep.y > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - i.bottom) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (ep.y <= i.top) {
                    if (ep.x < this.resizeCornerSize + i.left) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (ep.x > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - i.right) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (ep.y >= BasicInternalFrameUI.this.frame.getHeight() - i.bottom) {
                    if (ep.x < this.resizeCornerSize + i.left) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (ep.x > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - i.right) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    BasicInternalFrameUI.this.updateFrameCursor();
                }
                return;
            }
            BasicInternalFrameUI.this.updateFrameCursor();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BasicInternalFrameUI.this.updateFrameCursor();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BasicInternalFrameUI.this.updateFrameCursor();
        }
    }

    public class InternalFrameLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
            BasicInternalFrameUI.this.getHandler().addLayoutComponent(name, c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
            BasicInternalFrameUI.this.getHandler().removeLayoutComponent(c);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return BasicInternalFrameUI.this.getHandler().preferredLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return BasicInternalFrameUI.this.getHandler().minimumLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            BasicInternalFrameUI.this.getHandler().layoutContainer(c);
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BasicInternalFrameUI.this.getHandler().propertyChange(evt);
        }
    }
}

