/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.internal.ClientCommunicatorAdmin;
import com.sun.jmx.remote.internal.ClientListenerInfo;
import com.sun.jmx.remote.internal.ClientNotifForwarder;
import com.sun.jmx.remote.internal.IIOPHelper;
import com.sun.jmx.remote.internal.ProxyRef;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXAddressable;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.NoCallStackClassLoader;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.Subject;
import sun.reflect.misc.ReflectUtil;
import sun.rmi.server.UnicastRef2;
import sun.rmi.transport.LiveRef;

public class RMIConnector
implements JMXConnector,
Serializable,
JMXAddressable {
    private static final ClassLogger logger;
    private static final long serialVersionUID = 817323035842634473L;
    private static final String rmiServerImplStubClassName;
    private static final Class<?> rmiServerImplStubClass;
    private static final String rmiConnectionImplStubClassName;
    private static final Class<?> rmiConnectionImplStubClass;
    private static final String pRefClassName = "com.sun.jmx.remote.internal.PRef";
    private static final Constructor<?> proxyRefConstructor;
    private static final String iiopConnectionStubClassName = "org.omg.stub.javax.management.remote.rmi._RMIConnection_Stub";
    private static final String proxyStubClassName = "com.sun.jmx.remote.protocol.iiop.ProxyStub";
    private static final String ProxyInputStreamClassName = "com.sun.jmx.remote.protocol.iiop.ProxyInputStream";
    private static final String pInputStreamClassName = "com.sun.jmx.remote.protocol.iiop.PInputStream";
    private static final Class<?> proxyStubClass;
    private static final byte[] base64ToInt;
    private final RMIServer rmiServer;
    private final JMXServiceURL jmxServiceURL;
    private transient Map<String, Object> env;
    private transient ClassLoader defaultClassLoader;
    private transient RMIConnection connection;
    private transient String connectionId;
    private transient long clientNotifSeqNo = 0L;
    private transient WeakHashMap<Subject, MBeanServerConnection> rmbscMap;
    private transient RMINotifClient rmiNotifClient;
    private transient long clientNotifCounter = 0L;
    private transient boolean connected;
    private transient boolean terminated;
    private transient Exception closeException;
    private transient NotificationBroadcasterSupport connectionBroadcaster;
    private transient ClientCommunicatorAdmin communicatorAdmin;
    private static volatile WeakReference<Object> orb;

    private RMIConnector(RMIServer rmiServer, JMXServiceURL address, Map<String, ?> environment) {
        if (rmiServer == null && address == null) {
            throw new IllegalArgumentException("rmiServer and jmxServiceURL both null");
        }
        this.initTransients();
        this.rmiServer = rmiServer;
        this.jmxServiceURL = address;
        if (environment == null) {
            this.env = Collections.emptyMap();
        } else {
            EnvHelp.checkAttributes(environment);
            this.env = Collections.unmodifiableMap(environment);
        }
    }

    public RMIConnector(JMXServiceURL url, Map<String, ?> environment) {
        this(null, url, environment);
    }

    public RMIConnector(RMIServer rmiServer, Map<String, ?> environment) {
        this(rmiServer, null, environment);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getName());
        b.append(":");
        if (this.rmiServer != null) {
            b.append(" rmiServer=").append(this.rmiServer.toString());
        }
        if (this.jmxServiceURL != null) {
            if (this.rmiServer != null) {
                b.append(",");
            }
            b.append(" jmxServiceURL=").append(this.jmxServiceURL.toString());
        }
        return b.toString();
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.jmxServiceURL;
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    @Override
    public synchronized void connect(Map<String, ?> environment) throws IOException {
        String idstr;
        boolean tracing = logger.traceOn();
        String string = idstr = tracing ? "[" + this.toString() + "]" : null;
        if (this.terminated) {
            logger.trace("connect", idstr + " already closed.");
            throw new IOException("Connector closed");
        }
        if (this.connected) {
            logger.trace("connect", idstr + " already connected.");
            return;
        }
        try {
            if (tracing) {
                logger.trace("connect", idstr + " connecting...");
            }
            HashMap<String, Object> usemap = new HashMap<String, Object>(this.env == null ? Collections.emptyMap() : this.env);
            if (environment != null) {
                EnvHelp.checkAttributes(environment);
                usemap.putAll(environment);
            }
            if (tracing) {
                logger.trace("connect", idstr + " finding stub...");
            }
            RMIServer stub = this.rmiServer != null ? this.rmiServer : this.findRMIServer(this.jmxServiceURL, usemap);
            String stringBoolean = (String)usemap.get("jmx.remote.x.check.stub");
            boolean checkStub = EnvHelp.computeBooleanFromString(stringBoolean);
            if (checkStub) {
                RMIConnector.checkStub(stub, rmiServerImplStubClass);
            }
            if (tracing) {
                logger.trace("connect", idstr + " connecting stub...");
            }
            stub = RMIConnector.connectStub(stub, usemap);
            String string2 = idstr = tracing ? "[" + this.toString() + "]" : null;
            if (tracing) {
                logger.trace("connect", idstr + " getting connection...");
            }
            Object credentials = usemap.get("jmx.remote.credentials");
            try {
                this.connection = RMIConnector.getConnection(stub, credentials, checkStub);
            }
            catch (RemoteException re) {
                if (this.jmxServiceURL != null) {
                    String pro = this.jmxServiceURL.getProtocol();
                    String path = this.jmxServiceURL.getURLPath();
                    if ("rmi".equals(pro) && path.startsWith("/jndi/iiop:")) {
                        MalformedURLException mfe = new MalformedURLException("Protocol is rmi but JNDI scheme is iiop: " + this.jmxServiceURL);
                        mfe.initCause(re);
                        throw mfe;
                    }
                }
                throw re;
            }
            if (tracing) {
                logger.trace("connect", idstr + " getting class loader...");
            }
            this.defaultClassLoader = EnvHelp.resolveClientClassLoader(usemap);
            usemap.put("jmx.remote.default.class.loader", this.defaultClassLoader);
            this.rmiNotifClient = new RMINotifClient(this.defaultClassLoader, usemap);
            this.env = usemap;
            long checkPeriod = EnvHelp.getConnectionCheckPeriod(usemap);
            this.communicatorAdmin = new RMIClientCommunicatorAdmin(checkPeriod);
            this.connected = true;
            this.connectionId = this.getConnectionId();
            JMXConnectionNotification connectedNotif = new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifSeqNo++, "Successful connection", null);
            this.sendNotification(connectedNotif);
            if (tracing) {
                logger.trace("connect", idstr + " done...");
            }
        }
        catch (IOException e) {
            if (tracing) {
                logger.trace("connect", idstr + " failed to connect: " + e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (tracing) {
                logger.trace("connect", idstr + " failed to connect: " + e);
            }
            throw e;
        }
        catch (NamingException e) {
            String msg = "Failed to retrieve RMIServer stub: " + e;
            if (tracing) {
                logger.trace("connect", idstr + " " + msg);
            }
            throw EnvHelp.initCause(new IOException(msg), e);
        }
    }

    @Override
    public synchronized String getConnectionId() throws IOException {
        if (this.terminated || !this.connected) {
            if (logger.traceOn()) {
                logger.trace("getConnectionId", "[" + this.toString() + "] not connected.");
            }
            throw new IOException("Not connected");
        }
        return this.connection.getConnectionId();
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        if (this.terminated) {
            if (logger.traceOn()) {
                logger.trace("getMBeanServerConnection", "[" + this.toString() + "] already closed.");
            }
            throw new IOException("Connection closed");
        }
        if (!this.connected) {
            if (logger.traceOn()) {
                logger.trace("getMBeanServerConnection", "[" + this.toString() + "] is not connected.");
            }
            throw new IOException("Not connected");
        }
        MBeanServerConnection rmbsc = this.rmbscMap.get(delegationSubject);
        if (rmbsc != null) {
            return rmbsc;
        }
        rmbsc = new RemoteMBeanServerConnection(delegationSubject);
        this.rmbscMap.put(delegationSubject, rmbsc);
        return rmbsc;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    private void sendNotification(Notification n) {
        this.connectionBroadcaster.sendNotification(n);
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(false);
    }

    private synchronized void close(boolean intern) throws IOException {
        String savedConnectionId;
        String idstr;
        boolean tracing;
        block26: {
            boolean debug;
            block25: {
                tracing = logger.traceOn();
                debug = logger.debugOn();
                String string = idstr = tracing ? "[" + this.toString() + "]" : null;
                if (!intern) {
                    if (this.terminated) {
                        if (this.closeException == null) {
                            if (tracing) {
                                logger.trace("close", idstr + " already closed.");
                            }
                            return;
                        }
                    } else {
                        this.terminated = true;
                    }
                }
                if (this.closeException != null && tracing && tracing) {
                    logger.trace("close", idstr + " had failed: " + this.closeException);
                    logger.trace("close", idstr + " attempting to close again.");
                }
                savedConnectionId = null;
                if (this.connected) {
                    savedConnectionId = this.connectionId;
                }
                this.closeException = null;
                if (tracing) {
                    logger.trace("close", idstr + " closing.");
                }
                if (this.communicatorAdmin != null) {
                    this.communicatorAdmin.terminate();
                }
                if (this.rmiNotifClient != null) {
                    try {
                        this.rmiNotifClient.terminate();
                        if (tracing) {
                            logger.trace("close", idstr + " RMI Notification client terminated.");
                        }
                    }
                    catch (RuntimeException x) {
                        this.closeException = x;
                        if (tracing) {
                            logger.trace("close", idstr + " Failed to terminate RMI Notification client: " + x);
                        }
                        if (!debug) break block25;
                        logger.debug("close", x);
                    }
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    if (tracing) {
                        logger.trace("close", idstr + " closed.");
                    }
                }
                catch (NoSuchObjectException nse) {
                }
                catch (IOException e) {
                    this.closeException = e;
                    if (tracing) {
                        logger.trace("close", idstr + " Failed to close RMIServer: " + e);
                    }
                    if (!debug) break block26;
                    logger.debug("close", e);
                }
            }
        }
        this.rmbscMap.clear();
        if (savedConnectionId != null) {
            JMXConnectionNotification closedNotif = new JMXConnectionNotification("jmx.remote.connection.closed", this, savedConnectionId, this.clientNotifSeqNo++, "Client has been closed", null);
            this.sendNotification(closedNotif);
        }
        if (this.closeException != null) {
            if (tracing) {
                logger.trace("close", idstr + " failed to close: " + this.closeException);
            }
            if (this.closeException instanceof IOException) {
                throw (IOException)this.closeException;
            }
            if (this.closeException instanceof RuntimeException) {
                throw (RuntimeException)this.closeException;
            }
            IOException x = new IOException("Failed to close: " + this.closeException);
            throw EnvHelp.initCause(x, this.closeException);
        }
    }

    private Integer addListenerWithSubject(ObjectName name, MarshalledObject<NotificationFilter> filter, Subject delegationSubject, boolean reconnect) throws InstanceNotFoundException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("addListenerWithSubject", "(ObjectName,MarshalledObject,Subject)");
        }
        ObjectName[] names = new ObjectName[]{name};
        MarshalledObject[] filters = (MarshalledObject[])Util.cast(new MarshalledObject[]{filter});
        Subject[] delegationSubjects = new Subject[]{delegationSubject};
        Integer[] listenerIDs = this.addListenersWithSubjects(names, filters, delegationSubjects, reconnect);
        if (debug) {
            logger.debug("addListenerWithSubject", "listenerID=" + listenerIDs[0]);
        }
        return listenerIDs[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] addListenersWithSubjects(ObjectName[] names, MarshalledObject<NotificationFilter>[] filters, Subject[] delegationSubjects, boolean reconnect) throws InstanceNotFoundException, IOException {
        Integer[] listenerIDs;
        boolean debug;
        block10: {
            debug = logger.debugOn();
            if (debug) {
                logger.debug("addListenersWithSubjects", "(ObjectName[],MarshalledObject[],Subject[])");
            }
            ClassLoader old = this.pushDefaultClassLoader();
            listenerIDs = null;
            try {
                listenerIDs = this.connection.addNotificationListeners(names, filters, delegationSubjects);
            }
            catch (NoSuchObjectException noe) {
                if (reconnect) {
                    this.communicatorAdmin.gotIOException(noe);
                    listenerIDs = this.connection.addNotificationListeners(names, filters, delegationSubjects);
                    break block10;
                }
                throw noe;
            }
            catch (IOException ioe) {
                this.communicatorAdmin.gotIOException(ioe);
            }
            finally {
                this.popDefaultClassLoader(old);
            }
        }
        if (debug) {
            logger.debug("addListenersWithSubjects", "registered " + (listenerIDs == null ? 0 : listenerIDs.length) + " listener(s)");
        }
        return listenerIDs;
    }

    static RMIServer connectStub(RMIServer rmiServer, Map<String, ?> environment) throws IOException {
        if (IIOPHelper.isStub(rmiServer)) {
            try {
                IIOPHelper.getOrb(rmiServer);
            }
            catch (UnsupportedOperationException x) {
                IIOPHelper.connect(rmiServer, RMIConnector.resolveOrb(environment));
            }
        }
        return rmiServer;
    }

    static Object resolveOrb(Map<String, ?> environment) throws IOException {
        Object orb;
        if (environment != null) {
            orb = environment.get("java.naming.corba.orb");
            if (orb != null && !IIOPHelper.isOrb(orb)) {
                throw new IllegalArgumentException("java.naming.corba.orb must be an instance of org.omg.CORBA.ORB.");
            }
            if (orb != null) {
                return orb;
            }
        }
        Object v0 = (orb = RMIConnector.orb == null ? null : RMIConnector.orb.get());
        if (orb != null) {
            return orb;
        }
        Object newOrb = IIOPHelper.createOrb(null, null);
        RMIConnector.orb = new WeakReference<Object>(newOrb);
        return newOrb;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.rmiServer == null && this.jmxServiceURL == null) {
            throw new InvalidObjectException("rmiServer and jmxServiceURL both null");
        }
        this.initTransients();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.rmiServer == null && this.jmxServiceURL == null) {
            throw new InvalidObjectException("rmiServer and jmxServiceURL both null.");
        }
        RMIConnector.connectStub(this.rmiServer, this.env);
        s.defaultWriteObject();
    }

    private void initTransients() {
        this.rmbscMap = new WeakHashMap();
        this.connected = false;
        this.terminated = false;
        this.connectionBroadcaster = new NotificationBroadcasterSupport();
    }

    private static void checkStub(Remote stub, Class<?> stubClass) {
        RemoteRef ref;
        if (stub.getClass() != stubClass) {
            if (!Proxy.isProxyClass(stub.getClass())) {
                throw new SecurityException("Expecting a " + stubClass.getName() + " stub!");
            }
            InvocationHandler handler = Proxy.getInvocationHandler(stub);
            if (handler.getClass() != RemoteObjectInvocationHandler.class) {
                throw new SecurityException("Expecting a dynamic proxy instance with a " + RemoteObjectInvocationHandler.class.getName() + " invocation handler!");
            }
            stub = (Remote)((Object)handler);
        }
        if ((ref = ((RemoteObject)stub).getRef()).getClass() != UnicastRef2.class) {
            throw new SecurityException("Expecting a " + UnicastRef2.class.getName() + " remote reference in stub!");
        }
        LiveRef liveRef = ((UnicastRef2)ref).getLiveRef();
        RMIClientSocketFactory csf = liveRef.getClientSocketFactory();
        if (csf == null || csf.getClass() != SslRMIClientSocketFactory.class) {
            throw new SecurityException("Expecting a " + SslRMIClientSocketFactory.class.getName() + " RMI client socket factory in stub!");
        }
    }

    private RMIServer findRMIServer(JMXServiceURL directoryURL, Map<String, Object> environment) throws NamingException, IOException {
        String path;
        int end;
        boolean isIiop = RMIConnectorServer.isIiopURL(directoryURL, true);
        if (isIiop) {
            environment.put("java.naming.corba.orb", RMIConnector.resolveOrb(environment));
        }
        if ((end = (path = directoryURL.getURLPath()).indexOf(59)) < 0) {
            end = path.length();
        }
        if (path.startsWith("/jndi/")) {
            return this.findRMIServerJNDI(path.substring(6, end), environment, isIiop);
        }
        if (path.startsWith("/stub/")) {
            return this.findRMIServerJRMP(path.substring(6, end), environment, isIiop);
        }
        if (path.startsWith("/ior/")) {
            if (!IIOPHelper.isAvailable()) {
                throw new IOException("iiop protocol not available");
            }
            return this.findRMIServerIIOP(path.substring(5, end), environment, isIiop);
        }
        String msg = "URL path must begin with /jndi/ or /stub/ or /ior/: " + path;
        throw new MalformedURLException(msg);
    }

    private RMIServer findRMIServerJNDI(String jndiURL, Map<String, ?> env, boolean isIiop) throws NamingException {
        InitialContext ctx = new InitialContext(EnvHelp.mapToHashtable(env));
        Object objref = ctx.lookup(jndiURL);
        ctx.close();
        if (isIiop) {
            return RMIConnector.narrowIIOPServer(objref);
        }
        return RMIConnector.narrowJRMPServer(objref);
    }

    private static RMIServer narrowJRMPServer(Object objref) {
        return (RMIServer)objref;
    }

    private static RMIServer narrowIIOPServer(Object objref) {
        try {
            return IIOPHelper.narrow(objref, RMIServer.class);
        }
        catch (ClassCastException e) {
            if (logger.traceOn()) {
                logger.trace("narrowIIOPServer", "Failed to narrow objref=" + objref + ": " + e);
            }
            if (logger.debugOn()) {
                logger.debug("narrowIIOPServer", e);
            }
            return null;
        }
    }

    private RMIServer findRMIServerIIOP(String ior, Map<String, ?> env, boolean isIiop) {
        Object orb = env.get("java.naming.corba.orb");
        Object stub = IIOPHelper.stringToObject(orb, ior);
        return IIOPHelper.narrow(stub, RMIServer.class);
    }

    private RMIServer findRMIServerJRMP(String base64, Map<String, ?> env, boolean isIiop) throws IOException {
        Object stub;
        byte[] serialized;
        try {
            serialized = RMIConnector.base64ToByteArray(base64);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Bad BASE64 encoding: " + e.getMessage());
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        ClassLoader loader = EnvHelp.resolveClientClassLoader(env);
        ObjectInputStream oin = loader == null ? new ObjectInputStream(bin) : new ObjectInputStreamWithLoader(bin, loader);
        try {
            stub = oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new MalformedURLException("Class not found: " + e);
        }
        return (RMIServer)stub;
    }

    private static RMIConnection shadowJrmpStub(RemoteObject stub) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        RemoteRef ref = stub.getRef();
        RemoteRef proxyRef = (RemoteRef)proxyRefConstructor.newInstance(ref);
        Constructor<?> rmiConnectionImplStubConstructor = rmiConnectionImplStubClass.getConstructor(RemoteRef.class);
        Object[] args = new Object[]{proxyRef};
        RMIConnection proxyStub = (RMIConnection)rmiConnectionImplStubConstructor.newInstance(args);
        return proxyStub;
    }

    private static RMIConnection shadowIiopStub(Object stub) throws InstantiationException, IllegalAccessException {
        Object proxyStub = proxyStubClass.newInstance();
        IIOPHelper.setDelegate(proxyStub, IIOPHelper.getDelegate(stub));
        return (RMIConnection)proxyStub;
    }

    private static RMIConnection getConnection(RMIServer server, Object credentials, boolean checkStub) throws IOException {
        RMIConnection c = server.newClient(credentials);
        if (checkStub) {
            RMIConnector.checkStub(c, rmiConnectionImplStubClass);
        }
        try {
            if (c.getClass() == rmiConnectionImplStubClass) {
                return RMIConnector.shadowJrmpStub((RemoteObject)((Object)c));
            }
            if (c.getClass().getName().equals(iiopConnectionStubClassName)) {
                return RMIConnector.shadowIiopStub(c);
            }
            logger.trace("getConnection", "Did not wrap " + c.getClass() + " to foil " + "stack search for classes: class loading semantics " + "may be incorrect");
        }
        catch (Exception e) {
            logger.error("getConnection", "Could not wrap " + c.getClass() + " to foil " + "stack search for classes: class loading semantics " + "may be incorrect: " + e);
            logger.debug("getConnection", e);
        }
        return c;
    }

    private static byte[] base64ToByteArray(String s) {
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
        int inCursor = 0;
        int outCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int ch0 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch1 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch2 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch3 = RMIConnector.base64toInt(s.charAt(inCursor++));
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[outCursor++] = (byte)(ch2 << 6 | ch3);
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch1 = RMIConnector.base64toInt(s.charAt(inCursor++));
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = RMIConnector.base64toInt(s.charAt(inCursor++));
                result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return result;
    }

    private static int base64toInt(char c) {
        int result = c >= base64ToInt.length ? -1 : base64ToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return result;
    }

    private ClassLoader pushDefaultClassLoader() {
        final Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        if (this.defaultClassLoader != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    t.setContextClassLoader(RMIConnector.this.defaultClassLoader);
                    return null;
                }
            });
        }
        return old;
    }

    private void popDefaultClassLoader(final ClassLoader old) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(old);
                return null;
            }
        });
    }

    private static String objects(Object[] objs) {
        if (objs == null) {
            return "null";
        }
        return Arrays.asList(objs).toString();
    }

    private static String strings(String[] strs) {
        return RMIConnector.objects(strs);
    }

    static {
        Constructor constr;
        Class<?> stubClass;
        Class<?> serverStubClass;
        logger = new ClassLogger("javax.management.remote.rmi", "RMIConnector");
        rmiServerImplStubClassName = RMIServer.class.getName() + "Impl_Stub";
        rmiConnectionImplStubClassName = RMIConnection.class.getName() + "Impl_Stub";
        String pRefByteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0017\n\u0000\u0005\u0000\r\t\u0000\u0004\u0000\u000e\u000b\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0001\u0000\u0006<init>\u0001\u0000\u001e(Ljava/rmi/server/RemoteRef;)V\u0001\u0000\u0004Code\u0001\u0000\u0006invoke\u0001\u0000S(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0013\f\u0000\u0006\u0000\u0007\f\u0000\u0014\u0000\u0015\u0007\u0000\u0016\f\u0000\t\u0000\n\u0001\u0000 com/sun/jmx/remote/internal/PRef\u0001\u0000$com/sun/jmx/remote/internal/ProxyRef\u0001\u0000\u0013java/lang/Exception\u0001\u0000\u0003ref\u0001\u0000\u001bLjava/rmi/server/RemoteRef;\u0001\u0000\u0019java/rmi/server/RemoteRef\u0000!\u0000\u0004\u0000\u0005\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u001b\u0000\u0006\u0000\u0006\u0000\u0000\u0000\u000f*\u00b4\u0000\u0002+,-\u0016\u0004\u00b9\u0000\u0003\u0006\u0000\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0004\u0000\u0001\u0000\f\u0000\u0000";
        final byte[] pRefByteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0017\n\u0000\u0005\u0000\r\t\u0000\u0004\u0000\u000e\u000b\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0001\u0000\u0006<init>\u0001\u0000\u001e(Ljava/rmi/server/RemoteRef;)V\u0001\u0000\u0004Code\u0001\u0000\u0006invoke\u0001\u0000S(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0013\f\u0000\u0006\u0000\u0007\f\u0000\u0014\u0000\u0015\u0007\u0000\u0016\f\u0000\t\u0000\n\u0001\u0000 com/sun/jmx/remote/internal/PRef\u0001\u0000$com/sun/jmx/remote/internal/ProxyRef\u0001\u0000\u0013java/lang/Exception\u0001\u0000\u0003ref\u0001\u0000\u001bLjava/rmi/server/RemoteRef;\u0001\u0000\u0019java/rmi/server/RemoteRef\u0000!\u0000\u0004\u0000\u0005\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u001b\u0000\u0006\u0000\u0006\u0000\u0000\u0000\u000f*\u00b4\u0000\u0002+,-\u0016\u0004\u00b9\u0000\u0003\u0006\u0000\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0004\u0000\u0001\u0000\f\u0000\u0000");
        PrivilegedExceptionAction action = new PrivilegedExceptionAction<Constructor<?>>(){

            @Override
            public Constructor<?> run() throws Exception {
                Class<RMIConnector> thisClass = RMIConnector.class;
                ClassLoader thisLoader = thisClass.getClassLoader();
                ProtectionDomain thisProtectionDomain = thisClass.getProtectionDomain();
                String[] otherClassNames = new String[]{ProxyRef.class.getName()};
                NoCallStackClassLoader cl = new NoCallStackClassLoader(RMIConnector.pRefClassName, pRefByteCode, otherClassNames, thisLoader, thisProtectionDomain);
                Class<?> c = cl.loadClass(RMIConnector.pRefClassName);
                return c.getConstructor(RemoteRef.class);
            }
        };
        try {
            serverStubClass = Class.forName(rmiServerImplStubClassName);
        }
        catch (Exception e) {
            logger.error("<clinit>", "Failed to instantiate " + rmiServerImplStubClassName + ": " + e);
            logger.debug("<clinit>", e);
            serverStubClass = null;
        }
        rmiServerImplStubClass = serverStubClass;
        try {
            stubClass = Class.forName(rmiConnectionImplStubClassName);
            constr = (Constructor)AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            logger.error("<clinit>", "Failed to initialize proxy reference constructor for " + rmiConnectionImplStubClassName + ": " + e);
            logger.debug("<clinit>", e);
            stubClass = null;
            constr = null;
        }
        rmiConnectionImplStubClass = stubClass;
        proxyRefConstructor = constr;
        String proxyStubByteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u00003\u0000+\n\u0000\f\u0000\u0018\u0007\u0000\u0019\n\u0000\f\u0000\u001a\n\u0000\u0002\u0000\u001b\u0007\u0000\u001c\n\u0000\u0005\u0000\u001d\n\u0000\u0005\u0000\u001e\n\u0000\u0005\u0000\u001f\n\u0000\u0002\u0000 \n\u0000\f\u0000!\u0007\u0000\"\u0007\u0000#\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0007_invoke\u0001\u0000K(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\rStackMapTable\u0007\u0000\u001c\u0001\u0000\nExceptions\u0007\u0000$\u0001\u0000\r_releaseReply\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\f\u0000\r\u0000\u000e\u0001\u0000-com/sun/jmx/remote/protocol/iiop/PInputStream\f\u0000\u0010\u0000\u0011\f\u0000\r\u0000\u0017\u0001\u0000+org/omg/CORBA/portable/ApplicationException\f\u0000%\u0000&\f\u0000'\u0000(\f\u0000\r\u0000)\f\u0000*\u0000&\f\u0000\u0016\u0000\u0017\u0001\u0000*com/sun/jmx/remote/protocol/iiop/ProxyStub\u0001\u0000<org/omg/stub/javax/management/remote/rmi/_RMIConnection_Stub\u0001\u0000)org/omg/CORBA/portable/RemarshalException\u0001\u0000\u000egetInputStream\u0001\u0000&()Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\u0005getId\u0001\u0000\u0014()Ljava/lang/String;\u0001\u00009(Ljava/lang/String;Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0015getProxiedInputStream\u0000!\u0000\u000b\u0000\f\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0010\u0000\u0011\u0000\u0002\u0000\u000f\u0000\u0000\u0000G\u0000\u0004\u0000\u0004\u0000\u0000\u0000'\u00bb\u0000\u0002Y*+\u00b7\u0000\u0003\u00b7\u0000\u0004\u00b0M\u00bb\u0000\u0002Y,\u00b6\u0000\u0006\u00b7\u0000\u0004N\u00bb\u0000\u0005Y,\u00b6\u0000\u0007-\u00b7\u0000\b\u00bf\u0000\u0001\u0000\u0000\u0000\f\u0000\r\u0000\u0005\u0000\u0001\u0000\u0012\u0000\u0000\u0000\u0006\u0000\u0001M\u0007\u0000\u0013\u0000\u0014\u0000\u0000\u0000\u0006\u0000\u0002\u0000\u0005\u0000\u0015\u0000\u0001\u0000\u0016\u0000\u0017\u0000\u0001\u0000\u000f\u0000\u0000\u0000'\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0012+\u00c6\u0000\u000b+\u00c0\u0000\u0002\u00b6\u0000\tL*+\u00b7\u0000\n\u00b1\u0000\u0000\u0000\u0001\u0000\u0012\u0000\u0000\u0000\u0003\u0000\u0001\f\u0000\u0000";
        String pInputStreamByteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u00003\u0000\u001e\n\u0000\u0007\u0000\u000f\t\u0000\u0006\u0000\u0010\n\u0000\u0011\u0000\u0012\n\u0000\u0006\u0000\u0013\n\u0000\u0014\u0000\u0015\u0007\u0000\u0016\u0007\u0000\u0017\u0001\u0000\u0006<init>\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0004Code\u0001\u0000\bread_any\u0001\u0000\u0015()Lorg/omg/CORBA/Any;\u0001\u0000\nread_value\u0001\u0000)(Ljava/lang/Class;)Ljava/io/Serializable;\f\u0000\b\u0000\t\f\u0000\u0018\u0000\u0019\u0007\u0000\u001a\f\u0000\u000b\u0000\f\f\u0000\u001b\u0000\u001c\u0007\u0000\u001d\f\u0000\r\u0000\u000e\u0001\u0000-com/sun/jmx/remote/protocol/iiop/PInputStream\u0001\u00001com/sun/jmx/remote/protocol/iiop/ProxyInputStream\u0001\u0000\u0002in\u0001\u0000$Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\"org/omg/CORBA/portable/InputStream\u0001\u0000\u0006narrow\u0001\u0000*()Lorg/omg/CORBA_2_3/portable/InputStream;\u0001\u0000&org/omg/CORBA_2_3/portable/InputStream\u0000!\u0000\u0006\u0000\u0007\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\b\u0000\t\u0000\u0001\u0000\n\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u000b\u0000\f\u0000\u0001\u0000\n\u0000\u0000\u0000\u0014\u0000\u0001\u0000\u0001\u0000\u0000\u0000\b*\u00b4\u0000\u0002\u00b6\u0000\u0003\u00b0\u0000\u0000\u0000\u0000\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\n\u0000\u0000\u0000\u0015\u0000\u0002\u0000\u0002\u0000\u0000\u0000\t*\u00b6\u0000\u0004+\u00b6\u0000\u0005\u00b0\u0000\u0000\u0000\u0000\u0000\u0000";
        byte[] proxyStubByteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u00003\u0000+\n\u0000\f\u0000\u0018\u0007\u0000\u0019\n\u0000\f\u0000\u001a\n\u0000\u0002\u0000\u001b\u0007\u0000\u001c\n\u0000\u0005\u0000\u001d\n\u0000\u0005\u0000\u001e\n\u0000\u0005\u0000\u001f\n\u0000\u0002\u0000 \n\u0000\f\u0000!\u0007\u0000\"\u0007\u0000#\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0007_invoke\u0001\u0000K(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\rStackMapTable\u0007\u0000\u001c\u0001\u0000\nExceptions\u0007\u0000$\u0001\u0000\r_releaseReply\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\f\u0000\r\u0000\u000e\u0001\u0000-com/sun/jmx/remote/protocol/iiop/PInputStream\f\u0000\u0010\u0000\u0011\f\u0000\r\u0000\u0017\u0001\u0000+org/omg/CORBA/portable/ApplicationException\f\u0000%\u0000&\f\u0000'\u0000(\f\u0000\r\u0000)\f\u0000*\u0000&\f\u0000\u0016\u0000\u0017\u0001\u0000*com/sun/jmx/remote/protocol/iiop/ProxyStub\u0001\u0000<org/omg/stub/javax/management/remote/rmi/_RMIConnection_Stub\u0001\u0000)org/omg/CORBA/portable/RemarshalException\u0001\u0000\u000egetInputStream\u0001\u0000&()Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\u0005getId\u0001\u0000\u0014()Ljava/lang/String;\u0001\u00009(Ljava/lang/String;Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0015getProxiedInputStream\u0000!\u0000\u000b\u0000\f\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0010\u0000\u0011\u0000\u0002\u0000\u000f\u0000\u0000\u0000G\u0000\u0004\u0000\u0004\u0000\u0000\u0000'\u00bb\u0000\u0002Y*+\u00b7\u0000\u0003\u00b7\u0000\u0004\u00b0M\u00bb\u0000\u0002Y,\u00b6\u0000\u0006\u00b7\u0000\u0004N\u00bb\u0000\u0005Y,\u00b6\u0000\u0007-\u00b7\u0000\b\u00bf\u0000\u0001\u0000\u0000\u0000\f\u0000\r\u0000\u0005\u0000\u0001\u0000\u0012\u0000\u0000\u0000\u0006\u0000\u0001M\u0007\u0000\u0013\u0000\u0014\u0000\u0000\u0000\u0006\u0000\u0002\u0000\u0005\u0000\u0015\u0000\u0001\u0000\u0016\u0000\u0017\u0000\u0001\u0000\u000f\u0000\u0000\u0000'\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0012+\u00c6\u0000\u000b+\u00c0\u0000\u0002\u00b6\u0000\tL*+\u00b7\u0000\n\u00b1\u0000\u0000\u0000\u0001\u0000\u0012\u0000\u0000\u0000\u0003\u0000\u0001\f\u0000\u0000");
        byte[] pInputStreamByteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u00003\u0000\u001e\n\u0000\u0007\u0000\u000f\t\u0000\u0006\u0000\u0010\n\u0000\u0011\u0000\u0012\n\u0000\u0006\u0000\u0013\n\u0000\u0014\u0000\u0015\u0007\u0000\u0016\u0007\u0000\u0017\u0001\u0000\u0006<init>\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0004Code\u0001\u0000\bread_any\u0001\u0000\u0015()Lorg/omg/CORBA/Any;\u0001\u0000\nread_value\u0001\u0000)(Ljava/lang/Class;)Ljava/io/Serializable;\f\u0000\b\u0000\t\f\u0000\u0018\u0000\u0019\u0007\u0000\u001a\f\u0000\u000b\u0000\f\f\u0000\u001b\u0000\u001c\u0007\u0000\u001d\f\u0000\r\u0000\u000e\u0001\u0000-com/sun/jmx/remote/protocol/iiop/PInputStream\u0001\u00001com/sun/jmx/remote/protocol/iiop/ProxyInputStream\u0001\u0000\u0002in\u0001\u0000$Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\"org/omg/CORBA/portable/InputStream\u0001\u0000\u0006narrow\u0001\u0000*()Lorg/omg/CORBA_2_3/portable/InputStream;\u0001\u0000&org/omg/CORBA_2_3/portable/InputStream\u0000!\u0000\u0006\u0000\u0007\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\b\u0000\t\u0000\u0001\u0000\n\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u000b\u0000\f\u0000\u0001\u0000\n\u0000\u0000\u0000\u0014\u0000\u0001\u0000\u0001\u0000\u0000\u0000\b*\u00b4\u0000\u0002\u00b6\u0000\u0003\u00b0\u0000\u0000\u0000\u0000\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\n\u0000\u0000\u0000\u0015\u0000\u0002\u0000\u0002\u0000\u0000\u0000\t*\u00b6\u0000\u0004+\u00b6\u0000\u0005\u00b0\u0000\u0000\u0000\u0000\u0000\u0000");
        final String[] classNames = new String[]{proxyStubClassName, pInputStreamClassName};
        final byte[][] byteCodes = new byte[][]{proxyStubByteCode, pInputStreamByteCode};
        final String[] otherClassNames = new String[]{iiopConnectionStubClassName, ProxyInputStreamClassName};
        if (IIOPHelper.isAvailable()) {
            Class stubClass2;
            PrivilegedExceptionAction action2 = new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    Class<RMIConnector> thisClass = RMIConnector.class;
                    ClassLoader thisLoader = thisClass.getClassLoader();
                    ProtectionDomain thisProtectionDomain = thisClass.getProtectionDomain();
                    NoCallStackClassLoader cl = new NoCallStackClassLoader(classNames, byteCodes, otherClassNames, thisLoader, thisProtectionDomain);
                    return cl.loadClass(RMIConnector.proxyStubClassName);
                }
            };
            try {
                stubClass2 = (Class)AccessController.doPrivileged(action2);
            }
            catch (Exception e) {
                logger.error("<clinit>", "Unexpected exception making shadow IIOP stub class: " + e);
                logger.debug("<clinit>", e);
                stubClass2 = null;
            }
            proxyStubClass = stubClass2;
        } else {
            proxyStubClass = null;
        }
        base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        orb = null;
    }

    private static final class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader loader;

        ObjectInputStreamWithLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.loader = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String name = classDesc.getName();
            ReflectUtil.checkPackageAccess(name);
            return Class.forName(name, false, this.loader);
        }
    }

    private class RMIClientCommunicatorAdmin
    extends ClientCommunicatorAdmin {
        public RMIClientCommunicatorAdmin(long period) {
            super(period);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gotIOException(IOException ioe) throws IOException {
            block12: {
                if (ioe instanceof NoSuchObjectException) {
                    super.gotIOException(ioe);
                    return;
                }
                try {
                    RMIConnector.this.connection.getDefaultDomain(null);
                }
                catch (IOException ioexc) {
                    boolean toClose = false;
                    RMIClientCommunicatorAdmin rMIClientCommunicatorAdmin = this;
                    synchronized (rMIClientCommunicatorAdmin) {
                        if (!RMIConnector.this.terminated) {
                            RMIConnector.this.terminated = true;
                            toClose = true;
                        }
                    }
                    if (!toClose) break block12;
                    JMXConnectionNotification failedNotif = new JMXConnectionNotification("jmx.remote.connection.failed", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Failed to communicate with the server: " + ioe.toString(), ioe);
                    RMIConnector.this.sendNotification(failedNotif);
                    try {
                        RMIConnector.this.close(true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (ioe instanceof ServerException) {
                Throwable tt = ((ServerException)ioe).detail;
                if (tt instanceof IOException) {
                    throw (IOException)tt;
                }
                if (tt instanceof RuntimeException) {
                    throw (RuntimeException)tt;
                }
            }
            throw ioe;
        }

        public void reconnectNotificationListeners(ClientListenerInfo[] old) throws IOException {
            int i;
            int len = old.length;
            ClientListenerInfo[] clis = new ClientListenerInfo[len];
            Subject[] subjects = new Subject[len];
            ObjectName[] names = new ObjectName[len];
            NotificationListener[] listeners = new NotificationListener[len];
            NotificationFilter[] filters = new NotificationFilter[len];
            MarshalledObject[] mFilters = (MarshalledObject[])Util.cast(new MarshalledObject[len]);
            Object[] handbacks = new Object[len];
            for (i = 0; i < len; ++i) {
                subjects[i] = old[i].getDelegationSubject();
                names[i] = old[i].getObjectName();
                listeners[i] = old[i].getListener();
                filters[i] = old[i].getNotificationFilter();
                mFilters[i] = new MarshalledObject<NotificationFilter>(filters[i]);
                handbacks[i] = old[i].getHandback();
            }
            try {
                Integer[] ids = RMIConnector.this.addListenersWithSubjects(names, mFilters, subjects, false);
                for (i = 0; i < len; ++i) {
                    clis[i] = new ClientListenerInfo(ids[i], names[i], listeners[i], filters[i], handbacks[i], subjects[i]);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clis);
                return;
            }
            catch (InstanceNotFoundException infe) {
                int j = 0;
                for (i = 0; i < len; ++i) {
                    try {
                        Integer id = RMIConnector.this.addListenerWithSubject(names[i], new MarshalledObject<NotificationFilter>(filters[i]), subjects[i], false);
                        clis[j++] = new ClientListenerInfo(id, names[i], listeners[i], filters[i], handbacks[i], subjects[i]);
                        continue;
                    }
                    catch (InstanceNotFoundException infe2) {
                        logger.warning("reconnectNotificationListeners", "Can't reconnect listener for " + names[i]);
                    }
                }
                if (j != len) {
                    ClientListenerInfo[] tmp = clis;
                    clis = new ClientListenerInfo[j];
                    System.arraycopy(tmp, 0, clis, 0, j);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clis);
                return;
            }
        }

        @Override
        protected void checkConnection() throws IOException {
            if (logger.debugOn()) {
                logger.debug("RMIClientCommunicatorAdmin-checkConnection", "Calling the method getDefaultDomain.");
            }
            RMIConnector.this.connection.getDefaultDomain(null);
        }

        @Override
        protected void doStart() throws IOException {
            RMIServer stub;
            try {
                stub = RMIConnector.this.rmiServer != null ? RMIConnector.this.rmiServer : RMIConnector.this.findRMIServer(RMIConnector.this.jmxServiceURL, RMIConnector.this.env);
            }
            catch (NamingException ne) {
                throw new IOException("Failed to get a RMI stub: " + ne);
            }
            stub = RMIConnector.connectStub(stub, RMIConnector.this.env);
            Object credentials = RMIConnector.this.env.get("jmx.remote.credentials");
            RMIConnector.this.connection = stub.newClient(credentials);
            ClientListenerInfo[] old = RMIConnector.this.rmiNotifClient.preReconnection();
            this.reconnectNotificationListeners(old);
            RMIConnector.this.connectionId = RMIConnector.this.getConnectionId();
            JMXConnectionNotification reconnectedNotif = new JMXConnectionNotification("jmx.remote.connection.opened", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Reconnected to server", null);
            RMIConnector.this.sendNotification(reconnectedNotif);
        }

        @Override
        protected void doStop() {
            try {
                RMIConnector.this.close();
            }
            catch (IOException ioe) {
                logger.warning("RMIClientCommunicatorAdmin-doStop", "Failed to call the method close():" + ioe);
                logger.debug("RMIClientCommunicatorAdmin-doStop", ioe);
            }
        }
    }

    private class RMINotifClient
    extends ClientNotifForwarder {
        public RMINotifClient(ClassLoader cl, Map<String, ?> env) {
            super(cl, env);
        }

        @Override
        protected NotificationResult fetchNotifs(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException, ClassNotFoundException {
            while (true) {
                try {
                    return RMIConnector.this.connection.fetchNotifications(clientSequenceNumber, maxNotifications, timeout);
                }
                catch (IOException ioe) {
                    IOException org = ioe;
                    try {
                        RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                    }
                    catch (IOException ee) {
                        if (org instanceof UnmarshalException) {
                            UnmarshalException ume = (UnmarshalException)org;
                            if (ume.detail instanceof ClassNotFoundException) {
                                throw (ClassNotFoundException)ume.detail;
                            }
                            if (ume.detail instanceof WriteAbortedException) {
                                WriteAbortedException wae = (WriteAbortedException)ume.detail;
                                if (wae.detail instanceof IOException) {
                                    throw (IOException)wae.detail;
                                }
                            }
                        } else if (org instanceof MarshalException) {
                            MarshalException me = (MarshalException)org;
                            if (me.detail instanceof NotSerializableException) {
                                throw (NotSerializableException)me.detail;
                            }
                        }
                        throw org;
                    }
                }
            }
        }

        @Override
        protected Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException {
            Integer[] listenerIDs;
            NotificationFilterSupport clientFilter = new NotificationFilterSupport();
            clientFilter.enableType("JMX.mbean.unregistered");
            MarshalledObject<NotificationFilterSupport> sFilter = new MarshalledObject<NotificationFilterSupport>(clientFilter);
            ObjectName[] names = new ObjectName[]{MBeanServerDelegate.DELEGATE_NAME};
            MarshalledObject[] filters = (MarshalledObject[])Util.cast(new MarshalledObject[]{sFilter});
            Subject[] subjects = new Subject[]{null};
            try {
                listenerIDs = RMIConnector.this.connection.addNotificationListeners(names, filters, subjects);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                listenerIDs = RMIConnector.this.connection.addNotificationListeners(names, filters, subjects);
            }
            return listenerIDs[0];
        }

        @Override
        protected void removeListenerForMBeanRemovedNotif(Integer id) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
            try {
                RMIConnector.this.connection.removeNotificationListeners(MBeanServerDelegate.DELEGATE_NAME, new Integer[]{id}, null);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(MBeanServerDelegate.DELEGATE_NAME, new Integer[]{id}, null);
            }
        }

        @Override
        protected void lostNotifs(String message, long number) {
            String notifType = "jmx.remote.connection.notifs.lost";
            JMXConnectionNotification n = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", RMIConnector.this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifCounter++, message, number);
            RMIConnector.this.sendNotification(n);
        }
    }

    private class RemoteMBeanServerConnection
    implements MBeanServerConnection {
        private Subject delegationSubject;

        public RemoteMBeanServerConnection() {
            this(null);
        }

        public RemoteMBeanServerConnection(Subject delegationSubject) {
            this.delegationSubject = delegationSubject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "className=" + className + ", name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "className=" + className + ", name=" + name + ", loaderName=" + loaderName + ")");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "className=" + className + ", name=" + name + ", params=" + RMIConnector.objects(params) + ", signature=" + RMIConnector.strings(signature));
            }
            MarshalledObject<Object[]> sParams = new MarshalledObject<Object[]>(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "className=" + className + ", name=" + name + ", loaderName=" + loaderName + ", params=" + RMIConnector.objects(params) + ", signature=" + RMIConnector.strings(signature));
            }
            MarshalledObject<Object[]> sParams = new MarshalledObject<Object[]>(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.unregisterMBean(name, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.unregisterMBean(name, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(name, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(name, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryMBeans", "name=" + name + ", query=" + query);
            }
            MarshalledObject<QueryExp> sQuery = new MarshalledObject<QueryExp>(query);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set<ObjectInstance> set = RMIConnector.this.connection.queryMBeans(name, sQuery, this.delegationSubject);
                return set;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Set<ObjectInstance> set = RMIConnector.this.connection.queryMBeans(name, sQuery, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryNames", "name=" + name + ", query=" + query);
            }
            MarshalledObject<QueryExp> sQuery = new MarshalledObject<QueryExp>(query);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set<ObjectName> set = RMIConnector.this.connection.queryNames(name, sQuery, this.delegationSubject);
                return set;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Set<ObjectName> set = RMIConnector.this.connection.queryNames(name, sQuery, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            if (logger.debugOn()) {
                logger.debug("isRegistered", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isRegistered(name, this.delegationSubject);
                return bl;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                boolean bl = RMIConnector.this.connection.isRegistered(name, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer getMBeanCount() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttribute", "name=" + name + ", attribute=" + attribute);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Object object = RMIConnector.this.connection.getAttribute(name, attribute, this.delegationSubject);
                return object;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Object object = RMIConnector.this.connection.getAttribute(name, attribute, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttributes", "name=" + name + ", attributes=" + RMIConnector.strings(attributes));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(name, attributes, this.delegationSubject);
                return attributeList;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(name, attributes, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttribute", "name=" + name + ", attribute=" + attribute);
            }
            MarshalledObject<Attribute> sAttribute = new MarshalledObject<Attribute>(attribute);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.setAttribute(name, sAttribute, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.setAttribute(name, sAttribute, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttributes", "name=" + name + ", attributes=" + attributes);
            }
            MarshalledObject<AttributeList> sAttributes = new MarshalledObject<AttributeList>(attributes);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.setAttributes(name, sAttributes, this.delegationSubject);
                return attributeList;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                AttributeList attributeList = RMIConnector.this.connection.setAttributes(name, sAttributes, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("invoke", "name=" + name + ", operationName=" + operationName + ", params=" + RMIConnector.objects(params) + ", signature=" + RMIConnector.strings(signature));
            }
            MarshalledObject<Object[]> sParams = new MarshalledObject<Object[]>(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Object object = RMIConnector.this.connection.invoke(name, operationName, sParams, signature, this.delegationSubject);
                return object;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Object object = RMIConnector.this.connection.invoke(name, operationName, sParams, signature, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDefaultDomain() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getDomains() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDomains", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(name, this.delegationSubject);
                return mBeanInfo;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(name, this.delegationSubject);
                return mBeanInfo;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "name=" + name + ", className=" + className);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isInstanceOf(name, className, this.delegationSubject);
                return bl;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                boolean bl = RMIConnector.this.connection.isInstanceOf(name, className, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            MarshalledObject<NotificationFilter> sFilter = new MarshalledObject<NotificationFilter>(filter);
            MarshalledObject<Object> sHandback = new MarshalledObject<Object>(handback);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.addNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.addNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "name=" + name + ", listener=" + listener);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(name, listener, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListener(name, listener, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            MarshalledObject<NotificationFilter> sFilter = new MarshalledObject<NotificationFilter>(filter);
            MarshalledObject<Object> sHandback = new MarshalledObject<Object>(handback);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("addNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            Integer listenerID = RMIConnector.this.addListenerWithSubject(name, new MarshalledObject<NotificationFilter>(filter), this.delegationSubject, true);
            RMIConnector.this.rmiNotifClient.addNotificationListener(listenerID, name, listener, filter, handback, this.delegationSubject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener)", "name=" + name + ", listener=" + listener);
            }
            Object[] ret = RMIConnector.this.rmiNotifClient.removeNotificationListener(name, listener);
            if (debug) {
                logger.debug("removeNotificationListener", "listenerIDs=" + RMIConnector.objects(ret));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(name, (Integer[])ret, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(name, (Integer[])ret, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            Integer ret = RMIConnector.this.rmiNotifClient.removeNotificationListener(name, listener, filter, handback);
            if (debug) {
                logger.debug("removeNotificationListener", "listenerID=" + ret);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(name, new Integer[]{ret}, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(name, new Integer[]{ret}, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }
    }
}

