/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Cloneable {
    static final long serialVersionUID = -6178860474881375330L;
    static final MBeanOperationInfo[] NO_OPERATIONS = new MBeanOperationInfo[0];
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private final String type;
    private final MBeanParameterInfo[] signature;
    private final int impact;
    private final transient boolean arrayGettersSafe;

    public MBeanOperationInfo(String description, Method method) {
        this(method.getName(), description, MBeanOperationInfo.methodSignature(method), method.getReturnType().getName(), 3, Introspector.descriptorForElement(method));
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        this(name, description, signature, type, impact, null);
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact, Descriptor descriptor) {
        super(name, description, descriptor);
        signature = signature == null || signature.length == 0 ? MBeanParameterInfo.NO_PARAMS : (MBeanParameterInfo[])signature.clone();
        this.signature = signature;
        this.type = type;
        this.impact = impact;
        this.arrayGettersSafe = MBeanInfo.arrayGettersSafe(this.getClass(), MBeanOperationInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature == null) {
            return MBeanParameterInfo.NO_PARAMS;
        }
        if (this.signature.length == 0) {
            return this.signature;
        }
        return (MBeanParameterInfo[])this.signature.clone();
    }

    private MBeanParameterInfo[] fastGetSignature() {
        if (this.arrayGettersSafe) {
            if (this.signature == null) {
                return MBeanParameterInfo.NO_PARAMS;
            }
            return this.signature;
        }
        return this.getSignature();
    }

    public int getImpact() {
        return this.impact;
    }

    public String toString() {
        String impactString;
        switch (this.getImpact()) {
            case 1: {
                impactString = "action";
                break;
            }
            case 2: {
                impactString = "action/info";
                break;
            }
            case 0: {
                impactString = "info";
                break;
            }
            case 3: {
                impactString = "unknown";
                break;
            }
            default: {
                impactString = "(" + this.getImpact() + ")";
            }
        }
        return this.getClass().getName() + "[" + "description=" + this.getDescription() + ", " + "name=" + this.getName() + ", " + "returnType=" + this.getReturnType() + ", " + "signature=" + Arrays.asList(this.fastGetSignature()) + ", " + "impact=" + impactString + ", " + "descriptor=" + this.getDescriptor() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MBeanOperationInfo)) {
            return false;
        }
        MBeanOperationInfo p = (MBeanOperationInfo)o;
        return p.getName().equals(this.getName()) && p.getReturnType().equals(this.getReturnType()) && p.getDescription().equals(this.getDescription()) && p.getImpact() == this.getImpact() && Arrays.equals(p.fastGetSignature(), this.fastGetSignature()) && p.getDescriptor().equals(this.getDescriptor());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() ^ this.getReturnType().hashCode();
    }

    private static MBeanParameterInfo[] methodSignature(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        Annotation[][] annots = method.getParameterAnnotations();
        return MBeanOperationInfo.parameters(classes, annots);
    }

    static MBeanParameterInfo[] parameters(Class<?>[] classes, Annotation[][] annots) {
        MBeanParameterInfo[] params = new MBeanParameterInfo[classes.length];
        assert (classes.length == annots.length);
        for (int i = 0; i < classes.length; ++i) {
            Descriptor d = Introspector.descriptorForAnnotations(annots[i]);
            String pn = "p" + (i + 1);
            params[i] = new MBeanParameterInfo(pn, classes[i].getName(), "", d);
        }
        return params;
    }
}

