/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orbutil.proxy;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orbutil.proxy.CompositeInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompositeInvocationHandlerImpl
implements CompositeInvocationHandler {
    private Map classToInvocationHandler = new LinkedHashMap();
    private InvocationHandler defaultHandler = null;

    @Override
    public void addInvocationHandler(Class interf, InvocationHandler handler) {
        this.classToInvocationHandler.put(interf, handler);
    }

    @Override
    public void setDefaultHandler(InvocationHandler handler) {
        this.defaultHandler = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> cls = method.getDeclaringClass();
        InvocationHandler handler = (InvocationHandler)this.classToInvocationHandler.get(cls);
        if (handler == null) {
            if (this.defaultHandler != null) {
                handler = this.defaultHandler;
            } else {
                ORBUtilSystemException wrapper = ORBUtilSystemException.get("util");
                throw wrapper.noInvocationHandler("\"" + method.toString() + "\"");
            }
        }
        return handler.invoke(proxy, method, args);
    }
}

