/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECParameters;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.NamedCurve;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.DerValue;

final class P11ECKeyFactory
extends P11KeyFactory {
    P11ECKeyFactory(Token token, String algorithm) {
        super(token, algorithm);
    }

    static ECParameterSpec getECParameterSpec(String name) {
        return NamedCurve.getECParameterSpec((String)name);
    }

    static ECParameterSpec getECParameterSpec(int keySize) {
        return NamedCurve.getECParameterSpec((int)keySize);
    }

    static ECParameterSpec getECParameterSpec(ECParameterSpec spec) {
        return ECParameters.getNamedCurve((ECParameterSpec)spec);
    }

    static ECParameterSpec decodeParameters(byte[] params) throws IOException {
        return ECParameters.decodeParameters((byte[])params);
    }

    static byte[] encodeParameters(ECParameterSpec params) {
        return ECParameters.encodeParameters((ECParameterSpec)params);
    }

    static ECPoint decodePoint(byte[] encoded, EllipticCurve curve) throws IOException {
        return ECParameters.decodePoint((byte[])encoded, (EllipticCurve)curve);
    }

    static byte[] getEncodedPublicValue(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKeyImpl) {
            return ((ECPublicKeyImpl)key).getEncodedPublicValue();
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            ECPoint w = ecKey.getW();
            ECParameterSpec params = ecKey.getParams();
            return ECParameters.encodePoint((ECPoint)w, (EllipticCurve)params.getCurve());
        }
        throw new InvalidKeyException("Key class not yet supported: " + key.getClass().getName());
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPublicKey) {
                ECPublicKey ecKey = (ECPublicKey)key;
                return this.generatePublic(ecKey.getW(), ecKey.getParams());
            }
            if ("X.509".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new ECPublicKeyImpl(encoded);
                return this.implTranslatePublicKey(key);
            }
            throw new InvalidKeyException("PublicKey must be instance of ECPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC public key", e);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPrivateKey) {
                ECPrivateKey ecKey = (ECPrivateKey)key;
                return this.generatePrivate(ecKey.getS(), ecKey.getParams());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new ECPrivateKeyImpl(encoded);
                return this.implTranslatePrivateKey(key);
            }
            throw new InvalidKeyException("PrivateKey must be instance of ECPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                ECPublicKeyImpl key = new ECPublicKeyImpl(encoded);
                return this.implTranslatePublicKey(key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create EC public key", e);
            }
        }
        if (!(keySpec instanceof ECPublicKeySpec)) {
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        try {
            ECPublicKeySpec ec = (ECPublicKeySpec)keySpec;
            return this.generatePublic(ec.getW(), ec.getParams());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create EC public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKeyImpl key = new ECPrivateKeyImpl(encoded);
                return this.implTranslatePrivateKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create EC private key", e);
            }
        }
        if (!(keySpec instanceof ECPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        try {
            ECPrivateKeySpec ec = (ECPrivateKeySpec)keySpec;
            return this.generatePrivate(ec.getS(), ec.getParams());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create EC private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(ECPoint point, ECParameterSpec params) throws PKCS11Exception {
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
        byte[] encodedPoint = ECParameters.encodePoint((ECPoint)point, (EllipticCurve)params.getCurve());
        if (!this.token.config.getUseEcX963Encoding()) {
            try {
                encodedPoint = new DerValue(4, encodedPoint).toByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not DER encode point", e);
            }
        }
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(385L, encodedPoint), new CK_ATTRIBUTE(384L, encodedParams)};
        attributes = this.token.getAttributes("import", 2L, 3L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PublicKey publicKey = P11Key.publicKey(session, keyID, "EC", params.getCurve().getField().getFieldSize(), attributes);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger s, ECParameterSpec params) throws PKCS11Exception {
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(17L, s), new CK_ATTRIBUTE(384L, encodedParams)};
        attributes = this.token.getAttributes("import", 3L, 3L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "EC", params.getCurve().getField().getFieldSize(), attributes);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    KeySpec implGetPublicKeySpec(P11Key key, Class keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (ECPublicKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            try {
                ECParameterSpec params = P11ECKeyFactory.decodeParameters(attributes[1].getByteArray());
                ECPoint point = P11ECKeyFactory.decodePoint(attributes[0].getByteArray(), params.getCurve());
                return new ECPublicKeySpec(point, params);
            }
            catch (IOException e) {
                throw new InvalidKeySpecException("Could not parse key", e);
            }
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
    }

    @Override
    KeySpec implGetPrivateKeySpec(P11Key key, Class keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (ECPrivateKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(384L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            try {
                ECParameterSpec params = P11ECKeyFactory.decodeParameters(attributes[1].getByteArray());
                return new ECPrivateKeySpec(attributes[0].getBigInteger(), params);
            }
            catch (IOException e) {
                throw new InvalidKeySpecException("Could not parse key", e);
            }
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return ECKeyFactory.INSTANCE;
    }
}

