/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.KlassKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class InstanceKlassKlass
extends KlassKlass {
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("instanceKlassKlass");
        headerSize = type.getSize() + Oop.getHeaderSize();
    }

    InstanceKlassKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public long getObjectSize() {
        return InstanceKlassKlass.alignObjectSize(headerSize);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("InstanceKlassKlass");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                InstanceKlassKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

