/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;
import org.classpath.icedtea.pulseaudio.PulseAudioVolumeControl;
import org.classpath.icedtea.pulseaudio.Stream;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;

public final class PulseAudioSourceDataLine
extends PulseAudioDataLine
implements SourceDataLine,
PulseAudioPlaybackLine {
    private PulseAudioVolumeControl volumeControl;
    public static final String DEFAULT_SOURCEDATALINE_NAME = "Audio Stream";

    PulseAudioSourceDataLine(AudioFormat[] formats, AudioFormat defaultFormat) {
        this.supportedFormats = formats;
        this.lineListeners = new ArrayList();
        this.defaultFormat = defaultFormat;
        this.currentFormat = defaultFormat;
        this.streamName = DEFAULT_SOURCEDATALINE_NAME;
    }

    @Override
    public synchronized void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        super.open(format, bufferSize);
        this.volumeControl = new PulseAudioVolumeControl(this, this.eventLoop);
        this.controls.add(this.volumeControl);
        PulseAudioMixer parentMixer = PulseAudioMixer.getInstance();
        parentMixer.addSourceLine(this);
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioSourceDataLine.open(): line opened");
    }

    @Override
    public void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, 50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] native_set_volume(float value) {
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.native_set_volume(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] native_update_volume() {
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.native_update_volume();
        }
    }

    @Override
    public float getCachedVolume() {
        return this.stream.getCachedVolume();
    }

    @Override
    public synchronized void setCachedVolume(float value) {
        this.stream.setCachedVolume(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectLine(int bufferSize, Stream masterStream) throws LineUnavailableException {
        StreamBufferAttributes bufferAttributes = new StreamBufferAttributes(bufferSize, bufferSize / 4, bufferSize / 8, Math.max(bufferSize / 10, 100), 0);
        if (masterStream != null) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, bufferAttributes, masterStream.getStreamPointer());
            }
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, bufferAttributes, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] data, int offset, int length) {
        PulseAudioSourceDataLine pulseAudioSourceDataLine = this;
        synchronized (pulseAudioSourceDataLine) {
            this.writeInterrupted = false;
        }
        if (!this.isOpen()) {
            return 0;
        }
        int frameSize = this.currentFormat.getFrameSize();
        if (length % frameSize != 0) {
            throw new IllegalArgumentException("amount of data to write does not represent an integral number of frames");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (length < 0 || offset < 0 || offset > data.length - length) {
            throw new ArrayIndexOutOfBoundsException("Overflow condition: buffer.length=" + data.length + " offset= " + offset + " length=" + length);
        }
        int position = offset;
        int remainingLength = length;
        int availableSize = 0;
        int sizeWritten = 0;
        boolean interrupted = false;
        while (remainingLength != 0) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                PulseAudioSourceDataLine pulseAudioSourceDataLine2;
                do {
                    pulseAudioSourceDataLine2 = this;
                    synchronized (pulseAudioSourceDataLine2) {
                        if (this.writeInterrupted) {
                            return sizeWritten;
                        }
                    }
                    if (availableSize == -1) {
                        return sizeWritten;
                    }
                    availableSize = this.stream.getWritableSize();
                    if (availableSize != 0) continue;
                    try {
                        this.eventLoop.threadLock.wait(100L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                } while (availableSize == 0);
                if (availableSize > remainingLength) {
                    availableSize = remainingLength;
                }
                availableSize = availableSize / frameSize * frameSize;
                pulseAudioSourceDataLine2 = this;
                synchronized (pulseAudioSourceDataLine2) {
                    if (this.writeInterrupted) {
                        return sizeWritten;
                    }
                    this.stream.write(data, position, availableSize);
                }
                sizeWritten += availableSize;
                position += availableSize;
                remainingLength -= availableSize;
                this.framesSinceOpen += (long)(availableSize / frameSize);
            }
        }
        assert (sizeWritten == length);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return sizeWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.getWritableSize();
        }
    }

    @Override
    public int getFramePosition() {
        return (int)this.framesSinceOpen;
    }

    @Override
    public long getLongFramePosition() {
        return this.framesSinceOpen;
    }

    @Override
    public long getMicrosecondPosition() {
        float frameRate = this.currentFormat.getFrameRate();
        float time = (float)this.framesSinceOpen / frameRate;
        long microseconds = (long)(time * 1000000.0f);
        return microseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drain() {
        Operation operation;
        PulseAudioSourceDataLine pulseAudioSourceDataLine = this;
        synchronized (pulseAudioSourceDataLine) {
            this.writeInterrupted = true;
        }
        do {
            pulseAudioSourceDataLine = this;
            synchronized (pulseAudioSourceDataLine) {
                if (!this.isOpen()) {
                    return;
                }
                if (this.getBytesInBuffer() == 0) {
                    return;
                }
                if (this.isStarted) {
                    break;
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        } while (!this.isStarted);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.drain();
        }
        operation.waitForCompletion();
        operation.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PulseAudioSourceDataLine pulseAudioSourceDataLine = this;
        synchronized (pulseAudioSourceDataLine) {
            this.writeInterrupted = true;
        }
        if (this.isOpen()) {
            Operation operation;
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                operation = this.stream.flush();
            }
            operation.waitForCompletion();
            operation.releaseReference();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isOpen()) {
            return;
        }
        this.writeInterrupted = true;
        PulseAudioMixer parent = PulseAudioMixer.getInstance();
        parent.removeSourceLine(this);
        super.close();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioSourceDataLine.close(): line closed");
    }

    @Override
    public Line.Info getLineInfo() {
        return new DataLine.Info(SourceDataLine.class, this.supportedFormats, 0, 1000000);
    }
}

