/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.ccache.CCacheInputStream;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.ccache.Tag;

public class FileCredentialsCache
extends CredentialsCache
implements FileCCacheConstants {
    public int version;
    public Tag tag;
    public PrincipalName primaryPrincipal;
    public Realm primaryRealm;
    private Vector<Credentials> credentialsList;
    private static String dir;
    private static boolean DEBUG;

    public static synchronized FileCredentialsCache acquireInstance(PrincipalName principal, String cache) {
        block6: {
            try {
                FileCredentialsCache fcc = new FileCredentialsCache();
                cacheName = cache == null ? fcc.getDefaultCacheName() : FileCredentialsCache.checkValidation(cache);
                if (cacheName == null || !new File(cacheName).exists()) {
                    return null;
                }
                if (principal != null) {
                    fcc.primaryPrincipal = principal;
                    fcc.primaryRealm = principal.getRealm();
                }
                fcc.load(cacheName);
                return fcc;
            }
            catch (IOException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (KrbException e) {
                if (!DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static FileCredentialsCache acquireInstance() {
        return FileCredentialsCache.acquireInstance(null, null);
    }

    static synchronized FileCredentialsCache New(PrincipalName principal, String name) {
        try {
            FileCredentialsCache fcc = new FileCredentialsCache();
            cacheName = FileCredentialsCache.checkValidation(name);
            if (cacheName == null) {
                return null;
            }
            fcc.init(principal, cacheName);
            return fcc;
        }
        catch (IOException e) {
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return null;
    }

    static synchronized FileCredentialsCache New(PrincipalName principal) {
        block4: {
            try {
                FileCredentialsCache fcc = new FileCredentialsCache();
                cacheName = fcc.getDefaultCacheName();
                fcc.init(principal, cacheName);
                return fcc;
            }
            catch (IOException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (KrbException e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    private FileCredentialsCache() {
    }

    boolean exists(String cache) {
        File file = new File(cache);
        return file.exists();
    }

    synchronized void init(PrincipalName principal, String name) throws IOException, KrbException {
        this.primaryPrincipal = principal;
        this.primaryRealm = principal.getRealm();
        CCacheOutputStream cos = new CCacheOutputStream(new FileOutputStream(name));
        this.version = 1283;
        cos.writeHeader(this.primaryPrincipal, this.version);
        cos.close();
        this.load(name);
    }

    synchronized void load(String name) throws IOException, KrbException {
        CCacheInputStream cis = new CCacheInputStream(new FileInputStream(name));
        this.version = cis.readVersion();
        if (this.version == 1284) {
            this.tag = cis.readTag();
        } else {
            this.tag = null;
            if (this.version == 1281 || this.version == 1282) {
                cis.setNativeByteOrder();
            }
        }
        PrincipalName p = cis.readPrincipal(this.version);
        if (this.primaryPrincipal != null) {
            if (!this.primaryPrincipal.match(p)) {
                throw new IOException("Primary principals don't match.");
            }
        } else {
            this.primaryPrincipal = p;
        }
        this.primaryRealm = this.primaryPrincipal.getRealm();
        this.credentialsList = new Vector();
        while (cis.available() > 0) {
            Credentials cred = cis.readCred(this.version);
            if (cred == null) continue;
            this.credentialsList.addElement(cred);
        }
        cis.close();
    }

    @Override
    public synchronized void update(Credentials c) {
        if (this.credentialsList != null) {
            if (this.credentialsList.isEmpty()) {
                this.credentialsList.addElement(c);
            } else {
                Credentials tmp = null;
                boolean matched = false;
                for (int i = 0; i < this.credentialsList.size(); ++i) {
                    tmp = this.credentialsList.elementAt(i);
                    if (!this.match(c.sname.getNameStrings(), tmp.sname.getNameStrings()) || !c.sname.getRealmString().equalsIgnoreCase(tmp.sname.getRealmString())) continue;
                    matched = true;
                    if (c.endtime.getTime() < tmp.endtime.getTime()) continue;
                    if (DEBUG) {
                        System.out.println(" >>> FileCredentialsCache Ticket matched, overwrite the old one.");
                    }
                    this.credentialsList.removeElementAt(i);
                    this.credentialsList.addElement(c);
                }
                if (!matched) {
                    if (DEBUG) {
                        System.out.println(" >>> FileCredentialsCache Ticket not exactly matched, add new one into cache.");
                    }
                    this.credentialsList.addElement(c);
                }
            }
        }
    }

    @Override
    public synchronized PrincipalName getPrimaryPrincipal() {
        return this.primaryPrincipal;
    }

    @Override
    public synchronized void save() throws IOException, Asn1Exception {
        CCacheOutputStream cos = new CCacheOutputStream(new FileOutputStream(cacheName));
        cos.writeHeader(this.primaryPrincipal, this.version);
        Credentials[] tmp = null;
        tmp = this.getCredsList();
        if (tmp != null) {
            for (int i = 0; i < tmp.length; ++i) {
                cos.addCreds(tmp[i]);
            }
        }
        cos.close();
    }

    boolean match(String[] s1, String[] s2) {
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i].equalsIgnoreCase(s2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Credentials[] getCredsList() {
        if (this.credentialsList == null || this.credentialsList.isEmpty()) {
            return null;
        }
        Credentials[] tmp = new Credentials[this.credentialsList.size()];
        for (int i = 0; i < this.credentialsList.size(); ++i) {
            tmp[i] = this.credentialsList.elementAt(i);
        }
        return tmp;
    }

    @Override
    public Credentials getCreds(LoginOptions options, PrincipalName sname, Realm srealm) {
        if (options == null) {
            return this.getCreds(sname, srealm);
        }
        Credentials[] list = this.getCredsList();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!sname.match(list[i].sname) || !srealm.toString().equals(list[i].srealm.toString()) || !list[i].flags.match(options)) continue;
            return list[i];
        }
        return null;
    }

    @Override
    public Credentials getCreds(PrincipalName sname, Realm srealm) {
        Credentials[] list = this.getCredsList();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!sname.match(list[i].sname) || !srealm.toString().equals(list[i].srealm.toString())) continue;
            return list[i];
        }
        return null;
    }

    @Override
    public Credentials getDefaultCreds() {
        Credentials[] list = this.getCredsList();
        if (list == null) {
            return null;
        }
        for (int i = list.length - 1; i >= 0; --i) {
            String[] nameStrings;
            if (!list[i].sname.toString().startsWith("krbtgt") || !(nameStrings = list[i].sname.getNameStrings())[1].equals(list[i].srealm.toString())) continue;
            return list[i];
        }
        return null;
    }

    public static String getDefaultCacheName() {
        String name;
        String stdCacheNameComponent;
        block9: {
            stdCacheNameComponent = "krb5cc";
            name = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getenv("KRB5CCNAME");
                }
            });
            if (name != null) {
                if (DEBUG) {
                    System.out.println(">>>KinitOptions cache name is " + name);
                }
                return name;
            }
            String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (osname != null) {
                Object cmd = null;
                Object uidStr = null;
                long uid = 0L;
                if (osname.startsWith("SunOS") || osname.startsWith("Linux")) {
                    try {
                        Class<?> c = Class.forName("com.sun.security.auth.module.UnixSystem");
                        Constructor<?> constructor = c.getConstructor(new Class[0]);
                        Object obj = constructor.newInstance(new Object[0]);
                        Method method = c.getMethod("getUid", new Class[0]);
                        uid = (Long)method.invoke(obj, new Object[0]);
                        name = File.separator + "tmp" + File.separator + stdCacheNameComponent + "_" + uid;
                        if (DEBUG) {
                            System.out.println(">>>KinitOptions cache name is " + name);
                        }
                        return name;
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block9;
                        System.out.println("Exception in obtaining uid for Unix platforms Using user's home directory");
                        e.printStackTrace();
                    }
                }
            }
        }
        String user_name = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        String user_home = AccessController.doPrivileged(new GetPropertyAction("user.home"));
        if (user_home == null) {
            user_home = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        }
        name = user_name != null ? user_home + File.separator + stdCacheNameComponent + "_" + user_name : user_home + File.separator + stdCacheNameComponent;
        if (DEBUG) {
            System.out.println(">>>KinitOptions cache name is " + name);
        }
        return name;
    }

    public static String checkValidation(String name) {
        String fullname = null;
        if (name == null) {
            return null;
        }
        try {
            fullname = new File(name).getCanonicalPath();
            File fCheck = new File(fullname);
            if (!fCheck.exists()) {
                File temp = new File(fCheck.getParent());
                if (!temp.isDirectory()) {
                    fullname = null;
                }
                Object var3_4 = null;
            }
            fCheck = null;
        }
        catch (IOException e) {
            fullname = null;
        }
        return fullname;
    }

    private static String exec(String c) {
        StringTokenizer st = new StringTokenizer(c);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] command = new String[v.size()];
        v.copyInto(command);
        try {
            Process p = AccessController.doPrivileged(new PrivilegedAction<Process>((String[])command){
                final /* synthetic */ String[] val$command;
                {
                    this.val$command = stringArray;
                }

                @Override
                public Process run() {
                    try {
                        return Runtime.getRuntime().exec(this.val$command);
                    }
                    catch (IOException e) {
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                }
            });
            if (p == null) {
                return null;
            }
            BufferedReader commandResult = new BufferedReader(new InputStreamReader(p.getInputStream(), "8859_1"));
            String s1 = null;
            if (command.length == 1 && ((String)command[0]).equals("/usr/bin/env")) {
                while ((s1 = commandResult.readLine()) != null) {
                    if (s1.length() < 11 || !s1.substring(0, 11).equalsIgnoreCase("KRB5CCNAME=")) continue;
                    s1 = s1.substring(11);
                    break;
                }
            } else {
                s1 = commandResult.readLine();
            }
            commandResult.close();
            return s1;
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    static {
        DEBUG = Krb5.DEBUG;
    }
}

