/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.InquireType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Provider;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spnego.NegTokenInit;
import sun.security.jgss.spnego.NegTokenTarg;
import sun.security.jgss.spnego.SpNegoCredElement;
import sun.security.jgss.spnego.SpNegoMechFactory;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;

public class SpNegoContext
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private boolean delegPolicyState = false;
    private GSSNameSpi peerName = null;
    private GSSNameSpi myName = null;
    private SpNegoCredElement myCred = null;
    private GSSContext mechContext = null;
    private byte[] DER_mechTypes = null;
    private int lifetime;
    private ChannelBinding channelBinding;
    private boolean initiator;
    private Oid internal_mech = null;
    private final SpNegoMechFactory factory;
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.spnego.debug"));

    public SpNegoContext(SpNegoMechFactory factory, GSSNameSpi peerName, GSSCredentialSpi myCred, int lifetime) throws GSSException {
        if (peerName == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        if (myCred != null && !(myCred instanceof SpNegoCredElement)) {
            throw new IllegalArgumentException("Wrong cred element type");
        }
        this.peerName = peerName;
        this.myCred = (SpNegoCredElement)myCred;
        this.lifetime = lifetime;
        this.initiator = true;
        this.factory = factory;
    }

    public SpNegoContext(SpNegoMechFactory factory, GSSCredentialSpi myCred) throws GSSException {
        if (myCred != null && !(myCred instanceof SpNegoCredElement)) {
            throw new IllegalArgumentException("Wrong cred element type");
        }
        this.myCred = (SpNegoCredElement)myCred;
        this.initiator = false;
        this.factory = factory;
    }

    public SpNegoContext(SpNegoMechFactory factory, byte[] interProcessToken) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    @Override
    public final void requestConf(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = value;
        }
    }

    @Override
    public final boolean getConfState() {
        return this.confState;
    }

    @Override
    public final void requestInteg(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = value;
        }
    }

    @Override
    public final void requestDelegPolicy(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.delegPolicyState = value;
        }
    }

    @Override
    public final boolean getIntegState() {
        return this.integState;
    }

    @Override
    public final boolean getDelegPolicyState() {
        if (this.isInitiator() && this.mechContext != null && this.mechContext instanceof ExtendedGSSContext && (this.state == 2 || this.state == 3)) {
            return ((ExtendedGSSContext)this.mechContext).getDelegPolicyState();
        }
        return this.delegPolicyState;
    }

    @Override
    public final void requestCredDeleg(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.credDelegState = value;
        }
    }

    @Override
    public final boolean getCredDelegState() {
        if (this.isInitiator() && this.mechContext != null && (this.state == 2 || this.state == 3)) {
            return this.mechContext.getCredDelegState();
        }
        return this.credDelegState;
    }

    @Override
    public final void requestMutualAuth(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = value;
        }
    }

    @Override
    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    @Override
    public final Oid getMech() {
        if (this.isEstablished()) {
            return this.getNegotiatedMech();
        }
        return SpNegoMechFactory.GSS_SPNEGO_MECH_OID;
    }

    public final Oid getNegotiatedMech() {
        return this.internal_mech;
    }

    @Override
    public final Provider getProvider() {
        return SpNegoMechFactory.PROVIDER;
    }

    @Override
    public final void dispose() throws GSSException {
        this.mechContext = null;
        this.state = 4;
    }

    @Override
    public final boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public final boolean isProtReady() {
        return this.state == 3;
    }

    @Override
    public final byte[] initSecContext(InputStream is, int mechTokenSize) throws GSSException {
        byte[] retVal = null;
        NegTokenInit initToken = null;
        byte[] mechToken = null;
        int errorCode = 11;
        if (DEBUG) {
            System.out.println("Entered SpNego.initSecContext with state=" + SpNegoContext.printState(this.state));
        }
        if (!this.isInitiator()) {
            throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                errorCode = 13;
                Oid[] mechList = this.getAvailableMechs();
                this.DER_mechTypes = this.getEncodedMechs(mechList);
                this.internal_mech = mechList[0];
                mechToken = this.GSS_initSecContext(null);
                errorCode = 10;
                initToken = new NegTokenInit(this.DER_mechTypes, this.getContextFlags(), mechToken, null);
                if (DEBUG) {
                    System.out.println("SpNegoContext.initSecContext: sending token of type = " + SpNegoToken.getTokenName(initToken.getType()));
                }
                retVal = initToken.getEncoded();
            } else if (this.state == 2) {
                errorCode = 11;
                if (is == null) {
                    throw new GSSException(errorCode, -1, "No token received from peer!");
                }
                errorCode = 10;
                byte[] server_token = new byte[is.available()];
                SpNegoToken.readFully(is, server_token);
                if (DEBUG) {
                    System.out.println("SpNegoContext.initSecContext: process received token = " + SpNegoToken.getHexBytes(server_token));
                }
                NegTokenTarg targToken = new NegTokenTarg(server_token);
                if (DEBUG) {
                    System.out.println("SpNegoContext.initSecContext: received token of type = " + SpNegoToken.getTokenName(targToken.getType()));
                }
                this.internal_mech = targToken.getSupportedMech();
                if (this.internal_mech == null) {
                    throw new GSSException(errorCode, -1, "supported mechansim from server is null");
                }
                SpNegoToken.NegoResult negoResult = null;
                int result = targToken.getNegotiatedResult();
                switch (result) {
                    case 0: {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_COMPLETE;
                        this.state = 3;
                        break;
                    }
                    case 1: {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_INCOMPLETE;
                        this.state = 2;
                        break;
                    }
                    case 2: {
                        negoResult = SpNegoToken.NegoResult.REJECT;
                        this.state = 4;
                        break;
                    }
                    default: {
                        this.state = 3;
                    }
                }
                errorCode = 2;
                if (negoResult == SpNegoToken.NegoResult.REJECT) {
                    throw new GSSException(errorCode, -1, this.internal_mech.toString());
                }
                errorCode = 10;
                if (negoResult == SpNegoToken.NegoResult.ACCEPT_COMPLETE || negoResult == SpNegoToken.NegoResult.ACCEPT_INCOMPLETE) {
                    byte[] micToken;
                    byte[] accept_token = targToken.getResponseToken();
                    if (accept_token == null) {
                        if (!this.isMechContextEstablished()) {
                            throw new GSSException(errorCode, -1, "mechanism token from server is null");
                        }
                    } else {
                        mechToken = this.GSS_initSecContext(accept_token);
                    }
                    if (!GSSUtil.useMSInterop() && !this.verifyMechListMIC(this.DER_mechTypes, micToken = targToken.getMechListMIC())) {
                        throw new GSSException(errorCode, -1, "verification of MIC on MechList Failed!");
                    }
                    if (this.isMechContextEstablished()) {
                        this.state = 3;
                        retVal = mechToken;
                        if (DEBUG) {
                            System.out.println("SPNEGO Negotiated Mechanism = " + this.internal_mech + " " + GSSUtil.getMechStr(this.internal_mech));
                        }
                    } else {
                        initToken = new NegTokenInit(null, null, mechToken, null);
                        if (DEBUG) {
                            System.out.println("SpNegoContext.initSecContext: continue sending token of type = " + SpNegoToken.getTokenName(initToken.getType()));
                        }
                        retVal = initToken.getEncoded();
                    }
                }
            } else if (DEBUG) {
                System.out.println(this.state);
            }
            if (DEBUG && retVal != null) {
                System.out.println("SNegoContext.initSecContext: sending token = " + SpNegoToken.getHexBytes(retVal));
            }
        }
        catch (GSSException e) {
            GSSException gssException = new GSSException(errorCode, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        return retVal;
    }

    @Override
    public final byte[] acceptSecContext(InputStream is, int mechTokenSize) throws GSSException {
        byte[] retVal = null;
        boolean valid = true;
        if (DEBUG) {
            System.out.println("Entered SpNegoContext.acceptSecContext with state=" + SpNegoContext.printState(this.state));
        }
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                SpNegoToken.NegoResult negoResult;
                this.state = 2;
                byte[] token = new byte[is.available()];
                SpNegoToken.readFully(is, token);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: receiving token = " + SpNegoToken.getHexBytes(token));
                }
                NegTokenInit initToken = new NegTokenInit(token);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: received token of type = " + SpNegoToken.getTokenName(initToken.getType()));
                }
                Oid[] mechList = initToken.getMechTypeList();
                this.DER_mechTypes = initToken.getMechTypes();
                if (this.DER_mechTypes == null) {
                    valid = false;
                }
                byte[] mechToken = initToken.getMechToken();
                Oid[] supported_mechSet = this.getAvailableMechs();
                Oid mech_wanted = SpNegoContext.negotiate_mech_type(supported_mechSet, mechList);
                if (mech_wanted == null) {
                    valid = false;
                }
                this.internal_mech = mech_wanted;
                byte[] accept_token = this.GSS_acceptSecContext(mechToken);
                if (!GSSUtil.useMSInterop() && valid) {
                    valid = this.verifyMechListMIC(this.DER_mechTypes, initToken.getMechListMIC());
                }
                if (valid) {
                    if (this.isMechContextEstablished()) {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_COMPLETE;
                        this.state = 3;
                        this.setContextFlags();
                        if (DEBUG) {
                            System.out.println("SPNEGO Negotiated Mechanism = " + this.internal_mech + " " + GSSUtil.getMechStr(this.internal_mech));
                        }
                    } else {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_INCOMPLETE;
                        this.state = 2;
                    }
                } else {
                    negoResult = SpNegoToken.NegoResult.REJECT;
                    this.state = 3;
                }
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: mechanism wanted = " + mech_wanted);
                    System.out.println("SpNegoContext.acceptSecContext: negotiated result = " + (Object)((Object)negoResult));
                }
                NegTokenTarg targToken = new NegTokenTarg(negoResult.ordinal(), mech_wanted, accept_token, null);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: sending token of type = " + SpNegoToken.getTokenName(targToken.getType()));
                }
                retVal = targToken.getEncoded();
            } else if (this.state == 2) {
                SpNegoToken.NegoResult negoResult;
                byte[] client_token = new byte[is.available()];
                SpNegoToken.readFully(is, client_token);
                byte[] accept_token = this.GSS_acceptSecContext(client_token);
                if (accept_token == null) {
                    valid = false;
                }
                if (valid) {
                    if (this.isMechContextEstablished()) {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_COMPLETE;
                        this.state = 3;
                    } else {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_INCOMPLETE;
                        this.state = 2;
                    }
                } else {
                    negoResult = SpNegoToken.NegoResult.REJECT;
                    this.state = 3;
                }
                NegTokenTarg targToken = new NegTokenTarg(negoResult.ordinal(), null, accept_token, null);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: sending token of type = " + SpNegoToken.getTokenName(targToken.getType()));
                }
                retVal = targToken.getEncoded();
            } else if (DEBUG) {
                System.out.println("AcceptSecContext: state = " + this.state);
            }
            if (DEBUG) {
                System.out.println("SpNegoContext.acceptSecContext: sending token = " + SpNegoToken.getHexBytes(retVal));
            }
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        if (this.state == 3) {
            this.setContextFlags();
        }
        return retVal;
    }

    private Oid[] getAvailableMechs() {
        if (this.myCred != null) {
            Oid[] mechs = new Oid[]{this.myCred.getInternalMech()};
            return mechs;
        }
        return this.factory.availableMechs;
    }

    private byte[] getEncodedMechs(Oid[] mechSet) throws IOException, GSSException {
        DerOutputStream mech = new DerOutputStream();
        for (int i = 0; i < mechSet.length; ++i) {
            byte[] mechType = mechSet[i].getDER();
            mech.write(mechType);
        }
        DerOutputStream mechTypeList = new DerOutputStream();
        mechTypeList.write((byte)48, mech);
        byte[] encoded = mechTypeList.toByteArray();
        return encoded;
    }

    private BitArray getContextFlags() {
        BitArray out = new BitArray(7);
        if (this.getCredDelegState()) {
            out.set(0, true);
        }
        if (this.getMutualAuthState()) {
            out.set(1, true);
        }
        if (this.getReplayDetState()) {
            out.set(2, true);
        }
        if (this.getSequenceDetState()) {
            out.set(3, true);
        }
        if (this.getConfState()) {
            out.set(5, true);
        }
        if (this.getIntegState()) {
            out.set(6, true);
        }
        return out;
    }

    private void setContextFlags() {
        if (this.mechContext != null) {
            if (this.mechContext.getCredDelegState()) {
                this.credDelegState = true;
            }
            if (!this.mechContext.getMutualAuthState()) {
                this.mutualAuthState = false;
            }
            if (!this.mechContext.getReplayDetState()) {
                this.replayDetState = false;
            }
            if (!this.mechContext.getSequenceDetState()) {
                this.sequenceDetState = false;
            }
            if (!this.mechContext.getIntegState()) {
                this.integState = false;
            }
            if (!this.mechContext.getConfState()) {
                this.confState = false;
            }
        }
    }

    private boolean verifyMechListMIC(byte[] mechTypes, byte[] token) throws GSSException {
        boolean valid;
        block6: {
            if (token == null) {
                if (DEBUG) {
                    System.out.println("SpNegoContext: no MIC token validation");
                }
                return true;
            }
            if (!this.mechContext.getIntegState()) {
                if (DEBUG) {
                    System.out.println("SpNegoContext: no MIC token validation - mechanism does not support integrity");
                }
                return true;
            }
            valid = false;
            try {
                MessageProp prop = new MessageProp(0, true);
                this.verifyMIC(token, 0, token.length, mechTypes, 0, mechTypes.length, prop);
                valid = true;
            }
            catch (GSSException e) {
                valid = false;
                if (!DEBUG) break block6;
                System.out.println("SpNegoContext: MIC validation failed! " + e.getMessage());
            }
        }
        return valid;
    }

    private byte[] GSS_initSecContext(byte[] token) throws GSSException {
        byte[] tok = null;
        if (this.mechContext == null) {
            GSSName serverName = this.factory.manager.createName(this.peerName.toString(), this.peerName.getStringNameType(), this.internal_mech);
            GSSCredentialImpl cred = null;
            if (this.myCred != null) {
                cred = new GSSCredentialImpl(this.factory.manager, this.myCred.getInternalCred());
            }
            this.mechContext = this.factory.manager.createContext(serverName, this.internal_mech, cred, 0);
            this.mechContext.requestConf(this.confState);
            this.mechContext.requestInteg(this.integState);
            this.mechContext.requestCredDeleg(this.credDelegState);
            this.mechContext.requestMutualAuth(this.mutualAuthState);
            this.mechContext.requestReplayDet(this.replayDetState);
            this.mechContext.requestSequenceDet(this.sequenceDetState);
            if (this.mechContext instanceof ExtendedGSSContext) {
                ((ExtendedGSSContext)this.mechContext).requestDelegPolicy(this.delegPolicyState);
            }
        }
        tok = token != null ? token : new byte[]{};
        byte[] init_token = this.mechContext.initSecContext(tok, 0, tok.length);
        return init_token;
    }

    private byte[] GSS_acceptSecContext(byte[] token) throws GSSException {
        if (this.mechContext == null) {
            GSSCredentialImpl cred = null;
            if (this.myCred != null) {
                cred = new GSSCredentialImpl(this.factory.manager, this.myCred.getInternalCred());
            }
            this.mechContext = this.factory.manager.createContext(cred);
        }
        byte[] accept_token = this.mechContext.acceptSecContext(token, 0, token.length);
        return accept_token;
    }

    private static Oid negotiate_mech_type(Oid[] supported_mechSet, Oid[] mechSet) {
        for (int i = 0; i < supported_mechSet.length; ++i) {
            for (int j = 0; j < mechSet.length; ++j) {
                if (!mechSet[j].equals(supported_mechSet[i])) continue;
                if (DEBUG) {
                    System.out.println("SpNegoContext: negotiated mechanism = " + mechSet[j]);
                }
                return mechSet[j];
            }
        }
        return null;
    }

    @Override
    public final boolean isEstablished() {
        return this.state == 3;
    }

    public final boolean isMechContextEstablished() {
        if (this.mechContext != null) {
            return this.mechContext.isEstablished();
        }
        if (DEBUG) {
            System.out.println("The underlying mechansim context has not been initialized");
        }
        return false;
    }

    @Override
    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    @Override
    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public final void requestAnonymity(boolean value) throws GSSException {
    }

    @Override
    public final boolean getAnonymityState() {
        return false;
    }

    @Override
    public void requestLifetime(int lifetime) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = lifetime;
        }
    }

    @Override
    public final int getLifetime() {
        if (this.mechContext != null) {
            return this.mechContext.getLifetime();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isTransferable() throws GSSException {
        return false;
    }

    @Override
    public final void requestSequenceDet(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = value;
        }
    }

    @Override
    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    @Override
    public final void requestReplayDet(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = value;
        }
    }

    @Override
    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    @Override
    public final GSSNameSpi getTargName() throws GSSException {
        if (this.mechContext != null) {
            GSSNameImpl targName = (GSSNameImpl)this.mechContext.getTargName();
            this.peerName = targName.getElement(this.internal_mech);
            return this.peerName;
        }
        if (DEBUG) {
            System.out.println("The underlying mechansim context has not been initialized");
        }
        return null;
    }

    @Override
    public final GSSNameSpi getSrcName() throws GSSException {
        if (this.mechContext != null) {
            GSSNameImpl srcName = (GSSNameImpl)this.mechContext.getSrcName();
            this.myName = srcName.getElement(this.internal_mech);
            return this.myName;
        }
        if (DEBUG) {
            System.out.println("The underlying mechansim context has not been initialized");
        }
        return null;
    }

    @Override
    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.mechContext != null) {
            GSSCredentialImpl delegCred = (GSSCredentialImpl)this.mechContext.getDelegCred();
            boolean initiate = false;
            if (delegCred.getUsage() == 1) {
                initiate = true;
            }
            GSSCredentialSpi mechCred = delegCred.getElement(this.internal_mech, initiate);
            SpNegoCredElement cred = new SpNegoCredElement(mechCred);
            return cred.getInternalCred();
        }
        throw new GSSException(12, -1, "getDelegCred called in invalid state!");
    }

    @Override
    public final int getWrapSizeLimit(int qop, boolean confReq, int maxTokSize) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.getWrapSizeLimit(qop, confReq, maxTokSize);
        }
        throw new GSSException(12, -1, "getWrapSizeLimit called in invalid state!");
    }

    @Override
    public final byte[] wrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.wrap(inBuf, offset, len, msgProp);
        }
        throw new GSSException(12, -1, "Wrap called in invalid state!");
    }

    @Override
    public final void wrap(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        this.mechContext.wrap(is, os, msgProp);
    }

    @Override
    public final byte[] unwrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.unwrap(inBuf, offset, len, msgProp);
        }
        throw new GSSException(12, -1, "UnWrap called in invalid state!");
    }

    @Override
    public final void unwrap(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "UnWrap called in invalid state!");
        }
        this.mechContext.unwrap(is, os, msgProp);
    }

    @Override
    public final byte[] getMIC(byte[] inMsg, int offset, int len, MessageProp msgProp) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.getMIC(inMsg, offset, len, msgProp);
        }
        throw new GSSException(12, -1, "getMIC called in invalid state!");
    }

    @Override
    public final void getMIC(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "getMIC called in invalid state!");
        }
        this.mechContext.getMIC(is, os, msgProp);
    }

    @Override
    public final void verifyMIC(byte[] inTok, int tokOffset, int tokLen, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        this.mechContext.verifyMIC(inTok, tokOffset, tokLen, inMsg, msgOffset, msgLen, msgProp);
    }

    @Override
    public final void verifyMIC(InputStream is, InputStream msgStr, MessageProp msgProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        this.mechContext.verifyMIC(is, msgStr, msgProp);
    }

    private static String printState(int state) {
        switch (state) {
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_IN_PROCESS";
            }
            case 3: {
                return "STATE_DONE";
            }
            case 4: {
                return "STATE_DELETED";
            }
        }
        return "Unknown state " + state;
    }

    @Override
    public Object inquireSecContext(InquireType type) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "Underlying mech not established.");
        }
        if (this.mechContext instanceof ExtendedGSSContext) {
            return ((ExtendedGSSContext)this.mechContext).inquireSecContext(type);
        }
        throw new GSSException(2, -1, "inquireSecContext not supported by underlying mech.");
    }
}

