/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderMalfunctionError;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Sides;
import sun.awt.CharsetString;
import sun.awt.FontConfiguration;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.font.FontUtilities;
import sun.print.PSPathGraphics;
import sun.print.PSStreamPrintService;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /imageSrc {currentfile /ASCII85Decode filter /RunLengthDecode filter  imStr readstring pop } def";
    private static final String COPIES = "/#copies exch def";
    private static final String PAGE_SAVE = "/pgSave save def";
    private static final String PAGE_RESTORE = "pgSave restore";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String SetFontName = "F";
    private static final String DrawStringName = "S";
    private static final String EVEN_ODD_FILL_STR = "EF";
    private static final String WINDING_FILL_STR = "WF";
    private static final String EVEN_ODD_CLIP_STR = "EC";
    private static final String WINDING_CLIP_STR = "WC";
    private static final String MOVETO_STR = " M";
    private static final String LINETO_STR = " L";
    private static final String CURVETO_STR = " C";
    private static final String GRESTORE_STR = "R";
    private static final String GSAVE_STR = "G";
    private static final String NEWPATH_STR = "N";
    private static final String CLOSEPATH_STR = "P";
    private static final String SETRGBCOLOR_STR = " SC";
    private static final String SETGRAY_STR = " SG";
    private int mDestType;
    private String mDestination = "lp";
    private boolean mNoJobSheet = false;
    private String mOptions;
    private Font mLastFont;
    private Color mLastColor;
    private Shape mLastClip;
    private AffineTransform mLastTransform;
    private EPSPrinter epsPrinter = null;
    FontMetrics mCurMetrics;
    PrintStream mPSStream;
    File spoolFile;
    private String mFillOpStr = "WF";
    private String mClipOpStr = "WC";
    ArrayList mGStateStack = new ArrayList();
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;
    private static Properties mFontProps = null;

    private static Properties initProps() {
        String jhome = System.getProperty("java.home");
        if (jhome != null) {
            String ulocale = SunToolkit.getStartupLocale().getLanguage();
            try {
                File f = new File(jhome + File.separator + "lib" + File.separator + "psfontj2d.properties." + ulocale);
                if (!(f.canRead() || (f = new File(jhome + File.separator + "lib" + File.separator + "psfont.properties." + ulocale)).canRead() || (f = new File(jhome + File.separator + "lib" + File.separator + "psfontj2d.properties")).canRead() || (f = new File(jhome + File.separator + "lib" + File.separator + "psfont.properties")).canRead())) {
                    return null;
                }
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f.getPath()));
                Properties props = new Properties();
                props.load(in);
                ((InputStream)in).close();
                return props;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(new Copies(this.getCopies()));
        this.attributes.add(new JobName(this.getJobName(), null));
        boolean doPrint = false;
        DialogTypeSelection dts = (DialogTypeSelection)this.attributes.get(DialogTypeSelection.class);
        if (dts == DialogTypeSelection.NATIVE) {
            this.attributes.remove(DialogTypeSelection.class);
            doPrint = this.printDialog(this.attributes);
            this.attributes.add(DialogTypeSelection.NATIVE);
        } else {
            doPrint = this.printDialog(this.attributes);
        }
        if (doPrint) {
            Destination dest;
            Copies copies;
            JobName jobName = (JobName)this.attributes.get(JobName.class);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)this.attributes.get(Copies.class)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((dest = (Destination)this.attributes.get(Destination.class)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(dest.getURI()).getPath();
                }
                catch (Exception e) {
                    this.mDestination = "out.ps";
                }
            } else {
                this.mDestType = 0;
                PrintService pServ = this.getPrintService();
                if (pServ != null) {
                    this.mDestination = pServ.getName();
                }
            }
        }
        return doPrint;
    }

    @Override
    protected void startDoc() throws PrinterException {
        if (this.epsPrinter == null) {
            OutputStream output;
            if (this.getPrintService() instanceof PSStreamPrintService) {
                StreamPrintService sps = (StreamPrintService)this.getPrintService();
                this.mDestType = 2;
                if (sps.isDisposed()) {
                    throw new PrinterException("service is disposed");
                }
                output = sps.getOutputStream();
                if (output == null) {
                    throw new PrinterException("Null output stream");
                }
            } else {
                this.mNoJobSheet = this.noJobSheet;
                if (this.destinationAttr != null) {
                    this.mDestType = 1;
                    this.mDestination = this.destinationAttr;
                }
                if (this.mDestType == 1) {
                    try {
                        this.spoolFile = new File(this.mDestination);
                        output = new FileOutputStream(this.spoolFile);
                    }
                    catch (IOException ex) {
                        throw new PrinterIOException(ex);
                    }
                } else {
                    PrinterOpener po = new PrinterOpener();
                    AccessController.doPrivileged(po);
                    if (po.pex != null) {
                        throw po.pex;
                    }
                    output = po.result;
                }
            }
            this.mPSStream = new PrintStream(new BufferedOutputStream(output));
            this.mPSStream.println(ADOBE_PS_STR);
        }
        this.mPSStream.println("%%BeginProlog");
        this.mPSStream.println(READIMAGEPROC);
        this.mPSStream.println("/BD {bind def} bind def");
        this.mPSStream.println("/D {def} BD");
        this.mPSStream.println("/C {curveto} BD");
        this.mPSStream.println("/L {lineto} BD");
        this.mPSStream.println("/M {moveto} BD");
        this.mPSStream.println("/R {grestore} BD");
        this.mPSStream.println("/G {gsave} BD");
        this.mPSStream.println("/N {newpath} BD");
        this.mPSStream.println("/P {closepath} BD");
        this.mPSStream.println("/EC {eoclip} BD");
        this.mPSStream.println("/WC {clip} BD");
        this.mPSStream.println("/EF {eofill} BD");
        this.mPSStream.println("/WF {fill} BD");
        this.mPSStream.println("/SG {setgray} BD");
        this.mPSStream.println("/SC {setrgbcolor} BD");
        this.mPSStream.println("/ISOF {");
        this.mPSStream.println("     dup findfont dup length 1 add dict begin {");
        this.mPSStream.println("             1 index /FID eq {pop pop} {D} ifelse");
        this.mPSStream.println("     } forall /Encoding ISOLatin1Encoding D");
        this.mPSStream.println("     currentdict end definefont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.mPSStream.println("/S {");
        this.mPSStream.println("     moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("     1 index length 1 sub NZ div 0");
        this.mPSStream.println("     3 2 roll ashow newpath} BD");
        this.mPSStream.println("/FL [");
        if (mFontProps == null) {
            this.mPSStream.println(" /Helvetica ISOF");
            this.mPSStream.println(" /Helvetica-Bold ISOF");
            this.mPSStream.println(" /Helvetica-Oblique ISOF");
            this.mPSStream.println(" /Helvetica-BoldOblique ISOF");
            this.mPSStream.println(" /Times-Roman ISOF");
            this.mPSStream.println(" /Times-Bold ISOF");
            this.mPSStream.println(" /Times-Italic ISOF");
            this.mPSStream.println(" /Times-BoldItalic ISOF");
            this.mPSStream.println(" /Courier ISOF");
            this.mPSStream.println(" /Courier-Bold ISOF");
            this.mPSStream.println(" /Courier-Oblique ISOF");
            this.mPSStream.println(" /Courier-BoldOblique ISOF");
        } else {
            int cnt = Integer.parseInt(mFontProps.getProperty("font.num", "9"));
            for (int i = 0; i < cnt; ++i) {
                this.mPSStream.println("    /" + mFontProps.getProperty("font." + String.valueOf(i), "Courier ISOF"));
            }
        }
        this.mPSStream.println("] D");
        this.mPSStream.println("/F {");
        this.mPSStream.println("     FL exch get exch scalefont");
        this.mPSStream.println("     [1 0 0 -1 0 0] makefont setfont} BD");
        this.mPSStream.println("%%EndProlog");
        this.mPSStream.println("%%BeginSetup");
        if (this.epsPrinter == null) {
            PageFormat pageFormat = this.getPageable().getPageFormat(0);
            double paperHeight = pageFormat.getPaper().getHeight();
            double paperWidth = pageFormat.getPaper().getWidth();
            this.mPSStream.print("<< /PageSize [" + paperWidth + " " + paperHeight + "]");
            final PrintService pservice = this.getPrintService();
            Boolean isPS = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> psClass = Class.forName("sun.print.IPPPrintService");
                        if (psClass.isInstance(pservice)) {
                            Method isPSMethod = psClass.getMethod("isPostscript", null);
                            return (Boolean)isPSMethod.invoke(pservice, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return Boolean.TRUE;
                }
            });
            if (isPS.booleanValue()) {
                this.mPSStream.print(" /DeferredMediaSelection true");
            }
            this.mPSStream.print(" /ImagingBBox null /ManualFeed false");
            this.mPSStream.print(this.isCollated() ? " /Collate true" : "");
            this.mPSStream.print(" /NumCopies " + this.getCopiesInt());
            if (this.sidesAttr != Sides.ONE_SIDED) {
                if (this.sidesAttr == Sides.TWO_SIDED_LONG_EDGE) {
                    this.mPSStream.print(" /Duplex true ");
                } else if (this.sidesAttr == Sides.TWO_SIDED_SHORT_EDGE) {
                    this.mPSStream.print(" /Duplex true /Tumble true ");
                }
            }
            this.mPSStream.println(" >> setpagedevice ");
        }
        this.mPSStream.println("%%EndSetup");
    }

    @Override
    protected void abortDoc() {
        if (this.mPSStream != null && this.mDestType != 2) {
            this.mPSStream.close();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (PSPrinterJob.this.spoolFile != null && PSPrinterJob.this.spoolFile.exists()) {
                    PSPrinterJob.this.spoolFile.delete();
                }
                return null;
            }
        });
    }

    @Override
    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.flush();
            if (this.mDestType != 2) {
                this.mPSStream.close();
            }
        }
        if (this.mDestType == 0) {
            if (this.getPrintService() != null) {
                this.mDestination = this.getPrintService().getName();
            }
            PrinterSpooler spooler = new PrinterSpooler();
            AccessController.doPrivileged(spooler);
            if (spooler.pex != null) {
                throw spooler.pex;
            }
        }
    }

    @Override
    protected void startPage(PageFormat pageFormat, Printable painter, int index, boolean paperChanged) throws PrinterException {
        double paperHeight = pageFormat.getPaper().getHeight();
        double paperWidth = pageFormat.getPaper().getWidth();
        int pageNumber = index + 1;
        this.mGStateStack = new ArrayList();
        this.mGStateStack.add(new GState());
        this.mPSStream.println(PAGE_COMMENT + pageNumber + " " + pageNumber);
        if (index > 0 && paperChanged) {
            this.mPSStream.print("<< /PageSize [" + paperWidth + " " + paperHeight + "]");
            final PrintService pservice = this.getPrintService();
            Boolean isPS = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> psClass = Class.forName("sun.print.IPPPrintService");
                        if (psClass.isInstance(pservice)) {
                            Method isPSMethod = psClass.getMethod("isPostscript", null);
                            return (Boolean)isPSMethod.invoke(pservice, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return Boolean.TRUE;
                }
            });
            if (isPS.booleanValue()) {
                this.mPSStream.print(" /DeferredMediaSelection true");
            }
            this.mPSStream.println(" >> setpagedevice");
        }
        this.mPSStream.println(PAGE_SAVE);
        this.mPSStream.println(paperHeight + COORD_PREP);
    }

    @Override
    protected void endPage(PageFormat format, Printable painter, int index) throws PrinterException {
        this.mPSStream.println(PAGE_RESTORE);
        this.mPSStream.println(SHOWPAGE);
    }

    protected void drawImageBGR(byte[] bgrData, float destX, float destY, float destWidth, float destHeight, float srcX, float srcY, float srcWidth, float srcHeight, int srcBitMapWidth, int srcBitMapHeight) {
        int psBytesPerRow;
        this.setTransform(new AffineTransform());
        this.prepDrawing();
        int intSrcWidth = (int)srcWidth;
        int intSrcHeight = (int)srcHeight;
        this.mPSStream.println(IMAGE_SAVE);
        for (psBytesPerRow = 3 * intSrcWidth; psBytesPerRow > 65535; psBytesPerRow /= 2) {
        }
        this.mPSStream.println(psBytesPerRow + IMAGE_STR);
        this.mPSStream.println("[" + destWidth + " 0 " + "0 " + destHeight + " " + destX + " " + destY + "]concat");
        this.mPSStream.println(intSrcWidth + " " + intSrcHeight + " " + 8 + "[" + intSrcWidth + " 0 " + "0 " + intSrcHeight + " 0 " + 0 + "]" + "/imageSrc load false 3 colorimage");
        int index = 0;
        byte[] rgbData = new byte[intSrcWidth * 3];
        try {
            index = (int)srcY * srcBitMapWidth;
            for (int i = 0; i < intSrcHeight; ++i) {
                index += (int)srcX;
                index = PSPrinterJob.swapBGRtoRGB(bgrData, index, rgbData);
                byte[] encodedData = this.rlEncode(rgbData);
                byte[] asciiData = this.ascii85Encode(encodedData);
                this.mPSStream.write(asciiData);
                this.mPSStream.println("");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    @Override
    protected void printBand(byte[] bgrData, int x, int y, int width, int height) throws PrinterException {
        int psBytesPerRow;
        this.mPSStream.println(IMAGE_SAVE);
        for (psBytesPerRow = 3 * width; psBytesPerRow > 65535; psBytesPerRow /= 2) {
        }
        this.mPSStream.println(psBytesPerRow + IMAGE_STR);
        this.mPSStream.println("[" + width + " 0 " + "0 " + height + " " + x + " " + y + "]concat");
        this.mPSStream.println(width + " " + height + " " + 8 + "[" + width + " 0 " + "0 " + -height + " 0 " + height + "]" + "/imageSrc load false 3 colorimage");
        int index = 0;
        byte[] rgbData = new byte[width * 3];
        try {
            for (int i = 0; i < height; ++i) {
                index = PSPrinterJob.swapBGRtoRGB(bgrData, index, rgbData);
                byte[] encodedData = this.rlEncode(rgbData);
                byte[] asciiData = this.ascii85Encode(encodedData);
                this.mPSStream.write(asciiData);
                this.mPSStream.println("");
            }
        }
        catch (IOException e) {
            throw new PrinterIOException(e);
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    @Override
    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable painter, PageFormat pageFormat, int pageIndex) {
        PSPathGraphics pathGraphics;
        PeekMetrics metrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || metrics.hasNonSolidColors() || metrics.hasCompositing())) {
            pathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D bufferedGraphics = bufferedImage.createGraphics();
            boolean canRedraw = !peekGraphics.getAWTDrawingOnly();
            pathGraphics = new PSPathGraphics(bufferedGraphics, printerJob, painter, pageFormat, pageIndex, canRedraw);
        }
        return pathGraphics;
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    protected void setClip(Shape clip) {
        this.mLastClip = clip;
    }

    protected void setTransform(AffineTransform transform) {
        this.mLastTransform = transform;
    }

    protected boolean setFont(Font font) {
        this.mLastFont = font;
        return true;
    }

    private int[] getPSFontIndexArray(Font font, CharsetString[] charSet) {
        int[] psFont = null;
        if (mFontProps != null) {
            psFont = new int[charSet.length];
        }
        for (int i = 0; i < charSet.length && psFont != null; ++i) {
            CharsetString cs = charSet[i];
            CharsetEncoder fontCS = cs.fontDescriptor.encoder;
            String charsetName = cs.fontDescriptor.getFontCharsetName();
            charsetName = "Symbol".equals(charsetName) ? "symbol" : ("WingDings".equals(charsetName) || "X11Dingbats".equals(charsetName) ? "dingbats" : this.makeCharsetName(charsetName, cs.charsetChars));
            int styleMask = font.getStyle() | FontUtilities.getFont2D(font).getStyle();
            String style = FontConfiguration.getStyleString(styleMask);
            String fontName = font.getFamily().toLowerCase(Locale.ENGLISH);
            String name = mFontProps.getProperty(fontName = fontName.replace(' ', '_'), "");
            String psName = mFontProps.getProperty(name + "." + charsetName + "." + style, null);
            if (psName != null) {
                try {
                    psFont[i] = Integer.parseInt(mFontProps.getProperty(psName));
                }
                catch (NumberFormatException e) {
                    psFont = null;
                }
                continue;
            }
            psFont = null;
        }
        return psFont;
    }

    private static String escapeParens(String str) {
        if (str.indexOf(40) == -1 && str.indexOf(41) == -1) {
            return str;
        }
        int count = 0;
        int pos = 0;
        while ((pos = str.indexOf(40, pos)) != -1) {
            ++count;
            ++pos;
        }
        pos = 0;
        while ((pos = str.indexOf(41, pos)) != -1) {
            ++count;
            ++pos;
        }
        char[] inArr = str.toCharArray();
        char[] outArr = new char[inArr.length + count];
        pos = 0;
        for (int i = 0; i < inArr.length; ++i) {
            if (inArr[i] == '(' || inArr[i] == ')') {
                outArr[pos++] = 92;
            }
            outArr[pos++] = inArr[i];
        }
        return new String(outArr);
    }

    protected int platformFontCount(Font font, String str) {
        if (mFontProps == null) {
            return 0;
        }
        CharsetString[] acs = ((PlatformFont)font.getPeer()).makeMultiCharsetString(str, false);
        if (acs == null) {
            return 0;
        }
        int[] psFonts = this.getPSFontIndexArray(font, acs);
        return psFonts == null ? 0 : psFonts.length;
    }

    protected boolean textOut(Graphics g, String str, float x, float y, Font mLastFont, FontRenderContext frc, float width) {
        boolean didText = true;
        if (mFontProps == null) {
            return false;
        }
        this.prepDrawing();
        str = this.removeControlChars(str);
        if (str.length() == 0) {
            return true;
        }
        CharsetString[] acs = ((PlatformFont)mLastFont.getPeer()).makeMultiCharsetString(str, false);
        if (acs == null) {
            return false;
        }
        int[] psFonts = this.getPSFontIndexArray(mLastFont, acs);
        if (psFonts != null) {
            for (int i = 0; i < acs.length; ++i) {
                float desiredWidth;
                CharsetString cs = acs[i];
                CharsetEncoder fontCS = cs.fontDescriptor.encoder;
                StringBuffer nativeStr = new StringBuffer();
                byte[] strSeg = new byte[cs.length * 2];
                int len = 0;
                try {
                    ByteBuffer bb = ByteBuffer.wrap(strSeg);
                    fontCS.encode(CharBuffer.wrap(cs.charsetChars, cs.offset, cs.length), bb, true);
                    bb.flip();
                    len = bb.limit();
                }
                catch (IllegalStateException xx) {
                    continue;
                }
                catch (CoderMalfunctionError xx) {
                    continue;
                }
                if (acs.length == 1 && width != 0.0f) {
                    desiredWidth = width;
                } else {
                    Rectangle2D r2d = mLastFont.getStringBounds(cs.charsetChars, cs.offset, cs.offset + cs.length, frc);
                    desiredWidth = (float)r2d.getWidth();
                }
                if (desiredWidth == 0.0f) {
                    return didText;
                }
                nativeStr.append('<');
                for (int j = 0; j < len; ++j) {
                    byte b = strSeg[j];
                    String hexS = Integer.toHexString(b);
                    int length = hexS.length();
                    if (length > 2) {
                        hexS = hexS.substring(length - 2, length);
                    } else if (length == 1) {
                        hexS = "0" + hexS;
                    } else if (length == 0) {
                        hexS = "00";
                    }
                    nativeStr.append(hexS);
                }
                nativeStr.append('>');
                this.getGState().emitPSFont(psFonts[i], mLastFont.getSize2D());
                this.mPSStream.println(nativeStr.toString() + " " + desiredWidth + " " + x + " " + y + " " + DrawStringName);
                x += desiredWidth;
            }
        } else {
            didText = false;
        }
        return didText;
    }

    protected void setFillMode(int fillRule) {
        switch (fillRule) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void setColor(Color color) {
        this.mLastColor = color;
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    protected void beginPath() {
        this.prepDrawing();
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    protected void moveTo(float x, float y) {
        this.mPSStream.println(this.trunc(x) + " " + this.trunc(y) + MOVETO_STR);
        this.mStartPathX = x;
        this.mStartPathY = y;
        this.mPenX = x;
        this.mPenY = y;
    }

    protected void lineTo(float x, float y) {
        this.mPSStream.println(this.trunc(x) + " " + this.trunc(y) + LINETO_STR);
        this.mPenX = x;
        this.mPenY = y;
    }

    protected void bezierTo(float control1x, float control1y, float control2x, float control2y, float endX, float endY) {
        this.mPSStream.println(this.trunc(control1x) + " " + this.trunc(control1y) + " " + this.trunc(control2x) + " " + this.trunc(control2y) + " " + this.trunc(endX) + " " + this.trunc(endY) + CURVETO_STR);
        this.mPenX = endX;
        this.mPenY = endY;
    }

    String trunc(float f) {
        float af = Math.abs(f);
        if (af >= 1.0f && af <= 1000.0f) {
            f = (float)Math.round(f * 1000.0f) / 1000.0f;
        }
        return Float.toString(f);
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    @Override
    protected double getXRes() {
        return 300.0;
    }

    @Override
    protected double getYRes() {
        return 300.0;
    }

    @Override
    protected double getPhysicalPrintableX(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableY(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableWidth(Paper p) {
        return p.getImageableWidth();
    }

    @Override
    protected double getPhysicalPrintableHeight(Paper p) {
        return p.getImageableHeight();
    }

    @Override
    protected double getPhysicalPageWidth(Paper p) {
        return p.getWidth();
    }

    @Override
    protected double getPhysicalPageHeight(Paper p) {
        return p.getHeight();
    }

    @Override
    protected int getNoncollatedCopies() {
        return 1;
    }

    @Override
    protected int getCollatedCopies() {
        return 1;
    }

    private String[] printExecCmd(String printer, String options, boolean noJobSheet, String banner, int copies, String spoolFile) {
        String[] execCmd;
        String osname;
        int PRINTER = 1;
        int OPTIONS = 2;
        int BANNER = 4;
        int COPIES = 8;
        int NOSHEET = 16;
        int pFlags = 0;
        int ncomps = 2;
        int n = 0;
        if (printer != null && !printer.equals("") && !printer.equals("lp")) {
            pFlags |= PRINTER;
            ++ncomps;
        }
        if (options != null && !options.equals("")) {
            pFlags |= OPTIONS;
            ++ncomps;
        }
        if (banner != null && !banner.equals("")) {
            pFlags |= BANNER;
            ++ncomps;
        }
        if (copies > 1) {
            pFlags |= COPIES;
            ++ncomps;
        }
        if (noJobSheet) {
            pFlags |= NOSHEET;
            ++ncomps;
        }
        if ((osname = System.getProperty("os.name")).equals("Linux") || osname.contains("OS X")) {
            execCmd = new String[ncomps];
            execCmd[n++] = "/usr/bin/lpr";
            if ((pFlags & PRINTER) != 0) {
                execCmd[n++] = "-P" + printer;
            }
            if ((pFlags & BANNER) != 0) {
                execCmd[n++] = "-J" + banner;
            }
            if ((pFlags & COPIES) != 0) {
                execCmd[n++] = "-#" + copies;
            }
            if ((pFlags & NOSHEET) != 0) {
                execCmd[n++] = "-h";
            }
            if ((pFlags & OPTIONS) != 0) {
                execCmd[n++] = new String(options);
            }
        } else {
            execCmd = new String[++ncomps];
            execCmd[n++] = "/usr/bin/lp";
            execCmd[n++] = "-c";
            if ((pFlags & PRINTER) != 0) {
                execCmd[n++] = "-d" + printer;
            }
            if ((pFlags & BANNER) != 0) {
                execCmd[n++] = "-t" + banner;
            }
            if ((pFlags & COPIES) != 0) {
                execCmd[n++] = "-n" + copies;
            }
            if ((pFlags & NOSHEET) != 0) {
                execCmd[n++] = "-o nobanner";
            }
            if ((pFlags & OPTIONS) != 0) {
                execCmd[n++] = "-o" + options;
            }
        }
        execCmd[n++] = spoolFile;
        return execCmd;
    }

    private static int swapBGRtoRGB(byte[] image, int index, byte[] dest) {
        int destIndex = 0;
        while (index < image.length - 2 && destIndex < dest.length - 2) {
            dest[destIndex++] = image[index + 2];
            dest[destIndex++] = image[index + 1];
            dest[destIndex++] = image[index + 0];
            index += 3;
        }
        return index;
    }

    private String makeCharsetName(String name, char[] chs) {
        if (name.equals("Cp1252") || name.equals("ISO8859_1")) {
            return "latin1";
        }
        if (name.equals("UTF8")) {
            for (int i = 0; i < chs.length; ++i) {
                if (chs[i] <= '\u00ff') continue;
                return name.toLowerCase();
            }
            return "latin1";
        }
        if (name.startsWith("ISO8859")) {
            for (int i = 0; i < chs.length; ++i) {
                if (chs[i] <= '\u007f') continue;
                return name.toLowerCase();
            }
            return "latin1";
        }
        return name.toLowerCase();
    }

    private void prepDrawing() {
        while (!(this.isOuterGState() || this.getGState().canSetClip(this.mLastClip) && this.getGState().mTransform.equals(this.mLastTransform))) {
            this.grestore();
        }
        this.getGState().emitPSColor(this.mLastColor);
        if (this.isOuterGState()) {
            this.gsave();
            this.getGState().emitTransform(this.mLastTransform);
            this.getGState().emitPSClip(this.mLastClip);
        }
    }

    private GState getGState() {
        int count = this.mGStateStack.size();
        return (GState)this.mGStateStack.get(count - 1);
    }

    private void gsave() {
        GState oldGState = this.getGState();
        this.mGStateStack.add(new GState(oldGState));
        this.mPSStream.println(GSAVE_STR);
    }

    private void grestore() {
        int count = this.mGStateStack.size();
        this.mGStateStack.remove(count - 1);
        this.mPSStream.println(GRESTORE_STR);
    }

    private boolean isOuterGState() {
        return this.mGStateStack.size() == 1;
    }

    void convertToPSPath(PathIterator pathIter) {
        float[] segment = new float[6];
        int fillRule = pathIter.getWindingRule() == 0 ? 1 : 2;
        this.beginPath();
        this.setFillMode(fillRule);
        while (!pathIter.isDone()) {
            int segmentType = pathIter.currentSegment(segment);
            switch (segmentType) {
                case 0: {
                    this.moveTo(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    this.lineTo(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    float lastX = this.getPenX();
                    float lastY = this.getPenY();
                    float c1x = lastX + (segment[0] - lastX) * 2.0f / 3.0f;
                    float c1y = lastY + (segment[1] - lastY) * 2.0f / 3.0f;
                    float c2x = segment[2] - (segment[2] - segment[0]) * 2.0f / 3.0f;
                    float c2y = segment[3] - (segment[3] - segment[1]) * 2.0f / 3.0f;
                    this.bezierTo(c1x, c1y, c2x, c2y, segment[2], segment[3]);
                    break;
                }
                case 3: {
                    this.bezierTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    this.closeSubpath();
                }
            }
            pathIter.next();
        }
    }

    protected void deviceFill(PathIterator pathIter, Color color, AffineTransform tx, Shape clip) {
        this.setTransform(tx);
        this.setClip(clip);
        this.setColor(color);
        this.convertToPSPath(pathIter);
        this.mPSStream.println(GSAVE_STR);
        this.selectClipPath();
        this.fillPath();
        this.mPSStream.println("R N");
    }

    private byte[] rlEncode(byte[] inArr) {
        int inIndex = 0;
        int outIndex = 0;
        int startIndex = 0;
        int runLen = 0;
        byte[] outArr = new byte[inArr.length * 2 + 2];
        while (inIndex < inArr.length) {
            if (runLen == 0) {
                startIndex = inIndex++;
                runLen = 1;
            }
            while (runLen < 128 && inIndex < inArr.length && inArr[inIndex] == inArr[startIndex]) {
                ++runLen;
                ++inIndex;
            }
            if (runLen > 1) {
                outArr[outIndex++] = (byte)(257 - runLen);
                outArr[outIndex++] = inArr[startIndex];
                runLen = 0;
                continue;
            }
            while (runLen < 128 && inIndex < inArr.length && inArr[inIndex] != inArr[inIndex - 1]) {
                ++runLen;
                ++inIndex;
            }
            outArr[outIndex++] = (byte)(runLen - 1);
            for (int i = startIndex; i < startIndex + runLen; ++i) {
                outArr[outIndex++] = inArr[i];
            }
            runLen = 0;
        }
        outArr[outIndex++] = -128;
        byte[] encodedData = new byte[outIndex];
        System.arraycopy(outArr, 0, encodedData, 0, outIndex);
        return encodedData;
    }

    private byte[] ascii85Encode(byte[] inArr) {
        long rem;
        long val;
        byte[] outArr = new byte[(inArr.length + 4) * 5 / 4 + 2];
        long p1 = 85L;
        long p2 = p1 * p1;
        long p3 = p1 * p2;
        long p4 = p1 * p3;
        int pling = 33;
        int i = 0;
        int olen = 0;
        while (i + 3 < inArr.length) {
            if ((val = ((long)(inArr[i++] & 0xFF) << 24) + ((long)(inArr[i++] & 0xFF) << 16) + ((long)(inArr[i++] & 0xFF) << 8) + (long)(inArr[i++] & 0xFF)) == 0L) {
                outArr[olen++] = 122;
                continue;
            }
            rem = val;
            outArr[olen++] = (byte)(rem / p4 + (long)pling);
            outArr[olen++] = (byte)((rem %= p4) / p3 + (long)pling);
            outArr[olen++] = (byte)((rem %= p3) / p2 + (long)pling);
            outArr[olen++] = (byte)((rem %= p2) / p1 + (long)pling);
            outArr[olen++] = (byte)((rem %= p1) + (long)pling);
        }
        if (i < inArr.length) {
            int n = inArr.length - i;
            val = 0L;
            while (i < inArr.length) {
                val = (val << 8) + (long)(inArr[i++] & 0xFF);
            }
            int append = 4 - n;
            while (append-- > 0) {
                val <<= 8;
            }
            byte[] c = new byte[5];
            rem = val;
            c[0] = (byte)(rem / p4 + (long)pling);
            c[1] = (byte)((rem %= p4) / p3 + (long)pling);
            c[2] = (byte)((rem %= p3) / p2 + (long)pling);
            c[3] = (byte)((rem %= p2) / p1 + (long)pling);
            c[4] = (byte)((rem %= p1) + (long)pling);
            for (int b = 0; b < n + 1; ++b) {
                outArr[olen++] = c[b];
            }
        }
        outArr[olen++] = 126;
        outArr[olen++] = 62;
        byte[] retArr = new byte[olen];
        System.arraycopy(outArr, 0, retArr, 0, olen);
        return retArr;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                mFontProps = PSPrinterJob.initProps();
                return null;
            }
        });
    }

    public static class EPSPrinter
    implements Pageable {
        private PageFormat pf;
        private PSPrinterJob job;
        private int llx;
        private int lly;
        private int urx;
        private int ury;
        private Printable printable;
        private PrintStream stream;
        private String epsTitle;

        public EPSPrinter(Printable printable, String title, PrintStream stream, int x, int y, int wid, int hgt) {
            this.printable = printable;
            this.epsTitle = title;
            this.stream = stream;
            this.llx = x;
            this.lly = y;
            this.urx = this.llx + wid;
            this.ury = this.lly + hgt;
            Paper p = new Paper();
            p.setSize(wid, hgt);
            p.setImageableArea(0.0, 0.0, wid, hgt);
            this.pf = new PageFormat();
            this.pf.setPaper(p);
        }

        public void print() throws PrinterException {
            this.stream.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.stream.println("%%BoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
            this.stream.println("%%Title: " + this.epsTitle);
            this.stream.println("%%Creator: Java Printing");
            this.stream.println("%%CreationDate: " + new Date());
            this.stream.println("%%EndComments");
            this.stream.println("/pluginSave save def");
            this.stream.println("mark");
            this.job = new PSPrinterJob();
            this.job.epsPrinter = this;
            this.job.mPSStream = this.stream;
            this.job.mDestType = 2;
            this.job.startDoc();
            try {
                this.job.printPage(this, 0);
            }
            catch (Throwable t) {
                if (t instanceof PrinterException) {
                    throw (PrinterException)t;
                }
                throw new PrinterException(t.toString());
            }
            finally {
                this.stream.println("cleartomark");
                this.stream.println("pluginSave restore");
                this.job.endDoc();
            }
            this.stream.flush();
        }

        @Override
        public int getNumberOfPages() {
            return 1;
        }

        @Override
        public PageFormat getPageFormat(int pgIndex) {
            if (pgIndex > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.pf;
        }

        @Override
        public Printable getPrintable(int pgIndex) {
            if (pgIndex > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.printable;
        }
    }

    public static class PluginPrinter
    implements Printable {
        private EPSPrinter epsPrinter;
        private Component applet;
        private PrintStream stream;
        private String epsTitle;
        private int bx;
        private int by;
        private int bw;
        private int bh;
        private int width;
        private int height;

        public PluginPrinter(Component applet, PrintStream stream, int x, int y, int w, int h) {
            this.applet = applet;
            this.epsTitle = "Java Plugin Applet";
            this.stream = stream;
            this.bx = x;
            this.by = y;
            this.bw = w;
            this.bh = h;
            this.width = applet.size().width;
            this.height = applet.size().height;
            this.epsPrinter = new EPSPrinter(this, this.epsTitle, stream, 0, 0, this.width, this.height);
        }

        public void printPluginPSHeader() {
            this.stream.println("%%BeginDocument: JavaPluginApplet");
        }

        public void printPluginApplet() {
            try {
                this.epsPrinter.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }

        public void printPluginPSTrailer() {
            this.stream.println("%%EndDocument: JavaPluginApplet");
            this.stream.flush();
        }

        public void printAll() {
            this.printPluginPSHeader();
            this.printPluginApplet();
            this.printPluginPSTrailer();
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pgIndex) {
            if (pgIndex > 0) {
                return 1;
            }
            this.applet.printAll(g);
            return 0;
        }
    }

    private class GState {
        Color mColor;
        Shape mClip;
        Font mFont;
        AffineTransform mTransform;

        GState() {
            this.mColor = Color.black;
            this.mClip = null;
            this.mFont = null;
            this.mTransform = new AffineTransform();
        }

        GState(GState copyGState) {
            this.mColor = copyGState.mColor;
            this.mClip = copyGState.mClip;
            this.mFont = copyGState.mFont;
            this.mTransform = copyGState.mTransform;
        }

        boolean canSetClip(Shape clip) {
            return this.mClip == null || this.mClip.equals(clip);
        }

        void emitPSClip(Shape clip) {
            if (!(clip == null || this.mClip != null && this.mClip.equals(clip))) {
                String saveFillOp = PSPrinterJob.this.mFillOpStr;
                String saveClipOp = PSPrinterJob.this.mClipOpStr;
                PSPrinterJob.this.convertToPSPath(clip.getPathIterator(new AffineTransform()));
                PSPrinterJob.this.selectClipPath();
                this.mClip = clip;
                PSPrinterJob.this.mClipOpStr = saveFillOp;
                PSPrinterJob.this.mFillOpStr = saveFillOp;
            }
        }

        void emitTransform(AffineTransform transform) {
            if (transform != null && !transform.equals(this.mTransform)) {
                double[] matrix = new double[6];
                transform.getMatrix(matrix);
                PSPrinterJob.this.mPSStream.println("[" + (float)matrix[0] + " " + (float)matrix[1] + " " + (float)matrix[2] + " " + (float)matrix[3] + " " + (float)matrix[4] + " " + (float)matrix[5] + "] concat");
                this.mTransform = transform;
            }
        }

        void emitPSColor(Color color) {
            if (color != null && !color.equals(this.mColor)) {
                float[] rgb = color.getRGBColorComponents(null);
                if (rgb[0] == rgb[1] && rgb[1] == rgb[2]) {
                    PSPrinterJob.this.mPSStream.println(rgb[0] + PSPrinterJob.SETGRAY_STR);
                } else {
                    PSPrinterJob.this.mPSStream.println(rgb[0] + " " + rgb[1] + " " + rgb[2] + " " + PSPrinterJob.SETRGBCOLOR_STR);
                }
                this.mColor = color;
            }
        }

        void emitPSFont(int psFontIndex, float fontSize) {
            PSPrinterJob.this.mPSStream.println(fontSize + " " + psFontIndex + " " + PSPrinterJob.SetFontName);
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrinterException pex;

        private PrinterSpooler() {
        }

        public Object run() {
            try {
                if (PSPrinterJob.this.spoolFile == null || !PSPrinterJob.this.spoolFile.exists()) {
                    this.pex = new PrinterException("No spool file");
                    return null;
                }
                String fileName = PSPrinterJob.this.spoolFile.getAbsolutePath();
                String[] execCmd = PSPrinterJob.this.printExecCmd(PSPrinterJob.this.mDestination, PSPrinterJob.this.mOptions, PSPrinterJob.this.mNoJobSheet, PSPrinterJob.this.getJobNameInt(), 1, fileName);
                Process process = Runtime.getRuntime().exec(execCmd);
                process.waitFor();
                PSPrinterJob.this.spoolFile.delete();
            }
            catch (IOException ex) {
                this.pex = new PrinterIOException(ex);
            }
            catch (InterruptedException ie) {
                this.pex = new PrinterException(ie.toString());
            }
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrinterException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                PSPrinterJob.this.spoolFile = File.createTempFile("javaprint", ".ps", null);
                PSPrinterJob.this.spoolFile.deleteOnExit();
                this.result = new FileOutputStream(PSPrinterJob.this.spoolFile);
                return this.result;
            }
            catch (IOException ex) {
                this.pex = new PrinterIOException(ex);
                return null;
            }
        }
    }
}

