/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import sun.print.AttributeClass;
import sun.print.CustomMediaSizeName;
import sun.print.CustomMediaTray;
import sun.print.IPPPrintService;
import sun.security.action.LoadLibraryAction;

public class CUPSPrinter {
    private static final String debugPrefix = "CUPSPrinter>> ";
    private static final double PRINTER_DPI = 72.0;
    private boolean initialized;
    private MediaPrintableArea[] cupsMediaPrintables;
    private MediaSizeName[] cupsMediaSNames;
    private CustomMediaSizeName[] cupsCustomMediaSNames;
    private MediaTray[] cupsMediaTrays;
    public int nPageSizes = 0;
    public int nTrays = 0;
    private String[] media;
    private float[] pageSizes;
    private String printer;
    private static boolean libFound;
    private static String cupsServer;
    private static int cupsPort;

    private static native String getCupsServer();

    private static native int getCupsPort();

    private static native boolean canConnect(String var0, int var1);

    private static native boolean initIDs();

    private static synchronized native String[] getMedia(String var0);

    private static synchronized native float[] getPageSizes(String var0);

    CUPSPrinter(String printerName) {
        if (printerName == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = printerName;
        this.cupsMediaSNames = null;
        this.cupsMediaPrintables = null;
        this.cupsMediaTrays = null;
        this.initialized = false;
        if (!libFound) {
            throw new RuntimeException("cups lib not found");
        }
        this.media = CUPSPrinter.getMedia(this.printer);
        if (this.media == null) {
            throw new RuntimeException("error getting PPD");
        }
        this.pageSizes = CUPSPrinter.getPageSizes(this.printer);
        if (this.pageSizes != null) {
            this.nPageSizes = this.pageSizes.length / 6;
            this.nTrays = this.media.length / 2 - this.nPageSizes;
            assert (this.nTrays >= 0);
        }
    }

    public MediaSizeName[] getMediaSizeNames() {
        this.initMedia();
        return this.cupsMediaSNames;
    }

    public CustomMediaSizeName[] getCustomMediaSizeNames() {
        this.initMedia();
        return this.cupsCustomMediaSNames;
    }

    public MediaPrintableArea[] getMediaPrintableArea() {
        this.initMedia();
        return this.cupsMediaPrintables;
    }

    public MediaTray[] getMediaTrays() {
        this.initMedia();
        return this.cupsMediaTrays;
    }

    private synchronized void initMedia() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.pageSizes == null) {
            return;
        }
        this.cupsMediaPrintables = new MediaPrintableArea[this.nPageSizes];
        this.cupsMediaSNames = new MediaSizeName[this.nPageSizes];
        this.cupsCustomMediaSNames = new CustomMediaSizeName[this.nPageSizes];
        for (int i = 0; i < this.nPageSizes; ++i) {
            MediaPrintableArea mpa;
            block8: {
                float width = (float)((double)this.pageSizes[i * 6] / 72.0);
                float length = (float)((double)this.pageSizes[i * 6 + 1] / 72.0);
                float x = (float)((double)this.pageSizes[i * 6 + 2] / 72.0);
                float h = (float)((double)this.pageSizes[i * 6 + 3] / 72.0);
                float w = (float)((double)this.pageSizes[i * 6 + 4] / 72.0);
                float y = (float)((double)this.pageSizes[i * 6 + 5] / 72.0);
                CustomMediaSizeName msn = new CustomMediaSizeName(this.media[i * 2], this.media[i * 2 + 1], width, length);
                this.cupsMediaSNames[i] = msn.getStandardMedia();
                if (this.cupsMediaSNames[i] == null) {
                    this.cupsMediaSNames[i] = msn;
                    if ((double)width > 0.0 && (double)length > 0.0) {
                        new MediaSize(width, length, 25400, (MediaSizeName)msn);
                    }
                }
                this.cupsCustomMediaSNames[i] = msn;
                mpa = null;
                try {
                    mpa = new MediaPrintableArea(x, y, w, h, 25400);
                }
                catch (IllegalArgumentException e) {
                    if (!(width > 0.0f) || !(length > 0.0f)) break block8;
                    mpa = new MediaPrintableArea(0.0f, 0.0f, width, length, 25400);
                }
            }
            this.cupsMediaPrintables[i] = mpa;
        }
        this.cupsMediaTrays = new MediaTray[this.nTrays];
        for (int i = 0; i < this.nTrays; ++i) {
            CustomMediaTray mt = new CustomMediaTray(this.media[(this.nPageSizes + i) * 2], this.media[(this.nPageSizes + i) * 2 + 1]);
            this.cupsMediaTrays[i] = mt;
        }
    }

    public static String getDefaultPrinter() {
        try {
            URL url = new URL("http", CUPSPrinter.getServer(), CUPSPrinter.getPort(), "");
            final HttpURLConnection urlConnection = IPPPrintService.getIPPConnection(url);
            if (urlConnection != null) {
                OutputStream os = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return urlConnection.getOutputStream();
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                if (os == null) {
                    return null;
                }
                AttributeClass[] attCl = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("requested-attributes", 68, "printer-name")};
                if (IPPPrintService.writeIPPRequest(os, "4001", attCl)) {
                    HashMap defaultMap = null;
                    InputStream is = urlConnection.getInputStream();
                    HashMap[] responseMap = IPPPrintService.readIPPResponse(is);
                    is.close();
                    if (responseMap.length > 0) {
                        defaultMap = responseMap[0];
                    }
                    if (defaultMap == null) {
                        os.close();
                        urlConnection.disconnect();
                        return null;
                    }
                    AttributeClass attribClass = (AttributeClass)defaultMap.get("printer-name");
                    if (attribClass != null) {
                        String nameStr = attribClass.getStringValue();
                        os.close();
                        urlConnection.disconnect();
                        return nameStr;
                    }
                }
                os.close();
                urlConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String[] getAllPrinters() {
        try {
            URL url = new URL("http", CUPSPrinter.getServer(), CUPSPrinter.getPort(), "");
            final HttpURLConnection urlConnection = IPPPrintService.getIPPConnection(url);
            if (urlConnection != null) {
                OutputStream os = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return urlConnection.getOutputStream();
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                if (os == null) {
                    return null;
                }
                AttributeClass[] attCl = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("requested-attributes", 68, "printer-uri-supported")};
                if (IPPPrintService.writeIPPRequest(os, "4002", attCl)) {
                    InputStream is = urlConnection.getInputStream();
                    HashMap[] responseMap = IPPPrintService.readIPPResponse(is);
                    is.close();
                    os.close();
                    urlConnection.disconnect();
                    if (responseMap == null || responseMap.length == 0) {
                        return null;
                    }
                    ArrayList<String> printerNames = new ArrayList<String>();
                    for (int i = 0; i < responseMap.length; ++i) {
                        AttributeClass attribClass = (AttributeClass)responseMap[i].get("printer-uri-supported");
                        if (attribClass == null) continue;
                        String nameStr = attribClass.getStringValue();
                        printerNames.add(nameStr);
                    }
                    return printerNames.toArray(new String[0]);
                }
                os.close();
                urlConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getServer() {
        return cupsServer;
    }

    public static int getPort() {
        return cupsPort;
    }

    public static boolean isCupsRunning() {
        IPPPrintService.debug_println("CUPSPrinter>> libFound " + libFound);
        if (libFound) {
            IPPPrintService.debug_println("CUPSPrinter>> CUPS server " + CUPSPrinter.getServer() + " port " + CUPSPrinter.getPort());
            return CUPSPrinter.canConnect(CUPSPrinter.getServer(), CUPSPrinter.getPort());
        }
        return false;
    }

    static {
        cupsServer = null;
        cupsPort = 0;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        libFound = CUPSPrinter.initIDs();
        if (libFound) {
            cupsServer = CUPSPrinter.getCupsServer();
            cupsPort = CUPSPrinter.getCupsPort();
        }
    }
}

