/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.reflect.Modifier;

public class VerifyAccess {
    private static final int PACKAGE_ONLY = 0;
    private static final int ALL_ACCESS_MODES = 7;
    private static final boolean ALLOW_NESTMATE_ACCESS = false;

    private VerifyAccess() {
    }

    public static boolean isMemberAccessible(Class<?> refc, Class<?> defc, int mods, Class<?> lookupClass) {
        if (refc != defc) {
            if (!VerifyAccess.isClassAccessible(refc, lookupClass)) {
                return false;
            }
            if ((mods & 0xF) == 12 && !VerifyAccess.isRelatedClass(refc, lookupClass)) {
                return VerifyAccess.isSamePackage(defc, lookupClass);
            }
        }
        if (defc == lookupClass) {
            return true;
        }
        switch (mods & 7) {
            case 1: {
                if (refc != defc) {
                    return true;
                }
                return VerifyAccess.isClassAccessible(refc, lookupClass);
            }
            case 4: {
                return VerifyAccess.isSamePackage(defc, lookupClass) || VerifyAccess.isPublicSuperClass(defc, lookupClass);
            }
            case 0: {
                return VerifyAccess.isSamePackage(defc, lookupClass);
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("bad modifiers: " + Modifier.toString(mods));
    }

    static boolean isRelatedClass(Class<?> refc, Class<?> lookupClass) {
        return refc == lookupClass || refc.isAssignableFrom(lookupClass) || lookupClass.isAssignableFrom(refc);
    }

    static boolean isPublicSuperClass(Class<?> defc, Class<?> lookupClass) {
        return Modifier.isPublic(defc.getModifiers()) && defc.isAssignableFrom(lookupClass);
    }

    public static boolean isClassAccessible(Class<?> refc, Class<?> lookupClass) {
        int mods = refc.getModifiers();
        if (Modifier.isPublic(mods)) {
            return true;
        }
        return VerifyAccess.isSamePackage(lookupClass, refc);
    }

    public static boolean isSamePackage(Class<?> class1, Class<?> class2) {
        assert (!class1.isArray() && !class2.isArray());
        if (class1 == class2) {
            return true;
        }
        if (!VerifyAccess.loadersAreRelated(class1.getClassLoader(), class2.getClassLoader(), false)) {
            return false;
        }
        String name1 = class1.getName();
        String name2 = class2.getName();
        int dot = name1.lastIndexOf(46);
        if (dot != name2.lastIndexOf(46)) {
            return false;
        }
        for (int i = 0; i < dot; ++i) {
            if (name1.charAt(i) == name2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String getPackageName(Class<?> cls) {
        assert (!cls.isArray());
        String name = cls.getName();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(0, dot);
    }

    public static boolean isSamePackageMember(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return true;
        }
        if (!VerifyAccess.isSamePackage(class1, class2)) {
            return false;
        }
        return VerifyAccess.getOutermostEnclosingClass(class1) == VerifyAccess.getOutermostEnclosingClass(class2);
    }

    private static Class<?> getOutermostEnclosingClass(Class<?> c) {
        Class<?> pkgmem = c;
        Class<?> enc = c;
        while ((enc = enc.getEnclosingClass()) != null) {
            pkgmem = enc;
        }
        return pkgmem;
    }

    private static boolean loadersAreRelated(ClassLoader loader1, ClassLoader loader2, boolean loader1MustBeParent) {
        if (loader1 == loader2 || loader1 == null || loader2 == null && !loader1MustBeParent) {
            return true;
        }
        for (ClassLoader scan2 = loader2; scan2 != null; scan2 = scan2.getParent()) {
            if (scan2 != loader1) continue;
            return true;
        }
        if (loader1MustBeParent) {
            return false;
        }
        for (ClassLoader scan1 = loader1; scan1 != null; scan1 = scan1.getParent()) {
            if (scan1 != loader2) continue;
            return true;
        }
        return false;
    }

    public static boolean classLoaderIsAncestor(Class<?> parentClass, Class<?> childClass) {
        return VerifyAccess.loadersAreRelated(parentClass.getClassLoader(), childClass.getClassLoader(), true);
    }
}

