/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import sun.awt.FontConfiguration;
import sun.awt.FontDescriptor;
import sun.awt.SunToolkit;
import sun.awt.X11FontManager;
import sun.font.CompositeFontDescriptor;
import sun.font.FontConfigManager;
import sun.font.FontUtilities;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public class FcFontConfiguration
extends FontConfiguration {
    private static final String fileVersion = "1";
    private String fcInfoFileName = null;
    private FontConfigManager.FcCompFont[] fcCompFonts = null;

    public FcFontConfiguration(SunFontManager fm) {
        super(fm);
        this.init();
    }

    public FcFontConfiguration(SunFontManager fm, boolean preferLocaleFonts, boolean preferPropFonts) {
        super(fm, preferLocaleFonts, preferPropFonts);
        this.init();
    }

    @Override
    public synchronized boolean init() {
        if (this.fcCompFonts != null) {
            return true;
        }
        this.setFontConfiguration();
        this.readFcInfo();
        X11FontManager fm = (X11FontManager)this.fontManager;
        FontConfigManager fcm = fm.getFontConfigManager();
        if (this.fcCompFonts == null) {
            this.fcCompFonts = fcm.loadFontConfig();
            if (this.fcCompFonts != null) {
                try {
                    this.writeFcInfo();
                }
                catch (Exception e) {
                    if (FontUtilities.debugFonts()) {
                        FcFontConfiguration.warning("Exception writing fcInfo " + e);
                    }
                }
            } else if (FontUtilities.debugFonts()) {
                FcFontConfiguration.warning("Failed to get info from libfontconfig");
            }
        } else {
            fcm.populateFontConfig(this.fcCompFonts);
        }
        if (this.fcCompFonts == null) {
            return false;
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new Error("java.home property not set");
        }
        String javaLib = javaHome + File.separator + "lib";
        this.getInstalledFallbackFonts(javaLib);
        return true;
    }

    @Override
    public String getFallbackFamilyName(String fontName, String defaultFallback) {
        String compatibilityName = this.getCompatibilityFamilyName(fontName);
        if (compatibilityName != null) {
            return compatibilityName;
        }
        return defaultFallback;
    }

    @Override
    protected String getFaceNameFromComponentFontName(String componentFontName) {
        return null;
    }

    @Override
    protected String getFileNameFromComponentFontName(String componentFontName) {
        return null;
    }

    @Override
    public String getFileNameFromPlatformName(String platformName) {
        return null;
    }

    @Override
    protected Charset getDefaultFontCharset(String fontName) {
        return Charset.forName("ISO8859_1");
    }

    @Override
    protected String getEncoding(String awtFontName, String characterSubsetName) {
        return "default";
    }

    @Override
    protected void initReorderMap() {
        this.reorderMap = new HashMap();
    }

    @Override
    public FontDescriptor[] getFontDescriptors(String fontName, int style) {
        return new FontDescriptor[0];
    }

    @Override
    public int getNumberCoreFonts() {
        return 1;
    }

    @Override
    public String[] getPlatformFontNames() {
        HashSet<String> nameSet = new HashSet<String>();
        X11FontManager fm = (X11FontManager)this.fontManager;
        FontConfigManager fcm = fm.getFontConfigManager();
        FontConfigManager.FcCompFont[] fcCompFonts = fcm.loadFontConfig();
        for (int i = 0; i < fcCompFonts.length; ++i) {
            for (int j = 0; j < fcCompFonts[i].allFonts.length; ++j) {
                nameSet.add(fcCompFonts[i].allFonts[j].fontFile);
            }
        }
        return nameSet.toArray(new String[0]);
    }

    @Override
    public String getExtraFontPath() {
        return null;
    }

    @Override
    public boolean needToSearchForFile(String fileName) {
        return false;
    }

    private FontConfigManager.FontConfigFont[] getFcFontList(FontConfigManager.FcCompFont[] fcFonts, String fontname, int style) {
        if (fontname.equals("dialog")) {
            fontname = "sansserif";
        } else if (fontname.equals("dialoginput")) {
            fontname = "monospaced";
        }
        for (int i = 0; i < fcFonts.length; ++i) {
            if (!fontname.equals(fcFonts[i].jdkName) || style != fcFonts[i].style) continue;
            return fcFonts[i].allFonts;
        }
        return fcFonts[0].allFonts;
    }

    @Override
    public CompositeFontDescriptor[] get2DCompositeFontInfo() {
        X11FontManager fm = (X11FontManager)this.fontManager;
        FontConfigManager fcm = fm.getFontConfigManager();
        FontConfigManager.FcCompFont[] fcCompFonts = fcm.loadFontConfig();
        CompositeFontDescriptor[] result = new CompositeFontDescriptor[20];
        for (int fontIndex = 0; fontIndex < 5; ++fontIndex) {
            String fontName = publicFontNames[fontIndex];
            for (int styleIndex = 0; styleIndex < 4; ++styleIndex) {
                String faceName = fontName + "." + styleNames[styleIndex];
                FontConfigManager.FontConfigFont[] fcFonts = this.getFcFontList(fcCompFonts, fontNames[fontIndex], styleIndex);
                int numFonts = fcFonts.length;
                if (installedFallbackFontFiles != null) {
                    numFonts += installedFallbackFontFiles.length;
                }
                String[] fileNames = new String[numFonts];
                for (int index = 0; index < fcFonts.length; ++index) {
                    fileNames[index] = fcFonts[index].fontFile;
                }
                if (installedFallbackFontFiles != null) {
                    System.arraycopy(installedFallbackFontFiles, 0, fileNames, fcFonts.length, installedFallbackFontFiles.length);
                }
                result[fontIndex * 4 + styleIndex] = new CompositeFontDescriptor(faceName, 1, null, fileNames, null, null);
            }
        }
        return result;
    }

    private String getVersionString(File f) {
        try {
            Scanner sc = new Scanner(f);
            return sc.findInLine("(\\d)+((\\.)(\\d)+)*");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void setOsNameAndVersion() {
        block12: {
            super.setOsNameAndVersion();
            if (!osName.equals("Linux")) {
                return;
            }
            try {
                File f = new File("/etc/lsb-release");
                if (f.canRead()) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(f));
                    osName = props.getProperty("DISTRIB_ID");
                    osVersion = props.getProperty("DISTRIB_RELEASE");
                } else {
                    f = new File("/etc/redhat-release");
                    if (f.canRead()) {
                        osName = "RedHat";
                        osVersion = this.getVersionString(f);
                    } else {
                        f = new File("/etc/SuSE-release");
                        if (f.canRead()) {
                            osName = "SuSE";
                            osVersion = this.getVersionString(f);
                        } else {
                            f = new File("/etc/turbolinux-release");
                            if (f.canRead()) {
                                osName = "Turbo";
                                osVersion = this.getVersionString(f);
                            } else {
                                f = new File("/etc/fedora-release");
                                if (f.canRead()) {
                                    osName = "Fedora";
                                    osVersion = this.getVersionString(f);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!FontUtilities.debugFonts()) break block12;
                FcFontConfiguration.warning("Exception identifying Linux distro.");
            }
        }
    }

    private File getFcInfoFile() {
        if (this.fcInfoFileName == null) {
            String hostname;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "localhost";
            }
            String userDir = System.getProperty("user.home");
            String version = System.getProperty("java.version");
            String fs = File.separator;
            String dir = userDir + fs + ".java" + fs + "fonts" + fs + version;
            String lang = SunToolkit.getStartupLocale().getLanguage();
            String name = "fcinfo-1-" + hostname + "-" + osName + "-" + osVersion + "-" + lang + ".properties";
            this.fcInfoFileName = dir + fs + name;
        }
        return new File(this.fcInfoFileName);
    }

    private void writeFcInfo() {
        block7: {
            int i;
            Properties props = new Properties();
            props.setProperty("version", fileVersion);
            X11FontManager fm = (X11FontManager)this.fontManager;
            FontConfigManager fcm = fm.getFontConfigManager();
            FontConfigManager.FontConfigInfo fcInfo = fcm.getFontConfigInfo();
            props.setProperty("fcversion", Integer.toString(fcInfo.fcVersion));
            if (fcInfo.cacheDirs != null) {
                for (i = 0; i < fcInfo.cacheDirs.length; ++i) {
                    if (fcInfo.cacheDirs[i] == null) continue;
                    props.setProperty("cachedir." + i, fcInfo.cacheDirs[i]);
                }
            }
            for (i = 0; i < this.fcCompFonts.length; ++i) {
                FontConfigManager.FcCompFont fci = this.fcCompFonts[i];
                String styleKey = fci.jdkName + "." + fci.style;
                props.setProperty(styleKey + ".length", Integer.toString(fci.allFonts.length));
                for (int j = 0; j < fci.allFonts.length; ++j) {
                    props.setProperty(styleKey + "." + j + ".family", fci.allFonts[j].familyName);
                    props.setProperty(styleKey + "." + j + ".file", fci.allFonts[j].fontFile);
                }
            }
            try {
                File fcInfoFile = this.getFcInfoFile();
                File dir = fcInfoFile.getParentFile();
                dir.mkdirs();
                File tempFile = File.createTempFile("fcinfo", null, dir);
                FileOutputStream fos = new FileOutputStream(tempFile);
                props.store(fos, "JDK Font Configuration Generated File: *Do Not Edit*");
                fos.close();
                boolean renamed = tempFile.renameTo(fcInfoFile);
                if (!renamed && FontUtilities.debugFonts()) {
                    System.out.println("rename failed");
                    FcFontConfiguration.warning("Failed renaming file to " + this.getFcInfoFile());
                }
            }
            catch (Exception e) {
                if (!FontUtilities.debugFonts()) break block7;
                FcFontConfiguration.warning("IOException writing to " + this.getFcInfoFile());
            }
        }
    }

    private void readFcInfo() {
        block19: {
            String dir;
            File fcFile = this.getFcInfoFile();
            if (!fcFile.exists()) {
                return;
            }
            Properties props = new Properties();
            X11FontManager fm = (X11FontManager)this.fontManager;
            FontConfigManager fcm = fm.getFontConfigManager();
            try {
                FileInputStream fis = new FileInputStream(fcFile);
                props.load(fis);
                fis.close();
            }
            catch (IOException e) {
                if (FontUtilities.debugFonts()) {
                    FcFontConfiguration.warning("IOException reading from " + fcFile.toString());
                }
                return;
            }
            String version = (String)props.get("version");
            if (version == null || !version.equals(fileVersion)) {
                return;
            }
            String fcVersionStr = (String)props.get("fcversion");
            if (fcVersionStr != null) {
                try {
                    int fcVersion = Integer.parseInt(fcVersionStr);
                    if (fcVersion != 0) {
                        if (fcVersion != fcm.getFontConfigVersion()) {
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    if (FontUtilities.debugFonts()) {
                        FcFontConfiguration.warning("Exception parsing version " + fcVersionStr);
                    }
                    return;
                }
            }
            long lastModified = fcFile.lastModified();
            for (int cacheDirIndex = 0; cacheDirIndex < 4 && (dir = (String)props.get("cachedir." + cacheDirIndex)) != null; ++cacheDirIndex) {
                File dirFile = new File(dir);
                if (!dirFile.exists() || dirFile.lastModified() <= lastModified) continue;
                return;
            }
            String[] names = new String[]{"sansserif", "serif", "monospaced"};
            String[] fcnames = new String[]{"sans", "serif", "monospace"};
            int namesLen = names.length;
            int numStyles = 4;
            FontConfigManager.FcCompFont[] fci = new FontConfigManager.FcCompFont[namesLen * numStyles];
            try {
                for (int i = 0; i < namesLen; ++i) {
                    for (int s = 0; s < numStyles; ++s) {
                        int index = i * numStyles + s;
                        fci[index] = new FontConfigManager.FcCompFont();
                        String key = names[i] + "." + s;
                        fci[index].jdkName = names[i];
                        fci[index].fcFamily = fcnames[i];
                        fci[index].style = s;
                        String lenStr = (String)props.get(key + ".length");
                        int nfonts = Integer.parseInt(lenStr);
                        if (nfonts <= 0) {
                            return;
                        }
                        fci[index].allFonts = new FontConfigManager.FontConfigFont[nfonts];
                        for (int f = 0; f < nfonts; ++f) {
                            String family;
                            fci[index].allFonts[f] = new FontConfigManager.FontConfigFont();
                            String fkey = key + "." + f + ".family";
                            fci[index].allFonts[f].familyName = family = (String)props.get(fkey);
                            fkey = key + "." + f + ".file";
                            String file = (String)props.get(fkey);
                            if (file == null) {
                                return;
                            }
                            fci[index].allFonts[f].fontFile = file;
                        }
                        fci[index].firstFont = fci[index].allFonts[0];
                    }
                }
                this.fcCompFonts = fci;
            }
            catch (Throwable t) {
                if (!FontUtilities.debugFonts()) break block19;
                FcFontConfiguration.warning(t.toString());
            }
        }
    }

    private static void warning(String msg) {
        PlatformLogger logger = PlatformLogger.getLogger("sun.awt.FontConfiguration");
        logger.warning(msg);
    }
}

