/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import com.sun.java.swing.plaf.motif.MotifPasswordFieldUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.ComponentPeer;
import java.awt.peer.TextFieldPeer;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XTextTransferHelper;
import sun.awt.X11.XToolkit;
import sun.util.logging.PlatformLogger;

public class XTextFieldPeer
extends XComponentPeer
implements TextFieldPeer {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XTextField");
    String text;
    XAWTTextField xtext;
    boolean firstChangeSkipped = false;
    private static final int PADDING = 16;

    public XTextFieldPeer(TextField target) {
        super(target);
        this.text = target.getText();
        this.xtext = new XAWTTextField(this.text, this, target.getParent());
        this.xtext.getDocument().addDocumentListener(this.xtext);
        this.xtext.setCursor(target.getCursor());
        target.enableInputMethods(true);
        this.xtext.enableInputMethods(true);
        XToolkit.specialPeerMap.put(this.xtext, this);
        TextField txt = target;
        this.initTextField();
        this.setText(txt.getText());
        if (txt.echoCharIsSet()) {
            this.setEchoChar(txt.getEchoChar());
        } else {
            this.setEchoChar('\u0000');
        }
        int start = txt.getSelectionStart();
        int end = txt.getSelectionEnd();
        if (end > start) {
            this.select(start, end);
        }
        int caretPosition = Math.min(end, this.text.length());
        this.setCaretPosition(caretPosition);
        this.setEditable(txt.isEditable());
        this.firstChangeSkipped = true;
    }

    @Override
    public void dispose() {
        XToolkit.specialPeerMap.remove(this.xtext);
        this.xtext.removeNotify();
        super.dispose();
    }

    void initTextField() {
        this.setVisible(this.target.isVisible());
        this.setBounds(this.x, this.y, this.width, this.height, 3);
        AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
        this.foreground = compAccessor.getForeground(this.target);
        if (this.foreground == null) {
            this.foreground = SystemColor.textText;
        }
        this.setForeground(this.foreground);
        this.background = compAccessor.getBackground(this.target);
        if (this.background == null) {
            this.background = ((TextField)this.target).isEditable() ? SystemColor.text : SystemColor.control;
        }
        this.setBackground(this.background);
        if (!this.target.isBackgroundSet()) {
            compAccessor.setBackground(this.target, this.background);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setFont(this.font);
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.xtext != null) {
            this.xtext.setEditable(editable);
            this.xtext.repaint();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.xtext != null) {
            this.xtext.setEnabled(enabled);
            this.xtext.repaint();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.xtext != null) {
            return this.xtext.getInputMethodRequests();
        }
        return null;
    }

    @Override
    void handleJavaInputMethodEvent(InputMethodEvent e) {
        if (this.xtext != null) {
            this.xtext.processInputMethodEventImpl(e);
        }
    }

    @Override
    public void setEchoChar(char c) {
        if (this.xtext != null) {
            this.xtext.setEchoChar(c);
            this.xtext.putClientProperty("JPasswordField.cutCopyAllowed", this.xtext.echoCharIsSet() ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    @Override
    public int getSelectionStart() {
        return this.xtext.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.xtext.getSelectionEnd();
    }

    @Override
    public String getText() {
        return this.xtext.getText();
    }

    @Override
    public void setText(String txt) {
        this.setXAWTTextField(txt);
        this.repaint();
    }

    protected boolean setXAWTTextField(String txt) {
        this.text = txt;
        if (this.xtext != null) {
            this.xtext.getDocument().removeDocumentListener(this.xtext);
            this.xtext.setText(txt);
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.target, 900));
            }
            this.xtext.getDocument().addDocumentListener(this.xtext);
            this.xtext.setCaretPosition(0);
        }
        return true;
    }

    @Override
    public void setCaretPosition(int position) {
        if (this.xtext != null) {
            this.xtext.setCaretPosition(position);
        }
    }

    public void setEchoCharacter(char c) {
        this.setEchoChar(c);
    }

    void repaintText() {
        this.xtext.repaintNow();
    }

    @Override
    public void setBackground(Color c) {
        if (log.isLoggable(500)) {
            log.fine("target=" + this.target + ", old=" + this.background + ", new=" + c);
        }
        this.background = c;
        if (this.xtext != null) {
            this.xtext.setBackground(c);
            this.xtext.setSelectedTextColor(c);
        }
        this.repaintText();
    }

    @Override
    public void setForeground(Color c) {
        this.foreground = c;
        if (this.xtext != null) {
            this.xtext.setForeground(this.foreground);
            this.xtext.setSelectionColor(this.foreground);
            this.xtext.setCaretColor(this.foreground);
        }
        this.repaintText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font f) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.font = f;
            if (this.xtext != null) {
                this.xtext.setFont(this.font);
            }
        }
        this.xtext.validate();
    }

    public Dimension preferredSize(int cols) {
        return this.getPreferredSize(cols);
    }

    public void deselect() {
        int selEnd;
        int selStart = this.xtext.getSelectionStart();
        if (selStart != (selEnd = this.xtext.getSelectionEnd())) {
            this.xtext.select(selStart, selStart);
        }
    }

    @Override
    public int getCaretPosition() {
        return this.xtext.getCaretPosition();
    }

    @Override
    public void select(int s, int e) {
        this.xtext.select(s, e);
        this.xtext.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.xtext.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.xtext.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize(int cols) {
        return this.getMinimumSize(cols);
    }

    @Override
    public Dimension getMinimumSize(int cols) {
        Font f = this.xtext.getFont();
        FontMetrics fm = this.xtext.getFontMetrics(f);
        return new Dimension(fm.charWidth('0') * cols + 10, fm.getMaxDescent() + fm.getMaxAscent() + 16);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void action(long when, int modifiers) {
        this.postEvent(new ActionEvent(this.target, 1001, this.text, when, modifiers));
    }

    protected void disposeImpl() {
    }

    @Override
    public void repaint() {
        if (this.xtext != null) {
            this.xtext.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.xtext != null) {
            this.xtext.paint(g);
        }
    }

    @Override
    public void print(Graphics g) {
        if (this.xtext != null) {
            this.xtext.print(g);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.xtext.forwardFocusLost(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.xtext.forwardFocusGained(e);
    }

    @Override
    void handleJavaKeyEvent(KeyEvent e) {
        AWTAccessor.getComponentAccessor().processEvent(this.xtext, e);
    }

    @Override
    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        if (this.xtext != null) {
            mouseEvent.setSource(this.xtext);
            int id = mouseEvent.getID();
            if (id == 506 || id == 503) {
                this.xtext.processMouseMotionEventImpl(mouseEvent);
            } else {
                this.xtext.processMouseEventImpl(mouseEvent);
            }
        }
    }

    @Override
    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int cols) {
        return this.getMinimumSize(cols);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.xtext != null) {
            this.xtext.setVisible(b);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        super.setBounds(x, y, width, height, op);
        if (this.xtext != null) {
            int childX = x;
            int childY = y;
            Container parent = this.target.getParent();
            while (parent.isLightweight()) {
                childX -= parent.getX();
                childY -= parent.getY();
                parent = parent.getParent();
            }
            this.xtext.setBounds(childX, childY, width, height);
            this.xtext.validate();
        }
    }

    public int getIndexAtPoint(int x, int y) {
        return -1;
    }

    public Rectangle getCharacterBounds(int i) {
        return null;
    }

    public long filterEvents(long mask) {
        return 0L;
    }

    class XAWTTextField
    extends JPasswordField
    implements ActionListener,
    DocumentListener {
        boolean isFocused;
        XComponentPeer peer;

        public XAWTTextField(String text, XComponentPeer peer, Container parent) {
            super(text);
            this.isFocused = false;
            this.peer = peer;
            this.setDoubleBuffered(true);
            this.setFocusable(false);
            AWTAccessor.getComponentAccessor().setParent(this, parent);
            this.setBackground(peer.getPeerBackground());
            this.setForeground(peer.getPeerForeground());
            this.setFont(peer.getPeerFont());
            this.setCaretPosition(0);
            this.addActionListener(this);
            this.addNotify();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.peer.postEvent(new ActionEvent(this.peer.target, 1001, this.getText(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public ComponentPeer getPeer() {
            return this.peer;
        }

        public void repaintNow() {
            this.paintImmediately(this.getBounds());
        }

        @Override
        public Graphics getGraphics() {
            return this.peer.getGraphics();
        }

        @Override
        public void updateUI() {
            AWTTextFieldUI ui = new AWTTextFieldUI();
            this.setUI((ComponentUI)ui);
        }

        void forwardFocusGained(FocusEvent e) {
            this.isFocused = true;
            FocusEvent fe = CausedFocusEvent.retarget(e, this);
            super.processFocusEvent(fe);
        }

        void forwardFocusLost(FocusEvent e) {
            this.isFocused = false;
            FocusEvent fe = CausedFocusEvent.retarget(e, this);
            super.processFocusEvent(fe);
        }

        @Override
        public boolean hasFocus() {
            return this.isFocused;
        }

        public void processInputMethodEventImpl(InputMethodEvent e) {
            this.processInputMethodEvent(e);
        }

        public void processMouseEventImpl(MouseEvent e) {
            this.processMouseEvent(e);
        }

        public void processMouseMotionEventImpl(MouseEvent e) {
            this.processMouseMotionEvent(e);
        }

        @Override
        public void setTransferHandler(TransferHandler newHandler) {
            TransferHandler oldHandler = (TransferHandler)this.getClientProperty(XTextTransferHelper.getTransferHandlerKey());
            this.putClientProperty(XTextTransferHelper.getTransferHandlerKey(), newHandler);
            this.firePropertyChange("transferHandler", oldHandler, newHandler);
        }

        @Override
        public void setEchoChar(char c) {
            super.setEchoChar(c);
            ((AWTTextFieldUI)this.ui).installKeyboardActions();
        }
    }

    class XAWTCaret
    extends DefaultCaret {
        XAWTCaret() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            this.getComponent().repaint();
        }

        @Override
        public void setSelectionVisible(boolean vis) {
            if (vis) {
                super.setSelectionVisible(vis);
            } else {
                this.setDot(this.getDot());
            }
        }
    }

    class AWTTextFieldUI
    extends MotifPasswordFieldUI {
        JTextField jtf;

        AWTTextFieldUI() {
        }

        @Override
        protected String getPropertyPrefix() {
            JTextComponent comp = this.getComponent();
            if (comp instanceof JPasswordField && ((JPasswordField)comp).echoCharIsSet()) {
                return "PasswordField";
            }
            return "TextField";
        }

        @Override
        public void installUI(JComponent c) {
            Insets margin;
            Border b;
            Color dfg;
            Color sfg;
            Color s;
            Color color;
            Color fg;
            Color bg;
            super.installUI(c);
            JTextField editor = this.jtf = (JTextField)c;
            UIDefaults uidefaults = XToolkit.getUIDefaults();
            String prefix = this.getPropertyPrefix();
            Font f = editor.getFont();
            if (f == null || f instanceof UIResource) {
                editor.setFont(uidefaults.getFont(prefix + ".font"));
            }
            if ((bg = editor.getBackground()) == null || bg instanceof UIResource) {
                editor.setBackground(uidefaults.getColor(prefix + ".background"));
            }
            if ((fg = editor.getForeground()) == null || fg instanceof UIResource) {
                editor.setForeground(uidefaults.getColor(prefix + ".foreground"));
            }
            if ((color = editor.getCaretColor()) == null || color instanceof UIResource) {
                editor.setCaretColor(uidefaults.getColor(prefix + ".caretForeground"));
            }
            if ((s = editor.getSelectionColor()) == null || s instanceof UIResource) {
                editor.setSelectionColor(uidefaults.getColor(prefix + ".selectionBackground"));
            }
            if ((sfg = editor.getSelectedTextColor()) == null || sfg instanceof UIResource) {
                editor.setSelectedTextColor(uidefaults.getColor(prefix + ".selectionForeground"));
            }
            if ((dfg = editor.getDisabledTextColor()) == null || dfg instanceof UIResource) {
                editor.setDisabledTextColor(uidefaults.getColor(prefix + ".inactiveForeground"));
            }
            if ((b = editor.getBorder()) == null || b instanceof UIResource) {
                editor.setBorder(uidefaults.getBorder(prefix + ".border"));
            }
            if ((margin = editor.getMargin()) == null || margin instanceof UIResource) {
                editor.setMargin(uidefaults.getInsets(prefix + ".margin"));
            }
        }

        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            JTextComponent comp = this.getComponent();
            UIDefaults uidefaults = XToolkit.getUIDefaults();
            String prefix = this.getPropertyPrefix();
            InputMap map = (InputMap)uidefaults.get(prefix + ".focusInputMap");
            if (map != null) {
                SwingUtilities.replaceUIInputMap(comp, 0, map);
            }
        }

        @Override
        protected Caret createCaret() {
            return new XAWTCaret();
        }
    }
}

