/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.List;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;

class XDialogPeer
extends XDecoratedPeer
implements DialogPeer {
    private Boolean undecorated;

    XDialogPeer(Dialog target) {
        super(target);
    }

    @Override
    public void preInit(XCreateWindowParams params) {
        super.preInit(params);
        Dialog target = (Dialog)this.target;
        this.undecorated = target.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !target.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.functions = 1;
        this.winAttr.isResizable = true;
        this.winAttr.initialResizability = target.isResizable();
        this.winAttr.title = target.getTitle();
        this.winAttr.initialState = XWindowAttributesData.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean vis) {
        XToolkit.awtLock();
        try {
            Dialog target = (Dialog)this.target;
            if (vis) {
                if (target.getModalityType() != Dialog.ModalityType.MODELESS && !this.isModalBlocked()) {
                    XBaseWindow.ungrabInput();
                }
            } else {
                XDialogPeer.restoreTransientFor(this);
                this.prevTransientFor = null;
                this.nextTransientFor = null;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        super.setVisible(vis);
    }

    @Override
    boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Dialog)this.target).isUndecorated();
    }

    @Override
    int getDecorations() {
        int d = super.getDecorations();
        d = (d & 1) != 0 ? (d |= 0x60) : (d &= 0xFFFFFF9F);
        return d;
    }

    @Override
    int getFunctions() {
        int f = super.getFunctions();
        f = (f & 1) != 0 ? (f |= 0x18) : (f &= 0xFFFFFFE7);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockWindows(List<Window> toBlock) {
        Vector<XWindowPeer> javaToplevels = null;
        XToolkit.awtLock();
        try {
            javaToplevels = XWindowPeer.collectJavaToplevels();
            for (Window w : toBlock) {
                XWindowPeer wp = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
                if (wp == null) continue;
                wp.setModalBlocked((Dialog)this.target, true, javaToplevels);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isFocusedWindowModalBlocker() {
        Window focusedWindow = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        XWindowPeer focusedWindowPeer = null;
        focusedWindowPeer = focusedWindow != null ? (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(focusedWindow) : XDialogPeer.getNativeFocusedWindowPeer();
        Object object = this.getStateLock();
        synchronized (object) {
            if (focusedWindowPeer != null && focusedWindowPeer.modalBlocker == this.target) {
                return true;
            }
        }
        return super.isFocusedWindowModalBlocker();
    }
}

