/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ButtonPeer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;

public class XButtonPeer
extends XComponentPeer
implements ButtonPeer {
    boolean pressed = false;
    boolean armed = false;
    private Insets focusInsets;
    private Insets borderInsets;
    private Insets contentAreaInsets;
    private static final String propertyPrefix = "Button.";
    protected Color focusColor = SystemColor.windowText;
    private boolean disposed = false;
    String label;

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        this.borderInsets = new Insets(2, 2, 2, 2);
        this.focusInsets = new Insets(0, 0, 0, 0);
        this.contentAreaInsets = new Insets(3, 3, 3, 3);
    }

    public XButtonPeer(Button target) {
        super(target);
        this.label = target.getLabel();
        this.updateMotifColors(this.getPeerBackground());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Component component = this.target;
        synchronized (component) {
            this.disposed = true;
        }
        super.dispose();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.target);
    }

    @Override
    public void setBackground(Color c) {
        this.updateMotifColors(c);
        super.setBackground(c);
    }

    @Override
    void handleJavaMouseEvent(MouseEvent e) {
        super.handleJavaMouseEvent(e);
        int id = e.getID();
        switch (id) {
            case 501: {
                Button b;
                if (!XToolkit.isLeftMouseButton(e) || !(b = (Button)e.getSource()).contains(e.getX(), e.getY())) break;
                if (!this.isEnabled()) {
                    return;
                }
                this.pressed = true;
                this.armed = true;
                this.repaint();
                break;
            }
            case 502: {
                if (!XToolkit.isLeftMouseButton(e)) break;
                if (this.armed) {
                    this.action(e.getWhen(), e.getModifiers());
                }
                this.pressed = false;
                this.armed = false;
                this.repaint();
                break;
            }
            case 504: {
                if (!this.pressed) break;
                this.armed = true;
                break;
            }
            case 505: {
                this.armed = false;
            }
        }
    }

    public void action(long when, int modifiers) {
        this.postEvent(new ActionEvent(this.target, 1001, ((Button)this.target).getActionCommand(), when, modifiers));
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.repaint();
    }

    @Override
    void handleJavaKeyEvent(KeyEvent e) {
        int id = e.getID();
        switch (id) {
            case 401: {
                if (e.getKeyCode() != 32) break;
                this.pressed = true;
                this.armed = true;
                this.repaint();
                this.action(e.getWhen(), e.getModifiers());
                break;
            }
            case 402: {
                if (e.getKeyCode() != 32) break;
                this.pressed = false;
                this.armed = false;
                this.repaint();
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(this.getPeerFont());
        if (this.label == null) {
            this.label = "";
        }
        return new Dimension(fm.stringWidth(this.label) + 14, fm.getHeight() + 8);
    }

    @Override
    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics g, Component c) {
        if (!this.disposed && g != null) {
            Dimension size = this.getPeerSize();
            g.setColor(this.getPeerBackground());
            g.fillRect(0, 0, size.width, size.height);
            this.paintBorder(g, this.borderInsets.left, this.borderInsets.top, size.width - (this.borderInsets.left + this.borderInsets.right), size.height - (this.borderInsets.top + this.borderInsets.bottom));
            FontMetrics fm = g.getFontMetrics();
            Rectangle textRect = new Rectangle();
            Rectangle viewRect = new Rectangle();
            Rectangle iconRect = new Rectangle();
            viewRect.width = size.width - (this.contentAreaInsets.left + this.contentAreaInsets.right);
            viewRect.height = size.height - (this.contentAreaInsets.top + this.contentAreaInsets.bottom);
            viewRect.x = this.contentAreaInsets.left;
            viewRect.y = this.contentAreaInsets.right;
            String llabel = this.label != null ? this.label : "";
            String text = SwingUtilities.layoutCompoundLabel(fm, llabel, null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
            Font f = this.getPeerFont();
            g.setFont(f);
            if (this.pressed && this.armed) {
                this.paintButtonPressed(g, this.target);
            }
            this.paintText(g, this.target, textRect, text);
            if (this.hasFocus()) {
                this.paintFocus(g, this.focusInsets.left, this.focusInsets.top, size.width - (this.focusInsets.left + this.focusInsets.right) - 1, size.height - (this.focusInsets.top + this.focusInsets.bottom) - 1);
            }
        }
        this.flush();
    }

    public void paintBorder(Graphics g, int x, int y, int w, int h) {
        this.drawMotif3DRect(g, x, y, w - 1, h - 1, this.pressed);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.target.repaint();
    }

    protected void paintFocus(Graphics g, int x, int y, int w, int h) {
        g.setColor(this.focusColor);
        g.drawRect(x, y, w, h);
    }

    protected void paintButtonPressed(Graphics g, Component b) {
        Dimension size = this.getPeerSize();
        g.setColor(this.selectColor);
        g.fillRect(this.contentAreaInsets.left, this.contentAreaInsets.top, size.width - (this.contentAreaInsets.left + this.contentAreaInsets.right), size.height - (this.contentAreaInsets.top + this.contentAreaInsets.bottom));
    }

    protected void paintText(Graphics g, Component c, Rectangle textRect, String text) {
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = -1;
        if (this.isEnabled()) {
            g.setColor(this.getPeerForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(this.getPeerBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(c.getBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }
}

