/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.geom.Point2D;
import java.awt.peer.ComponentPeer;
import java.io.File;
import java.security.AccessControlContext;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.RequestFocusController;
import sun.misc.Unsafe;

public final class AWTAccessor {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static ComponentAccessor componentAccessor;
    private static ContainerAccessor containerAccessor;
    private static WindowAccessor windowAccessor;
    private static AWTEventAccessor awtEventAccessor;
    private static InputEventAccessor inputEventAccessor;
    private static FrameAccessor frameAccessor;
    private static KeyboardFocusManagerAccessor kfmAccessor;
    private static MenuComponentAccessor menuComponentAccessor;
    private static EventQueueAccessor eventQueueAccessor;
    private static PopupMenuAccessor popupMenuAccessor;
    private static FileDialogAccessor fileDialogAccessor;

    private AWTAccessor() {
    }

    public static void setComponentAccessor(ComponentAccessor ca) {
        componentAccessor = ca;
    }

    public static ComponentAccessor getComponentAccessor() {
        if (componentAccessor == null) {
            unsafe.ensureClassInitialized(Component.class);
        }
        return componentAccessor;
    }

    public static void setContainerAccessor(ContainerAccessor ca) {
        containerAccessor = ca;
    }

    public static ContainerAccessor getContainerAccessor() {
        if (containerAccessor == null) {
            unsafe.ensureClassInitialized(Container.class);
        }
        return containerAccessor;
    }

    public static void setWindowAccessor(WindowAccessor wa) {
        windowAccessor = wa;
    }

    public static WindowAccessor getWindowAccessor() {
        if (windowAccessor == null) {
            unsafe.ensureClassInitialized(Window.class);
        }
        return windowAccessor;
    }

    public static void setAWTEventAccessor(AWTEventAccessor aea) {
        awtEventAccessor = aea;
    }

    public static AWTEventAccessor getAWTEventAccessor() {
        if (awtEventAccessor == null) {
            unsafe.ensureClassInitialized(AWTEvent.class);
        }
        return awtEventAccessor;
    }

    public static void setInputEventAccessor(InputEventAccessor iea) {
        inputEventAccessor = iea;
    }

    public static InputEventAccessor getInputEventAccessor() {
        if (inputEventAccessor == null) {
            unsafe.ensureClassInitialized(InputEvent.class);
        }
        return inputEventAccessor;
    }

    public static void setFrameAccessor(FrameAccessor fa) {
        frameAccessor = fa;
    }

    public static FrameAccessor getFrameAccessor() {
        if (frameAccessor == null) {
            unsafe.ensureClassInitialized(Frame.class);
        }
        return frameAccessor;
    }

    public static void setKeyboardFocusManagerAccessor(KeyboardFocusManagerAccessor kfma) {
        kfmAccessor = kfma;
    }

    public static KeyboardFocusManagerAccessor getKeyboardFocusManagerAccessor() {
        if (kfmAccessor == null) {
            unsafe.ensureClassInitialized(KeyboardFocusManager.class);
        }
        return kfmAccessor;
    }

    public static void setMenuComponentAccessor(MenuComponentAccessor mca) {
        menuComponentAccessor = mca;
    }

    public static MenuComponentAccessor getMenuComponentAccessor() {
        if (menuComponentAccessor == null) {
            unsafe.ensureClassInitialized(MenuComponent.class);
        }
        return menuComponentAccessor;
    }

    public static void setEventQueueAccessor(EventQueueAccessor eqa) {
        eventQueueAccessor = eqa;
    }

    public static EventQueueAccessor getEventQueueAccessor() {
        if (eventQueueAccessor == null) {
            unsafe.ensureClassInitialized(EventQueue.class);
        }
        return eventQueueAccessor;
    }

    public static void setPopupMenuAccessor(PopupMenuAccessor pma) {
        popupMenuAccessor = pma;
    }

    public static PopupMenuAccessor getPopupMenuAccessor() {
        if (popupMenuAccessor == null) {
            unsafe.ensureClassInitialized(PopupMenu.class);
        }
        return popupMenuAccessor;
    }

    public static void setFileDialogAccessor(FileDialogAccessor fda) {
        fileDialogAccessor = fda;
    }

    public static FileDialogAccessor getFileDialogAccessor() {
        if (fileDialogAccessor == null) {
            unsafe.ensureClassInitialized(FileDialog.class);
        }
        return fileDialogAccessor;
    }

    public static interface FileDialogAccessor {
        public void setFiles(FileDialog var1, File[] var2);

        public void setFile(FileDialog var1, String var2);

        public void setDirectory(FileDialog var1, String var2);

        public boolean isMultipleMode(FileDialog var1);
    }

    public static interface PopupMenuAccessor {
        public boolean isTrayIconPopup(PopupMenu var1);
    }

    public static interface EventQueueAccessor {
        public Thread getDispatchThread(EventQueue var1);

        public boolean isDispatchThreadImpl(EventQueue var1);
    }

    public static interface MenuComponentAccessor {
        public AppContext getAppContext(MenuComponent var1);

        public void setAppContext(MenuComponent var1, AppContext var2);

        public MenuContainer getParent(MenuComponent var1);
    }

    public static interface KeyboardFocusManagerAccessor {
        public int shouldNativelyFocusHeavyweight(Component var1, Component var2, boolean var3, boolean var4, long var5, CausedFocusEvent.Cause var7);

        public boolean processSynchronousLightweightTransfer(Component var1, Component var2, boolean var3, boolean var4, long var5);

        public void removeLastFocusRequest(Component var1);

        public void setMostRecentFocusOwner(Window var1, Component var2);

        public KeyboardFocusManager getCurrentKeyboardFocusManager(AppContext var1);
    }

    public static interface FrameAccessor {
        public void setExtendedState(Frame var1, int var2);

        public int getExtendedState(Frame var1);

        public Rectangle getMaximizedBounds(Frame var1);
    }

    public static interface InputEventAccessor {
        public int[] getButtonDownMasks();
    }

    public static interface AWTEventAccessor {
        public void setPosted(AWTEvent var1);

        public void setSystemGenerated(AWTEvent var1);

        public boolean isSystemGenerated(AWTEvent var1);

        public AccessControlContext getAccessControlContext(AWTEvent var1);
    }

    public static interface WindowAccessor {
        public float getOpacity(Window var1);

        public void setOpacity(Window var1, float var2);

        public Shape getShape(Window var1);

        public void setShape(Window var1, Shape var2);

        public void setOpaque(Window var1, boolean var2);

        public void updateWindow(Window var1);

        public Dimension getSecurityWarningSize(Window var1);

        public void setSecurityWarningSize(Window var1, int var2, int var3);

        public void setSecurityWarningPosition(Window var1, Point2D var2, float var3, float var4);

        public Point2D calculateSecurityWarningPosition(Window var1, double var2, double var4, double var6, double var8);

        public void setLWRequestStatus(Window var1, boolean var2);

        public boolean isAutoRequestFocus(Window var1);

        public boolean isTrayIconWindow(Window var1);

        public void setTrayIconWindow(Window var1, boolean var2);
    }

    public static interface ContainerAccessor {
        public void validateUnconditionally(Container var1);
    }

    public static interface ComponentAccessor {
        public void setBackgroundEraseDisabled(Component var1, boolean var2);

        public boolean getBackgroundEraseDisabled(Component var1);

        public Rectangle getBounds(Component var1);

        public void setMixingCutoutShape(Component var1, Shape var2);

        public void setGraphicsConfiguration(Component var1, GraphicsConfiguration var2);

        public boolean requestFocus(Component var1, CausedFocusEvent.Cause var2);

        public boolean canBeFocusOwner(Component var1);

        public boolean isVisible(Component var1);

        public void setRequestFocusController(RequestFocusController var1);

        public AppContext getAppContext(Component var1);

        public void setAppContext(Component var1, AppContext var2);

        public Container getParent(Component var1);

        public void setParent(Component var1, Container var2);

        public void setSize(Component var1, int var2, int var3);

        public Point getLocation(Component var1);

        public void setLocation(Component var1, int var2, int var3);

        public boolean isEnabled(Component var1);

        public boolean isDisplayable(Component var1);

        public Cursor getCursor(Component var1);

        public ComponentPeer getPeer(Component var1);

        public void setPeer(Component var1, ComponentPeer var2);

        public boolean isLightweight(Component var1);

        public boolean getIgnoreRepaint(Component var1);

        public int getWidth(Component var1);

        public int getHeight(Component var1);

        public int getX(Component var1);

        public int getY(Component var1);

        public Color getForeground(Component var1);

        public Color getBackground(Component var1);

        public void setBackground(Component var1, Color var2);

        public Font getFont(Component var1);

        public void processEvent(Component var1, AWTEvent var2);

        public AccessControlContext getAccessControlContext(Component var1);
    }
}

