/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> tclass, Class<W> vclass, String fieldName) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(tclass, vclass, fieldName);
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T obj, V newValue) {
        V current;
        while (!this.compareAndSet(obj, current = this.get(obj), newValue)) {
        }
        return current;
    }

    private static final class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<V> vclass;
        private final Class cclass;

        AtomicReferenceFieldUpdaterImpl(Class<T> tclass, Class<V> vclass, String fieldName) {
            Field field = null;
            Class<?> fieldClass = null;
            Class caller = null;
            int modifiers = 0;
            try {
                field = tclass.getDeclaredField(fieldName);
                caller = Reflection.getCallerClass(3);
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ReflectUtil.checkPackageAccess(tclass);
                fieldClass = field.getType();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (vclass != fieldClass) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.vclass = vclass == Object.class ? null : vclass;
            this.offset = unsafe.objectFieldOffset(field);
        }

        void targetCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        void updateCheck(T obj, V update) {
            if (!this.tclass.isInstance(obj) || update != null && this.vclass != null && !this.vclass.isInstance(update)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        @Override
        public boolean compareAndSet(T obj, V expect, V update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || update != null && this.vclass != null && this.vclass != update.getClass()) {
                this.updateCheck(obj, update);
            }
            return unsafe.compareAndSwapObject(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, V expect, V update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || update != null && this.vclass != null && this.vclass != update.getClass()) {
                this.updateCheck(obj, update);
            }
            return unsafe.compareAndSwapObject(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, V newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || newValue != null && this.vclass != null && this.vclass != newValue.getClass()) {
                this.updateCheck(obj, newValue);
            }
            unsafe.putObjectVolatile(obj, this.offset, newValue);
        }

        @Override
        public void lazySet(T obj, V newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || newValue != null && this.vclass != null && this.vclass != newValue.getClass()) {
                this.updateCheck(obj, newValue);
            }
            unsafe.putOrderedObject(obj, this.offset, newValue);
        }

        @Override
        public V get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.targetCheck(obj);
            }
            return (V)unsafe.getObjectVolatile(obj, this.offset);
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }
}

