/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue;
    private static Finalizer unfinalized;
    private static Object lock;
    private Finalizer next = null;
    private Finalizer prev = null;

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    private Finalizer(Object finalizee) {
        super(finalizee, queue);
        this.add();
    }

    static void register(Object finalizee) {
        new Finalizer(finalizee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer() {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            Object finalizee = this.get();
            if (finalizee != null && !(finalizee instanceof Enum)) {
                Finalizer.invokeFinalizeMethod(finalizee);
                finalizee = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable proc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                Thread sft = new Thread(tg, proc, "Secondary finalizer");
                sft.start();
                try {
                    sft.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            @Override
            public void run() {
                Finalizer f;
                while ((f = (Finalizer)queue.poll()) != null) {
                    f.runFinalizer();
                }
            }
        });
    }

    static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Finalizer f;
                    Object object = lock;
                    synchronized (object) {
                        f = unfinalized;
                        if (f == null) {
                            break;
                        }
                        unfinalized = f.next;
                    }
                    f.runFinalizer();
                }
            }
        });
    }

    static {
        ThreadGroup tg;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        FinalizerThread finalizer = new FinalizerThread(tg);
        finalizer.setPriority(8);
        finalizer.setDaemon(true);
        finalizer.start();
    }

    private static class FinalizerThread
    extends Thread {
        FinalizerThread(ThreadGroup g) {
            super(g, "Finalizer");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Finalizer f = (Finalizer)queue.remove();
                        f.runFinalizer();
                    }
                }
                catch (InterruptedException x) {
                    continue;
                }
                break;
            }
        }
    }
}

