/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.List;
import sun.invoke.util.ValueConversions;

public abstract class MethodHandle {
    private byte vmentry;
    Object vmtarget;
    static final int INT_FIELD = 0;
    static final long LONG_FIELD = 0L;
    private MethodType type;

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType type) {
        type.getClass();
        this.type = type;
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    public Object invokeWithArguments(Object ... arguments) throws Throwable {
        int argc = arguments == null ? 0 : arguments.length;
        MethodType type = this.type();
        if (type.parameterCount() != argc || this.isVarargsCollector()) {
            return this.asType(MethodType.genericMethodType(argc)).invokeWithArguments(arguments);
        }
        MethodHandle invoker = type.invokers().varargsInvoker();
        return invoker.invokeExact(this, arguments);
    }

    public Object invokeWithArguments(List<?> arguments) throws Throwable {
        return this.invokeWithArguments(arguments.toArray());
    }

    public MethodHandle asType(MethodType newType) {
        if (!this.type.isConvertibleTo(newType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + newType);
        }
        return MethodHandleImpl.convertArguments(this, newType, 1);
    }

    public MethodHandle asSpreader(Class<?> arrayType, int arrayLength) {
        this.asSpreaderChecks(arrayType, arrayLength);
        return MethodHandleImpl.spreadArguments(this, arrayType, arrayLength);
    }

    private void asSpreaderChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs < arrayLength || arrayLength < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        if (arrayType != Object[].class && arrayLength != 0) {
            boolean sawProblem = false;
            Class<?> arrayElement = arrayType.getComponentType();
            for (int i = nargs - arrayLength; i < nargs; ++i) {
                if (MethodType.canConvert(arrayElement, this.type().parameterType(i))) continue;
                sawProblem = true;
                break;
            }
            if (sawProblem) {
                ArrayList ptypes = new ArrayList(this.type().parameterList());
                for (int i = nargs - arrayLength; i < nargs; ++i) {
                    ptypes.set(i, arrayElement);
                }
                this.asType(MethodType.methodType(this.type().returnType(), ptypes));
            }
        }
    }

    private void spreadArrayChecks(Class<?> arrayType, int arrayLength) {
        Class<?> arrayElement = arrayType.getComponentType();
        if (arrayElement == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", arrayType);
        }
        if ((arrayLength & 0x7F) != arrayLength) {
            if ((arrayLength & 0xFF) != arrayLength) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", arrayLength);
            }
            assert (arrayLength >= 128);
            if (arrayElement == Long.TYPE || arrayElement == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", arrayLength);
            }
        }
    }

    public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
        this.asCollectorChecks(arrayType, arrayLength);
        MethodHandle collector = ValueConversions.varargsArray(arrayType, arrayLength);
        return MethodHandleImpl.collectArguments(this, this.type.parameterCount() - 1, collector);
    }

    private boolean asCollectorChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs != 0) {
            Class<?> lastParam = this.type().parameterType(nargs - 1);
            if (lastParam == arrayType) {
                return true;
            }
            if (lastParam.isAssignableFrom(arrayType)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, arrayType);
    }

    public MethodHandle asVarargsCollector(Class<?> arrayType) {
        Class<?> arrayElement = arrayType.getComponentType();
        boolean lastMatch = this.asCollectorChecks(arrayType, 0);
        if (this.isVarargsCollector() && lastMatch) {
            return this;
        }
        return AdapterMethodHandle.makeVarargsCollector(this, arrayType);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object x) {
        Class<?> ptype;
        if (this.type().parameterCount() == 0 || (ptype = this.type().parameterType(0)).isPrimitive()) {
            throw MethodHandleStatics.newIllegalArgumentException("no leading reference parameter", x);
        }
        MethodHandle bmh = MethodHandleImpl.bindReceiver(this, x = MethodHandles.checkValue(ptype, x));
        if (bmh != null) {
            return bmh;
        }
        return MethodHandleImpl.bindArgument(this, 0, x);
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return this.debugString();
        }
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return MethodHandleStatics.getNameString(this);
    }

    static {
        MethodHandleImpl.initStatics();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

