/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private final char[] value;
    private final int offset;
    private final int count;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public String() {
        this.offset = 0;
        this.count = 0;
        this.value = new char[0];
    }

    public String(String original) {
        char[] v;
        int size = original.count;
        char[] originalValue = original.value;
        if (originalValue.length > size) {
            int off = original.offset;
            v = Arrays.copyOfRange(originalValue, off, off + size);
        } else {
            v = originalValue;
        }
        this.offset = 0;
        this.count = size;
        this.value = v;
    }

    public String(char[] value) {
        int size = value.length;
        this.offset = 0;
        this.count = size;
        this.value = Arrays.copyOf(value, size);
    }

    public String(char[] value, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > value.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        this.offset = 0;
        this.count = count;
        this.value = Arrays.copyOfRange(value, offset, offset + count);
    }

    public String(int[] codePoints, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > codePoints.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        int end = offset + count;
        int n = count;
        for (int i = offset; i < end; ++i) {
            int c = codePoints[i];
            if (Character.isBmpCodePoint(c)) continue;
            if (Character.isValidCodePoint(c)) {
                ++n;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(c));
        }
        char[] v = new char[n];
        int i = offset;
        int j = 0;
        while (i < end) {
            int c = codePoints[i];
            if (Character.isBmpCodePoint(c)) {
                v[j] = (char)c;
            } else {
                Character.toSurrogates(c, v, j++);
            }
            ++i;
            ++j;
        }
        this.value = v;
        this.count = n;
        this.offset = 0;
    }

    @Deprecated
    public String(byte[] ascii, int hibyte, int offset, int count) {
        String.checkBounds(ascii, offset, count);
        char[] value = new char[count];
        if (hibyte == 0) {
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(ascii[i + offset] & 0xFF);
            }
        } else {
            hibyte <<= 8;
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(hibyte | ascii[i + offset] & 0xFF);
            }
        }
        this.offset = 0;
        this.count = count;
        this.value = value;
    }

    @Deprecated
    public String(byte[] ascii, int hibyte) {
        this(ascii, hibyte, 0, ascii.length);
    }

    private static void checkBounds(byte[] bytes, int offset, int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (offset > bytes.length - length) {
            throw new StringIndexOutOfBoundsException(offset + length);
        }
    }

    public String(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBounds(bytes, offset, length);
        char[] v = StringCoding.decode(charsetName, bytes, offset, length);
        this.offset = 0;
        this.count = v.length;
        this.value = v;
    }

    public String(byte[] bytes, int offset, int length, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBounds(bytes, offset, length);
        char[] v = StringCoding.decode(charset, bytes, offset, length);
        this.offset = 0;
        this.count = v.length;
        this.value = v;
    }

    public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, charsetName);
    }

    public String(byte[] bytes, Charset charset) {
        this(bytes, 0, bytes.length, charset);
    }

    public String(byte[] bytes, int offset, int length) {
        String.checkBounds(bytes, offset, length);
        char[] v = StringCoding.decode(bytes, offset, length);
        this.offset = 0;
        this.count = v.length;
        this.value = v;
    }

    public String(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public String(StringBuffer buffer) {
        String result = buffer.toString();
        this.value = result.value;
        this.count = result.count;
        this.offset = result.offset;
    }

    public String(StringBuilder builder) {
        String result = builder.toString();
        this.value = result.value;
        this.count = result.count;
        this.offset = result.offset;
    }

    String(int offset, int count, char[] value) {
        this.value = value;
        this.offset = offset;
        this.count = count;
    }

    @Override
    public int length() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index + this.offset];
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAtImpl(this.value, this.offset + index, this.offset + this.count);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBeforeImpl(this.value, this.offset + index, this.offset);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, this.offset + beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, this.offset, this.count, this.offset + index, codePointOffset) - this.offset;
    }

    void getChars(char[] dst, int dstBegin) {
        System.arraycopy(this.value, this.offset, dst, dstBegin, this.count);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        System.arraycopy(this.value, this.offset + srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @Deprecated
    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = dstBegin;
        int n = this.offset + srcEnd;
        int i = this.offset + srcBegin;
        char[] val = this.value;
        while (i < n) {
            dst[j++] = (byte)val[i++];
        }
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charsetName, this.value, this.offset, this.count);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charset, this.value, this.offset, this.count);
    }

    public byte[] getBytes() {
        return StringCoding.encode(this.value, this.offset, this.count);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof String) {
            String anotherString = (String)anObject;
            int n = this.count;
            if (n == anotherString.count) {
                char[] v1 = this.value;
                char[] v2 = anotherString.value;
                int i = this.offset;
                int j = anotherString.offset;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer sb) {
        StringBuffer stringBuffer = sb;
        synchronized (stringBuffer) {
            return this.contentEquals((CharSequence)sb);
        }
    }

    public boolean contentEquals(CharSequence cs) {
        if (this.count != cs.length()) {
            return false;
        }
        if (cs instanceof AbstractStringBuilder) {
            char[] v1 = this.value;
            char[] v2 = ((AbstractStringBuilder)cs).getValue();
            int i = this.offset;
            int j = 0;
            int n = this.count;
            while (n-- != 0) {
                if (v1[i++] == v2[j++]) continue;
                return false;
            }
            return true;
        }
        if (cs.equals(this)) {
            return true;
        }
        char[] v1 = this.value;
        int i = this.offset;
        int j = 0;
        int n = this.count;
        while (n-- != 0) {
            if (v1[i++] == cs.charAt(j++)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.count == this.count && this.regionMatches(true, 0, anotherString, 0, this.count);
    }

    @Override
    public int compareTo(String anotherString) {
        int len1 = this.count;
        int len2 = anotherString.count;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = anotherString.value;
        int i = this.offset;
        int j = anotherString.offset;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                char c2;
                char c1;
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(String str) {
        return CASE_INSENSITIVE_ORDER.compare(this, str);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        char[] ta = this.value;
        int to = this.offset + toffset;
        char[] pa = other.value;
        int po = other.offset + ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.count - (long)len || (long)ooffset > (long)other.count - (long)len) {
            return false;
        }
        while (len-- > 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        char[] ta = this.value;
        int to = this.offset + toffset;
        char[] pa = other.value;
        int po = other.offset + ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.count - (long)len || (long)ooffset > (long)other.count - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = pa[po++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix, int toffset) {
        char[] ta = this.value;
        int to = this.offset + toffset;
        char[] pa = prefix.value;
        int po = prefix.offset;
        int pc = prefix.count;
        if (toffset < 0 || toffset > this.count - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.count - suffix.count);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.count > 0) {
            int off = this.offset;
            char[] val = this.value;
            int len = this.count;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + val[off++];
            }
            this.hash = h;
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.count) {
            return -1;
        }
        if (ch < 65536) {
            char[] value = this.value;
            int offset = this.offset;
            int max = offset + this.count;
            for (int i = offset + fromIndex; i < max; ++i) {
                if (value[i] != ch) continue;
                return i - offset;
            }
            return -1;
        }
        return this.indexOfSupplementary(ch, fromIndex);
    }

    private int indexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] value = this.value;
            int offset = this.offset;
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            int max = offset + this.count - 1;
            for (int i = offset + fromIndex; i < max; ++i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i - offset;
            }
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.count - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        if (ch < 65536) {
            char[] value = this.value;
            int offset = this.offset;
            for (int i = offset + Math.min(fromIndex, this.count - 1); i >= offset; --i) {
                if (value[i] != ch) continue;
                return i - offset;
            }
            return -1;
        }
        return this.lastIndexOfSupplementary(ch, fromIndex);
    }

    private int lastIndexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] value = this.value;
            int offset = this.offset;
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            for (int i = offset + Math.min(fromIndex, this.count - 2); i >= offset; --i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i - offset;
            }
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.value, this.offset, this.count, str.value, str.offset, str.count, fromIndex);
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, this.offset, this.count, str.value, str.offset, str.count, fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.count);
    }

    public String substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.count) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return beginIndex == 0 && endIndex == this.count ? this : new String(this.offset + beginIndex, endIndex - beginIndex, this.value);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String concat(String str) {
        int otherLen = str.length();
        if (otherLen == 0) {
            return this;
        }
        char[] buf = new char[this.count + otherLen];
        this.getChars(0, this.count, buf, 0);
        str.getChars(0, otherLen, buf, this.count);
        return new String(0, this.count + otherLen, buf);
    }

    public String replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = this.count;
            int i = -1;
            char[] val = this.value;
            int off = this.offset;
            while (++i < len && val[off + i] != oldChar) {
            }
            if (i < len) {
                char[] buf = new char[len];
                for (int j = 0; j < i; ++j) {
                    buf[j] = val[off + j];
                }
                while (i < len) {
                    char c = val[off + i];
                    buf[i] = c == oldChar ? newChar : c;
                    ++i;
                }
                return new String(0, len, buf);
            }
        }
        return this;
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) > -1;
    }

    public String replaceFirst(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceFirst(replacement);
    }

    public String replaceAll(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceAll(replacement);
    }

    public String replace(CharSequence target, CharSequence replacement) {
        return Pattern.compile(target.toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(replacement.toString()));
    }

    public String[] split(String regex, int limit) {
        char ch = '\u0000';
        if ((regex.count == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            int resultSize;
            int off = 0;
            int next = 0;
            boolean limited = limit > 0;
            ArrayList<String> list = new ArrayList<String>();
            while ((next = this.indexOf(ch, off)) != -1) {
                if (!limited || list.size() < limit - 1) {
                    list.add(this.substring(off, next));
                    off = next + 1;
                    continue;
                }
                list.add(this.substring(off, this.count));
                off = this.count;
                break;
            }
            if (off == 0) {
                return new String[]{this};
            }
            if (!limited || list.size() < limit) {
                list.add(this.substring(off, this.count));
            }
            if (limit == 0) {
                for (resultSize = list.size(); resultSize > 0 && ((String)list.get(resultSize - 1)).length() == 0; --resultSize) {
                }
            }
            String[] result = new String[resultSize];
            return list.subList(0, resultSize).toArray(result);
        }
        return Pattern.compile(regex).split(this, limit);
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public String toLowerCase(Locale locale) {
        int srcCount;
        int firstUpper;
        block15: {
            if (locale == null) {
                throw new NullPointerException();
            }
            firstUpper = 0;
            while (firstUpper < this.count) {
                char c = this.value[this.offset + firstUpper];
                if (c >= '\ud800' && c <= '\udbff') {
                    int supplChar = this.codePointAt(firstUpper);
                    if (supplChar == Character.toLowerCase(supplChar)) {
                        firstUpper += Character.charCount(supplChar);
                        continue;
                    }
                } else if (c == Character.toLowerCase(c)) {
                    ++firstUpper;
                    continue;
                }
                break block15;
            }
            return this;
        }
        char[] result = new char[this.count];
        int resultOffset = 0;
        System.arraycopy(this.value, this.offset, result, 0, firstUpper);
        String lang = locale.getLanguage();
        boolean localeDependent = lang == "tr" || lang == "az" || lang == "lt";
        for (int i = firstUpper; i < this.count; i += srcCount) {
            int srcChar = this.value[this.offset + i];
            if ((char)srcChar >= '\ud800' && (char)srcChar <= '\udbff') {
                srcChar = this.codePointAt(i);
                srcCount = Character.charCount(srcChar);
            } else {
                srcCount = 1;
            }
            int lowerChar = localeDependent || srcChar == 931 ? ConditionalSpecialCasing.toLowerCaseEx(this, i, locale) : (srcChar == 304 ? -1 : Character.toLowerCase(srcChar));
            if (lowerChar == -1 || lowerChar >= 65536) {
                char[] lowerCharArray;
                if (lowerChar == -1) {
                    lowerCharArray = !localeDependent && srcChar == 304 ? ConditionalSpecialCasing.toLowerCaseCharArray(this, i, Locale.ENGLISH) : ConditionalSpecialCasing.toLowerCaseCharArray(this, i, locale);
                } else {
                    if (srcCount == 2) {
                        resultOffset += Character.toChars(lowerChar, result, i + resultOffset) - srcCount;
                        continue;
                    }
                    lowerCharArray = Character.toChars(lowerChar);
                }
                int mapLen = lowerCharArray.length;
                if (mapLen > srcCount) {
                    char[] result2 = new char[result.length + mapLen - srcCount];
                    System.arraycopy(result, 0, result2, 0, i + resultOffset);
                    result = result2;
                }
                for (int x = 0; x < mapLen; ++x) {
                    result[i + resultOffset + x] = lowerCharArray[x];
                }
                resultOffset += mapLen - srcCount;
                continue;
            }
            result[i + resultOffset] = (char)lowerChar;
        }
        return new String(0, this.count + resultOffset, result);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int srcCount;
        int firstLower;
        block14: {
            int srcCount2;
            if (locale == null) {
                throw new NullPointerException();
            }
            for (firstLower = 0; firstLower < this.count; firstLower += srcCount2) {
                int c = this.value[this.offset + firstLower];
                if (c >= 55296 && c <= 56319) {
                    c = this.codePointAt(firstLower);
                    srcCount2 = Character.charCount(c);
                } else {
                    srcCount2 = 1;
                }
                int upperCaseChar = Character.toUpperCaseEx(c);
                if (upperCaseChar != -1 && c == upperCaseChar) {
                    continue;
                }
                break block14;
            }
            return this;
        }
        char[] result = new char[this.count];
        int resultOffset = 0;
        System.arraycopy(this.value, this.offset, result, 0, firstLower);
        String lang = locale.getLanguage();
        boolean localeDependent = lang == "tr" || lang == "az" || lang == "lt";
        for (int i = firstLower; i < this.count; i += srcCount) {
            int srcChar = this.value[this.offset + i];
            if ((char)srcChar >= '\ud800' && (char)srcChar <= '\udbff') {
                srcChar = this.codePointAt(i);
                srcCount = Character.charCount(srcChar);
            } else {
                srcCount = 1;
            }
            int upperChar = localeDependent ? ConditionalSpecialCasing.toUpperCaseEx(this, i, locale) : Character.toUpperCaseEx(srcChar);
            if (upperChar == -1 || upperChar >= 65536) {
                char[] upperCharArray;
                if (upperChar == -1) {
                    upperCharArray = localeDependent ? ConditionalSpecialCasing.toUpperCaseCharArray(this, i, locale) : Character.toUpperCaseCharArray(srcChar);
                } else {
                    if (srcCount == 2) {
                        resultOffset += Character.toChars(upperChar, result, i + resultOffset) - srcCount;
                        continue;
                    }
                    upperCharArray = Character.toChars(upperChar);
                }
                int mapLen = upperCharArray.length;
                if (mapLen > srcCount) {
                    char[] result2 = new char[result.length + mapLen - srcCount];
                    System.arraycopy(result, 0, result2, 0, i + resultOffset);
                    result = result2;
                }
                for (int x = 0; x < mapLen; ++x) {
                    result[i + resultOffset + x] = upperCharArray[x];
                }
                resultOffset += mapLen - srcCount;
                continue;
            }
            result[i + resultOffset] = (char)upperChar;
        }
        return new String(0, this.count + resultOffset, result);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int st;
        int len = this.count;
        int off = this.offset;
        char[] val = this.value;
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < this.count ? this.substring(st, len) : this;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] result = new char[this.count];
        this.getChars(0, this.count, result, 0);
        return result;
    }

    public static String format(String format, Object ... args) {
        return new Formatter().format(format, args).toString();
    }

    public static String format(Locale l, String format, Object ... args) {
        return new Formatter(l).format(format, args).toString();
    }

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data) {
        return String.copyValueOf(data, 0, data.length);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] data = new char[]{c};
        return new String(0, 1, data);
    }

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

