/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.MissingResourceFailureException;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;
    private Element c14nMethod;
    private Element signatureMethod;

    public SignedInfo(Document doc) throws XMLSecurityException {
        this(doc, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document doc, String signatureMethodURI, String canonicalizationMethodURI) throws XMLSecurityException {
        this(doc, signatureMethodURI, 0, canonicalizationMethodURI);
    }

    public SignedInfo(Document doc, String signatureMethodURI, int hMACOutputLength, String canonicalizationMethodURI) throws XMLSecurityException {
        super(doc);
        this.c14nMethod = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        this.c14nMethod.setAttributeNS(null, "Algorithm", canonicalizationMethodURI);
        this._constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = hMACOutputLength > 0 ? new SignatureAlgorithm(this._doc, signatureMethodURI, hMACOutputLength) : new SignatureAlgorithm(this._doc, signatureMethodURI);
        this.signatureMethod = this._signatureAlgorithm.getElement();
        this._constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Document doc, Element signatureMethodElem, Element canonicalizationMethodElem) throws XMLSecurityException {
        super(doc);
        this.c14nMethod = canonicalizationMethodElem;
        this._constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = new SignatureAlgorithm(signatureMethodElem, null);
        this.signatureMethod = this._signatureAlgorithm.getElement();
        this._constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
        this.c14nMethod = XMLUtils.getNextElement(element.getFirstChild());
        String c14nMethodURI = this.getCanonicalizationMethodURI();
        if (!(c14nMethodURI.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || c14nMethodURI.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || c14nMethodURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || c14nMethodURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
            try {
                Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
                this._c14nizedBytes = c14nizer.canonicalizeSubtree(this._constructionElement);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document newdoc = db.parse(new ByteArrayInputStream(this._c14nizedBytes));
                Node imported = this._doc.importNode(newdoc.getDocumentElement(), true);
                this._constructionElement.getParentNode().replaceChild(imported, this._constructionElement);
                this._constructionElement = (Element)imported;
            }
            catch (ParserConfigurationException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (IOException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (SAXException ex) {
                throw new XMLSecurityException("empty", ex);
            }
        }
        this.signatureMethod = XMLUtils.getNextElement(this.c14nMethod.getNextSibling());
        this._signatureAlgorithm = new SignatureAlgorithm(this.signatureMethod, this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean followManifests) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(followManifests);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = c14nizer.canonicalizeSubtree(this._constructionElement);
        }
        byte[] output = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, output, 0, output.length);
        return output;
    }

    public void signInOctectStream(OutputStream os) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            c14nizer.setWriter(os);
            String inclusiveNamespaces = this.getInclusiveNamespaces();
            if (inclusiveNamespaces == null) {
                c14nizer.canonicalizeSubtree(this._constructionElement);
            } else {
                c14nizer.canonicalizeSubtree(this._constructionElement, inclusiveNamespaces);
            }
        } else {
            try {
                os.write(this._c14nizedBytes);
            }
            catch (IOException e) {
                throw new RuntimeException("" + e);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        return this.c14nMethod.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element signatureElement = this.getSignatureMethodElement();
        if (signatureElement != null) {
            return signatureElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return this.signatureMethod;
    }

    public SecretKey createSecretKey(byte[] secretKeyBytes) {
        return new SecretKeySpec(secretKeyBytes, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    protected SignatureAlgorithm getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    @Override
    public String getBaseLocalName() {
        return "SignedInfo";
    }

    public String getInclusiveNamespaces() {
        String c14nMethodURI = this.c14nMethod.getAttributeNS(null, "Algorithm");
        if (!c14nMethodURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !c14nMethodURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            return null;
        }
        Element inclusiveElement = XMLUtils.getNextElement(this.c14nMethod.getFirstChild());
        if (inclusiveElement != null) {
            try {
                String inclusiveNamespaces = new InclusiveNamespaces(inclusiveElement, "http://www.w3.org/2001/10/xml-exc-c14n#").getInclusiveNamespaces();
                return inclusiveNamespaces;
            }
            catch (XMLSecurityException e) {
                return null;
            }
        }
        return null;
    }
}

