/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SimpleSoundbank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;

public class JARSoundbankReader
extends SoundbankReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZIP(URL url) {
        boolean ok = false;
        try (InputStream stream = url.openStream();){
            byte[] buff = new byte[4];
            boolean bl = ok = stream.read(buff) == 4;
            if (ok) {
                ok = buff[0] == 80 && buff[1] == 75 && buff[2] == 3 && buff[3] == 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        if (!this.isZIP(url)) {
            return null;
        }
        ArrayList<Soundbank> soundbanks = new ArrayList<Soundbank>();
        URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{url});
        InputStream stream = ucl.getResourceAsStream("META-INF/services/javax.sound.midi.Soundbank");
        if (stream == null) {
            return null;
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(stream));
            String line = r.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    try {
                        Class<?> c = Class.forName(line.trim(), true, ucl);
                        Object o = c.newInstance();
                        if (o instanceof Soundbank) {
                            soundbanks.add((Soundbank)o);
                        }
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (InstantiationException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                line = r.readLine();
            }
        }
        finally {
            stream.close();
        }
        if (soundbanks.size() == 0) {
            return null;
        }
        if (soundbanks.size() == 1) {
            return (Soundbank)soundbanks.get(0);
        }
        SimpleSoundbank sbk = new SimpleSoundbank();
        for (Soundbank soundbank : soundbanks) {
            sbk.addAllInstruments(soundbank);
        }
        return sbk;
    }

    @Override
    public Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        return null;
    }

    @Override
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        return this.getSoundbank(file.toURI().toURL());
    }
}

