/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.ImageTypeIterator;
import com.sun.imageio.plugins.jpeg.ImageTypeProducer;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.LoadLibraryAction;

public class JPEGImageReader
extends ImageReader {
    private boolean debug = false;
    private long structPointer = 0L;
    private ImageInputStream iis = null;
    private List imagePositions = null;
    private int numImages = 0;
    protected static final int WARNING_NO_EOI = 0;
    protected static final int WARNING_NO_JFIF_IN_THUMB = 1;
    protected static final int WARNING_IGNORE_INVALID_ICC = 2;
    private static final int MAX_WARNING = 2;
    private int currentImage = -1;
    private int width;
    private int height;
    private int colorSpaceCode;
    private int outColorSpaceCode;
    private int numComponents;
    private ColorSpace iccCS = null;
    private ColorConvertOp convert = null;
    private BufferedImage image = null;
    private WritableRaster raster = null;
    private WritableRaster target = null;
    private DataBufferByte buffer = null;
    private Rectangle destROI = null;
    private int[] destinationBands = null;
    private JPEGMetadata streamMetadata = null;
    private JPEGMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private boolean haveSeeked = false;
    private JPEGQTable[] abbrevQTables = null;
    private JPEGHuffmanTable[] abbrevDCHuffmanTables = null;
    private JPEGHuffmanTable[] abbrevACHuffmanTables = null;
    private int minProgressivePass = 0;
    private int maxProgressivePass = Integer.MAX_VALUE;
    private static final int UNKNOWN = -1;
    private static final int MIN_ESTIMATED_PASSES = 10;
    private int knownPassCount = -1;
    private int pass = 0;
    private float percentToDate = 0.0f;
    private float previousPassPercentage = 0.0f;
    private int progInterval = 0;
    private boolean tablesOnlyChecked = false;
    private Object disposerReferent = new Object();
    private DisposerRecord disposerRecord;
    private Thread theThread = null;
    private int theLockCount = 0;

    private static native void initReaderIDs(Class var0, Class var1, Class var2);

    public JPEGImageReader(ImageReaderSpi originator) {
        super(originator);
        this.structPointer = this.initJPEGImageReader();
        this.disposerRecord = new JPEGReaderDisposerRecord(this.structPointer);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    private native long initJPEGImageReader();

    protected void warningOccurred(int code) {
        if (code < 0 || code > 2) {
            throw new InternalError("Invalid warning index");
        }
        this.processWarningOccurred("com.sun.imageio.plugins.jpeg.JPEGImageReaderResources", Integer.toString(code));
    }

    protected void warningWithMessage(String msg) {
        this.processWarningOccurred(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.setThreadLock();
        try {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            this.ignoreMetadata = ignoreMetadata;
            this.resetInternalState();
            this.iis = (ImageInputStream)input;
            this.setSource(this.structPointer, this.iis);
        }
        finally {
            this.clearThreadLock();
        }
    }

    private native void setSource(long var1, ImageInputStream var3);

    private void checkTablesOnly() throws IOException {
        boolean tablesOnly;
        if (this.debug) {
            System.out.println("Checking for tables-only image");
        }
        long savePos = this.iis.getStreamPosition();
        if (this.debug) {
            System.out.println("saved pos is " + savePos);
            System.out.println("length is " + this.iis.length());
        }
        if (tablesOnly = this.readNativeHeader(true)) {
            long pos;
            if (this.debug) {
                System.out.println("tables-only image found");
                pos = this.iis.getStreamPosition();
                System.out.println("pos after return from native is " + pos);
            }
            if (!this.ignoreMetadata) {
                this.iis.seek(savePos);
                this.haveSeeked = true;
                this.streamMetadata = new JPEGMetadata(true, false, this.iis, this);
                pos = this.iis.getStreamPosition();
                if (this.debug) {
                    System.out.println("pos after constructing stream metadata is " + pos);
                }
            }
            if (this.hasNextImage()) {
                this.imagePositions.add(new Long(this.iis.getStreamPosition()));
            }
        } else {
            this.imagePositions.add(new Long(savePos));
            this.currentImage = 0;
        }
        if (this.seekForwardOnly) {
            Long pos = (Long)this.imagePositions.get(this.imagePositions.size() - 1);
            this.iis.flushBefore(pos);
        }
        this.tablesOnlyChecked = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.setThreadLock();
        try {
            int n = this.getNumImagesOnThread(allowSearch);
            return n;
        }
        finally {
            this.clearThreadLock();
        }
    }

    private int getNumImagesOnThread(boolean allowSearch) throws IOException {
        if (this.numImages != 0) {
            return this.numImages;
        }
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        if (allowSearch) {
            if (this.seekForwardOnly) {
                throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
            }
            if (!this.tablesOnlyChecked) {
                this.checkTablesOnly();
            }
            this.iis.mark();
            this.gotoImage(0);
            JPEGBuffer buffer = new JPEGBuffer(this.iis);
            buffer.loadBuf(0);
            boolean done = false;
            block4: while (!done) {
                done = buffer.scanForFF(this);
                switch (buffer.buf[buffer.bufPtr] & 0xFF) {
                    case 216: {
                        ++this.numImages;
                    }
                    case 0: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 217: {
                        --buffer.bufAvail;
                        ++buffer.bufPtr;
                        continue block4;
                    }
                }
                --buffer.bufAvail;
                ++buffer.bufPtr;
                buffer.loadBuf(2);
                int length = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8 | buffer.buf[buffer.bufPtr++] & 0xFF;
                buffer.bufAvail -= 2;
                buffer.skipData(length -= 2);
            }
            this.iis.reset();
            return this.numImages;
        }
        return -1;
    }

    private void gotoImage(int imageIndex) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        if (imageIndex < this.minIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.tablesOnlyChecked) {
            this.checkTablesOnly();
        }
        if (imageIndex < this.imagePositions.size()) {
            this.iis.seek((Long)this.imagePositions.get(imageIndex));
        } else {
            Long pos = (Long)this.imagePositions.get(this.imagePositions.size() - 1);
            this.iis.seek(pos);
            this.skipImage();
            for (int index = this.imagePositions.size(); index <= imageIndex; ++index) {
                if (!this.hasNextImage()) {
                    throw new IndexOutOfBoundsException();
                }
                pos = new Long(this.iis.getStreamPosition());
                this.imagePositions.add(pos);
                if (this.seekForwardOnly) {
                    this.iis.flushBefore(pos);
                }
                if (index >= imageIndex) continue;
                this.skipImage();
            }
        }
        if (this.seekForwardOnly) {
            this.minIndex = imageIndex;
        }
        this.haveSeeked = true;
    }

    private void skipImage() throws IOException {
        if (this.debug) {
            System.out.println("skipImage called");
        }
        boolean foundFF = false;
        int byteval = this.iis.read();
        while (byteval != -1) {
            if (foundFF && byteval == 217) {
                return;
            }
            foundFF = byteval == 255;
            byteval = this.iis.read();
        }
        throw new IndexOutOfBoundsException();
    }

    private boolean hasNextImage() throws IOException {
        if (this.debug) {
            System.out.print("hasNextImage called; returning ");
        }
        this.iis.mark();
        boolean foundFF = false;
        int byteval = this.iis.read();
        while (byteval != -1) {
            if (foundFF && byteval == 216) {
                this.iis.reset();
                if (this.debug) {
                    System.out.println("true");
                }
                return true;
            }
            foundFF = byteval == 255;
            byteval = this.iis.read();
        }
        this.iis.reset();
        if (this.debug) {
            System.out.println("false");
        }
        return false;
    }

    private void pushBack(int num) throws IOException {
        if (this.debug) {
            System.out.println("pushing back " + num + " bytes");
        }
        this.iis.seek(this.iis.getStreamPosition() - (long)num);
    }

    private void readHeader(int imageIndex, boolean reset) throws IOException {
        this.gotoImage(imageIndex);
        this.readNativeHeader(reset);
        this.currentImage = imageIndex;
    }

    private boolean readNativeHeader(boolean reset) throws IOException {
        boolean retval = false;
        retval = this.readImageHeader(this.structPointer, this.haveSeeked, reset);
        this.haveSeeked = false;
        return retval;
    }

    private native boolean readImageHeader(long var1, boolean var3, boolean var4) throws IOException;

    private void setImageData(int width, int height, int colorSpaceCode, int outColorSpaceCode, int numComponents, byte[] iccData) {
        this.width = width;
        this.height = height;
        this.colorSpaceCode = colorSpaceCode;
        this.outColorSpaceCode = outColorSpaceCode;
        this.numComponents = numComponents;
        if (iccData == null) {
            this.iccCS = null;
            return;
        }
        ICC_Profile newProfile = null;
        try {
            newProfile = ICC_Profile.getInstance(iccData);
        }
        catch (IllegalArgumentException e) {
            this.iccCS = null;
            this.warningOccurred(2);
            return;
        }
        byte[] newData = newProfile.getData();
        ICC_Profile oldProfile = null;
        if (this.iccCS instanceof ICC_ColorSpace) {
            oldProfile = ((ICC_ColorSpace)this.iccCS).getProfile();
        }
        byte[] oldData = null;
        if (oldProfile != null) {
            oldData = oldProfile.getData();
        }
        if (oldData == null || !Arrays.equals(oldData, newData)) {
            this.iccCS = new ICC_ColorSpace(newProfile);
            try {
                float[] colors = this.iccCS.fromRGB(new float[]{1.0f, 0.0f, 0.0f});
            }
            catch (CMMException e) {
                this.iccCS = null;
                this.warningOccurred(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.setThreadLock();
        try {
            if (this.currentImage != imageIndex) {
                this.readHeader(imageIndex, true);
            }
            int n = this.width;
            return n;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.setThreadLock();
        try {
            if (this.currentImage != imageIndex) {
                this.readHeader(imageIndex, true);
            }
            int n = this.height;
            return n;
        }
        finally {
            this.clearThreadLock();
        }
    }

    private ImageTypeProducer getImageType(int code) {
        ImageTypeProducer ret = null;
        if (code > 0 && code < 12) {
            ret = ImageTypeProducer.getTypeProducer(code);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        this.setThreadLock();
        try {
            if (this.currentImage != imageIndex) {
                this.readHeader(imageIndex, true);
            }
            ImageTypeSpecifier imageTypeSpecifier = this.getImageType(this.colorSpaceCode).getType();
            return imageTypeSpecifier;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.setThreadLock();
        try {
            Iterator iterator = this.getImageTypesOnThread(imageIndex);
            return iterator;
        }
        finally {
            this.clearThreadLock();
        }
    }

    private Iterator getImageTypesOnThread(int imageIndex) throws IOException {
        if (this.currentImage != imageIndex) {
            this.readHeader(imageIndex, true);
        }
        ImageTypeProducer raw = this.getImageType(this.colorSpaceCode);
        ArrayList<ImageTypeProducer> list = new ArrayList<ImageTypeProducer>(1);
        switch (this.colorSpaceCode) {
            case 1: {
                list.add(raw);
                list.add(this.getImageType(2));
                break;
            }
            case 2: {
                list.add(raw);
                list.add(this.getImageType(1));
                list.add(this.getImageType(5));
                break;
            }
            case 6: {
                list.add(raw);
                break;
            }
            case 5: {
                if (raw == null) break;
                list.add(raw);
                list.add(this.getImageType(2));
                break;
            }
            case 10: {
                if (raw == null) break;
                list.add(raw);
                break;
            }
            case 3: {
                list.add(this.getImageType(2));
                if (this.iccCS != null) {
                    list.add(new ImageTypeProducer(){

                        @Override
                        protected ImageTypeSpecifier produce() {
                            return ImageTypeSpecifier.createInterleaved(JPEGImageReader.this.iccCS, JPEG.bOffsRGB, 0, false, false);
                        }
                    });
                }
                list.add(this.getImageType(1));
                list.add(this.getImageType(5));
                break;
            }
            case 7: {
                list.add(this.getImageType(6));
            }
        }
        return new ImageTypeIterator(list.iterator());
    }

    private void checkColorConversion(BufferedImage image, ImageReadParam param) throws IIOException {
        if (param != null && (param.getSourceBands() != null || param.getDestinationBands() != null)) {
            return;
        }
        ColorModel cm = image.getColorModel();
        if (cm instanceof IndexColorModel) {
            throw new IIOException("IndexColorModel not supported");
        }
        ColorSpace cs = cm.getColorSpace();
        int csType = cs.getType();
        this.convert = null;
        switch (this.outColorSpaceCode) {
            case 1: {
                if (csType == 5) {
                    this.setOutColorSpace(this.structPointer, 2);
                    this.outColorSpaceCode = 2;
                    this.numComponents = 3;
                    break;
                }
                if (csType == 6) break;
                throw new IIOException("Incompatible color conversion");
            }
            case 2: {
                if (csType == 6) {
                    if (this.colorSpaceCode != 3) break;
                    this.setOutColorSpace(this.structPointer, 1);
                    this.outColorSpaceCode = 1;
                    this.numComponents = 1;
                    break;
                }
                if (this.iccCS != null && cm.getNumComponents() == this.numComponents && cs != this.iccCS) {
                    this.convert = new ColorConvertOp(this.iccCS, cs, null);
                    break;
                }
                if (this.iccCS == null && !cs.isCS_sRGB() && cm.getNumComponents() == this.numComponents) {
                    this.convert = new ColorConvertOp(JPEG.JCS.sRGB, cs, null);
                    break;
                }
                if (csType == 5) break;
                throw new IIOException("Incompatible color conversion");
            }
            case 6: {
                if (csType == 5 && cm.getNumComponents() == this.numComponents) break;
                throw new IIOException("Incompatible color conversion");
            }
            case 5: {
                ColorSpace YCC = JPEG.JCS.getYCC();
                if (YCC == null) {
                    throw new IIOException("Incompatible color conversion");
                }
                if (cs == YCC || cm.getNumComponents() != this.numComponents) break;
                this.convert = new ColorConvertOp(YCC, cs, null);
                break;
            }
            case 10: {
                ColorSpace YCC = JPEG.JCS.getYCC();
                if (YCC != null && cs == YCC && cm.getNumComponents() == this.numComponents) break;
                throw new IIOException("Incompatible color conversion");
            }
            default: {
                throw new IIOException("Incompatible color conversion");
            }
        }
    }

    private native void setOutColorSpace(long var1, int var3);

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new JPEGImageReadParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        this.setThreadLock();
        try {
            if (!this.tablesOnlyChecked) {
                this.checkTablesOnly();
            }
            JPEGMetadata jPEGMetadata = this.streamMetadata;
            return jPEGMetadata;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.setThreadLock();
        try {
            if (this.imageMetadataIndex == imageIndex && this.imageMetadata != null) {
                JPEGMetadata jPEGMetadata = this.imageMetadata;
                return jPEGMetadata;
            }
            this.gotoImage(imageIndex);
            this.imageMetadata = new JPEGMetadata(false, false, this.iis, this);
            this.imageMetadataIndex = imageIndex;
            JPEGMetadata jPEGMetadata = this.imageMetadata;
            return jPEGMetadata;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.setThreadLock();
        try {
            try {
                this.readInternal(imageIndex, param, false);
            }
            catch (RuntimeException e) {
                this.resetLibraryState(this.structPointer);
                throw e;
            }
            catch (IOException e) {
                this.resetLibraryState(this.structPointer);
                throw e;
            }
            BufferedImage ret = this.image;
            this.image = null;
            BufferedImage bufferedImage = ret;
            return bufferedImage;
        }
        finally {
            this.clearThreadLock();
        }
    }

    private Raster readInternal(int imageIndex, ImageReadParam param, boolean wantRaster) throws IOException {
        this.readHeader(imageIndex, false);
        WritableRaster imRas = null;
        int numImageBands = 0;
        if (!wantRaster) {
            Iterator imageTypes = this.getImageTypes(imageIndex);
            if (!imageTypes.hasNext()) {
                throw new IIOException("Unsupported Image Type");
            }
            this.image = JPEGImageReader.getDestination(param, imageTypes, this.width, this.height);
            imRas = this.image.getRaster();
            numImageBands = this.image.getSampleModel().getNumBands();
            this.checkColorConversion(this.image, param);
            JPEGImageReader.checkReadParamBandSettings(param, this.numComponents, numImageBands);
        } else {
            this.setOutColorSpace(this.structPointer, this.colorSpaceCode);
            this.image = null;
        }
        int[] srcBands = JPEG.bandOffsets[this.numComponents - 1];
        int numRasterBands = wantRaster ? this.numComponents : numImageBands;
        this.destinationBands = null;
        Rectangle srcROI = new Rectangle(0, 0, 0, 0);
        this.destROI = new Rectangle(0, 0, 0, 0);
        JPEGImageReader.computeRegions(param, this.width, this.height, this.image, srcROI, this.destROI);
        int periodX = 1;
        int periodY = 1;
        this.minProgressivePass = 0;
        this.maxProgressivePass = Integer.MAX_VALUE;
        if (param != null) {
            JPEGImageReadParam jparam;
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
            int[] sBands = param.getSourceBands();
            if (sBands != null) {
                srcBands = sBands;
                numRasterBands = srcBands.length;
            }
            if (!wantRaster) {
                this.destinationBands = param.getDestinationBands();
            }
            this.minProgressivePass = param.getSourceMinProgressivePass();
            this.maxProgressivePass = param.getSourceMaxProgressivePass();
            if (param instanceof JPEGImageReadParam && (jparam = (JPEGImageReadParam)param).areTablesSet()) {
                this.abbrevQTables = jparam.getQTables();
                this.abbrevDCHuffmanTables = jparam.getDCHuffmanTables();
                this.abbrevACHuffmanTables = jparam.getACHuffmanTables();
            }
        }
        int lineSize = this.destROI.width * numRasterBands;
        this.buffer = new DataBufferByte(lineSize);
        int[] bandOffs = JPEG.bandOffsets[numRasterBands - 1];
        this.raster = Raster.createInterleavedRaster(this.buffer, this.destROI.width, 1, lineSize, numRasterBands, bandOffs, null);
        this.target = wantRaster ? Raster.createInterleavedRaster(0, this.destROI.width, this.destROI.height, lineSize, numRasterBands, bandOffs, null) : imRas;
        int[] bandSizes = this.target.getSampleModel().getSampleSize();
        boolean callbackUpdates = this.updateListeners != null || this.progressListeners != null;
        this.initProgressData();
        if (imageIndex == this.imageMetadataIndex) {
            this.knownPassCount = 0;
            Iterator iter = this.imageMetadata.markerSequence.iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof SOSMarkerSegment)) continue;
                ++this.knownPassCount;
            }
        }
        this.progInterval = Math.max((this.target.getHeight() - 1) / 20, 1);
        if (this.knownPassCount > 0) {
            this.progInterval *= this.knownPassCount;
        } else if (this.maxProgressivePass != Integer.MAX_VALUE) {
            this.progInterval *= this.maxProgressivePass - this.minProgressivePass + 1;
        }
        if (this.debug) {
            int i;
            System.out.println("**** Read Data *****");
            System.out.println("numRasterBands is " + numRasterBands);
            System.out.print("srcBands:");
            for (i = 0; i < srcBands.length; ++i) {
                System.out.print(" " + srcBands[i]);
            }
            System.out.println();
            System.out.println("destination bands is " + this.destinationBands);
            if (this.destinationBands != null) {
                for (i = 0; i < this.destinationBands.length; ++i) {
                    System.out.print(" " + this.destinationBands[i]);
                }
                System.out.println();
            }
            System.out.println("sourceROI is " + srcROI);
            System.out.println("destROI is " + this.destROI);
            System.out.println("periodX is " + periodX);
            System.out.println("periodY is " + periodY);
            System.out.println("minProgressivePass is " + this.minProgressivePass);
            System.out.println("maxProgressivePass is " + this.maxProgressivePass);
            System.out.println("callbackUpdates is " + callbackUpdates);
        }
        this.processImageStarted(this.currentImage);
        boolean aborted = false;
        aborted = this.readImage(this.structPointer, this.buffer.getData(), numRasterBands, srcBands, bandSizes, srcROI.x, srcROI.y, srcROI.width, srcROI.height, periodX, periodY, this.abbrevQTables, this.abbrevDCHuffmanTables, this.abbrevACHuffmanTables, this.minProgressivePass, this.maxProgressivePass, callbackUpdates);
        if (aborted) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.target;
    }

    private void acceptPixels(int y, boolean progressive) {
        if (this.convert != null) {
            this.convert.filter(this.raster, this.raster);
        }
        this.target.setRect(this.destROI.x, this.destROI.y + y, this.raster);
        this.processImageUpdate(this.image, this.destROI.x, this.destROI.y + y, this.raster.getWidth(), 1, 1, 1, this.destinationBands);
        if (y > 0 && y % this.progInterval == 0) {
            int height = this.target.getHeight() - 1;
            float percentOfPass = (float)y / (float)height;
            if (progressive) {
                if (this.knownPassCount != -1) {
                    this.processImageProgress(((float)this.pass + percentOfPass) * 100.0f / (float)this.knownPassCount);
                } else if (this.maxProgressivePass != Integer.MAX_VALUE) {
                    this.processImageProgress(((float)this.pass + percentOfPass) * 100.0f / (float)(this.maxProgressivePass - this.minProgressivePass + 1));
                } else {
                    int remainingPasses = Math.max(2, 10 - this.pass);
                    int totalPasses = this.pass + remainingPasses - 1;
                    this.progInterval = Math.max(height / 20 * totalPasses, totalPasses);
                    if (y % this.progInterval == 0) {
                        this.percentToDate = this.previousPassPercentage + (1.0f - this.previousPassPercentage) * percentOfPass / (float)remainingPasses;
                        if (this.debug) {
                            System.out.print("pass= " + this.pass);
                            System.out.print(", y= " + y);
                            System.out.print(", progInt= " + this.progInterval);
                            System.out.print(", % of pass: " + percentOfPass);
                            System.out.print(", rem. passes: " + remainingPasses);
                            System.out.print(", prev%: " + this.previousPassPercentage);
                            System.out.print(", %ToDate: " + this.percentToDate);
                            System.out.print(" ");
                        }
                        this.processImageProgress(this.percentToDate * 100.0f);
                    }
                }
            } else {
                this.processImageProgress(percentOfPass * 100.0f);
            }
        }
    }

    private void initProgressData() {
        this.knownPassCount = -1;
        this.pass = 0;
        this.percentToDate = 0.0f;
        this.previousPassPercentage = 0.0f;
        this.progInterval = 0;
    }

    private void passStarted(int pass) {
        this.pass = pass;
        this.previousPassPercentage = this.percentToDate;
        this.processPassStarted(this.image, pass, this.minProgressivePass, this.maxProgressivePass, 0, 0, 1, 1, this.destinationBands);
    }

    private void passComplete() {
        this.processPassComplete(this.image);
    }

    void thumbnailStarted(int thumbnailIndex) {
        this.processThumbnailStarted(this.currentImage, thumbnailIndex);
    }

    void thumbnailProgress(float percentageDone) {
        this.processThumbnailProgress(percentageDone);
    }

    void thumbnailComplete() {
        this.processThumbnailComplete();
    }

    private native boolean readImage(long var1, byte[] var3, int var4, int[] var5, int[] var6, int var7, int var8, int var9, int var10, int var11, int var12, JPEGQTable[] var13, JPEGHuffmanTable[] var14, JPEGHuffmanTable[] var15, int var16, int var17, boolean var18);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.setThreadLock();
        try {
            super.abort();
            this.abortRead(this.structPointer);
        }
        finally {
            this.clearThreadLock();
        }
    }

    private native void abortRead(long var1);

    private native void resetLibraryState(long var1);

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.setThreadLock();
        Raster retval = null;
        try {
            Point saveDestOffset = null;
            if (param != null) {
                saveDestOffset = param.getDestinationOffset();
                param.setDestinationOffset(new Point(0, 0));
            }
            retval = this.readInternal(imageIndex, param, true);
            if (saveDestOffset != null) {
                this.target = this.target.createWritableTranslatedChild(saveDestOffset.x, saveDestOffset.y);
            }
        }
        catch (RuntimeException e) {
            this.resetLibraryState(this.structPointer);
            throw e;
        }
        catch (IOException e) {
            this.resetLibraryState(this.structPointer);
            throw e;
        }
        finally {
            this.clearThreadLock();
        }
        return retval;
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        this.setThreadLock();
        try {
            this.getImageMetadata(imageIndex);
            JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            int retval = 0;
            if (jfif != null) {
                retval = jfif.thumb == null ? 0 : 1;
                retval += jfif.extSegments.size();
            }
            int n = retval;
            return n;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThumbnailWidth(int imageIndex, int thumbnailIndex) throws IOException {
        this.setThreadLock();
        try {
            if (thumbnailIndex < 0 || thumbnailIndex >= this.getNumThumbnails(imageIndex)) {
                throw new IndexOutOfBoundsException("No such thumbnail");
            }
            JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            int n = jfif.getThumbnailWidth(thumbnailIndex);
            return n;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThumbnailHeight(int imageIndex, int thumbnailIndex) throws IOException {
        this.setThreadLock();
        try {
            if (thumbnailIndex < 0 || thumbnailIndex >= this.getNumThumbnails(imageIndex)) {
                throw new IndexOutOfBoundsException("No such thumbnail");
            }
            JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            int n = jfif.getThumbnailHeight(thumbnailIndex);
            return n;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        this.setThreadLock();
        try {
            if (thumbnailIndex < 0 || thumbnailIndex >= this.getNumThumbnails(imageIndex)) {
                throw new IndexOutOfBoundsException("No such thumbnail");
            }
            JFIFMarkerSegment jfif = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            BufferedImage bufferedImage = jfif.getThumbnail(this.iis, thumbnailIndex, this);
            return bufferedImage;
        }
        finally {
            this.clearThreadLock();
        }
    }

    private void resetInternalState() {
        this.resetReader(this.structPointer);
        this.numImages = 0;
        this.imagePositions = new ArrayList();
        this.currentImage = -1;
        this.image = null;
        this.raster = null;
        this.target = null;
        this.buffer = null;
        this.destROI = null;
        this.destinationBands = null;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.imageMetadataIndex = -1;
        this.haveSeeked = false;
        this.tablesOnlyChecked = false;
        this.iccCS = null;
        this.initProgressData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.setThreadLock();
        try {
            super.reset();
        }
        finally {
            this.clearThreadLock();
        }
    }

    private native void resetReader(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.setThreadLock();
        try {
            if (this.structPointer != 0L) {
                this.disposerRecord.dispose();
                this.structPointer = 0L;
            }
        }
        finally {
            this.clearThreadLock();
        }
    }

    private static native void disposeReader(long var0);

    private synchronized void setThreadLock() {
        Thread currThread = Thread.currentThread();
        if (this.theThread != null) {
            if (this.theThread != currThread) {
                throw new IllegalStateException("Attempt to use instance of " + this + " locked on thread " + this.theThread + " from thread " + currThread);
            }
            ++this.theLockCount;
        } else {
            this.theThread = currThread;
            this.theLockCount = 1;
        }
    }

    private synchronized void clearThreadLock() {
        Thread currThread = Thread.currentThread();
        if (this.theThread == null || this.theThread != currThread) {
            throw new IllegalStateException("Attempt to clear thread lock  form wrong thread. Locked thread: " + this.theThread + "; current thread: " + currThread);
        }
        --this.theLockCount;
        if (this.theLockCount == 0) {
            this.theThread = null;
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("javajpeg"));
        JPEGImageReader.initReaderIDs(ImageInputStream.class, JPEGQTable.class, JPEGHuffmanTable.class);
    }

    private static class JPEGReaderDisposerRecord
    implements DisposerRecord {
        private long pData;

        public JPEGReaderDisposerRecord(long pData) {
            this.pData = pData;
        }

        @Override
        public synchronized void dispose() {
            if (this.pData != 0L) {
                JPEGImageReader.disposeReader(this.pData);
                this.pData = 0L;
            }
        }
    }
}

