/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import sun.security.ssl.EngineOutputRecord;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSocketImpl;

public class HandshakeOutStream
extends OutputStream {
    private SSLSocketImpl socket;
    private SSLEngineImpl engine;
    OutputRecord r;

    HandshakeOutStream(ProtocolVersion protocolVersion, ProtocolVersion helloVersion, HandshakeHash handshakeHash, SSLSocketImpl socket) {
        this.socket = socket;
        this.r = new OutputRecord(22);
        this.init(protocolVersion, helloVersion, handshakeHash);
    }

    HandshakeOutStream(ProtocolVersion protocolVersion, ProtocolVersion helloVersion, HandshakeHash handshakeHash, SSLEngineImpl engine) {
        this.engine = engine;
        this.r = new EngineOutputRecord(22, engine);
        this.init(protocolVersion, helloVersion, handshakeHash);
    }

    private void init(ProtocolVersion protocolVersion, ProtocolVersion helloVersion, HandshakeHash handshakeHash) {
        this.r.setVersion(protocolVersion);
        this.r.setHelloVersion(helloVersion);
        this.r.setHandshakeHash(handshakeHash);
    }

    void doHashes() {
        this.r.doHashes();
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int howmuch = Math.min(len, this.r.availableDataBytes());
            if (howmuch == 0) {
                this.flush();
                continue;
            }
            this.r.write(buf, off, howmuch);
            off += howmuch;
            len -= howmuch;
        }
    }

    @Override
    public void write(int i) throws IOException {
        if (this.r.availableDataBytes() < 1) {
            this.flush();
        }
        this.r.write(i);
    }

    @Override
    public void flush() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.writeRecord(this.r);
            }
            catch (IOException e) {
                this.socket.waitForClose(true);
                throw e;
            }
        } else {
            this.engine.writeRecord((EngineOutputRecord)this.r);
        }
    }

    void setFinishedMsg() {
        assert (this.socket == null);
        ((EngineOutputRecord)this.r).setFinishedMsg();
    }

    void putInt8(int i) throws IOException {
        this.r.write(i);
    }

    void putInt16(int i) throws IOException {
        if (this.r.availableDataBytes() < 2) {
            this.flush();
        }
        this.r.write(i >> 8);
        this.r.write(i);
    }

    void putInt24(int i) throws IOException {
        if (this.r.availableDataBytes() < 3) {
            this.flush();
        }
        this.r.write(i >> 16);
        this.r.write(i >> 8);
        this.r.write(i);
    }

    void putInt32(int i) throws IOException {
        if (this.r.availableDataBytes() < 4) {
            this.flush();
        }
        this.r.write(i >> 24);
        this.r.write(i >> 16);
        this.r.write(i >> 8);
        this.r.write(i);
    }

    void putBytes8(byte[] b) throws IOException {
        if (b == null) {
            this.putInt8(0);
            return;
        }
        this.putInt8(b.length);
        this.write(b, 0, b.length);
    }

    public void putBytes16(byte[] b) throws IOException {
        if (b == null) {
            this.putInt16(0);
            return;
        }
        this.putInt16(b.length);
        this.write(b, 0, b.length);
    }

    void putBytes24(byte[] b) throws IOException {
        if (b == null) {
            this.putInt24(0);
            return;
        }
        this.putInt24(b.length);
        this.write(b, 0, b.length);
    }
}

