/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;
import javax.crypto.SecretKey;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Digest
extends MessageDigestSpi {
    private static final int S_BLANK = 1;
    private static final int S_BUFFERED = 2;
    private static final int S_INIT = 3;
    private static final int BUFFER_SIZE = 96;
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private final int digestLength;
    private Session session;
    private int state;
    private byte[] oneByte;
    private final byte[] buffer;
    private int bufOfs;

    P11Digest(Token token, String algorithm, long mechanism) {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        switch ((int)mechanism) {
            case 512: 
            case 528: {
                this.digestLength = 16;
                break;
            }
            case 544: {
                this.digestLength = 20;
                break;
            }
            case 592: {
                this.digestLength = 32;
                break;
            }
            case 608: {
                this.digestLength = 48;
                break;
            }
            case 624: {
                this.digestLength = 64;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + mechanism);
            }
        }
        this.buffer = new byte[96];
        this.state = 1;
        this.engineReset();
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestLength;
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (this.session == null) {
            return;
        }
        if (this.state != 3 || !this.token.explicitCancel) {
            return;
        }
        try {
            this.token.p11.C_DigestFinal(this.session.id(), this.buffer, 0, this.buffer.length);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("cancel() failed", e);
        }
        finally {
            this.state = 2;
        }
    }

    private void fetchSession() {
        this.token.ensureValid();
        if (this.state == 1) {
            this.engineReset();
        }
    }

    @Override
    protected void engineReset() {
        try {
            this.cancelOperation();
            this.bufOfs = 0;
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            this.state = 2;
        }
        catch (PKCS11Exception e) {
            this.state = 1;
            throw new ProviderException("reset() failed, ", e);
        }
    }

    @Override
    protected byte[] engineDigest() {
        try {
            byte[] digest = new byte[this.digestLength];
            int n = this.engineDigest(digest, 0, this.digestLength);
            return digest;
        }
        catch (DigestException e) {
            throw new ProviderException("internal error", e);
        }
    }

    @Override
    protected int engineDigest(byte[] digest, int ofs, int len) throws DigestException {
        if (len < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength);
        }
        this.fetchSession();
        try {
            int n;
            if (this.state == 2) {
                n = this.token.p11.C_DigestSingle(this.session.id(), new CK_MECHANISM(this.mechanism), this.buffer, 0, this.bufOfs, digest, ofs, len);
            } else {
                if (this.bufOfs != 0) {
                    this.doUpdate(this.buffer, 0, this.bufOfs);
                }
                n = this.token.p11.C_DigestFinal(this.session.id(), digest, ofs, len);
            }
            if (n != this.digestLength) {
                throw new ProviderException("internal digest length error");
            }
            int n2 = n;
            return n2;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("digest() failed", e);
        }
        finally {
            this.state = 1;
            this.bufOfs = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    @Override
    protected void engineUpdate(byte in) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = in;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int ofs, int len) {
        this.fetchSession();
        if (len <= 0) {
            return;
        }
        if (this.bufOfs != 0 && this.bufOfs + len > this.buffer.length) {
            this.doUpdate(this.buffer, 0, this.bufOfs);
            this.bufOfs = 0;
        }
        if (this.bufOfs + len > this.buffer.length) {
            this.doUpdate(in, ofs, len);
        } else {
            System.arraycopy(in, ofs, this.buffer, this.bufOfs, len);
            this.bufOfs += len;
        }
    }

    protected void implUpdate(SecretKey key) throws InvalidKeyException {
        this.fetchSession();
        if (this.bufOfs != 0) {
            this.doUpdate(this.buffer, 0, this.bufOfs);
            this.bufOfs = 0;
        }
        if (!(key instanceof P11Key)) {
            throw new InvalidKeyException("Not a P11Key: " + key);
        }
        P11Key p11Key = (P11Key)((Object)key);
        if (p11Key.token != this.token) {
            throw new InvalidKeyException("Not a P11Key of this provider: " + key);
        }
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), new CK_MECHANISM(this.mechanism));
                this.state = 3;
            }
            this.token.p11.C_DigestKey(this.session.id(), p11Key.keyID);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update(SecretKey) failed", e);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.fetchSession();
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        if (!(byteBuffer instanceof DirectBuffer)) {
            super.engineUpdate(byteBuffer);
            return;
        }
        long addr = ((DirectBuffer)((Object)byteBuffer)).address();
        int ofs = byteBuffer.position();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), new CK_MECHANISM(this.mechanism));
                this.state = 3;
                if (this.bufOfs != 0) {
                    this.doUpdate(this.buffer, 0, this.bufOfs);
                    this.bufOfs = 0;
                }
            }
            this.token.p11.C_DigestUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
            byteBuffer.position(ofs + len);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }

    private void doUpdate(byte[] in, int ofs, int len) {
        if (len <= 0) {
            return;
        }
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), new CK_MECHANISM(this.mechanism));
                this.state = 3;
            }
            this.token.p11.C_DigestUpdate(this.session.id(), 0L, in, ofs, len);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }
}

