/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

public class GSSCredentialImpl
implements GSSCredential {
    private GSSManagerImpl gssManager = null;
    private boolean destroyed = false;
    private Hashtable<SearchKey, GSSCredentialSpi> hashtable = null;
    private GSSCredentialSpi tempCred = null;

    GSSCredentialImpl(GSSManagerImpl gssManager, int usage) throws GSSException {
        this(gssManager, null, 0, (Oid[])null, usage);
    }

    GSSCredentialImpl(GSSManagerImpl gssManager, GSSName name, int lifetime, Oid mech, int usage) throws GSSException {
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        this.init(gssManager);
        this.add(name, lifetime, lifetime, mech, usage);
    }

    GSSCredentialImpl(GSSManagerImpl gssManager, GSSName name, int lifetime, Oid[] mechs, int usage) throws GSSException {
        this.init(gssManager);
        boolean defaultList = false;
        if (mechs == null) {
            mechs = gssManager.getMechs();
            defaultList = true;
        }
        for (int i = 0; i < mechs.length; ++i) {
            try {
                this.add(name, lifetime, lifetime, mechs[i], usage);
                continue;
            }
            catch (GSSException e) {
                if (defaultList) {
                    GSSUtil.debug("Ignore " + e + " while acquring cred for " + mechs[i]);
                    continue;
                }
                throw e;
            }
        }
        if (this.hashtable.size() == 0 || usage != this.getUsage()) {
            throw new GSSException(13);
        }
    }

    public GSSCredentialImpl(GSSManagerImpl gssManager, GSSCredentialSpi mechElement) throws GSSException {
        this.init(gssManager);
        int usage = 2;
        if (mechElement.isInitiatorCredential()) {
            usage = mechElement.isAcceptorCredential() ? 0 : 1;
        }
        SearchKey key = new SearchKey(mechElement.getMechanism(), usage);
        this.tempCred = mechElement;
        this.hashtable.put(key, this.tempCred);
    }

    void init(GSSManagerImpl gssManager) {
        this.gssManager = gssManager;
        this.hashtable = new Hashtable(gssManager.getMechs().length);
    }

    @Override
    public void dispose() throws GSSException {
        if (!this.destroyed) {
            Enumeration<GSSCredentialSpi> values = this.hashtable.elements();
            while (values.hasMoreElements()) {
                GSSCredentialSpi element = values.nextElement();
                element.dispose();
            }
            this.destroyed = true;
        }
    }

    @Override
    public GSSName getName() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        return GSSNameImpl.wrapElement(this.gssManager, this.tempCred.getName());
    }

    @Override
    public GSSName getName(Oid mech) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        SearchKey key = null;
        GSSCredentialSpi element = null;
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 1))) == null) {
            key = new SearchKey(mech, 2);
            element = this.hashtable.get(key);
        }
        if (element == null) {
            key = new SearchKey(mech, 0);
            element = this.hashtable.get(key);
        }
        if (element == null) {
            throw new GSSExceptionImpl(2, mech);
        }
        return GSSNameImpl.wrapElement(this.gssManager, element.getName());
    }

    @Override
    public int getRemainingLifetime() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        int tempLife = 0;
        int tempInitLife = 0;
        int tempAcceptLife = 0;
        int min = Integer.MAX_VALUE;
        Enumeration<SearchKey> e = this.hashtable.keys();
        while (e.hasMoreElements()) {
            SearchKey tempKey = e.nextElement();
            GSSCredentialSpi tempCred = this.hashtable.get(tempKey);
            if (tempKey.getUsage() == 1) {
                tempLife = tempCred.getInitLifetime();
            } else if (tempKey.getUsage() == 2) {
                tempLife = tempCred.getAcceptLifetime();
            } else {
                tempInitLife = tempCred.getInitLifetime();
                int n = tempLife = tempInitLife < (tempAcceptLife = tempCred.getAcceptLifetime()) ? tempInitLife : tempAcceptLife;
            }
            if (min <= tempLife) continue;
            min = tempLife;
        }
        return min;
    }

    @Override
    public int getRemainingInitLifetime(Oid mech) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi element = null;
        SearchKey key = null;
        boolean found = false;
        int max = 0;
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 1))) != null) {
            found = true;
            if (max < element.getInitLifetime()) {
                max = element.getInitLifetime();
            }
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 0))) != null) {
            found = true;
            if (max < element.getInitLifetime()) {
                max = element.getInitLifetime();
            }
        }
        if (!found) {
            throw new GSSExceptionImpl(2, mech);
        }
        return max;
    }

    @Override
    public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi element = null;
        SearchKey key = null;
        boolean found = false;
        int max = 0;
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 2))) != null) {
            found = true;
            if (max < element.getAcceptLifetime()) {
                max = element.getAcceptLifetime();
            }
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 0))) != null) {
            found = true;
            if (max < element.getAcceptLifetime()) {
                max = element.getAcceptLifetime();
            }
        }
        if (!found) {
            throw new GSSExceptionImpl(2, mech);
        }
        return max;
    }

    @Override
    public int getUsage() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        boolean initiate = false;
        boolean accept = false;
        Enumeration<SearchKey> e = this.hashtable.keys();
        while (e.hasMoreElements()) {
            SearchKey tempKey = e.nextElement();
            if (tempKey.getUsage() == 1) {
                initiate = true;
                continue;
            }
            if (tempKey.getUsage() == 2) {
                accept = true;
                continue;
            }
            return 0;
        }
        if (initiate) {
            if (accept) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    @Override
    public int getUsage(Oid mech) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi element = null;
        SearchKey key = null;
        boolean initiate = false;
        boolean accept = false;
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 1))) != null) {
            initiate = true;
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 2))) != null) {
            accept = true;
        }
        if ((element = this.hashtable.get(key = new SearchKey(mech, 0))) != null) {
            initiate = true;
            accept = true;
        }
        if (initiate && accept) {
            return 0;
        }
        if (initiate) {
            return 1;
        }
        if (accept) {
            return 2;
        }
        throw new GSSExceptionImpl(2, mech);
    }

    @Override
    public Oid[] getMechs() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        Vector<Oid> result = new Vector<Oid>(this.hashtable.size());
        Enumeration<SearchKey> e = this.hashtable.keys();
        while (e.hasMoreElements()) {
            SearchKey tempKey = e.nextElement();
            result.addElement(tempKey.getMech());
        }
        return result.toArray(new Oid[0]);
    }

    @Override
    public void add(GSSName name, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
        SearchKey key;
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        if (this.hashtable.containsKey(key = new SearchKey(mech, usage))) {
            throw new GSSExceptionImpl(17, "Duplicate element found: " + GSSCredentialImpl.getElementStr(mech, usage));
        }
        GSSNameSpi nameElement = name == null ? null : ((GSSNameImpl)name).getElement(mech);
        this.tempCred = this.gssManager.getCredentialElement(nameElement, initLifetime, acceptLifetime, mech, usage);
        if (this.tempCred != null) {
            if (!(usage != 0 || this.tempCred.isAcceptorCredential() && this.tempCred.isInitiatorCredential())) {
                int desiredUsage;
                int currentUsage;
                if (!this.tempCred.isInitiatorCredential()) {
                    currentUsage = 2;
                    desiredUsage = 1;
                } else {
                    currentUsage = 1;
                    desiredUsage = 2;
                }
                key = new SearchKey(mech, currentUsage);
                this.hashtable.put(key, this.tempCred);
                this.tempCred = this.gssManager.getCredentialElement(nameElement, initLifetime, acceptLifetime, mech, desiredUsage);
                key = new SearchKey(mech, desiredUsage);
                this.hashtable.put(key, this.tempCred);
            } else {
                this.hashtable.put(key, this.tempCred);
            }
        }
    }

    @Override
    public boolean equals(Object another) {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        if (this == another) {
            return true;
        }
        if (!(another instanceof GSSCredentialImpl)) {
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        return 1;
    }

    public GSSCredentialSpi getElement(Oid mechOid, boolean initiate) throws GSSException {
        GSSCredentialSpi element;
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        if (mechOid == null) {
            mechOid = ProviderList.DEFAULT_MECH_OID;
            SearchKey key = new SearchKey(mechOid, initiate ? 1 : 2);
            element = this.hashtable.get(key);
            if (element == null && (element = this.hashtable.get(key = new SearchKey(mechOid, 0))) == null) {
                Object[] elements = this.hashtable.entrySet().toArray();
                for (int i = 0; i < elements.length && (element = (GSSCredentialSpi)((Map.Entry)elements[i]).getValue()).isInitiatorCredential() != initiate; ++i) {
                }
            }
        } else {
            SearchKey key = initiate ? new SearchKey(mechOid, 1) : new SearchKey(mechOid, 2);
            element = this.hashtable.get(key);
            if (element == null) {
                key = new SearchKey(mechOid, 0);
                element = this.hashtable.get(key);
            }
        }
        if (element == null) {
            throw new GSSExceptionImpl(13, "No credential found for: " + mechOid + GSSCredentialImpl.getElementStr(mechOid, initiate ? 1 : 2));
        }
        return element;
    }

    Set<GSSCredentialSpi> getElements() {
        HashSet<GSSCredentialSpi> retVal = new HashSet<GSSCredentialSpi>(this.hashtable.size());
        Enumeration<GSSCredentialSpi> values = this.hashtable.elements();
        while (values.hasMoreElements()) {
            GSSCredentialSpi o = values.nextElement();
            retVal.add(o);
        }
        return retVal;
    }

    private static String getElementStr(Oid mechOid, int usage) {
        String displayString = mechOid.toString();
        displayString = usage == 1 ? displayString.concat(" usage: Initiate") : (usage == 2 ? displayString.concat(" usage: Accept") : displayString.concat(" usage: Initiate and Accept"));
        return displayString;
    }

    public String toString() {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi element = null;
        StringBuffer buffer = new StringBuffer("[GSSCredential: ");
        Object[] elements = this.hashtable.entrySet().toArray();
        for (int i = 0; i < elements.length; ++i) {
            try {
                buffer.append('\n');
                element = (GSSCredentialSpi)((Map.Entry)elements[i]).getValue();
                buffer.append(element.getName());
                buffer.append(' ');
                buffer.append(element.getMechanism());
                buffer.append(element.isInitiatorCredential() ? " Initiate" : "");
                buffer.append(element.isAcceptorCredential() ? " Accept" : "");
                buffer.append(" [");
                buffer.append(element.toString());
                buffer.append(']');
                continue;
            }
            catch (GSSException e) {
                // empty catch block
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    static class SearchKey {
        private Oid mechOid = null;
        private int usage = 0;

        public SearchKey(Oid mechOid, int usage) {
            this.mechOid = mechOid;
            this.usage = usage;
        }

        public Oid getMech() {
            return this.mechOid;
        }

        public int getUsage() {
            return this.usage;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SearchKey)) {
                return false;
            }
            SearchKey that = (SearchKey)other;
            return this.mechOid.equals(that.mechOid) && this.usage == that.usage;
        }

        public int hashCode() {
            return this.mechOid.hashCode();
        }
    }
}

