/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractPoller;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class LinuxWatchService
extends AbstractWatchService {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final Poller poller;

    LinuxWatchService(UnixFileSystem fs) throws IOException {
        int ifd = -1;
        try {
            ifd = LinuxWatchService.inotifyInit();
        }
        catch (UnixException x) {
            throw new IOException(x.errorString());
        }
        int[] sp = new int[2];
        try {
            LinuxWatchService.configureBlocking(ifd, false);
            LinuxWatchService.socketpair(sp);
            LinuxWatchService.configureBlocking(sp[0], false);
        }
        catch (UnixException x) {
            UnixNativeDispatcher.close(ifd);
            throw new IOException(x.errorString());
        }
        this.poller = new Poller(fs, this, ifd, sp);
        this.poller.start();
    }

    @Override
    WatchKey register(Path dir, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.poller.register(dir, events, modifiers);
    }

    @Override
    void implClose() throws IOException {
        this.poller.close();
    }

    private static native int eventSize();

    private static native int[] eventOffsets();

    private static native int inotifyInit() throws UnixException;

    private static native int inotifyAddWatch(int var0, long var1, int var3) throws UnixException;

    private static native void inotifyRmWatch(int var0, int var1) throws UnixException;

    private static native void configureBlocking(int var0, boolean var1) throws UnixException;

    private static native void socketpair(int[] var0) throws UnixException;

    private static native int poll(int var0, int var1) throws UnixException;

    static /* synthetic */ int access$200() {
        return LinuxWatchService.eventSize();
    }

    static /* synthetic */ int[] access$300() {
        return LinuxWatchService.eventOffsets();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }

    private static class Poller
    extends AbstractPoller {
        private static final int SIZEOF_INOTIFY_EVENT = LinuxWatchService.access$200();
        private static final int[] offsets = LinuxWatchService.access$300();
        private static final int OFFSETOF_WD = offsets[0];
        private static final int OFFSETOF_MASK = offsets[1];
        private static final int OFFSETOF_LEN = offsets[3];
        private static final int OFFSETOF_NAME = offsets[4];
        private static final int IN_MODIFY = 2;
        private static final int IN_ATTRIB = 4;
        private static final int IN_MOVED_FROM = 64;
        private static final int IN_MOVED_TO = 128;
        private static final int IN_CREATE = 256;
        private static final int IN_DELETE = 512;
        private static final int IN_UNMOUNT = 8192;
        private static final int IN_Q_OVERFLOW = 16384;
        private static final int IN_IGNORED = 32768;
        private static final int BUFFER_SIZE = 8192;
        private final UnixFileSystem fs;
        private final LinuxWatchService watcher;
        private final int ifd;
        private final int[] socketpair;
        private final Map<Integer, LinuxWatchKey> wdToKey;
        private final long address;

        Poller(UnixFileSystem fs, LinuxWatchService watcher, int ifd, int[] sp) {
            this.fs = fs;
            this.watcher = watcher;
            this.ifd = ifd;
            this.socketpair = sp;
            this.wdToKey = new HashMap<Integer, LinuxWatchKey>();
            this.address = unsafe.allocateMemory(8192L);
        }

        @Override
        void wakeup() throws IOException {
            try {
                UnixNativeDispatcher.write(this.socketpair[1], this.address, 1);
            }
            catch (UnixException x) {
                throw new IOException(x.errorString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object implRegister(Path obj, Set<? extends WatchEvent.Kind<?>> events, WatchEvent.Modifier ... modifiers) {
            UnixPath dir = (UnixPath)obj;
            int mask = 0;
            for (WatchEvent.Kind<?> event : events) {
                if (event == StandardWatchEventKinds.ENTRY_CREATE) {
                    mask |= 0x180;
                    continue;
                }
                if (event == StandardWatchEventKinds.ENTRY_DELETE) {
                    mask |= 0x240;
                    continue;
                }
                if (event != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                mask |= 6;
            }
            if (modifiers.length > 0) {
                for (WatchEvent.Modifier modifier : modifiers) {
                    if (modifier == null) {
                        return new NullPointerException();
                    }
                    if (modifier instanceof SensitivityWatchEventModifier) continue;
                    return new UnsupportedOperationException("Modifier not supported");
                }
            }
            UnixFileAttributes attrs = null;
            try {
                attrs = UnixFileAttributes.get(dir, true);
            }
            catch (UnixException x) {
                return x.asIOException(dir);
            }
            if (!attrs.isDirectory()) {
                return new NotDirectoryException(dir.getPathForExecptionMessage());
            }
            int wd = -1;
            try {
                NativeBuffer buffer = NativeBuffers.asNativeBuffer(dir.getByteArrayForSysCalls());
                try {
                    wd = LinuxWatchService.inotifyAddWatch(this.ifd, buffer.address(), mask);
                }
                finally {
                    buffer.release();
                }
            }
            catch (UnixException x) {
                if (x.errno() == 28) {
                    return new IOException("User limit of inotify watches reached");
                }
                return x.asIOException(dir);
            }
            LinuxWatchKey key = this.wdToKey.get(wd);
            if (key == null) {
                key = new LinuxWatchKey(dir, this.watcher, this.ifd, wd);
                this.wdToKey.put(wd, key);
            }
            return key;
        }

        @Override
        void implCancelKey(WatchKey obj) {
            LinuxWatchKey key = (LinuxWatchKey)obj;
            if (key.isValid()) {
                this.wdToKey.remove(key.descriptor());
                key.invalidate(true);
            }
        }

        @Override
        void implCloseAll() {
            for (Map.Entry<Integer, LinuxWatchKey> entry : this.wdToKey.entrySet()) {
                entry.getValue().invalidate(true);
            }
            this.wdToKey.clear();
            unsafe.freeMemory(this.address);
            UnixNativeDispatcher.close(this.socketpair[0]);
            UnixNativeDispatcher.close(this.socketpair[1]);
            UnixNativeDispatcher.close(this.ifd);
        }

        @Override
        public void run() {
            try {
                block6: while (true) {
                    int bytesRead;
                    block13: {
                        int nReady = LinuxWatchService.poll(this.ifd, this.socketpair[0]);
                        try {
                            bytesRead = UnixNativeDispatcher.read(this.ifd, this.address, 8192);
                        }
                        catch (UnixException x) {
                            if (x.errno() != 11) {
                                throw x;
                            }
                            bytesRead = 0;
                        }
                        if (nReady > 1 || nReady == 1 && bytesRead == 0) {
                            try {
                                UnixNativeDispatcher.read(this.socketpair[0], this.address, 8192);
                                boolean shutdown = this.processRequests();
                                if (!shutdown) break block13;
                                break;
                            }
                            catch (UnixException x) {
                                if (x.errno() == 11) break block13;
                                throw x;
                            }
                        }
                    }
                    int offset = 0;
                    while (true) {
                        if (offset >= bytesRead) continue block6;
                        long event = this.address + (long)offset;
                        int wd = unsafe.getInt(event + (long)OFFSETOF_WD);
                        int mask = unsafe.getInt(event + (long)OFFSETOF_MASK);
                        int len = unsafe.getInt(event + (long)OFFSETOF_LEN);
                        UnixPath name = null;
                        if (len > 0) {
                            int actual;
                            for (actual = len; actual > 0; --actual) {
                                long last = event + (long)OFFSETOF_NAME + (long)actual - 1L;
                                if (unsafe.getByte(last) != 0) break;
                            }
                            if (actual > 0) {
                                byte[] buf = new byte[actual];
                                unsafe.copyMemory(null, event + (long)OFFSETOF_NAME, buf, Unsafe.ARRAY_BYTE_BASE_OFFSET, actual);
                                name = new UnixPath(this.fs, buf);
                            }
                        }
                        this.processEvent(wd, mask, name);
                        offset += SIZEOF_INOTIFY_EVENT + len;
                    }
                    break;
                }
            }
            catch (UnixException x) {
                x.printStackTrace();
            }
        }

        private WatchEvent.Kind<?> maskToEventKind(int mask) {
            if ((mask & 2) > 0) {
                return StandardWatchEventKinds.ENTRY_MODIFY;
            }
            if ((mask & 4) > 0) {
                return StandardWatchEventKinds.ENTRY_MODIFY;
            }
            if ((mask & 0x100) > 0) {
                return StandardWatchEventKinds.ENTRY_CREATE;
            }
            if ((mask & 0x80) > 0) {
                return StandardWatchEventKinds.ENTRY_CREATE;
            }
            if ((mask & 0x200) > 0) {
                return StandardWatchEventKinds.ENTRY_DELETE;
            }
            if ((mask & 0x40) > 0) {
                return StandardWatchEventKinds.ENTRY_DELETE;
            }
            return null;
        }

        private void processEvent(int wd, int mask, UnixPath name) {
            if ((mask & 0x4000) > 0) {
                for (Map.Entry<Integer, LinuxWatchKey> entry : this.wdToKey.entrySet()) {
                    entry.getValue().signalEvent(StandardWatchEventKinds.OVERFLOW, null);
                }
                return;
            }
            LinuxWatchKey key = this.wdToKey.get(wd);
            if (key == null) {
                return;
            }
            if ((mask & 0x8000) > 0) {
                this.wdToKey.remove(wd);
                key.invalidate(false);
                key.signal();
                return;
            }
            if (name == null) {
                return;
            }
            WatchEvent.Kind<?> kind = this.maskToEventKind(mask);
            if (kind != null) {
                key.signalEvent(kind, name);
            }
        }
    }

    private static class LinuxWatchKey
    extends AbstractWatchKey {
        private final int ifd;
        private volatile int wd;

        LinuxWatchKey(UnixPath dir, LinuxWatchService watcher, int ifd, int wd) {
            super(dir, watcher);
            this.ifd = ifd;
            this.wd = wd;
        }

        int descriptor() {
            return this.wd;
        }

        void invalidate(boolean remove) {
            if (remove) {
                try {
                    LinuxWatchService.inotifyRmWatch(this.ifd, this.wd);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
            }
            this.wd = -1;
        }

        @Override
        public boolean isValid() {
            return this.wd != -1;
        }

        @Override
        public void cancel() {
            if (this.isValid()) {
                ((LinuxWatchService)this.watcher()).poller.cancel(this);
            }
        }
    }
}

