/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.fs.LinuxFileStore;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.LinuxUserDefinedFileAttributeView;
import sun.nio.fs.LinuxWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;

class LinuxFileSystem
extends UnixFileSystem {
    LinuxFileSystem(UnixFileSystemProvider provider, String dir) {
        super(provider, dir);
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new LinuxWatchService(this);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews;
    }

    @Override
    void copyNonPosixAttributes(int ofd, int nfd) {
        LinuxUserDefinedFileAttributeView.copyExtendedAttributes(ofd, nfd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<UnixMountEntry> getMountEntries(String fstab) {
        ArrayList<UnixMountEntry> entries = new ArrayList<UnixMountEntry>();
        try {
            long fp = LinuxNativeDispatcher.setmntent(fstab.getBytes(), "r".getBytes());
            try {
                UnixMountEntry entry;
                int res;
                while ((res = LinuxNativeDispatcher.getextmntent(fp, entry = new UnixMountEntry())) >= 0) {
                    entries.add(entry);
                }
            }
            finally {
                LinuxNativeDispatcher.endmntent(fp);
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        return entries;
    }

    @Override
    Iterable<UnixMountEntry> getMountEntries() {
        return this.getMountEntries("/etc/mtab");
    }

    @Override
    FileStore getFileStore(UnixMountEntry entry) throws IOException {
        return new LinuxFileStore(this, entry);
    }

    private static class SupportedFileFileAttributeViewsHolder {
        static final Set<String> supportedFileAttributeViews = SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews();

        private SupportedFileFileAttributeViewsHolder() {
        }

        private static Set<String> supportedFileAttributeViews() {
            HashSet<String> result = new HashSet<String>();
            result.addAll(UnixFileSystem.standardFileAttributeViews());
            result.add("dos");
            result.add("user");
            return Collections.unmodifiableSet(result);
        }
    }
}

