/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.Util;

public class ServerSocketAdaptor
extends ServerSocket {
    private final ServerSocketChannelImpl ssc;
    private volatile int timeout = 0;

    public static ServerSocket create(ServerSocketChannelImpl ssc) {
        try {
            return new ServerSocketAdaptor(ssc);
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    private ServerSocketAdaptor(ServerSocketChannelImpl ssc) throws IOException {
        this.ssc = ssc;
    }

    @Override
    public void bind(SocketAddress local) throws IOException {
        this.bind(local, 50);
    }

    @Override
    public void bind(SocketAddress local, int backlog) throws IOException {
        if (local == null) {
            local = new InetSocketAddress(0);
        }
        try {
            this.ssc.bind(local, backlog);
        }
        catch (Exception x) {
            Net.translateException(x);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.ssc.isBound()) {
            return null;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getAddress();
    }

    @Override
    public int getLocalPort() {
        if (!this.ssc.isBound()) {
            return -1;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            if (!this.ssc.isBound()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (this.timeout == 0) {
                    SocketChannel sc = this.ssc.accept();
                    if (sc == null && !this.ssc.isBlocking()) {
                        throw new IllegalBlockingModeException();
                    }
                    return sc.socket();
                }
                SelectionKey sk = null;
                Selector sel = null;
                this.ssc.configureBlocking(false);
                try {
                    long st;
                    SocketChannel sc = this.ssc.accept();
                    if (sc != null) {
                        Socket socket = sc.socket();
                        return socket;
                    }
                    sel = Util.getTemporarySelector(this.ssc);
                    sk = this.ssc.register(sel, 16);
                    long to = this.timeout;
                    do {
                        if (!this.ssc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        st = System.currentTimeMillis();
                        int ns = sel.select(to);
                        if (ns > 0 && sk.isAcceptable() && (sc = this.ssc.accept()) != null) {
                            Socket socket = sc.socket();
                            return socket;
                        }
                        sel.selectedKeys().remove(sk);
                    } while ((to -= System.currentTimeMillis() - st) > 0L);
                    throw new SocketTimeoutException();
                }
                finally {
                    if (sk != null) {
                        sk.cancel();
                    }
                    if (this.ssc.isOpen()) {
                        this.ssc.configureBlocking(true);
                    }
                    if (sel != null) {
                        Util.releaseTemporarySelector(sel);
                    }
                }
            }
            catch (Exception x) {
                Net.translateException(x);
                assert (false);
                return null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ssc.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    @Override
    public boolean isBound() {
        return this.ssc.isBound();
    }

    @Override
    public boolean isClosed() {
        return !this.ssc.isOpen();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)on);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("size cannot be 0 or negative");
        }
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)size);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return -1;
        }
    }
}

