/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.StreamClosedException;
import sun.net.httpserver.WriteFinishedEvent;

class FixedLengthOutputStream
extends FilterOutputStream {
    private long remaining;
    private boolean eof = false;
    private boolean closed = false;
    ExchangeImpl t;

    FixedLengthOutputStream(ExchangeImpl t, OutputStream src, long len) {
        super(src);
        this.t = t;
        this.remaining = len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        boolean bl = this.eof = this.remaining == 0L;
        if (this.eof) {
            throw new StreamClosedException();
        }
        this.out.write(b);
        --this.remaining;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        boolean bl = this.eof = this.remaining == 0L;
        if (this.eof) {
            throw new StreamClosedException();
        }
        if ((long)len > this.remaining) {
            throw new IOException("too many bytes to write to stream");
        }
        this.out.write(b, off, len);
        this.remaining -= (long)len;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.remaining > 0L) {
            this.t.close();
            throw new IOException("insufficient bytes written to stream");
        }
        this.flush();
        this.eof = true;
        LeftOverInputStream is = this.t.getOriginalInputStream();
        if (!is.isClosed()) {
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        WriteFinishedEvent e = new WriteFinishedEvent(this.t);
        this.t.getHttpContext().getServerImpl().addEvent(e);
    }
}

