/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class Wrapper
extends Enum<Wrapper> {
    public static final /* enum */ Wrapper BOOLEAN = new Wrapper(Boolean.class, Boolean.TYPE, 'Z', false, new boolean[0], Format.unsigned(1));
    public static final /* enum */ Wrapper BYTE = new Wrapper(Byte.class, Byte.TYPE, 'B', (byte)0, new byte[0], Format.signed(8));
    public static final /* enum */ Wrapper SHORT = new Wrapper(Short.class, Short.TYPE, 'S', (short)0, new short[0], Format.signed(16));
    public static final /* enum */ Wrapper CHAR = new Wrapper(Character.class, Character.TYPE, 'C', Character.valueOf('\u0000'), new char[0], Format.unsigned(16));
    public static final /* enum */ Wrapper INT = new Wrapper(Integer.class, Integer.TYPE, 'I', 0, new int[0], Format.signed(32));
    public static final /* enum */ Wrapper LONG = new Wrapper(Long.class, Long.TYPE, 'J', 0L, new long[0], Format.signed(64));
    public static final /* enum */ Wrapper FLOAT = new Wrapper(Float.class, Float.TYPE, 'F', Float.valueOf(0.0f), new float[0], Format.floating(32));
    public static final /* enum */ Wrapper DOUBLE = new Wrapper(Double.class, Double.TYPE, 'D', 0.0, new double[0], Format.floating(64));
    public static final /* enum */ Wrapper OBJECT = new Wrapper(Object.class, Object.class, 'L', null, new Object[0], Format.other(1));
    public static final /* enum */ Wrapper VOID = new Wrapper(Void.class, Void.TYPE, 'V', null, null, Format.other(0));
    private final Class<?> wrapperType;
    private final Class<?> primitiveType;
    private final char basicTypeChar;
    private final Object zero;
    private final Object emptyArray;
    private final int format;
    private final String simpleName;
    private static final Wrapper[] FROM_PRIM;
    private static final Wrapper[] FROM_WRAP;
    private static final Wrapper[] FROM_CHAR;
    private static final /* synthetic */ Wrapper[] $VALUES;

    public static Wrapper[] values() {
        return (Wrapper[])$VALUES.clone();
    }

    public static Wrapper valueOf(String name) {
        return Enum.valueOf(Wrapper.class, name);
    }

    private Wrapper(Class<?> wtype, Class<?> ptype, char tchar, Object zero, Object emptyArray, int format) {
        this.wrapperType = wtype;
        this.primitiveType = ptype;
        this.basicTypeChar = tchar;
        this.zero = zero;
        this.emptyArray = emptyArray;
        this.format = format;
        this.simpleName = wtype.getSimpleName();
    }

    public String detailString() {
        return this.simpleName + Arrays.asList(this.wrapperType, this.primitiveType, Character.valueOf(this.basicTypeChar), this.zero, "0x" + Integer.toHexString(this.format));
    }

    public int bitWidth() {
        return this.format >> 2 & 0x3FF;
    }

    public int stackSlots() {
        return this.format >> 0 & 3;
    }

    public boolean isSingleWord() {
        return (this.format & 1) != 0;
    }

    public boolean isDoubleWord() {
        return (this.format & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.format & 0xFFFFFFFC) != 0;
    }

    public boolean isIntegral() {
        return this.isNumeric() && this.format < 4225;
    }

    public boolean isSubwordOrInt() {
        return this.isIntegral() && this.isSingleWord();
    }

    public boolean isSigned() {
        return this.format < 0;
    }

    public boolean isUnsigned() {
        return this.format >= 5 && this.format < 4225;
    }

    public boolean isFloating() {
        return this.format >= 4225;
    }

    public boolean isOther() {
        return (this.format & 0xFFFFFFFC) == 0;
    }

    public boolean isConvertibleFrom(Wrapper source) {
        boolean floatOrSigned;
        if (this == source) {
            return true;
        }
        if (this.compareTo(source) < 0) {
            return false;
        }
        boolean bl = floatOrSigned = (this.format & source.format & 0xFFFFF000) != 0;
        if (!floatOrSigned) {
            if (this.isOther()) {
                return true;
            }
            return source.format == 65;
        }
        assert (this.isFloating() || this.isSigned());
        assert (source.isFloating() || source.isSigned());
        return true;
    }

    private static boolean checkConvertibleFrom() {
        for (Wrapper w : Wrapper.values()) {
            assert (w.isConvertibleFrom(w));
            assert (VOID.isConvertibleFrom(w));
            if (w != VOID) {
                assert (OBJECT.isConvertibleFrom(w));
                assert (!w.isConvertibleFrom(VOID));
            }
            if (w != CHAR) {
                assert (!CHAR.isConvertibleFrom(w));
                if (!w.isConvertibleFrom(INT)) assert (!w.isConvertibleFrom(CHAR));
            }
            if (w != BOOLEAN) {
                assert (!BOOLEAN.isConvertibleFrom(w));
                if (w != VOID && w != OBJECT) assert (!w.isConvertibleFrom(BOOLEAN));
            }
            if (w.isSigned()) {
                for (Wrapper x : Wrapper.values()) {
                    if (w != x && (x.isFloating() ? !$assertionsDisabled && w.isConvertibleFrom(x) : x.isSigned() && (w.compareTo(x) < 0 ? !$assertionsDisabled && w.isConvertibleFrom(x) : !$assertionsDisabled && !w.isConvertibleFrom(x)))) {
                        throw new AssertionError();
                    }
                }
            }
            if (!w.isFloating()) continue;
            for (Wrapper x : Wrapper.values()) {
                if (w != x && (x.isSigned() ? !$assertionsDisabled && !w.isConvertibleFrom(x) : x.isFloating() && (w.compareTo(x) < 0 ? !$assertionsDisabled && w.isConvertibleFrom(x) : !$assertionsDisabled && !w.isConvertibleFrom(x)))) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    public Object zero() {
        return this.zero;
    }

    public <T> T zero(Class<T> type) {
        return this.convert(this.zero, type);
    }

    public static Wrapper forPrimitiveType(Class<?> type) {
        Wrapper w = Wrapper.findPrimitiveType(type);
        if (w != null) {
            return w;
        }
        if (type.isPrimitive()) {
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not primitive: " + type);
    }

    static Wrapper findPrimitiveType(Class<?> type) {
        Wrapper w = FROM_PRIM[Wrapper.hashPrim(type)];
        if (w != null && w.primitiveType == type) {
            return w;
        }
        return null;
    }

    public static Wrapper forWrapperType(Class<?> type) {
        Wrapper w = Wrapper.findWrapperType(type);
        if (w != null) {
            return w;
        }
        for (Wrapper x : Wrapper.values()) {
            if (x.wrapperType != type) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not wrapper: " + type);
    }

    static Wrapper findWrapperType(Class<?> type) {
        Wrapper w = FROM_WRAP[Wrapper.hashWrap(type)];
        if (w != null && w.wrapperType == type) {
            return w;
        }
        return null;
    }

    public static Wrapper forBasicType(char type) {
        Wrapper w = FROM_CHAR[Wrapper.hashChar(type)];
        if (w != null && w.basicTypeChar == type) {
            return w;
        }
        for (Wrapper x : Wrapper.values()) {
            if (w.basicTypeChar != type) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not basic type char: " + type);
    }

    public static Wrapper forBasicType(Class<?> type) {
        if (type.isPrimitive()) {
            return Wrapper.forPrimitiveType(type);
        }
        return OBJECT;
    }

    private static int hashPrim(Class<?> x) {
        String xn = x.getName();
        if (xn.length() < 3) {
            return 0;
        }
        return (xn.charAt(0) + xn.charAt(2)) % 16;
    }

    private static int hashWrap(Class<?> x) {
        String xn = x.getName();
        int offset = 10;
        assert (10 == "java.lang.".length());
        if (xn.length() < 13) {
            return 0;
        }
        return (3 * xn.charAt(11) + xn.charAt(12)) % 16;
    }

    private static int hashChar(char x) {
        return (x + (x >> 1)) % 16;
    }

    public Class<?> primitiveType() {
        return this.primitiveType;
    }

    public Class<?> wrapperType() {
        return this.wrapperType;
    }

    public <T> Class<T> wrapperType(Class<T> exampleType) {
        if (exampleType == this.wrapperType) {
            return exampleType;
        }
        if (exampleType == this.primitiveType || this.wrapperType == Object.class || exampleType.isInterface()) {
            return Wrapper.forceType(this.wrapperType, exampleType);
        }
        throw Wrapper.newClassCastException(exampleType, this.primitiveType);
    }

    private static ClassCastException newClassCastException(Class<?> actual, Class<?> expected) {
        return new ClassCastException(actual + " is not compatible with " + expected);
    }

    public static <T> Class<T> asWrapperType(Class<T> type) {
        if (type.isPrimitive()) {
            return Wrapper.forPrimitiveType(type).wrapperType(type);
        }
        return type;
    }

    public static <T> Class<T> asPrimitiveType(Class<T> type) {
        Wrapper w = Wrapper.findWrapperType(type);
        if (w != null) {
            return Wrapper.forceType(w.primitiveType(), type);
        }
        return type;
    }

    public static boolean isWrapperType(Class<?> type) {
        return Wrapper.findWrapperType(type) != null;
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type.isPrimitive();
    }

    public static char basicTypeChar(Class<?> type) {
        if (!type.isPrimitive()) {
            return 'L';
        }
        return Wrapper.forPrimitiveType(type).basicTypeChar();
    }

    public char basicTypeChar() {
        return this.basicTypeChar;
    }

    public String simpleName() {
        return this.simpleName;
    }

    public <T> T cast(Object x, Class<T> type) {
        return this.convert(x, type, true);
    }

    public <T> T convert(Object x, Class<T> type) {
        return this.convert(x, type, false);
    }

    private <T> T convert(Object x, Class<T> type, boolean isCast) {
        Wrapper source;
        if (this == OBJECT) {
            Object result = x;
            return (T)result;
        }
        Class<T> wtype = this.wrapperType(type);
        if (wtype.isInstance(x)) {
            Object result = x;
            return (T)result;
        }
        Class<?> sourceType = x.getClass();
        if (!(isCast || (source = Wrapper.findWrapperType(sourceType)) != null && this.isConvertibleFrom(source))) {
            throw Wrapper.newClassCastException(wtype, sourceType);
        }
        Object result = this.wrap(x);
        assert (result.getClass() == wtype);
        return (T)result;
    }

    static <T> Class<T> forceType(Class<?> type, Class<T> exampleType) {
        boolean z;
        boolean bl = z = type == exampleType || type.isPrimitive() && Wrapper.forPrimitiveType(type) == Wrapper.findWrapperType(exampleType) || exampleType.isPrimitive() && Wrapper.forPrimitiveType(exampleType) == Wrapper.findWrapperType(type) || type == Object.class && !exampleType.isPrimitive();
        if (!z) {
            System.out.println(type + " <= " + exampleType);
        }
        assert (type == exampleType || type.isPrimitive() && Wrapper.forPrimitiveType(type) == Wrapper.findWrapperType(exampleType) || exampleType.isPrimitive() && Wrapper.forPrimitiveType(exampleType) == Wrapper.findWrapperType(type) || type == Object.class && !exampleType.isPrimitive());
        Class<?> result = type;
        return result;
    }

    public Object wrap(Object x) {
        switch (this.basicTypeChar) {
            case 'L': {
                return x;
            }
            case 'V': {
                return null;
            }
        }
        Number xn = Wrapper.numberValue(x);
        switch (this.basicTypeChar) {
            case 'I': {
                return xn.intValue();
            }
            case 'J': {
                return xn.longValue();
            }
            case 'F': {
                return Float.valueOf(xn.floatValue());
            }
            case 'D': {
                return xn.doubleValue();
            }
            case 'S': {
                return (short)xn.intValue();
            }
            case 'B': {
                return (byte)xn.intValue();
            }
            case 'C': {
                return Character.valueOf((char)xn.intValue());
            }
            case 'Z': {
                return Wrapper.boolValue(xn.longValue());
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrap(int x) {
        if (this.basicTypeChar == 'L') {
            return x;
        }
        switch (this.basicTypeChar) {
            case 'L': {
                throw Wrapper.newIllegalArgumentException("cannot wrap to object type");
            }
            case 'V': {
                return null;
            }
            case 'I': {
                return x;
            }
            case 'J': {
                return (long)x;
            }
            case 'F': {
                return Float.valueOf(x);
            }
            case 'D': {
                return (double)x;
            }
            case 'S': {
                return (short)x;
            }
            case 'B': {
                return (byte)x;
            }
            case 'C': {
                return Character.valueOf((char)x);
            }
            case 'Z': {
                return Wrapper.boolValue(x);
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrapRaw(long x) {
        switch (this.basicTypeChar) {
            case 'F': {
                return Float.valueOf(Float.intBitsToFloat((int)x));
            }
            case 'D': {
                return Double.longBitsToDouble(x);
            }
            case 'J': 
            case 'L': {
                return x;
            }
        }
        return this.wrap((int)x);
    }

    public long unwrapRaw(Object x) {
        switch (this.basicTypeChar) {
            case 'F': {
                return Float.floatToRawIntBits(((Float)x).floatValue());
            }
            case 'D': {
                return Double.doubleToRawLongBits((Double)x);
            }
            case 'L': {
                throw Wrapper.newIllegalArgumentException("cannot unwrap from sobject type");
            }
            case 'V': {
                return 0L;
            }
            case 'I': {
                return ((Integer)x).intValue();
            }
            case 'J': {
                return (Long)x;
            }
            case 'S': {
                return ((Short)x).shortValue();
            }
            case 'B': {
                return ((Byte)x).byteValue();
            }
            case 'C': {
                return ((Character)x).charValue();
            }
            case 'Z': {
                return (Boolean)x != false ? 1L : 0L;
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Class<?> rawPrimitiveType() {
        return this.rawPrimitive().primitiveType();
    }

    public Wrapper rawPrimitive() {
        switch (this.basicTypeChar) {
            case 'B': 
            case 'C': 
            case 'F': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return INT;
            }
            case 'D': {
                return LONG;
            }
        }
        return this;
    }

    private static Number numberValue(Object x) {
        if (x instanceof Number) {
            return (Number)x;
        }
        if (x instanceof Character) {
            return (int)((Character)x).charValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        return (Number)x;
    }

    private static boolean boolValue(long bits) {
        return (bits &= 1L) != 0L;
    }

    private static RuntimeException newIllegalArgumentException(String message, Object x) {
        return Wrapper.newIllegalArgumentException(message + x);
    }

    private static RuntimeException newIllegalArgumentException(String message) {
        return new IllegalArgumentException(message);
    }

    public Object makeArray(int len) {
        return Array.newInstance(this.primitiveType, len);
    }

    public Class<?> arrayType() {
        return this.emptyArray.getClass();
    }

    public void copyArrayUnboxing(Object[] values, int vpos, Object a, int apos, int length) {
        if (a.getClass() != this.arrayType()) {
            this.arrayType().cast(a);
        }
        for (int i = 0; i < length; ++i) {
            Object value = values[i + vpos];
            value = this.convert(value, this.primitiveType);
            Array.set(a, i + apos, value);
        }
    }

    public void copyArrayBoxing(Object a, int apos, Object[] values, int vpos, int length) {
        if (a.getClass() != this.arrayType()) {
            this.arrayType().cast(a);
        }
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(a, i + apos);
            assert (value.getClass() == this.wrapperType);
            values[i + vpos] = value;
        }
    }

    static {
        $VALUES = new Wrapper[]{BOOLEAN, BYTE, SHORT, CHAR, INT, LONG, FLOAT, DOUBLE, OBJECT, VOID};
        assert (Wrapper.checkConvertibleFrom());
        FROM_PRIM = new Wrapper[16];
        FROM_WRAP = new Wrapper[16];
        FROM_CHAR = new Wrapper[16];
        for (Wrapper w : Wrapper.values()) {
            int pi = Wrapper.hashPrim(w.primitiveType);
            int wi = Wrapper.hashWrap(w.wrapperType);
            int ci = Wrapper.hashChar(w.basicTypeChar);
            assert (FROM_PRIM[pi] == null);
            assert (FROM_WRAP[wi] == null);
            assert (FROM_CHAR[ci] == null);
            Wrapper.FROM_PRIM[pi] = w;
            Wrapper.FROM_WRAP[wi] = w;
            Wrapper.FROM_CHAR[ci] = w;
        }
    }

    private static abstract class Format {
        static final int SLOT_SHIFT = 0;
        static final int SIZE_SHIFT = 2;
        static final int KIND_SHIFT = 12;
        static final int SIGNED = -4096;
        static final int UNSIGNED = 0;
        static final int FLOATING = 4096;
        static final int SLOT_MASK = 3;
        static final int SIZE_MASK = 1023;
        static final int INT = -3967;
        static final int SHORT = -4031;
        static final int BOOLEAN = 5;
        static final int CHAR = 65;
        static final int FLOAT = 4225;
        static final int VOID = 0;
        static final int NUM_MASK = -4;

        private Format() {
        }

        static int format(int kind, int size, int slots) {
            assert (kind >> 12 << 12 == kind);
            assert ((size & size - 1) == 0);
            assert (kind == -4096 ? size > 0 : (kind == 0 ? size > 0 : kind == 4096 && (size == 32 || size == 64)));
            assert (slots == 2 ? size == 64 : slots == 1 && size <= 32);
            return kind | size << 2 | slots << 0;
        }

        static int signed(int size) {
            return Format.format(-4096, size, size > 32 ? 2 : 1);
        }

        static int unsigned(int size) {
            return Format.format(0, size, size > 32 ? 2 : 1);
        }

        static int floating(int size) {
            return Format.format(4096, size, size > 32 ? 2 : 1);
        }

        static int other(int slots) {
            return slots << 0;
        }
    }
}

