/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import sun.font.Font2D;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.GlyphLayout;
import sun.font.TextRecord;
import sun.font.TrueTypeFont;

public final class SunLayoutEngine
implements GlyphLayout.LayoutEngine,
GlyphLayout.LayoutEngineFactory {
    private GlyphLayout.LayoutEngineKey key;
    private static GlyphLayout.LayoutEngineFactory instance;
    private SoftReference cacheref = new SoftReference<Object>(null);

    private static native void initGVIDs();

    public static GlyphLayout.LayoutEngineFactory instance() {
        if (instance == null) {
            instance = new SunLayoutEngine();
        }
        return instance;
    }

    private SunLayoutEngine() {
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(Font2D font, int script, int lang) {
        return this.getEngine(new GlyphLayout.LayoutEngineKey(font, script, lang));
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(GlyphLayout.LayoutEngineKey key) {
        GlyphLayout.LayoutEngine e;
        HashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine> cache = (HashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>)this.cacheref.get();
        if (cache == null) {
            cache = new HashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>();
            this.cacheref = new SoftReference(cache);
        }
        if ((e = (GlyphLayout.LayoutEngine)cache.get(key)) == null) {
            e = new SunLayoutEngine(key.copy());
            cache.put(key, e);
        }
        return e;
    }

    private SunLayoutEngine(GlyphLayout.LayoutEngineKey key) {
        this.key = key;
    }

    @Override
    public void layout(FontStrikeDesc desc, float[] mat, int gmask, int baseIndex, TextRecord tr, int typo_flags, Point2D.Float pt, GlyphLayout.GVData data) {
        Font2D font = this.key.font();
        FontStrike strike = font.getStrike(desc);
        long layoutTables = 0L;
        if (font instanceof TrueTypeFont) {
            layoutTables = ((TrueTypeFont)font).getLayoutTableCache();
        }
        SunLayoutEngine.nativeLayout(font, strike, mat, gmask, baseIndex, tr.text, tr.start, tr.limit, tr.min, tr.max, this.key.script(), this.key.lang(), typo_flags, pt, data, font.getUnitsPerEm(), layoutTables);
    }

    private static native void nativeLayout(Font2D var0, FontStrike var1, float[] var2, int var3, int var4, char[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Point2D.Float var13, GlyphLayout.GVData var14, long var15, long var17);

    static {
        FontManagerNativeLibrary.load();
        SunLayoutEngine.initGVIDs();
    }
}

