/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import sun.awt.datatransfer.DataTransferer;

public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static String JavaMIME = "JAVA_DATAFLAVOR:";
    private static final WeakHashMap flavorMaps = new WeakHashMap();
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String[] UNICODE_TEXT_CLASSES = new String[]{"java.io.Reader", "java.lang.String", "java.nio.CharBuffer", "\"[C\""};
    private static final String[] ENCODED_TEXT_CLASSES = new String[]{"java.io.InputStream", "java.nio.ByteBuffer", "\"[B\""};
    private static final String TEXT_PLAIN_BASE_TYPE = "text/plain";
    private static final boolean SYNTHESIZE_IF_NOT_FOUND = true;
    private Map nativeToFlavor = new HashMap();
    private Map flavorToNative = new HashMap();
    private boolean isMapInitialized = false;
    private Map getNativesForFlavorCache = new HashMap();
    private Map getFlavorsForNativeCache = new HashMap();
    private Set disabledMappingGenerationKeys = new HashSet();

    private Map getNativeToFlavor() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
        }
        return this.nativeToFlavor;
    }

    private synchronized Map getFlavorToNative() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
        }
        return this.flavorToNative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlavorMap getDefaultFlavorMap() {
        FlavorMap fm;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        WeakHashMap weakHashMap = flavorMaps;
        synchronized (weakHashMap) {
            fm = (FlavorMap)flavorMaps.get(contextClassLoader);
            if (fm == null) {
                fm = new SystemFlavorMap();
                flavorMaps.put(contextClassLoader, fm);
            }
        }
        return fm;
    }

    private SystemFlavorMap() {
    }

    private void initSystemFlavorMap() {
        if (this.isMapInitialized) {
            return;
        }
        this.isMapInitialized = true;
        BufferedReader flavormapDotProperties = AccessController.doPrivileged(new PrivilegedAction<BufferedReader>(){

            @Override
            public BufferedReader run() {
                String fileName = System.getProperty("java.home") + File.separator + "lib" + File.separator + "flavormap.properties";
                try {
                    return new BufferedReader(new InputStreamReader(new File(fileName).toURI().toURL().openStream(), "ISO-8859-1"));
                }
                catch (MalformedURLException e) {
                    System.err.println("MalformedURLException:" + e + " while loading default flavormap.properties file:" + fileName);
                }
                catch (IOException e) {
                    System.err.println("IOException:" + e + " while loading default flavormap.properties file:" + fileName);
                }
                return null;
            }
        });
        BufferedReader flavormapURL = AccessController.doPrivileged(new PrivilegedAction<BufferedReader>(){

            @Override
            public BufferedReader run() {
                String url = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                if (url == null) {
                    return null;
                }
                try {
                    return new BufferedReader(new InputStreamReader(new URL(url).openStream(), "ISO-8859-1"));
                }
                catch (MalformedURLException e) {
                    System.err.println("MalformedURLException:" + e + " while reading AWT.DnD.flavorMapFileURL:" + url);
                }
                catch (IOException e) {
                    System.err.println("IOException:" + e + " while reading AWT.DnD.flavorMapFileURL:" + url);
                }
                return null;
            }
        });
        if (flavormapDotProperties != null) {
            try {
                this.parseAndStoreReader(flavormapDotProperties);
            }
            catch (IOException e) {
                System.err.println("IOException:" + e + " while parsing default flavormap.properties file");
            }
        }
        if (flavormapURL != null) {
            try {
                this.parseAndStoreReader(flavormapURL);
            }
            catch (IOException e) {
                System.err.println("IOException:" + e + " while parsing AWT.DnD.flavorMapFileURL");
            }
        }
    }

    private void parseAndStoreReader(BufferedReader in) throws IOException {
        while (true) {
            DataFlavor flavor;
            String value;
            String key;
            block19: {
                int valueIndex;
                int separatorIndex;
                int keyStart;
                char firstChar;
                String line;
                if ((line = in.readLine()) == null) {
                    return;
                }
                if (line.length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
                while (this.continueLine(line)) {
                    int startIndex;
                    String nextLine = in.readLine();
                    if (nextLine == null) {
                        nextLine = "";
                    }
                    String loppedLine = line.substring(0, line.length() - 1);
                    for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                    }
                    nextLine = nextLine.substring(startIndex, nextLine.length());
                    line = loppedLine + nextLine;
                }
                int len = line.length();
                for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                if (keyStart == len) continue;
                for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                    char currentChar = line.charAt(separatorIndex);
                    if (currentChar == '\\') {
                        ++separatorIndex;
                        continue;
                    }
                    if (keyValueSeparators.indexOf(currentChar) != -1) break;
                }
                for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
                }
                if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                    ++valueIndex;
                }
                while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                    ++valueIndex;
                }
                key = line.substring(keyStart, separatorIndex);
                value = separatorIndex < len ? line.substring(valueIndex, len) : "";
                key = this.loadConvert(key);
                value = this.loadConvert(value);
                try {
                    DataTransferer transferer;
                    MimeType mime = new MimeType(value);
                    if (!"text".equals(mime.getPrimaryType())) break block19;
                    String charset = mime.getParameter("charset");
                    if (DataTransferer.doesSubtypeSupportCharset(mime.getSubType(), charset) && (transferer = DataTransferer.getInstance()) != null) {
                        transferer.registerTextFlavorProperties(key, charset, mime.getParameter("eoln"), mime.getParameter("terminators"));
                    }
                    mime.removeParameter("charset");
                    mime.removeParameter("class");
                    mime.removeParameter("eoln");
                    mime.removeParameter("terminators");
                    value = mime.toString();
                }
                catch (MimeTypeParseException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            try {
                flavor = new DataFlavor(value);
            }
            catch (Exception e) {
                try {
                    flavor = new DataFlavor(value, (String)null);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    continue;
                }
            }
            if ("text".equals(flavor.getPrimaryType())) {
                this.store(value, key, this.getFlavorToNative());
                this.store(key, value, this.getNativeToFlavor());
                continue;
            }
            this.store(flavor, key, this.getFlavorToNative());
            this.store(key, flavor, this.getNativeToFlavor());
        }
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private void store(Object hashed, Object listed, Map map) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(hashed);
        if (list == null) {
            list = new ArrayList<Object>(1);
            map.put(hashed, list);
        }
        if (!list.contains(listed)) {
            list.add(listed);
        }
    }

    private List nativeToFlavorLookup(String nat) {
        List platformFlavors;
        DataTransferer transferer;
        ArrayList<DataFlavor> flavors = (ArrayList<DataFlavor>)this.getNativeToFlavor().get(nat);
        if (nat != null && !this.disabledMappingGenerationKeys.contains(nat) && (transferer = DataTransferer.getInstance()) != null && !(platformFlavors = transferer.getPlatformMappingsForNative(nat)).isEmpty()) {
            if (flavors != null) {
                platformFlavors.removeAll(new HashSet(flavors));
                platformFlavors.addAll(flavors);
            }
            flavors = platformFlavors;
        }
        if (flavors == null && SystemFlavorMap.isJavaMIMEType(nat)) {
            String decoded = SystemFlavorMap.decodeJavaMIMEType(nat);
            DataFlavor flavor = null;
            try {
                flavor = new DataFlavor(decoded);
            }
            catch (Exception e) {
                System.err.println("Exception \"" + e.getClass().getName() + ": " + e.getMessage() + "\"while constructing DataFlavor for: " + decoded);
            }
            if (flavor != null) {
                flavors = new ArrayList<DataFlavor>(1);
                this.getNativeToFlavor().put(nat, flavors);
                flavors.add(flavor);
                this.getFlavorsForNativeCache.remove(nat);
                this.getFlavorsForNativeCache.remove(null);
                ArrayList<String> natives = (ArrayList<String>)this.getFlavorToNative().get(flavor);
                if (natives == null) {
                    natives = new ArrayList<String>(1);
                    this.getFlavorToNative().put(flavor, natives);
                }
                natives.add(nat);
                this.getNativesForFlavorCache.remove(flavor);
                this.getNativesForFlavorCache.remove(null);
            }
        }
        return flavors != null ? flavors : new ArrayList(0);
    }

    private List flavorToNativeLookup(DataFlavor flav, boolean synthesize) {
        List platformNatives;
        DataTransferer transferer;
        List<String> natives = (ArrayList<String>)this.getFlavorToNative().get(flav);
        if (flav != null && !this.disabledMappingGenerationKeys.contains(flav) && (transferer = DataTransferer.getInstance()) != null && !(platformNatives = transferer.getPlatformMappingsForFlavor(flav)).isEmpty()) {
            if (natives != null) {
                platformNatives.removeAll(new HashSet(natives));
                platformNatives.addAll(natives);
            }
            natives = platformNatives;
        }
        if (natives == null) {
            if (synthesize) {
                String encoded = SystemFlavorMap.encodeDataFlavor(flav);
                natives = new ArrayList(1);
                this.getFlavorToNative().put(flav, natives);
                natives.add(encoded);
                this.getNativesForFlavorCache.remove(flav);
                this.getNativesForFlavorCache.remove(null);
                ArrayList<DataFlavor> flavors = (ArrayList<DataFlavor>)this.getNativeToFlavor().get(encoded);
                if (flavors == null) {
                    flavors = new ArrayList<DataFlavor>(1);
                    this.getNativeToFlavor().put(encoded, flavors);
                }
                flavors.add(flav);
                this.getFlavorsForNativeCache.remove(encoded);
                this.getFlavorsForNativeCache.remove(null);
            } else {
                natives = new ArrayList<String>(0);
            }
        }
        return natives;
    }

    @Override
    public synchronized List<String> getNativesForFlavor(DataFlavor flav) {
        List<Object> retval = null;
        SoftReference ref = (SoftReference)this.getNativesForFlavorCache.get(flav);
        if (ref != null && (retval = (ArrayList)ref.get()) != null) {
            return new ArrayList<String>(retval);
        }
        if (flav == null) {
            retval = new ArrayList(this.getNativeToFlavor().keySet());
        } else if (this.disabledMappingGenerationKeys.contains(flav)) {
            retval = this.flavorToNativeLookup(flav, false);
        } else if (DataTransferer.isFlavorCharsetTextType(flav)) {
            ArrayList textPlainList;
            if ("text".equals(flav.getPrimaryType()) && (retval = (List)this.getFlavorToNative().get(flav.mimeType.getBaseType())) != null) {
                retval = new ArrayList<Object>(retval);
            }
            if ((textPlainList = (ArrayList)this.getFlavorToNative().get(TEXT_PLAIN_BASE_TYPE)) != null && !textPlainList.isEmpty()) {
                textPlainList = new ArrayList(textPlainList);
                if (retval != null && !retval.isEmpty()) {
                    textPlainList.removeAll(new HashSet<Object>(retval));
                    retval.addAll(textPlainList);
                } else {
                    retval = textPlainList;
                }
            }
            if (retval == null || retval.isEmpty()) {
                retval = this.flavorToNativeLookup(flav, true);
            } else {
                ArrayList explicitList = this.flavorToNativeLookup(flav, false);
                if (!explicitList.isEmpty()) {
                    explicitList = new ArrayList(explicitList);
                    explicitList.removeAll(new HashSet<Object>(retval));
                    retval.addAll(explicitList);
                }
            }
        } else if (DataTransferer.isFlavorNoncharsetTextType(flav)) {
            retval = (List)this.getFlavorToNative().get(flav.mimeType.getBaseType());
            if (retval == null || retval.isEmpty()) {
                retval = this.flavorToNativeLookup(flav, true);
            } else {
                ArrayList explicitList = this.flavorToNativeLookup(flav, false);
                if (!explicitList.isEmpty()) {
                    retval = new ArrayList<Object>(retval);
                    explicitList = new ArrayList(explicitList);
                    explicitList.removeAll(new HashSet<Object>(retval));
                    retval.addAll(explicitList);
                }
            }
        } else {
            retval = this.flavorToNativeLookup(flav, true);
        }
        this.getNativesForFlavorCache.put(flav, new SoftReference(retval));
        return new ArrayList<String>(retval);
    }

    @Override
    public synchronized List<DataFlavor> getFlavorsForNative(String nat) {
        AbstractList retval;
        SoftReference ref = (SoftReference)this.getFlavorsForNativeCache.get(nat);
        if (ref != null && (retval = (ArrayList)ref.get()) != null) {
            return (List)((ArrayList)retval).clone();
        }
        retval = new LinkedList();
        if (nat == null) {
            List<String> natives = this.getNativesForFlavor(null);
            HashSet<DataFlavor> dups = new HashSet<DataFlavor>(natives.size());
            Iterator<String> natives_iter = natives.iterator();
            while (natives_iter.hasNext()) {
                List<DataFlavor> flavors = this.getFlavorsForNative(natives_iter.next());
                for (DataFlavor flavor : flavors) {
                    if (!dups.add(flavor)) continue;
                    ((LinkedList)retval).add(flavor);
                }
            }
        } else {
            List flavors = this.nativeToFlavorLookup(nat);
            if (this.disabledMappingGenerationKeys.contains(nat)) {
                return flavors;
            }
            HashSet<DataFlavor> dups = new HashSet<DataFlavor>(flavors.size());
            List flavorsAndbaseTypes = this.nativeToFlavorLookup(nat);
            for (Object value : flavorsAndbaseTypes) {
                if (value instanceof String) {
                    DataFlavor toAdd;
                    String subType;
                    String baseType;
                    block23: {
                        baseType = (String)value;
                        subType = null;
                        try {
                            MimeType mimeType = new MimeType(baseType);
                            subType = mimeType.getSubType();
                        }
                        catch (MimeTypeParseException mtpe) {
                            if ($assertionsDisabled) break block23;
                            throw new AssertionError();
                        }
                    }
                    if (DataTransferer.doesSubtypeSupportCharset(subType, null)) {
                        if (TEXT_PLAIN_BASE_TYPE.equals(baseType) && dups.add(DataFlavor.stringFlavor)) {
                            ((LinkedList)retval).add(DataFlavor.stringFlavor);
                        }
                        for (int i = 0; i < UNICODE_TEXT_CLASSES.length; ++i) {
                            toAdd = null;
                            try {
                                toAdd = new DataFlavor(baseType + ";charset=Unicode;class=" + UNICODE_TEXT_CLASSES[i]);
                            }
                            catch (ClassNotFoundException cannotHappen) {
                                // empty catch block
                            }
                            if (!dups.add(toAdd)) continue;
                            ((LinkedList)retval).add(toAdd);
                        }
                        Iterator charset_iter = DataTransferer.standardEncodings();
                        while (charset_iter.hasNext()) {
                            String charset = (String)charset_iter.next();
                            for (int i = 0; i < ENCODED_TEXT_CLASSES.length; ++i) {
                                DataFlavor toAdd2 = null;
                                try {
                                    toAdd2 = new DataFlavor(baseType + ";charset=" + charset + ";class=" + ENCODED_TEXT_CLASSES[i]);
                                }
                                catch (ClassNotFoundException cannotHappen) {
                                    // empty catch block
                                }
                                if (toAdd2.equals(DataFlavor.plainTextFlavor)) {
                                    toAdd2 = DataFlavor.plainTextFlavor;
                                }
                                if (!dups.add(toAdd2)) continue;
                                ((LinkedList)retval).add(toAdd2);
                            }
                        }
                        if (!TEXT_PLAIN_BASE_TYPE.equals(baseType) || !dups.add(DataFlavor.plainTextFlavor)) continue;
                        ((LinkedList)retval).add(DataFlavor.plainTextFlavor);
                        continue;
                    }
                    for (int i = 0; i < ENCODED_TEXT_CLASSES.length; ++i) {
                        toAdd = null;
                        try {
                            toAdd = new DataFlavor(baseType + ";class=" + ENCODED_TEXT_CLASSES[i]);
                        }
                        catch (ClassNotFoundException cannotHappen) {
                            // empty catch block
                        }
                        if (!dups.add(toAdd)) continue;
                        ((LinkedList)retval).add(toAdd);
                    }
                    continue;
                }
                DataFlavor flavor = (DataFlavor)value;
                if (!dups.add(flavor)) continue;
                ((LinkedList)retval).add(flavor);
            }
        }
        ArrayList arrayList = new ArrayList(retval);
        this.getFlavorsForNativeCache.put(nat, new SoftReference(arrayList));
        return (List)arrayList.clone();
    }

    @Override
    public synchronized Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] flavors) {
        if (flavors == null) {
            List<DataFlavor> flavor_list = this.getFlavorsForNative(null);
            flavors = new DataFlavor[flavor_list.size()];
            flavor_list.toArray(flavors);
        }
        HashMap<DataFlavor, String> retval = new HashMap<DataFlavor, String>(flavors.length, 1.0f);
        for (int i = 0; i < flavors.length; ++i) {
            List<String> natives = this.getNativesForFlavor(flavors[i]);
            String nat = natives.isEmpty() ? null : natives.get(0);
            retval.put(flavors[i], nat);
        }
        return retval;
    }

    @Override
    public synchronized Map<String, DataFlavor> getFlavorsForNatives(String[] natives) {
        if (natives == null) {
            List<String> native_list = this.getNativesForFlavor(null);
            natives = new String[native_list.size()];
            native_list.toArray(natives);
        }
        HashMap<String, DataFlavor> retval = new HashMap<String, DataFlavor>(natives.length, 1.0f);
        for (int i = 0; i < natives.length; ++i) {
            List<DataFlavor> flavors = this.getFlavorsForNative(natives[i]);
            DataFlavor flav = flavors.isEmpty() ? null : flavors.get(0);
            retval.put(natives[i], flav);
        }
        return retval;
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor flav, String nat) {
        if (flav == null || nat == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        ArrayList<String> natives = (ArrayList<String>)this.getFlavorToNative().get(flav);
        if (natives == null) {
            natives = new ArrayList<String>(1);
            this.getFlavorToNative().put(flav, natives);
        } else if (natives.contains(nat)) {
            return;
        }
        natives.add(nat);
        this.getNativesForFlavorCache.remove(flav);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void setNativesForFlavor(DataFlavor flav, String[] natives) {
        if (flav == null || natives == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.getFlavorToNative().remove(flav);
        for (int i = 0; i < natives.length; ++i) {
            this.addUnencodedNativeForFlavor(flav, natives[i]);
        }
        this.disabledMappingGenerationKeys.add(flav);
        this.getNativesForFlavorCache.remove(flav);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void addFlavorForUnencodedNative(String nat, DataFlavor flav) {
        if (nat == null || flav == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        ArrayList<DataFlavor> flavors = (ArrayList<DataFlavor>)this.getNativeToFlavor().get(nat);
        if (flavors == null) {
            flavors = new ArrayList<DataFlavor>(1);
            this.getNativeToFlavor().put(nat, flavors);
        } else if (flavors.contains(flav)) {
            return;
        }
        flavors.add(flav);
        this.getFlavorsForNativeCache.remove(nat);
        this.getFlavorsForNativeCache.remove(null);
    }

    public synchronized void setFlavorsForNative(String nat, DataFlavor[] flavors) {
        if (nat == null || flavors == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.getNativeToFlavor().remove(nat);
        for (int i = 0; i < flavors.length; ++i) {
            this.addFlavorForUnencodedNative(nat, flavors[i]);
        }
        this.disabledMappingGenerationKeys.add(nat);
        this.getFlavorsForNativeCache.remove(nat);
        this.getFlavorsForNativeCache.remove(null);
    }

    public static String encodeJavaMIMEType(String mimeType) {
        return mimeType != null ? JavaMIME + mimeType : null;
    }

    public static String encodeDataFlavor(DataFlavor flav) {
        return flav != null ? SystemFlavorMap.encodeJavaMIMEType(flav.getMimeType()) : null;
    }

    public static boolean isJavaMIMEType(String str) {
        return str != null && str.startsWith(JavaMIME, 0);
    }

    public static String decodeJavaMIMEType(String nat) {
        return SystemFlavorMap.isJavaMIMEType(nat) ? nat.substring(JavaMIME.length(), nat.length()).trim() : null;
    }

    public static DataFlavor decodeDataFlavor(String nat) throws ClassNotFoundException {
        String retval_str = SystemFlavorMap.decodeJavaMIMEType(nat);
        return retval_str != null ? new DataFlavor(retval_str) : null;
    }
}

