/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

public class MenuItem
extends MenuComponent
implements Accessible {
    boolean enabled = true;
    String label;
    String actionCommand;
    long eventMask;
    transient ActionListener actionListener;
    private MenuShortcut shortcut = null;
    private static final String base = "menuitem";
    private static int nameCounter;
    private static final long serialVersionUID = -21757335363267194L;
    private int menuItemSerializedDataVersion = 1;

    public MenuItem() throws HeadlessException {
        this("", null);
    }

    public MenuItem(String label) throws HeadlessException {
        this(label, null);
    }

    public MenuItem(String label, MenuShortcut s) throws HeadlessException {
        this.label = label;
        this.shortcut = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<MenuItem> clazz = MenuItem.class;
        synchronized (MenuItem.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        MenuItemPeer peer = (MenuItemPeer)this.peer;
        if (peer != null) {
            peer.setLabel(label);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean b) {
        this.enable(b);
    }

    @Deprecated
    public synchronized void enable() {
        this.enabled = true;
        MenuItemPeer peer = (MenuItemPeer)this.peer;
        if (peer != null) {
            peer.setEnabled(true);
        }
    }

    @Deprecated
    public void enable(boolean b) {
        if (b) {
            this.enable();
        } else {
            this.disable();
        }
    }

    @Deprecated
    public synchronized void disable() {
        this.enabled = false;
        MenuItemPeer peer = (MenuItemPeer)this.peer;
        if (peer != null) {
            peer.setEnabled(false);
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut s) {
        this.shortcut = s;
        MenuItemPeer peer = (MenuItemPeer)this.peer;
        if (peer != null) {
            peer.setLabel(this.label);
        }
    }

    public void deleteShortcut() {
        this.shortcut = null;
        MenuItemPeer peer = (MenuItemPeer)this.peer;
        if (peer != null) {
            peer.setLabel(this.label);
        }
    }

    void deleteShortcut(MenuShortcut s) {
        if (s.equals(this.shortcut)) {
            this.shortcut = null;
            MenuItemPeer peer = (MenuItemPeer)this.peer;
            if (peer != null) {
                peer.setLabel(this.label);
            }
        }
    }

    void doMenuEvent(long when, int modifiers) {
        Toolkit.getEventQueue().postEvent(new ActionEvent(this, 1001, this.getActionCommand(), when, modifiers));
    }

    private final boolean isItemEnabled() {
        Menu menu;
        if (!this.isEnabled()) {
            return false;
        }
        MenuContainer container = this.getParent_NoClientCode();
        do {
            if (!(container instanceof Menu)) {
                return true;
            }
            menu = (Menu)container;
            if (menu.isEnabled()) continue;
            return false;
        } while ((container = menu.getParent_NoClientCode()) != null);
        return true;
    }

    boolean handleShortcut(KeyEvent e) {
        MenuShortcut s = new MenuShortcut(e.getKeyCode(), (e.getModifiers() & 1) > 0);
        MenuShortcut sE = new MenuShortcut(e.getExtendedKeyCode(), (e.getModifiers() & 1) > 0);
        if ((s.equals(this.shortcut) || sE.equals(this.shortcut)) && this.isItemEnabled()) {
            if (e.getID() == 401) {
                this.doMenuEvent(e.getWhen(), e.getModifiers());
            }
            return true;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut s) {
        return s.equals(this.shortcut) ? this : null;
    }

    protected final void enableEvents(long eventsToEnable) {
        this.eventMask |= eventsToEnable;
        this.newEventsOnly = true;
    }

    protected final void disableEvents(long eventsToDisable) {
        this.eventMask &= eventsToDisable ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.getActionCommandImpl();
    }

    final String getActionCommandImpl() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        ActionListener l = null;
        if (listenerType == ActionListener.class) {
            l = this.actionListener;
        }
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        }
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        if (e.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(e);
    }

    protected void processActionEvent(ActionEvent e) {
        ActionListener listener = this.actionListener;
        if (listener != null) {
            listener.actionPerformed(e);
        }
    }

    @Override
    public String paramString() {
        String str = ",label=" + this.label;
        if (this.shortcut != null) {
            str = str + ",shortcut=" + this.shortcut;
        }
        return super.paramString() + str;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "actionL", this.actionListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuItem.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -217847831945965825L;

        protected AccessibleAWTMenuItem() {
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MenuItem.this.getLabel() == null) {
                return super.getAccessibleName();
            }
            return MenuItem.this.getLabel();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return "click";
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(MenuItem.this, 1001, MenuItem.this.getActionCommand(), EventQueue.getMostRecentEventTime(), 0));
                return true;
            }
            return false;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return 0;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return 0;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return 0;
        }
    }
}

