/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.sound.midi.Patch;

public class SoftTuning {
    private String name = null;
    private double[] tuning = new double[128];
    private Patch patch = null;

    public SoftTuning() {
        this.name = "12-TET";
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
    }

    public SoftTuning(byte[] data) {
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
        this.load(data);
    }

    public SoftTuning(Patch patch) {
        this.patch = patch;
        this.name = "12-TET";
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
    }

    public SoftTuning(Patch patch, byte[] data) {
        this.patch = patch;
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
        this.load(data);
    }

    private boolean checksumOK(byte[] data) {
        int x = data[1] & 0xFF;
        for (int i = 2; i < data.length - 2; ++i) {
            x ^= data[i] & 0xFF;
        }
        return (data[data.length - 2] & 0xFF) == (x & 0x7F);
    }

    public void load(byte[] data) {
        block33: {
            if ((data[1] & 0xFF) != 126 && (data[1] & 0xFF) != 127) break block33;
            int subid1 = data[3] & 0xFF;
            switch (subid1) {
                case 8: {
                    int subid2 = data[4] & 0xFF;
                    switch (subid2) {
                        case 1: {
                            try {
                                this.name = new String(data, 6, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException e) {
                                this.name = null;
                            }
                            int r = 22;
                            for (int i = 0; i < 128; ++i) {
                                int xx = data[r++] & 0xFF;
                                int yy = data[r++] & 0xFF;
                                int zz = data[r++] & 0xFF;
                                if (xx == 127 && yy == 127 && zz == 127) continue;
                                this.tuning[i] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            break block33;
                        }
                        case 2: {
                            int ll = data[6] & 0xFF;
                            int r = 7;
                            for (int i = 0; i < ll; ++i) {
                                int kk = data[r++] & 0xFF;
                                int xx = data[r++] & 0xFF;
                                int yy = data[r++] & 0xFF;
                                int zz = data[r++] & 0xFF;
                                if (xx == 127 && yy == 127 && zz == 127) continue;
                                this.tuning[kk] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            break block33;
                        }
                        case 4: {
                            if (!this.checksumOK(data)) break block33;
                            try {
                                this.name = new String(data, 7, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException e) {
                                this.name = null;
                            }
                            int r = 23;
                            for (int i = 0; i < 128; ++i) {
                                int xx = data[r++] & 0xFF;
                                int yy = data[r++] & 0xFF;
                                int zz = data[r++] & 0xFF;
                                if (xx == 127 && yy == 127 && zz == 127) continue;
                                this.tuning[i] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            break block33;
                        }
                        case 5: {
                            int i;
                            if (!this.checksumOK(data)) break block33;
                            try {
                                this.name = new String(data, 7, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException e) {
                                this.name = null;
                            }
                            int[] octave_tuning = new int[12];
                            for (i = 0; i < 12; ++i) {
                                octave_tuning[i] = (data[i + 23] & 0xFF) - 64;
                            }
                            for (i = 0; i < this.tuning.length; ++i) {
                                this.tuning[i] = i * 100 + octave_tuning[i % 12];
                            }
                            break block33;
                        }
                        case 6: {
                            int i;
                            if (!this.checksumOK(data)) break block33;
                            try {
                                this.name = new String(data, 7, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException e) {
                                this.name = null;
                            }
                            double[] octave_tuning = new double[12];
                            for (i = 0; i < 12; ++i) {
                                int v = (data[i * 2 + 23] & 0xFF) * 128 + (data[i * 2 + 24] & 0xFF);
                                octave_tuning[i] = ((double)v / 8192.0 - 1.0) * 100.0;
                            }
                            for (i = 0; i < this.tuning.length; ++i) {
                                this.tuning[i] = (double)(i * 100) + octave_tuning[i % 12];
                            }
                            break block33;
                        }
                        case 7: {
                            int ll = data[7] & 0xFF;
                            int r = 8;
                            for (int i = 0; i < ll; ++i) {
                                int kk = data[r++] & 0xFF;
                                int xx = data[r++] & 0xFF;
                                int yy = data[r++] & 0xFF;
                                int zz = data[r++] & 0xFF;
                                if (xx == 127 && yy == 127 && zz == 127) continue;
                                this.tuning[kk] = 100.0 * ((double)(xx * 16384 + yy * 128 + zz) / 16384.0);
                            }
                            break block33;
                        }
                        case 8: {
                            int i;
                            int[] octave_tuning = new int[12];
                            for (i = 0; i < 12; ++i) {
                                octave_tuning[i] = (data[i + 8] & 0xFF) - 64;
                            }
                            for (i = 0; i < this.tuning.length; ++i) {
                                this.tuning[i] = i * 100 + octave_tuning[i % 12];
                            }
                            break block33;
                        }
                        case 9: {
                            int i;
                            double[] octave_tuning = new double[12];
                            for (i = 0; i < 12; ++i) {
                                int v = (data[i * 2 + 8] & 0xFF) * 128 + (data[i * 2 + 9] & 0xFF);
                                octave_tuning[i] = ((double)v / 8192.0 - 1.0) * 100.0;
                            }
                            for (i = 0; i < this.tuning.length; ++i) {
                                this.tuning[i] = (double)(i * 100) + octave_tuning[i % 12];
                            }
                        }
                    }
                }
            }
        }
    }

    public double[] getTuning() {
        return Arrays.copyOf(this.tuning, this.tuning.length);
    }

    public double getTuning(int noteNumber) {
        return this.tuning[noteNumber];
    }

    public Patch getPatch() {
        return this.patch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

