/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelStandardIndexedDirector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.sampled.AudioFormat;

public abstract class ModelInstrument
extends Instrument {
    protected ModelInstrument(Soundbank soundbank, Patch patch, String name, Class<?> dataClass) {
        super(soundbank, patch, name, dataClass);
    }

    public ModelDirector getDirector(ModelPerformer[] performers, MidiChannel channel, ModelDirectedPlayer player) {
        return new ModelStandardIndexedDirector(performers, player);
    }

    public ModelPerformer[] getPerformers() {
        return new ModelPerformer[0];
    }

    public ModelChannelMixer getChannelMixer(MidiChannel channel, AudioFormat format) {
        return null;
    }

    public Patch getPatchAlias() {
        Patch patch = this.getPatch();
        int program = patch.getProgram();
        int bank = patch.getBank();
        if (bank != 0) {
            return patch;
        }
        boolean percussion = false;
        if (this.getPatch() instanceof ModelPatch) {
            percussion = ((ModelPatch)this.getPatch()).isPercussion();
        }
        if (percussion) {
            return new Patch(15360, program);
        }
        return new Patch(15488, program);
    }

    public String[] getKeys() {
        String[] keys = new String[128];
        for (ModelPerformer performer : this.getPerformers()) {
            for (int k = performer.getKeyFrom(); k <= performer.getKeyTo(); ++k) {
                if (k < 0 || k >= 128 || keys[k] != null) continue;
                String name = performer.getName();
                if (name == null) {
                    name = "untitled";
                }
                keys[k] = name;
            }
        }
        return keys;
    }

    public boolean[] getChannels() {
        boolean percussion = false;
        if (this.getPatch() instanceof ModelPatch) {
            percussion = ((ModelPatch)this.getPatch()).isPercussion();
        }
        if (percussion) {
            boolean[] ch = new boolean[16];
            for (int i = 0; i < ch.length; ++i) {
                ch[i] = false;
            }
            ch[9] = true;
            return ch;
        }
        int bank = this.getPatch().getBank();
        if (bank >> 7 == 120 || bank >> 7 == 121) {
            boolean[] ch = new boolean[16];
            for (int i = 0; i < ch.length; ++i) {
                ch[i] = true;
            }
            return ch;
        }
        boolean[] ch = new boolean[16];
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = true;
        }
        ch[9] = false;
        return ch;
    }
}

