/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AiffFileWriter
extends SunFileWriter {
    private static final AudioFileFormat.Type[] aiffTypes = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};
    private static final int DOUBLE_MANTISSA_LENGTH = 52;
    private static final int DOUBLE_EXPONENT_LENGTH = 11;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int DOUBLE_EXPONENT_OFFSET = 1023;
    private static final int EXTENDED_EXPONENT_OFFSET = 16383;
    private static final int EXTENDED_MANTISSA_LENGTH = 63;
    private static final int EXTENDED_EXPONENT_LENGTH = 15;
    private static final long EXTENDED_INTEGER_MASK = Long.MIN_VALUE;

    public AiffFileWriter() {
        super(aiffTypes);
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileFormat.Type[] filetypes = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, filetypes, 0, this.types.length);
        AudioFormat format = stream.getFormat();
        AudioFormat.Encoding encoding = format.getEncoding();
        if (AudioFormat.Encoding.ALAW.equals(encoding) || AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            return filetypes;
        }
        return new AudioFileFormat.Type[0];
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        AiffFileFormat aiffFileFormat = (AiffFileFormat)this.getAudioFileFormat(fileType, stream);
        if (stream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        int bytesWritten = this.writeAiffFile(stream, aiffFileFormat, out);
        return bytesWritten;
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        AiffFileFormat aiffFileFormat = (AiffFileFormat)this.getAudioFileFormat(fileType, stream);
        FileOutputStream fos = new FileOutputStream(out);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
        int bytesWritten = this.writeAiffFile(stream, aiffFileFormat, bos);
        bos.close();
        if (aiffFileFormat.getByteLength() == -1) {
            int ssndBlockSize = aiffFileFormat.getFormat().getChannels() * aiffFileFormat.getFormat().getSampleSizeInBits();
            int aiffLength = bytesWritten;
            int ssndChunkSize = aiffLength - aiffFileFormat.getHeaderSize() + 16;
            long dataSize = ssndChunkSize - 16;
            int numFrames = (int)(dataSize * 8L / (long)ssndBlockSize);
            RandomAccessFile raf = new RandomAccessFile(out, "rw");
            raf.skipBytes(4);
            raf.writeInt(aiffLength - 8);
            raf.skipBytes(4 + aiffFileFormat.getFverChunkSize() + 4 + 4 + 2);
            raf.writeInt(numFrames);
            raf.skipBytes(16);
            raf.writeInt(ssndChunkSize - 8);
            raf.close();
        }
        return bytesWritten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream stream) {
        int sampleSizeInBits;
        AudioFormat format = null;
        AiffFileFormat fileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat streamFormat = stream.getFormat();
        AudioFormat.Encoding streamEncoding = streamFormat.getEncoding();
        boolean convert8to16 = false;
        if (!this.types[0].equals(type)) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (AudioFormat.Encoding.ALAW.equals(streamEncoding) || AudioFormat.Encoding.ULAW.equals(streamEncoding)) {
            if (streamFormat.getSampleSizeInBits() != 8) throw new IllegalArgumentException("Encoding " + streamEncoding + " supported only for 8-bit data.");
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = 16;
            convert8to16 = true;
        } else if (streamFormat.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            sampleSizeInBits = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = streamFormat.getSampleSizeInBits();
        }
        format = new AudioFormat(encoding, streamFormat.getSampleRate(), sampleSizeInBits, streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), true);
        int fileSize = stream.getFrameLength() != -1L ? (convert8to16 ? (int)stream.getFrameLength() * streamFormat.getFrameSize() * 2 + 54 : (int)stream.getFrameLength() * streamFormat.getFrameSize() + 54) : -1;
        return new AiffFileFormat(AudioFileFormat.Type.AIFF, fileSize, format, (int)stream.getFrameLength());
    }

    private int writeAiffFile(InputStream in, AiffFileFormat aiffFileFormat, OutputStream out) throws IOException {
        int bytesRead = 0;
        int bytesWritten = 0;
        InputStream fileStream = this.getFileStream(aiffFileFormat, in);
        byte[] buffer = new byte[4096];
        int maxLength = aiffFileFormat.getByteLength();
        while ((bytesRead = fileStream.read(buffer)) >= 0) {
            if (maxLength > 0) {
                if (bytesRead < maxLength) {
                    out.write(buffer, 0, bytesRead);
                    bytesWritten += bytesRead;
                    maxLength -= bytesRead;
                    continue;
                }
                out.write(buffer, 0, maxLength);
                bytesWritten += maxLength;
                maxLength = 0;
                break;
            }
            out.write(buffer, 0, bytesRead);
            bytesWritten += bytesRead;
        }
        return bytesWritten;
    }

    private InputStream getFileStream(AiffFileFormat aiffFileFormat, InputStream audioStream) throws IOException {
        AudioFormat format = aiffFileFormat.getFormat();
        AudioFormat streamFormat = null;
        AudioFormat.Encoding encoding = null;
        int headerSize = aiffFileFormat.getHeaderSize();
        int fverChunkSize = aiffFileFormat.getFverChunkSize();
        int commChunkSize = aiffFileFormat.getCommChunkSize();
        int aiffLength = -1;
        int ssndChunkSize = -1;
        int ssndOffset = aiffFileFormat.getSsndChunkOffset();
        short channels = (short)format.getChannels();
        short sampleSize = (short)format.getSampleSizeInBits();
        int ssndBlockSize = channels * sampleSize;
        int numFrames = aiffFileFormat.getFrameLength();
        long dataSize = -1L;
        if (numFrames != -1) {
            dataSize = (long)numFrames * (long)ssndBlockSize / 8L;
            ssndChunkSize = (int)dataSize + 16;
            aiffLength = (int)dataSize + headerSize;
        }
        float sampleFramesPerSecond = format.getSampleRate();
        int compCode = 1313820229;
        byte[] header = null;
        ByteArrayInputStream headerStream = null;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        SequenceInputStream aiffStream = null;
        InputStream codedAudioStream = audioStream;
        if (audioStream instanceof AudioInputStream) {
            streamFormat = ((AudioInputStream)audioStream).getFormat();
            encoding = streamFormat.getEncoding();
            if (AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) && !streamFormat.isBigEndian()) {
                codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, streamFormat.getSampleRate(), streamFormat.getSampleSizeInBits(), streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), true), (AudioInputStream)audioStream);
            } else if (AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.ALAW.equals(encoding)) {
                if (streamFormat.getSampleSizeInBits() != 8) {
                    throw new IllegalArgumentException("unsupported encoding");
                }
                codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, streamFormat.getSampleRate(), streamFormat.getSampleSizeInBits() * 2, streamFormat.getChannels(), streamFormat.getFrameSize() * 2, streamFormat.getFrameRate(), true), (AudioInputStream)audioStream);
            }
        }
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        dos.writeInt(1179603533);
        dos.writeInt(aiffLength - 8);
        dos.writeInt(1095321158);
        dos.writeInt(1129270605);
        dos.writeInt(commChunkSize - 8);
        dos.writeShort(channels);
        dos.writeInt(numFrames);
        dos.writeShort(sampleSize);
        this.write_ieee_extended(dos, sampleFramesPerSecond);
        dos.writeInt(1397968452);
        dos.writeInt(ssndChunkSize - 8);
        dos.writeInt(0);
        dos.writeInt(0);
        dos.close();
        header = baos.toByteArray();
        headerStream = new ByteArrayInputStream(header);
        aiffStream = new SequenceInputStream(headerStream, new SunFileWriter.NoCloseInputStream(this, codedAudioStream));
        return aiffStream;
    }

    private void write_ieee_extended(DataOutputStream dos, float f) throws IOException {
        long doubleBits = Double.doubleToLongBits(f);
        long sign = (doubleBits & Long.MIN_VALUE) >> 63;
        long doubleExponent = (doubleBits & 0x7FF0000000000000L) >> 52;
        long doubleMantissa = doubleBits & 0xFFFFFFFFFFFFFL;
        long extendedExponent = doubleExponent - 1023L + 16383L;
        long extendedMantissa = doubleMantissa << 11;
        long extendedSign = sign << 15;
        short extendedBits79To64 = (short)(extendedSign | extendedExponent);
        long extendedBits63To0 = Long.MIN_VALUE | extendedMantissa;
        dos.writeShort(extendedBits79To64);
        dos.writeLong(extendedBits63To0);
    }
}

