/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.Filter;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.UnsolicitedResponseImpl;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.sasl.LdapSasl;
import com.sun.jndi.ldap.sasl.SaslInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.ldap.Control;

public final class LdapClient
implements PooledConnection {
    private static final int debug = 0;
    static final boolean caseIgnore = true;
    private static final Hashtable defaultBinaryAttrs = new Hashtable(23, 0.75f);
    private static final String DISCONNECT_OID = "1.3.6.1.4.1.1466.20036";
    boolean isLdapv3;
    int referenceCount = 1;
    Connection conn;
    private final PoolCallback pcb;
    private final boolean pooled;
    private boolean authenticateCalled = false;
    static final int SCOPE_BASE_OBJECT = 0;
    static final int SCOPE_ONE_LEVEL = 1;
    static final int SCOPE_SUBTREE = 2;
    static final int ADD = 0;
    static final int DELETE = 1;
    static final int REPLACE = 2;
    static final int LDAP_VERSION3_VERSION2 = 32;
    static final int LDAP_VERSION2 = 2;
    static final int LDAP_VERSION3 = 3;
    static final int LDAP_VERSION = 3;
    static final int LDAP_REF_FOLLOW = 1;
    static final int LDAP_REF_THROW = 2;
    static final int LDAP_REF_IGNORE = 3;
    static final String LDAP_URL = "ldap://";
    static final String LDAPS_URL = "ldaps://";
    static final int LBER_BOOLEAN = 1;
    static final int LBER_INTEGER = 2;
    static final int LBER_BITSTRING = 3;
    static final int LBER_OCTETSTRING = 4;
    static final int LBER_NULL = 5;
    static final int LBER_ENUMERATED = 10;
    static final int LBER_SEQUENCE = 48;
    static final int LBER_SET = 49;
    static final int LDAP_SUPERIOR_DN = 128;
    static final int LDAP_REQ_BIND = 96;
    static final int LDAP_REQ_UNBIND = 66;
    static final int LDAP_REQ_SEARCH = 99;
    static final int LDAP_REQ_MODIFY = 102;
    static final int LDAP_REQ_ADD = 104;
    static final int LDAP_REQ_DELETE = 74;
    static final int LDAP_REQ_MODRDN = 108;
    static final int LDAP_REQ_COMPARE = 110;
    static final int LDAP_REQ_ABANDON = 80;
    static final int LDAP_REQ_EXTENSION = 119;
    static final int LDAP_REP_BIND = 97;
    static final int LDAP_REP_SEARCH = 100;
    static final int LDAP_REP_SEARCH_REF = 115;
    static final int LDAP_REP_RESULT = 101;
    static final int LDAP_REP_MODIFY = 103;
    static final int LDAP_REP_ADD = 105;
    static final int LDAP_REP_DELETE = 107;
    static final int LDAP_REP_MODRDN = 109;
    static final int LDAP_REP_COMPARE = 111;
    static final int LDAP_REP_EXTENSION = 120;
    static final int LDAP_REP_REFERRAL = 163;
    static final int LDAP_REP_EXT_OID = 138;
    static final int LDAP_REP_EXT_VAL = 139;
    static final int LDAP_CONTROLS = 160;
    static final String LDAP_CONTROL_MANAGE_DSA_IT = "2.16.840.1.113730.3.4.2";
    static final String LDAP_CONTROL_PREFERRED_LANG = "1.3.6.1.4.1.1466.20035";
    static final String LDAP_CONTROL_PAGED_RESULTS = "1.2.840.113556.1.4.319";
    static final String LDAP_CONTROL_SERVER_SORT_REQ = "1.2.840.113556.1.4.473";
    static final String LDAP_CONTROL_SERVER_SORT_RES = "1.2.840.113556.1.4.474";
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_OPERATIONS_ERROR = 1;
    static final int LDAP_PROTOCOL_ERROR = 2;
    static final int LDAP_TIME_LIMIT_EXCEEDED = 3;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_COMPARE_FALSE = 5;
    static final int LDAP_COMPARE_TRUE = 6;
    static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    static final int LDAP_PARTIAL_RESULTS = 9;
    static final int LDAP_REFERRAL = 10;
    static final int LDAP_ADMIN_LIMIT_EXCEEDED = 11;
    static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    static final int LDAP_UNDEFINED_ATTRIBUTE_TYPE = 17;
    static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    static final int LDAP_CONSTRAINT_VIOLATION = 19;
    static final int LDAP_ATTRIBUTE_OR_VALUE_EXISTS = 20;
    static final int LDAP_INVALID_ATTRIBUTE_SYNTAX = 21;
    static final int LDAP_NO_SUCH_OBJECT = 32;
    static final int LDAP_ALIAS_PROBLEM = 33;
    static final int LDAP_INVALID_DN_SYNTAX = 34;
    static final int LDAP_IS_LEAF = 35;
    static final int LDAP_ALIAS_DEREFERENCING_PROBLEM = 36;
    static final int LDAP_INAPPROPRIATE_AUTHENTICATION = 48;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_INSUFFICIENT_ACCESS_RIGHTS = 50;
    static final int LDAP_BUSY = 51;
    static final int LDAP_UNAVAILABLE = 52;
    static final int LDAP_UNWILLING_TO_PERFORM = 53;
    static final int LDAP_LOOP_DETECT = 54;
    static final int LDAP_NAMING_VIOLATION = 64;
    static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    static final int LDAP_NOT_ALLOWED_ON_NON_LEAF = 66;
    static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    static final int LDAP_ENTRY_ALREADY_EXISTS = 68;
    static final int LDAP_OBJECT_CLASS_MODS_PROHIBITED = 69;
    static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    static final int LDAP_OTHER = 80;
    static final String[] ldap_error_message;
    private Vector unsolicited = new Vector(3);

    LdapClient(String host, int port, String socketFactory, int connectTimeout, int readTimeout, OutputStream trace, PoolCallback pcb) throws NamingException {
        this.conn = new Connection(this, host, port, socketFactory, connectTimeout, readTimeout, trace);
        this.pcb = pcb;
        this.pooled = pcb != null;
    }

    synchronized boolean authenticateCalled() {
        return this.authenticateCalled;
    }

    /*
     * Unable to fully structure code
     */
    synchronized LdapResult authenticate(boolean initial, String name, Object pw, int version, String authMechanism, Control[] ctls, Hashtable env) throws NamingException {
        block37: {
            this.authenticateCalled = true;
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                ne = new CommunicationException();
                ne.setRootCause(e);
                throw ne;
            }
            switch (version) {
                case 3: 
                case 32: {
                    this.isLdapv3 = true;
                    break;
                }
                case 2: {
                    this.isLdapv3 = false;
                    break;
                }
                default: {
                    throw new CommunicationException("Protocol version " + version + " not supported");
                }
            }
            res = null;
            if (authMechanism.equalsIgnoreCase("none") || authMechanism.equalsIgnoreCase("anonymous")) {
                if (!initial || version == 2 || version == 32 || ctls != null && ctls.length > 0) {
                    try {
                        name = null;
                        pw = null;
                        res = this.ldapBind(null, null, ctls, null, false);
                        if (res.status != 0) ** GOTO lbl69
                        this.conn.setBound();
                    }
                    catch (IOException e) {
                        ne = new CommunicationException("anonymous bind failed: " + this.conn.host + ":" + this.conn.port);
                        ne.setRootCause(e);
                        throw ne;
                    }
                } else {
                    res = new LdapResult();
                    res.status = 0;
                }
            } else {
                if (authMechanism.equalsIgnoreCase("simple")) {
                    encodedPw = null;
                    try {
                        encodedPw = LdapClient.encodePassword(pw, this.isLdapv3);
                        res = this.ldapBind(name, encodedPw, ctls, null, false);
                        if (res.status == 0) {
                            this.conn.setBound();
                        }
                        ** if (encodedPw == pw || encodedPw == null) goto lbl-1000
                    }
                    catch (IOException e) {
                        try {
                            ne = new CommunicationException("simple bind failed: " + this.conn.host + ":" + this.conn.port);
                            ne.setRootCause(e);
                            throw ne;
                        }
                        catch (Throwable var12_21) {
                            if (encodedPw != pw && encodedPw != null) {
                                for (i = 0; i < encodedPw.length; ++i) {
                                    encodedPw[i] = 0;
                                }
                            }
                            throw var12_21;
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        for (i = 0; i < encodedPw.length; ++i) {
                            encodedPw[i] = 0;
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block37;
                    }
                }
                if (this.isLdapv3) {
                    try {
                        res = LdapSasl.saslBind(this, this.conn, this.conn.host, name, pw, authMechanism, env, ctls);
                        if (res.status != 0) ** GOTO lbl69
                        this.conn.setBound();
                    }
                    catch (IOException e) {
                        ne = new CommunicationException("SASL bind failed: " + this.conn.host + ":" + this.conn.port);
                        ne.setRootCause(e);
                        throw ne;
                    }
                } else {
                    throw new AuthenticationNotSupportedException(authMechanism);
                }
            }
        }
        if (initial && res.status == 2 && version == 32 && (authMechanism.equalsIgnoreCase("none") || authMechanism.equalsIgnoreCase("anonymous") || authMechanism.equalsIgnoreCase("simple"))) {
            encodedPw = null;
            try {
                this.isLdapv3 = false;
                encodedPw = LdapClient.encodePassword(pw, false);
                res = this.ldapBind(name, encodedPw, ctls, null, false);
                if (res.status == 0) {
                    this.conn.setBound();
                }
                ** if (encodedPw == pw || encodedPw == null) goto lbl-1000
            }
            catch (IOException e) {
                try {
                    ne = new CommunicationException(authMechanism + ":" + this.conn.host + ":" + this.conn.port);
                    ne.setRootCause(e);
                    throw ne;
                }
                catch (Throwable var14_23) {
                    if (encodedPw != pw && encodedPw != null) {
                        for (i = 0; i < encodedPw.length; ++i) {
                            encodedPw[i] = 0;
                        }
                    }
                    throw var14_23;
                }
            }
lbl-1000:
            // 2 sources

            {
                for (i = 0; i < encodedPw.length; ++i) {
                    encodedPw[i] = 0;
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (res.status == 32) {
            throw new AuthenticationException(LdapClient.getErrorMessage(res.status, res.errorMessage));
        }
        this.conn.setV3(this.isLdapv3);
        return res;
    }

    public synchronized LdapResult ldapBind(String dn, byte[] toServer, Control[] bindCtls, String auth, boolean pauseAfterReceipt) throws IOException, NamingException {
        this.ensureOpen();
        this.conn.abandonOutstandingReqs(null);
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        LdapResult res = new LdapResult();
        res.status = 1;
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(96);
        ber.encodeInt(this.isLdapv3 ? 3 : 2);
        ber.encodeString(dn, this.isLdapv3);
        if (auth != null) {
            ber.beginSeq(163);
            ber.encodeString(auth, this.isLdapv3);
            if (toServer != null) {
                ber.encodeOctetString(toServer, 4);
            }
            ber.endSeq();
        } else if (toServer != null) {
            ber.encodeOctetString(toServer, 128);
        } else {
            ber.encodeOctetString(null, 128, 0, 0);
        }
        ber.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, bindCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId, pauseAfterReceipt);
        if (toServer != null) {
            ber.reset();
        }
        BerDecoder rber = this.conn.readReply(req);
        rber.parseSeq(null);
        rber.parseInt();
        if (rber.parseByte() != 97) {
            return res;
        }
        rber.parseLength();
        LdapClient.parseResult(rber, res, this.isLdapv3);
        if (this.isLdapv3 && rber.bytesLeft() > 0 && rber.peekByte() == 135) {
            res.serverCreds = rber.parseOctetString(135, null);
        }
        res.resControls = this.isLdapv3 ? LdapClient.parseControls(rber) : null;
        this.conn.removeRequest(req);
        return res;
    }

    boolean usingSaslStreams() {
        return this.conn.inStream instanceof SaslInputStream;
    }

    synchronized void incRefCount() {
        ++this.referenceCount;
    }

    private static byte[] encodePassword(Object pw, boolean v3) throws IOException {
        if (pw instanceof char[]) {
            pw = new String((char[])pw);
        }
        if (pw instanceof String) {
            if (v3) {
                return ((String)pw).getBytes("UTF8");
            }
            return ((String)pw).getBytes("8859_1");
        }
        return (byte[])pw;
    }

    synchronized void close(Control[] reqCtls, boolean hardClose) {
        --this.referenceCount;
        if (this.referenceCount <= 0 && this.conn != null) {
            if (!this.pooled) {
                this.conn.cleanup(reqCtls, false);
                this.conn = null;
            } else if (hardClose) {
                this.conn.cleanup(reqCtls, false);
                this.conn = null;
                this.pcb.removePooledConnection(this);
            } else {
                this.pcb.releasePooledConnection(this);
            }
        }
    }

    private void forceClose(boolean cleanPool) {
        this.referenceCount = 0;
        if (this.conn != null) {
            this.conn.cleanup(null, false);
            this.conn = null;
            if (cleanPool) {
                this.pcb.removePooledConnection(this);
            }
        }
    }

    protected void finalize() {
        this.forceClose(this.pooled);
    }

    @Override
    public synchronized void closeConnection() {
        this.forceClose(false);
    }

    void processConnectionClosure() {
        if (this.unsolicited.size() > 0) {
            String msg = this.conn != null ? this.conn.host + ":" + this.conn.port + " connection closed" : "Connection closed";
            this.notifyUnsolicited(new CommunicationException(msg));
        }
        if (this.pooled) {
            this.pcb.removePooledConnection(this);
        }
    }

    LdapResult search(String dn, int scope, int deref, int sizeLimit, int timeLimit, boolean attrsOnly, String[] attrs, String filter, int batchSize, Control[] reqCtls, Hashtable binaryAttrs, boolean waitFirstReply, int replyQueueCapacity) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult res = new LdapResult();
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(99);
        ber.encodeString(dn == null ? "" : dn, this.isLdapv3);
        ber.encodeInt(scope, 10);
        ber.encodeInt(deref, 10);
        ber.encodeInt(sizeLimit);
        ber.encodeInt(timeLimit);
        ber.encodeBoolean(attrsOnly);
        Filter.encodeFilterString(ber, filter, this.isLdapv3);
        ber.beginSeq(48);
        ber.encodeStringArray(attrs, this.isLdapv3);
        ber.endSeq();
        ber.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, reqCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId, false, replyQueueCapacity);
        res.msgId = curMsgId;
        res.status = 0;
        if (waitFirstReply) {
            res = this.getSearchReply(req, batchSize, res, binaryAttrs);
        }
        return res;
    }

    void clearSearchReply(LdapResult res, Control[] ctls) {
        if (res != null && this.conn != null) {
            LdapRequest req = this.conn.findRequest(res.msgId);
            if (req == null) {
                return;
            }
            if (req.hasSearchCompleted()) {
                this.conn.removeRequest(req);
            } else {
                this.conn.abandonRequest(req, ctls);
            }
        }
    }

    LdapResult getSearchReply(int batchSize, LdapResult res, Hashtable binaryAttrs) throws IOException, NamingException {
        this.ensureOpen();
        LdapRequest req = this.conn.findRequest(res.msgId);
        if (req == null) {
            return null;
        }
        return this.getSearchReply(req, batchSize, res, binaryAttrs);
    }

    private LdapResult getSearchReply(LdapRequest req, int batchSize, LdapResult res, Hashtable binaryAttrs) throws IOException, NamingException {
        if (batchSize == 0) {
            batchSize = Integer.MAX_VALUE;
        }
        if (res.entries != null) {
            res.entries.setSize(0);
        } else {
            res.entries = new Vector(batchSize == Integer.MAX_VALUE ? 32 : batchSize);
        }
        if (res.referrals != null) {
            res.referrals.setSize(0);
        }
        int i = 0;
        while (i < batchSize) {
            BerDecoder replyBer = this.conn.readReply(req);
            replyBer.parseSeq(null);
            replyBer.parseInt();
            int seq = replyBer.parseSeq(null);
            if (seq == 100) {
                BasicAttributes lattrs = new BasicAttributes(true);
                String DN = replyBer.parseString(this.isLdapv3);
                LdapEntry le = new LdapEntry(DN, lattrs);
                int[] seqlen = new int[1];
                replyBer.parseSeq(seqlen);
                int endseq = replyBer.getParsePosition() + seqlen[0];
                while (replyBer.getParsePosition() < endseq && replyBer.bytesLeft() > 0) {
                    Attribute la = this.parseAttribute(replyBer, binaryAttrs);
                    lattrs.put(la);
                }
                le.respCtls = this.isLdapv3 ? LdapClient.parseControls(replyBer) : null;
                res.entries.addElement(le);
                ++i;
                continue;
            }
            if (seq == 115 && this.isLdapv3) {
                Vector<String> URLs = new Vector<String>(4);
                if (replyBer.peekByte() == 48) {
                    replyBer.parseSeq(null);
                }
                while (replyBer.bytesLeft() > 0 && replyBer.peekByte() == 4) {
                    URLs.addElement(replyBer.parseString(this.isLdapv3));
                }
                if (res.referrals == null) {
                    res.referrals = new Vector(4);
                }
                res.referrals.addElement(URLs);
                res.resControls = this.isLdapv3 ? LdapClient.parseControls(replyBer) : null;
                continue;
            }
            if (seq == 120) {
                this.parseExtResponse(replyBer, res);
                continue;
            }
            if (seq != 101) continue;
            LdapClient.parseResult(replyBer, res, this.isLdapv3);
            res.resControls = this.isLdapv3 ? LdapClient.parseControls(replyBer) : null;
            this.conn.removeRequest(req);
            return res;
        }
        return res;
    }

    private Attribute parseAttribute(BerDecoder ber, Hashtable binaryAttrs) throws IOException {
        int[] len = new int[1];
        int seq = ber.parseSeq(null);
        String attrid = ber.parseString(this.isLdapv3);
        boolean hasBinaryValues = this.isBinaryValued(attrid, binaryAttrs);
        LdapAttribute la = new LdapAttribute(attrid);
        seq = ber.parseSeq(len);
        if (seq == 49) {
            for (int attrlen = len[0]; ber.bytesLeft() > 0 && attrlen > 0; attrlen -= this.parseAttributeValue(ber, la, hasBinaryValues)) {
                try {
                    continue;
                }
                catch (IOException ex) {
                    ber.seek(attrlen);
                    break;
                }
            }
        } else {
            ber.seek(len[0]);
        }
        return la;
    }

    private int parseAttributeValue(BerDecoder ber, Attribute la, boolean hasBinaryValues) throws IOException {
        int[] len = new int[1];
        if (hasBinaryValues) {
            la.add(ber.parseOctetString(ber.peekByte(), len));
        } else {
            la.add(ber.parseStringWithTag(4, this.isLdapv3, len));
        }
        return len[0];
    }

    private boolean isBinaryValued(String attrid, Hashtable binaryAttrs) {
        String id = attrid.toLowerCase();
        return id.indexOf(";binary") != -1 || defaultBinaryAttrs.containsKey(id) || binaryAttrs != null && binaryAttrs.containsKey(id);
    }

    static void parseResult(BerDecoder replyBer, LdapResult res, boolean isLdapv3) throws IOException {
        res.status = replyBer.parseEnumeration();
        res.matchedDN = replyBer.parseString(isLdapv3);
        res.errorMessage = replyBer.parseString(isLdapv3);
        if (isLdapv3 && replyBer.bytesLeft() > 0 && replyBer.peekByte() == 163) {
            Vector<String> URLs = new Vector<String>(4);
            int[] seqlen = new int[1];
            replyBer.parseSeq(seqlen);
            int endseq = replyBer.getParsePosition() + seqlen[0];
            while (replyBer.getParsePosition() < endseq && replyBer.bytesLeft() > 0) {
                URLs.addElement(replyBer.parseString(isLdapv3));
            }
            if (res.referrals == null) {
                res.referrals = new Vector(4);
            }
            res.referrals.addElement(URLs);
        }
    }

    static Vector parseControls(BerDecoder replyBer) throws IOException {
        if (replyBer.bytesLeft() > 0 && replyBer.peekByte() == 160) {
            Vector<BasicControl> ctls = new Vector<BasicControl>(4);
            boolean criticality = false;
            byte[] controlValue = null;
            int[] seqlen = new int[1];
            replyBer.parseSeq(seqlen);
            int endseq = replyBer.getParsePosition() + seqlen[0];
            while (replyBer.getParsePosition() < endseq && replyBer.bytesLeft() > 0) {
                replyBer.parseSeq(null);
                String controlOID = replyBer.parseString(true);
                if (replyBer.bytesLeft() > 0 && replyBer.peekByte() == 1) {
                    criticality = replyBer.parseBoolean();
                }
                if (replyBer.bytesLeft() > 0 && replyBer.peekByte() == 4) {
                    controlValue = replyBer.parseOctetString(4, null);
                }
                if (controlOID == null) continue;
                ctls.addElement(new BasicControl(controlOID, criticality, controlValue));
            }
            return ctls;
        }
        return null;
    }

    private void parseExtResponse(BerDecoder replyBer, LdapResult res) throws IOException {
        LdapClient.parseResult(replyBer, res, this.isLdapv3);
        if (replyBer.bytesLeft() > 0 && replyBer.peekByte() == 138) {
            res.extensionId = replyBer.parseStringWithTag(138, this.isLdapv3, null);
        }
        if (replyBer.bytesLeft() > 0 && replyBer.peekByte() == 139) {
            res.extensionValue = replyBer.parseOctetString(139, null);
        }
        res.resControls = LdapClient.parseControls(replyBer);
    }

    static void encodeControls(BerEncoder ber, Control[] reqCtls) throws IOException {
        if (reqCtls == null || reqCtls.length == 0) {
            return;
        }
        ber.beginSeq(160);
        for (int i = 0; i < reqCtls.length; ++i) {
            byte[] controlVal;
            ber.beginSeq(48);
            ber.encodeString(reqCtls[i].getID(), true);
            if (reqCtls[i].isCritical()) {
                ber.encodeBoolean(true);
            }
            if ((controlVal = reqCtls[i].getEncodedValue()) != null) {
                ber.encodeOctetString(controlVal, 4);
            }
            ber.endSeq();
        }
        ber.endSeq();
    }

    private LdapResult processReply(LdapRequest req, LdapResult res, int responseType) throws IOException, NamingException {
        BerDecoder rber = this.conn.readReply(req);
        rber.parseSeq(null);
        rber.parseInt();
        if (rber.parseByte() != responseType) {
            return res;
        }
        rber.parseLength();
        LdapClient.parseResult(rber, res, this.isLdapv3);
        res.resControls = this.isLdapv3 ? LdapClient.parseControls(rber) : null;
        this.conn.removeRequest(req);
        return res;
    }

    LdapResult modify(String dn, int[] operations, Attribute[] attrs, Control[] reqCtls) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult res = new LdapResult();
        res.status = 1;
        if (dn == null || operations.length != attrs.length) {
            return res;
        }
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(102);
        ber.encodeString(dn, this.isLdapv3);
        ber.beginSeq(48);
        for (int i = 0; i < operations.length; ++i) {
            ber.beginSeq(48);
            ber.encodeInt(operations[i], 10);
            if (operations[i] == 0 && LdapClient.hasNoValue(attrs[i])) {
                throw new InvalidAttributeValueException("'" + attrs[i].getID() + "' has no values.");
            }
            this.encodeAttribute(ber, attrs[i]);
            ber.endSeq();
        }
        ber.endSeq();
        ber.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, reqCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId);
        return this.processReply(req, res, 103);
    }

    private void encodeAttribute(BerEncoder ber, Attribute attr) throws IOException, NamingException {
        ber.beginSeq(48);
        ber.encodeString(attr.getID(), this.isLdapv3);
        ber.beginSeq(49);
        NamingEnumeration<?> enum_ = attr.getAll();
        while (enum_.hasMore()) {
            Object val = enum_.next();
            if (val instanceof String) {
                ber.encodeString((String)val, this.isLdapv3);
                continue;
            }
            if (val instanceof byte[]) {
                ber.encodeOctetString((byte[])val, 4);
                continue;
            }
            if (val == null) continue;
            throw new InvalidAttributeValueException("Malformed '" + attr.getID() + "' attribute value");
        }
        ber.endSeq();
        ber.endSeq();
    }

    private static boolean hasNoValue(Attribute attr) throws NamingException {
        return attr.size() == 0 || attr.size() == 1 && attr.get() == null;
    }

    LdapResult add(LdapEntry entry, Control[] reqCtls) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult res = new LdapResult();
        res.status = 1;
        if (entry == null || entry.DN == null) {
            return res;
        }
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(104);
        ber.encodeString(entry.DN, this.isLdapv3);
        ber.beginSeq(48);
        NamingEnumeration<? extends Attribute> enum_ = entry.attributes.getAll();
        while (enum_.hasMore()) {
            Attribute attr = enum_.next();
            if (LdapClient.hasNoValue(attr)) {
                throw new InvalidAttributeValueException("'" + attr.getID() + "' has no values.");
            }
            this.encodeAttribute(ber, attr);
        }
        ber.endSeq();
        ber.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, reqCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId);
        return this.processReply(req, res, 105);
    }

    LdapResult delete(String DN, Control[] reqCtls) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult res = new LdapResult();
        res.status = 1;
        if (DN == null) {
            return res;
        }
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.encodeString(DN, 74, this.isLdapv3);
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, reqCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId);
        return this.processReply(req, res, 107);
    }

    LdapResult moddn(String DN, String newrdn, boolean deleteOldRdn, String newSuperior, Control[] reqCtls) throws IOException, NamingException {
        this.ensureOpen();
        boolean changeSuperior = newSuperior != null && newSuperior.length() > 0;
        LdapResult res = new LdapResult();
        res.status = 1;
        if (DN == null || newrdn == null) {
            return res;
        }
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(108);
        ber.encodeString(DN, this.isLdapv3);
        ber.encodeString(newrdn, this.isLdapv3);
        ber.encodeBoolean(deleteOldRdn);
        if (this.isLdapv3 && changeSuperior) {
            ber.encodeString(newSuperior, 128, this.isLdapv3);
        }
        ber.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, reqCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId);
        return this.processReply(req, res, 109);
    }

    LdapResult compare(String DN, String type, String value, Control[] reqCtls) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult res = new LdapResult();
        res.status = 1;
        if (DN == null || type == null || value == null) {
            return res;
        }
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(110);
        ber.encodeString(DN, this.isLdapv3);
        ber.beginSeq(48);
        ber.encodeString(type, this.isLdapv3);
        byte[] val = this.isLdapv3 ? value.getBytes("UTF8") : value.getBytes("8859_1");
        ber.encodeOctetString(Filter.unescapeFilterValue(val, 0, val.length), 4);
        ber.endSeq();
        ber.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(ber, reqCtls);
        }
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId);
        return this.processReply(req, res, 111);
    }

    LdapResult extendedOp(String id, byte[] request, Control[] reqCtls, boolean pauseAfterReceipt) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult res = new LdapResult();
        res.status = 1;
        if (id == null) {
            return res;
        }
        BerEncoder ber = new BerEncoder();
        int curMsgId = this.conn.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(curMsgId);
        ber.beginSeq(119);
        ber.encodeString(id, 128, this.isLdapv3);
        if (request != null) {
            ber.encodeOctetString(request, 129);
        }
        ber.endSeq();
        LdapClient.encodeControls(ber, reqCtls);
        ber.endSeq();
        LdapRequest req = this.conn.writeRequest(ber, curMsgId, pauseAfterReceipt);
        BerDecoder rber = this.conn.readReply(req);
        rber.parseSeq(null);
        rber.parseInt();
        if (rber.parseByte() != 120) {
            return res;
        }
        rber.parseLength();
        this.parseExtResponse(rber, res);
        this.conn.removeRequest(req);
        return res;
    }

    static String getErrorMessage(int errorCode, String errorMessage) {
        String message = "[LDAP: error code " + errorCode;
        if (errorMessage != null && errorMessage.length() != 0) {
            message = message + " - " + errorMessage + "]";
        } else {
            try {
                if (ldap_error_message[errorCode] != null) {
                    message = message + " - " + ldap_error_message[errorCode] + "]";
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                message = message + "]";
            }
        }
        return message;
    }

    void addUnsolicited(LdapCtx ctx) {
        this.unsolicited.addElement(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUnsolicited(LdapCtx ctx) {
        Vector vector = this.unsolicited;
        synchronized (vector) {
            if (this.unsolicited.size() == 0) {
                return;
            }
            this.unsolicited.removeElement(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processUnsolicited(BerDecoder ber) {
        Vector vector = this.unsolicited;
        synchronized (vector) {
            try {
                LdapResult res = new LdapResult();
                ber.parseSeq(null);
                ber.parseInt();
                if (ber.parseByte() != 120) {
                    throw new IOException("Unsolicited Notification must be an Extended Response");
                }
                ber.parseLength();
                this.parseExtResponse(ber, res);
                if (DISCONNECT_OID.equals(res.extensionId)) {
                    this.forceClose(this.pooled);
                }
                if (this.unsolicited.size() > 0) {
                    UnsolicitedResponseImpl notice = new UnsolicitedResponseImpl(res.extensionId, res.extensionValue, res.referrals, res.status, res.errorMessage, res.matchedDN, res.resControls != null ? ((LdapCtx)this.unsolicited.elementAt(0)).convertControls(res.resControls) : null);
                    this.notifyUnsolicited(notice);
                    if (DISCONNECT_OID.equals(res.extensionId)) {
                        this.notifyUnsolicited(new CommunicationException("Connection closed"));
                    }
                }
            }
            catch (IOException e) {
                if (this.unsolicited.size() == 0) {
                    return;
                }
                CommunicationException ne = new CommunicationException("Problem parsing unsolicited notification");
                ne.setRootCause(e);
                this.notifyUnsolicited(ne);
            }
            catch (NamingException e) {
                this.notifyUnsolicited(e);
            }
        }
    }

    private void notifyUnsolicited(Object e) {
        for (int i = 0; i < this.unsolicited.size(); ++i) {
            ((LdapCtx)this.unsolicited.elementAt(i)).fireUnsolicited(e);
        }
        if (e instanceof NamingException) {
            this.unsolicited.setSize(0);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.conn == null || !this.conn.useable) {
            if (this.conn != null && this.conn.closureReason != null) {
                throw this.conn.closureReason;
            }
            throw new IOException("connection closed");
        }
    }

    static LdapClient getInstance(boolean usePool, String hostname, int port, String factory, int connectTimeout, int readTimeout, OutputStream trace, int version, String authMechanism, Control[] ctls, String protocol, String user, Object passwd, Hashtable env) throws NamingException {
        if (usePool && LdapPoolManager.isPoolingAllowed(factory, trace, authMechanism, protocol, env)) {
            LdapClient answer = LdapPoolManager.getLdapClient(hostname, port, factory, connectTimeout, readTimeout, trace, version, authMechanism, ctls, protocol, user, passwd, env);
            answer.referenceCount = 1;
            return answer;
        }
        return new LdapClient(hostname, port, factory, connectTimeout, readTimeout, trace, null);
    }

    static {
        defaultBinaryAttrs.put("userpassword", Boolean.TRUE);
        defaultBinaryAttrs.put("javaserializeddata", Boolean.TRUE);
        defaultBinaryAttrs.put("javaserializedobject", Boolean.TRUE);
        defaultBinaryAttrs.put("jpegphoto", Boolean.TRUE);
        defaultBinaryAttrs.put("audio", Boolean.TRUE);
        defaultBinaryAttrs.put("thumbnailphoto", Boolean.TRUE);
        defaultBinaryAttrs.put("thumbnaillogo", Boolean.TRUE);
        defaultBinaryAttrs.put("usercertificate", Boolean.TRUE);
        defaultBinaryAttrs.put("cacertificate", Boolean.TRUE);
        defaultBinaryAttrs.put("certificaterevocationlist", Boolean.TRUE);
        defaultBinaryAttrs.put("authorityrevocationlist", Boolean.TRUE);
        defaultBinaryAttrs.put("crosscertificatepair", Boolean.TRUE);
        defaultBinaryAttrs.put("photo", Boolean.TRUE);
        defaultBinaryAttrs.put("personalsignature", Boolean.TRUE);
        defaultBinaryAttrs.put("x500uniqueidentifier", Boolean.TRUE);
        ldap_error_message = new String[]{"Success", "Operations Error", "Protocol Error", "Timelimit Exceeded", "Sizelimit Exceeded", "Compare False", "Compare True", "Authentication Method Not Supported", "Strong Authentication Required", null, "Referral", "Administrative Limit Exceeded", "Unavailable Critical Extension", "Confidentiality Required", "SASL Bind In Progress", null, "No Such Attribute", "Undefined Attribute Type", "Inappropriate Matching", "Constraint Violation", "Attribute Or Value Exists", "Invalid Attribute Syntax", null, null, null, null, null, null, null, null, null, null, "No Such Object", "Alias Problem", "Invalid DN Syntax", null, "Alias Dereferencing Problem", null, null, null, null, null, null, null, null, null, null, null, "Inappropriate Authentication", "Invalid Credentials", "Insufficient Access Rights", "Busy", "Unavailable", "Unwilling To Perform", "Loop Detect", null, null, null, null, null, null, null, null, null, "Naming Violation", "Object Class Violation", "Not Allowed On Non-leaf", "Not Allowed On RDN", "Entry Already Exists", "Object Class Modifications Prohibited", null, "Affects Multiple DSAs", null, null, null, null, null, null, null, null, "Other", null, null, null, null, null, null, null, null, null, null};
    }
}

