/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class CacheMap<K, V>
extends WeakHashMap<K, V> {
    private final LinkedList<SoftReference<K>> cache = new LinkedList();
    private final int nSoftReferences;

    public CacheMap(int nSoftReferences) {
        if (nSoftReferences < 0) {
            throw new IllegalArgumentException("nSoftReferences = " + nSoftReferences);
        }
        this.nSoftReferences = nSoftReferences;
    }

    @Override
    public V put(K key, V value) {
        this.cache(key);
        return super.put(key, value);
    }

    @Override
    public V get(Object key) {
        this.cache(Util.cast(key));
        return super.get(key);
    }

    private void cache(K key) {
        Iterator it = this.cache.iterator();
        while (it.hasNext()) {
            SoftReference sref = (SoftReference)it.next();
            Object key1 = sref.get();
            if (key1 == null) {
                it.remove();
                continue;
            }
            if (!key.equals(key1)) continue;
            it.remove();
            this.cache.add(0, sref);
            return;
        }
        int size = this.cache.size();
        if (size == this.nSoftReferences) {
            if (size == 0) {
                return;
            }
            it.remove();
        }
        this.cache.add(0, new SoftReference<K>(key));
    }
}

