/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.finder.PrimitiveWrapperMap;
import java.util.HashMap;

abstract class AbstractFinder<T> {
    private final Class<?>[] args;

    protected AbstractFinder(Class<?>[] args) {
        this.args = args;
    }

    protected abstract Class<?>[] getParameters(T var1);

    protected abstract boolean isVarArgs(T var1);

    protected abstract boolean isValid(T var1);

    final T find(T[] methods) throws NoSuchMethodException {
        boolean useOld;
        boolean useNew;
        Class<?>[] newParams;
        HashMap<T, Class[]> map = new HashMap<T, Class[]>();
        T oldMethod = null;
        Class<?>[] oldParams = null;
        boolean ambiguous = false;
        for (T newMethod : methods) {
            int length;
            if (!this.isValid(newMethod)) continue;
            newParams = this.getParameters(newMethod);
            if (newParams.length == this.args.length) {
                PrimitiveWrapperMap.replacePrimitivesWithWrappers(newParams);
                if (this.isAssignable(newParams, this.args)) {
                    if (oldMethod == null) {
                        oldMethod = newMethod;
                        oldParams = newParams;
                    } else {
                        useNew = this.isAssignable(oldParams, newParams);
                        useOld = this.isAssignable(newParams, oldParams);
                        if (useOld == useNew) {
                            ambiguous = true;
                        } else if (useNew) {
                            oldMethod = newMethod;
                            oldParams = newParams;
                            ambiguous = false;
                        }
                    }
                }
            }
            if (!this.isVarArgs(newMethod) || (length = newParams.length - 1) > this.args.length) continue;
            Class[] array = new Class[this.args.length];
            System.arraycopy(newParams, 0, array, 0, length);
            if (length < this.args.length) {
                Class<?> type = newParams[length].getComponentType();
                if (type.isPrimitive()) {
                    type = PrimitiveWrapperMap.getType(type.getName());
                }
                for (int i = length; i < this.args.length; ++i) {
                    array[i] = type;
                }
            }
            map.put(newMethod, array);
        }
        for (T newMethod : methods) {
            newParams = (Class[])map.get(newMethod);
            if (newParams == null || !this.isAssignable(newParams, this.args)) continue;
            if (oldMethod == null) {
                oldMethod = newMethod;
                oldParams = newParams;
                continue;
            }
            useNew = this.isAssignable(oldParams, newParams);
            useOld = this.isAssignable(newParams, oldParams);
            if (useOld == useNew) {
                if (oldParams != map.get(oldMethod)) continue;
                ambiguous = true;
                continue;
            }
            if (!useNew) continue;
            oldMethod = newMethod;
            oldParams = newParams;
            ambiguous = false;
        }
        if (ambiguous) {
            throw new NoSuchMethodException("Ambiguous methods are found");
        }
        if (oldMethod == null) {
            throw new NoSuchMethodException("Method is not found");
        }
        return oldMethod;
    }

    private boolean isAssignable(Class<?>[] min, Class<?>[] max) {
        for (int i = 0; i < this.args.length; ++i) {
            if (null == this.args[i] || min[i].isAssignableFrom(max[i])) continue;
            return false;
        }
        return true;
    }
}

