/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Principal;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.ServicePermission;
import javax.security.auth.login.LoginException;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.PrincipalName;
import sun.security.ssl.Krb5Proxy;

public class Krb5ProxyImpl
implements Krb5Proxy {
    @Override
    public Subject getClientSubject(AccessControlContext acc) throws LoginException {
        return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (AccessControlContext)acc);
    }

    @Override
    public Subject getServerSubject(AccessControlContext acc) throws LoginException {
        return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_SERVER, (AccessControlContext)acc);
    }

    @Override
    public SecretKey[] getServerKeys(AccessControlContext acc) throws LoginException {
        return Krb5Util.getServiceCreds((GSSCaller)GSSCaller.CALLER_SSL_SERVER, null, (AccessControlContext)acc).getKKeys();
    }

    @Override
    public String getServerPrincipalName(SecretKey kerberosKey) {
        return ((KerberosKey)kerberosKey).getPrincipal().getName();
    }

    @Override
    public String getPrincipalHostName(Principal principal) {
        if (principal == null) {
            return null;
        }
        String hostName = null;
        try {
            PrincipalName princName = new PrincipalName(principal.getName(), 3);
            String[] nameParts = princName.getNameStrings();
            if (nameParts.length >= 2) {
                hostName = nameParts[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    @Override
    public Permission getServicePermission(String principalName, String action) {
        return new ServicePermission(principalName, action);
    }
}

