# Node.js 9 ChangeLog

<!--lint disable prohibited-strings-->

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#9.3.0">9.3.0</a><br/>
<a href="#9.2.1">9.2.1</a><br/>
<a href="#9.2.0">9.2.0</a><br/>
<a href="#9.1.0">9.1.0</a><br/>
<a href="#9.0.0">9.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="9.3.0"></a>
## 2017-12-12, Version 9.3.0 (Current), @MylesBorins

### Notable Changes

* **async\_hooks**:
  - add trace events to async_hooks (Andreas Madsen) [#15538](https://github.com/nodejs/node/pull/15538)
  - add provider types for net server (Andreas Madsen) [#17157](https://github.com/nodejs/node/pull/17157)
* **console**:
  - console.debug can now be used outside of the inspector (Benjamin Zaslavsky) [#17033](https://github.com/nodejs/node/pull/17033)
* **deps**:
  - upgrade libuv to 1.18.0 (cjihrig) [#17282](https://github.com/nodejs/node/pull/17282)
  - patch V8 to 6.2.414.46 (Myles Borins) [#17206](https://github.com/nodejs/node/pull/17206)
* **module**:
  - module.builtinModules will return a list of built in modules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* **n-api**:
  - add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* **process**:
  - process.setUncaughtExceptionCaptureCallback can now be used to customize behavior for `--abort-on-uncaught-exception` (Anna Henningsen) [#17159](https://github.com/nodejs/node/pull/17159)
  - A signal handler is now able to receive the signal code that triggered the handler. (Robert Rossmann) [#15606](https://github.com/nodejs/node/pull/15606)
* **src**:
  - embedders can now use Node::CreatePlatform to create an instance of NodePlatform (Cheng Zhao) [#16981](https://github.com/nodejs/node/pull/16981)
* **stream**:
  - writable.writableHighWaterMark and readable.readableHighWaterMark will return the values the stream object was instantiated with (Calvin Metcalf) [#12860](https://github.com/nodejs/node/pull/12860)
* **Added new collaborators**
  * [maclover7](https://github.com/maclover7) Jon Moss
  * [guybedford](https://github.com/guybedford) Guy Bedford
  * [hashseed](https://github.com/hashseed) Yang Guo

### Commits

* [[`623b589921`](https://github.com/nodejs/node/commit/623b589921)] - tools/doc: add tools/remark-* to eslintignore (Ivan Wei) [#17240](https://github.com/nodejs/node/pull/17240)
* [[`cf0d7cfc46`](https://github.com/nodejs/node/commit/cf0d7cfc46)] - **async_hooks**: add destroy event for gced AsyncResources (Sebastian Mayr) [#16998](https://github.com/nodejs/node/pull/16998)
* [[`cf7e15cf78`](https://github.com/nodejs/node/commit/cf7e15cf78)] - **(SEMVER-MINOR)** **async_hooks**: add trace events to async_hooks (Andreas Madsen) [#15538](https://github.com/nodejs/node/pull/15538)
* [[`e0ce7cf1e9`](https://github.com/nodejs/node/commit/e0ce7cf1e9)] - **(SEMVER-MINOR)** **async_wrap**: add provider types for net server (Andreas Madsen) [#17157](https://github.com/nodejs/node/pull/17157)
* [[`cbd0be59f0`](https://github.com/nodejs/node/commit/cbd0be59f0)] - **benchmark**: fix http/simple.js benchmark (Anatoli Papirovski) [#17583](https://github.com/nodejs/node/pull/17583)
* [[`120d756e47`](https://github.com/nodejs/node/commit/120d756e47)] - **benchmark**: refactor to use template string (Antonio V) [#17313](https://github.com/nodejs/node/pull/17313)
* [[`b16d570395`](https://github.com/nodejs/node/commit/b16d570395)] - **benchmark**: set maxHeaderListPairs in h2 headers.js (Anatoli Papirovski) [#17194](https://github.com/nodejs/node/pull/17194)
* [[`9ffdee811d`](https://github.com/nodejs/node/commit/9ffdee811d)] - **benchmark**: use unique filenames in fs benchmarks (Rich Trott) [#16776](https://github.com/nodejs/node/pull/16776)
* [[`ee84fc333d`](https://github.com/nodejs/node/commit/ee84fc333d)] - **benchmark,path**: remove unused variables (薛定谔的猫) [#15789](https://github.com/nodejs/node/pull/15789)
* [[`883281bca9`](https://github.com/nodejs/node/commit/883281bca9)] - **buffer**: don't predefine error (buji) [#17021](https://github.com/nodejs/node/pull/17021)
* [[`dcb53c10e2`](https://github.com/nodejs/node/commit/dcb53c10e2)] - **build**: allow running configure from any directory (Gibson Fahnestock) [#17321](https://github.com/nodejs/node/pull/17321)
* [[`5d1463a0bc`](https://github.com/nodejs/node/commit/5d1463a0bc)] - **build**: define HAVE_OPENSSL macro for cctest (Matheus Marchini) [#17461](https://github.com/nodejs/node/pull/17461)
* [[`4bb27a2db3`](https://github.com/nodejs/node/commit/4bb27a2db3)] - **build**: add a `make help` option for common targets (Gibson Fahnestock) [#17323](https://github.com/nodejs/node/pull/17323)
* [[`5e0f39323f`](https://github.com/nodejs/node/commit/5e0f39323f)] - **build**: add serial commas to messages in configure script (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`742a4566ee`](https://github.com/nodejs/node/commit/742a4566ee)] - **build**: fix test-v8 target (Michaël Zasso) [#17269](https://github.com/nodejs/node/pull/17269)
* [[`46c1d999d9`](https://github.com/nodejs/node/commit/46c1d999d9)] - **build**: add make lint-js-fix (Joyee Cheung) [#17283](https://github.com/nodejs/node/pull/17283)
* [[`0a40a1133d`](https://github.com/nodejs/node/commit/0a40a1133d)] - **build**: fix bsd build with gcc (Matheus Marchini) [#16737](https://github.com/nodejs/node/pull/16737)
* [[`0f727c07b9`](https://github.com/nodejs/node/commit/0f727c07b9)] - **build**: remove empty VCLibrarianTool entry (Daniel Bevenius) [#17191](https://github.com/nodejs/node/pull/17191)
* [[`09bd797711`](https://github.com/nodejs/node/commit/09bd797711)] - **build**: Allow linking against an external copy of nghttp2. (Ed Schouten) [#16788](https://github.com/nodejs/node/pull/16788)
* [[`9093392954`](https://github.com/nodejs/node/commit/9093392954)] - **build**: do not build doc in source tarball (Joyee Cheung) [#17100](https://github.com/nodejs/node/pull/17100)
* [[`9a4abe47d5`](https://github.com/nodejs/node/commit/9a4abe47d5)] - **build**: minor corrections to configure descriptions (Daniel Bevenius) [#17094](https://github.com/nodejs/node/pull/17094)
* [[`035a24e619`](https://github.com/nodejs/node/commit/035a24e619)] - **build**: enforce order of dependency when building addons (Joyee Cheung) [#17048](https://github.com/nodejs/node/pull/17048)
* [[`91385be239`](https://github.com/nodejs/node/commit/91385be239)] - **build**: fix cctest target --with-dtrace (Daniel Bevenius) [#17039](https://github.com/nodejs/node/pull/17039)
* [[`2eec94489d`](https://github.com/nodejs/node/commit/2eec94489d)] - ***Revert*** "**build**: for --enable-static, run only cctest" (Daniel Bevenius) [#14986](https://github.com/nodejs/node/pull/14986)
* [[`578d80b59b`](https://github.com/nodejs/node/commit/578d80b59b)] - **build**: prevent echoing of recipes for test target (Daniel Bevenius) [#17010](https://github.com/nodejs/node/pull/17010)
* [[`5fc1e27e98`](https://github.com/nodejs/node/commit/5fc1e27e98)] - **build, win**: faster Release rebuilds (Bartosz Sosnowski) [#17393](https://github.com/nodejs/node/pull/17393)
* [[`90a5e9f19b`](https://github.com/nodejs/node/commit/90a5e9f19b)] - **build,win**: vcbuild refactoring call configure (Refael Ackermann) [#17299](https://github.com/nodejs/node/pull/17299)
* [[`87c885bd44`](https://github.com/nodejs/node/commit/87c885bd44)] - **build,win,msi**: support WiX with VS2017 (João Reis) [#17101](https://github.com/nodejs/node/pull/17101)
* [[`23967b2713`](https://github.com/nodejs/node/commit/23967b2713)] - **console**: make dirxml an alias for console.log (Benjamin Zaslavsky) [#17152](https://github.com/nodejs/node/pull/17152)
* [[`40d4fee8d7`](https://github.com/nodejs/node/commit/40d4fee8d7)] - **console**: add support for console.debug (Benjamin Zaslavsky) [#17033](https://github.com/nodejs/node/pull/17033)
* [[`4a5e32206a`](https://github.com/nodejs/node/commit/4a5e32206a)] - **crypto**: remove BIO_set_shutdown (Daniel Bevenius) [#17542](https://github.com/nodejs/node/pull/17542)
* [[`c951e2c7d4`](https://github.com/nodejs/node/commit/c951e2c7d4)] - **crypto**: remove explicit qualifiers in Initialize (Daniel Bevenius) [#17490](https://github.com/nodejs/node/pull/17490)
* [[`8c2143091d`](https://github.com/nodejs/node/commit/8c2143091d)] - **crypto**: do not reach into OpenSSL internals for ThrowCryptoError (David Benjamin) [#16701](https://github.com/nodejs/node/pull/16701)
* [[`49402b12d0`](https://github.com/nodejs/node/commit/49402b12d0)] - **crypto**: declare int return type for set_field (Daniel Bevenius) [#17468](https://github.com/nodejs/node/pull/17468)
* [[`9e50f1721e`](https://github.com/nodejs/node/commit/9e50f1721e)] - **crypto**: use SetNull instead of Set (Daniel Bevenius) [#17521](https://github.com/nodejs/node/pull/17521)
* [[`e3df569d1c`](https://github.com/nodejs/node/commit/e3df569d1c)] - **deps**: upgrade libuv to 1.18.0 (cjihrig) [#17282](https://github.com/nodejs/node/pull/17282)
* [[`9f282ddaf7`](https://github.com/nodejs/node/commit/9f282ddaf7)] - **deps**: cherry-pick 1420e44db0 from upstream V8 (Timothy Gu) [#17344](https://github.com/nodejs/node/pull/17344)
* [[`47cd49a8cb`](https://github.com/nodejs/node/commit/47cd49a8cb)] - **deps**: backport 3c8195d from V8 upstream (Myles Borins) [#17383](https://github.com/nodejs/node/pull/17383)
* [[`465a32a087`](https://github.com/nodejs/node/commit/465a32a087)] - ***Revert*** "**deps**: cherry-pick 3c8195d from V8 upstream" (Myles Borins) [#17383](https://github.com/nodejs/node/pull/17383)
* [[`49d23a3021`](https://github.com/nodejs/node/commit/49d23a3021)] - **deps**: V8: backport 14ac02c from upstream (Ali Ijaz Sheikh) [#17512](https://github.com/nodejs/node/pull/17512)
* [[`7c2a9bba64`](https://github.com/nodejs/node/commit/7c2a9bba64)] - **deps**: patch V8 to 6.2.414.46 (Myles Borins) [#17206](https://github.com/nodejs/node/pull/17206)
* [[`04115724dc`](https://github.com/nodejs/node/commit/04115724dc)] - **deps**: cherry-pick 98c40a4bae915 from V8 upstream (Anna Henningsen) [#17134](https://github.com/nodejs/node/pull/17134)
* [[`7812c93a41`](https://github.com/nodejs/node/commit/7812c93a41)] - **deps**: cherry-pick c690f54d95802 from V8 upstream (Anna Henningsen) [#17134](https://github.com/nodejs/node/pull/17134)
* [[`24bb99a808`](https://github.com/nodejs/node/commit/24bb99a808)] - **deps**: cherry-pick upstream ICU fix (Mathias Bynens) [#16931](https://github.com/nodejs/node/pull/16931)
* [[`026f76024b`](https://github.com/nodejs/node/commit/026f76024b)] - **dns**: fix crash while setting server during query (XadillaX) [#14891](https://github.com/nodejs/node/pull/14891)
* [[`ccffbd96d1`](https://github.com/nodejs/node/commit/ccffbd96d1)] - **doc**: fix modules.md export example (Anatoli Papirovski) [#17579](https://github.com/nodejs/node/pull/17579)
* [[`7e2fa5a2d6`](https://github.com/nodejs/node/commit/7e2fa5a2d6)] - **doc**: add link to debugger in process.md (Delapouite) [#17522](https://github.com/nodejs/node/pull/17522)
* [[`a965dda849`](https://github.com/nodejs/node/commit/a965dda849)] - **doc**: simplify and clarify FIPS text in BUILDING.md (Rich Trott) [#17538](https://github.com/nodejs/node/pull/17538)
* [[`b015747156`](https://github.com/nodejs/node/commit/b015747156)] - **doc**: esm loader example with module.builtinModules (Guy Bedford) [#17385](https://github.com/nodejs/node/pull/17385)
* [[`1eff647fd3`](https://github.com/nodejs/node/commit/1eff647fd3)] - **doc**: 'constructor' implies use of new keyword (Cameron Moorehead) [#17364](https://github.com/nodejs/node/pull/17364)
* [[`8a17b7b6f3`](https://github.com/nodejs/node/commit/8a17b7b6f3)] - **doc**: use correct and consistent typography for products (Rich Trott) [#17492](https://github.com/nodejs/node/pull/17492)
* [[`0a0a56aa34`](https://github.com/nodejs/node/commit/0a0a56aa34)] - **doc**: add "Hello world" example for N-API (Franziska Hinkelmann) [#17425](https://github.com/nodejs/node/pull/17425)
* [[`865c4520b6`](https://github.com/nodejs/node/commit/865c4520b6)] - **doc**: immprove inode text in fs.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`18d6dab19d`](https://github.com/nodejs/node/commit/18d6dab19d)] - **doc**: improve text for Console constructor (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`cb09959e8f`](https://github.com/nodejs/node/commit/cb09959e8f)] - **doc**: improve readability of README.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`0948238aa2`](https://github.com/nodejs/node/commit/0948238aa2)] - **doc**: improve readability of COLLABORATOR_GUIDE.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`7f2764debb`](https://github.com/nodejs/node/commit/7f2764debb)] - **doc**: add info on post-publishing ARM6 builds (Michael Dawson) [#17455](https://github.com/nodejs/node/pull/17455)
* [[`6aa6d418e2`](https://github.com/nodejs/node/commit/6aa6d418e2)] - **doc**: mention node-test-pull-request-lite job (Jon Moss) [#17513](https://github.com/nodejs/node/pull/17513)
* [[`b8141a42d0`](https://github.com/nodejs/node/commit/b8141a42d0)] - **doc**: fix typo in repl.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`232a486c0c`](https://github.com/nodejs/node/commit/232a486c0c)] - **doc**: fix common typo involving one-time listeners (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`07df234ea2`](https://github.com/nodejs/node/commit/07df234ea2)] - **doc**: fix typo in dns.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`6c97f7fed5`](https://github.com/nodejs/node/commit/6c97f7fed5)] - **doc**: use American spellings per style guide (Rich Trott) [#17471](https://github.com/nodejs/node/pull/17471)
* [[`35d492c428`](https://github.com/nodejs/node/commit/35d492c428)] - **doc**: remove unused link reference (Anatoli Papirovski) [#17510](https://github.com/nodejs/node/pull/17510)
* [[`e9ee168a3d`](https://github.com/nodejs/node/commit/e9ee168a3d)] - **doc**: remove IPC channel implementation details (Bartosz Sosnowski) [#17460](https://github.com/nodejs/node/pull/17460)
* [[`7e38821df2`](https://github.com/nodejs/node/commit/7e38821df2)] - **doc**: use arrow functions in util.md sample code (Mithun Sasidharan) [#17459](https://github.com/nodejs/node/pull/17459)
* [[`53ed05582a`](https://github.com/nodejs/node/commit/53ed05582a)] - **doc**: update AUTHORS list (Michaël Zasso) [#17452](https://github.com/nodejs/node/pull/17452)
* [[`f7b0054b2b`](https://github.com/nodejs/node/commit/f7b0054b2b)] - **doc**: use serial comma in tls.md (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`20dcbfce89`](https://github.com/nodejs/node/commit/20dcbfce89)] - **doc**: add serial comma in CPP_STYLE_GUIDE.md (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`01be9462d5`](https://github.com/nodejs/node/commit/01be9462d5)] - **doc**: edit module introduction (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`4fff2ab7ca`](https://github.com/nodejs/node/commit/4fff2ab7ca)] - **doc**: standardize preposition usage in fs.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`f3ec355123`](https://github.com/nodejs/node/commit/f3ec355123)] - **doc**: improve punctuation in fs.open() text (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`ef7444cc94`](https://github.com/nodejs/node/commit/ef7444cc94)] - **doc**: use colon consistently in assert.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`cd7cee57e9`](https://github.com/nodejs/node/commit/cd7cee57e9)] - **doc**: update example in module registration (Franziska Hinkelmann) [#17424](https://github.com/nodejs/node/pull/17424)
* [[`d3e76e78ff`](https://github.com/nodejs/node/commit/d3e76e78ff)] - **doc**: introduce categories to Cpp style guide (Franziska Hinkelmann) [#17095](https://github.com/nodejs/node/pull/17095)
* [[`e00923bf5e`](https://github.com/nodejs/node/commit/e00923bf5e)] - **doc**: add missing serial commas (Rich Trott) [#17384](https://github.com/nodejs/node/pull/17384)
* [[`9df52dd115`](https://github.com/nodejs/node/commit/9df52dd115)] - **doc**: be concise about serial commas (Rich Trott) [#17384](https://github.com/nodejs/node/pull/17384)
* [[`7849d53158`](https://github.com/nodejs/node/commit/7849d53158)] - **doc**: document tls.checkServerIdentity (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`a596577a31`](https://github.com/nodejs/node/commit/a596577a31)] - **doc**: improve checkServerIdentity docs (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`2a4f4f8125`](https://github.com/nodejs/node/commit/2a4f4f8125)] - **doc**: add guide to maintaining npm (Myles Borins) [#16541](https://github.com/nodejs/node/pull/16541)
* [[`3807c6887a`](https://github.com/nodejs/node/commit/3807c6887a)] - **doc**: fix doc example for cctest (Matheus Marchini) [#17355](https://github.com/nodejs/node/pull/17355)
* [[`bd55a79422`](https://github.com/nodejs/node/commit/bd55a79422)] - **doc**: clarify fast-track of reversions (Refael Ackermann) [#17332](https://github.com/nodejs/node/pull/17332)
* [[`dcd87acb7b`](https://github.com/nodejs/node/commit/dcd87acb7b)] - **doc**: make error descriptions more concise (Rich Trott) [#16954](https://github.com/nodejs/node/pull/16954)
* [[`cc91a00af6`](https://github.com/nodejs/node/commit/cc91a00af6)] - **doc**: fix typo in stream.md (Matthew Leon) [#17357](https://github.com/nodejs/node/pull/17357)
* [[`048878288b`](https://github.com/nodejs/node/commit/048878288b)] - **doc**: non-partitioned async crypto operations (Jamie Davis) [#17250](https://github.com/nodejs/node/pull/17250)
* [[`0443909848`](https://github.com/nodejs/node/commit/0443909848)] - **doc**: move Code of Conduct to admin repo (Myles Borins) [#17301](https://github.com/nodejs/node/pull/17301)
* [[`5756d67f95`](https://github.com/nodejs/node/commit/5756d67f95)] - **doc**: fix typo occuring -\> occurring (Leko) [#17350](https://github.com/nodejs/node/pull/17350)
* [[`94be7fdfec`](https://github.com/nodejs/node/commit/94be7fdfec)] - **doc**: Add link for ECMAScript 2015 (smatsu-hl) [#17317](https://github.com/nodejs/node/pull/17317)
* [[`a0acd91470`](https://github.com/nodejs/node/commit/a0acd91470)] - **doc**: caution against removing pseudoheaders (James M Snell) [#17329](https://github.com/nodejs/node/pull/17329)
* [[`2bd241e974`](https://github.com/nodejs/node/commit/2bd241e974)] - **doc**: replace string with template string (Leko) [#17316](https://github.com/nodejs/node/pull/17316)
* [[`0b1448897d`](https://github.com/nodejs/node/commit/0b1448897d)] - **doc**: replace function with arrow function in vm.md (narirou) [#17307](https://github.com/nodejs/node/pull/17307)
* [[`078b4a625b`](https://github.com/nodejs/node/commit/078b4a625b)] - **doc**: replace function with arrow function (Leko) [#17304](https://github.com/nodejs/node/pull/17304)
* [[`4fafeae4a2`](https://github.com/nodejs/node/commit/4fafeae4a2)] - **doc**: update maintainting V8 guide (Michaël Zasso) [#17260](https://github.com/nodejs/node/pull/17260)
* [[`524db29844`](https://github.com/nodejs/node/commit/524db29844)] - **doc**: fix typo in api doc of url.format(urlObject) (pkovacs) [#17295](https://github.com/nodejs/node/pull/17295)
* [[`c901ccec40`](https://github.com/nodejs/node/commit/c901ccec40)] - **doc**: add ES Modules entry to who-to-cc (Rich Trott) [#17205](https://github.com/nodejs/node/pull/17205)
* [[`e45c9c651a`](https://github.com/nodejs/node/commit/e45c9c651a)] - **doc**: add maclover7 to collaborators (Jon Moss) [#17289](https://github.com/nodejs/node/pull/17289)
* [[`f13667221b`](https://github.com/nodejs/node/commit/f13667221b)] - **doc**: update http URLs to https in README.md (Ronald Eddy Jr) [#17264](https://github.com/nodejs/node/pull/17264)
* [[`c67612963c`](https://github.com/nodejs/node/commit/c67612963c)] - **doc**: update http URLs to https in doc/api (Ronald Eddy Jr) [#17263](https://github.com/nodejs/node/pull/17263)
* [[`c345a107a6`](https://github.com/nodejs/node/commit/c345a107a6)] - **doc**: update http URLs to https in GOVERNANCE.md (Ronald Eddy Jr) [#17262](https://github.com/nodejs/node/pull/17262)
* [[`f3c5f76fe8`](https://github.com/nodejs/node/commit/f3c5f76fe8)] - **doc**: update http URLs to https in CONTRIBUTING.md (Ronald Eddy Jr) [#17261](https://github.com/nodejs/node/pull/17261)
* [[`df5436cee1`](https://github.com/nodejs/node/commit/df5436cee1)] - **doc**: add SharedArrayBuffer to Buffer documentation (Thomas den Hollander) [#15489](https://github.com/nodejs/node/pull/15489)
* [[`821951e2a9`](https://github.com/nodejs/node/commit/821951e2a9)] - **doc**: document resolve hook formats (Lucas Azzola) [#16375](https://github.com/nodejs/node/pull/16375)
* [[`04c4c1f260`](https://github.com/nodejs/node/commit/04c4c1f260)] - **doc**: fs.readFile is async but not partitioned (Jamie Davis) [#17154](https://github.com/nodejs/node/pull/17154)
* [[`74506f72e6`](https://github.com/nodejs/node/commit/74506f72e6)] - **doc**: add description for inspector-only console methods. (Benjamin Zaslavsky) [#17004](https://github.com/nodejs/node/pull/17004)
* [[`1a3aadb2e9`](https://github.com/nodejs/node/commit/1a3aadb2e9)] - **doc**: use better terminology for build machines (Anna Henningsen) [#17142](https://github.com/nodejs/node/pull/17142)
* [[`2fccf84015`](https://github.com/nodejs/node/commit/2fccf84015)] - **doc**: use "JavaScript" instead of "Javascript" (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`9dcf748000`](https://github.com/nodejs/node/commit/9dcf748000)] - **doc**: prepare for v8/V8 linting in doc text (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`bd1dbcef85`](https://github.com/nodejs/node/commit/bd1dbcef85)] - **doc**: add capitalization styling to STYLE_GUIDE (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`68870161cc`](https://github.com/nodejs/node/commit/68870161cc)] - **doc**: update mgol in AUTHORS.txt, add to .mailmap (Michał Gołębiowski-Owczarek) [#17239](https://github.com/nodejs/node/pull/17239)
* [[`ef4c909335`](https://github.com/nodejs/node/commit/ef4c909335)] - **doc**: update release table in V8 guide (Ali Ijaz Sheikh) [#17136](https://github.com/nodejs/node/pull/17136)
* [[`3f363d3cda`](https://github.com/nodejs/node/commit/3f363d3cda)] - **doc**: add guybedford to collaborators (Guy Bedford) [#17197](https://github.com/nodejs/node/pull/17197)
* [[`7b5a05bc0f`](https://github.com/nodejs/node/commit/7b5a05bc0f)] - **doc**: update AUTHORS list (Michaël Zasso) [#16571](https://github.com/nodejs/node/pull/16571)
* [[`4c23e6a8c7`](https://github.com/nodejs/node/commit/4c23e6a8c7)] - **doc**: normalize ToC indentation with heading levels in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`f1d19d5eb9`](https://github.com/nodejs/node/commit/f1d19d5eb9)] - **doc**: add Contributing to Node.js to the README ToC (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`fa82f3a5c4`](https://github.com/nodejs/node/commit/fa82f3a5c4)] - **doc**: merge Working Groups with Contributing to Node.js in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`39cfecd568`](https://github.com/nodejs/node/commit/39cfecd568)] - **doc**: remove IRC node-dev link from README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`976ed7507b`](https://github.com/nodejs/node/commit/976ed7507b)] - **doc**: add missing introduced_in comments (Luigi Pinca) [#16741](https://github.com/nodejs/node/pull/16741)
* [[`39cb687ee5`](https://github.com/nodejs/node/commit/39cb687ee5)] - **doc**: change v8 to V8 (Rich Trott) [#17089](https://github.com/nodejs/node/pull/17089)
* [[`4b35dfbb31`](https://github.com/nodejs/node/commit/4b35dfbb31)] - **doc**: avoid mentioning 'uncaughtException' (Luigi Pinca) [#16905](https://github.com/nodejs/node/pull/16905)
* [[`18b08f082a`](https://github.com/nodejs/node/commit/18b08f082a)] - **doc**: add note about using cluster without networking (pimlie) [#17031](https://github.com/nodejs/node/pull/17031)
* [[`2f34d35b0a`](https://github.com/nodejs/node/commit/2f34d35b0a)] - **doc**: explicitly document highWaterMark option (Sebastian Silbermann) [#17049](https://github.com/nodejs/node/pull/17049)
* [[`c917cd6fdd`](https://github.com/nodejs/node/commit/c917cd6fdd)] - **doc**: fix a link in dgram.md (Vse Mozhet Byt) [#17107](https://github.com/nodejs/node/pull/17107)
* [[`a12bc2df0e`](https://github.com/nodejs/node/commit/a12bc2df0e)] - **doc**: reorganize collaborator guide (Joyee Cheung) [#17056](https://github.com/nodejs/node/pull/17056)
* [[`4a9c75a279`](https://github.com/nodejs/node/commit/4a9c75a279)] - **doc**: delete unused definition in README.md (Vse Mozhet Byt) [#17108](https://github.com/nodejs/node/pull/17108)
* [[`378439e2cb`](https://github.com/nodejs/node/commit/378439e2cb)] - **doc**: add Support section in README (Rich Trott) [#16533](https://github.com/nodejs/node/pull/16533)
* [[`8dc05e4630`](https://github.com/nodejs/node/commit/8dc05e4630)] - **doc**: document common pattern for instanceof checks (Michael Dawson) [#16699](https://github.com/nodejs/node/pull/16699)
* [[`03803ee505`](https://github.com/nodejs/node/commit/03803ee505)] - **doc**: mention smart pointers in Cpp style guide (Franziska Hinkelmann) [#17055](https://github.com/nodejs/node/pull/17055)
* [[`b87030c5cf`](https://github.com/nodejs/node/commit/b87030c5cf)] - **doc**: correct the wrong added meta data (Gaara) [#17072](https://github.com/nodejs/node/pull/17072)
* [[`73295370cc`](https://github.com/nodejs/node/commit/73295370cc)] - **doc**: document fs.realpath.native() (Ben Noordhuis) [#17059](https://github.com/nodejs/node/pull/17059)
* [[`4bdd05dd84`](https://github.com/nodejs/node/commit/4bdd05dd84)] - **doc**: add Table of Contents to Cpp style guide (Franziska Hinkelmann) [#17052](https://github.com/nodejs/node/pull/17052)
* [[`7d49bd0045`](https://github.com/nodejs/node/commit/7d49bd0045)] - **doc**: add `clientCertEngine` to docs (Rich Trott) 
* [[`7594032fac`](https://github.com/nodejs/node/commit/7594032fac)] - **doc**: add hashseed to collaborators (Yang Guo) 
* [[`a256482318`](https://github.com/nodejs/node/commit/a256482318)] - **doc,test**: remove unnecessary await with return instances (Rich Trott) [#17265](https://github.com/nodejs/node/pull/17265)
* [[`bccdea623d`](https://github.com/nodejs/node/commit/bccdea623d)] - **doc,win**: clarify WSL support (João Reis) [#17008](https://github.com/nodejs/node/pull/17008)
* [[`9b16e15f44`](https://github.com/nodejs/node/commit/9b16e15f44)] - **domain**: re-implement domain over async_hook (vladimir) [#16222](https://github.com/nodejs/node/pull/16222)
* [[`9c2f24e288`](https://github.com/nodejs/node/commit/9c2f24e288)] - **errors**: fix typo in TLS_SESSION_ATTACK message (Tom Hallam) [#17388](https://github.com/nodejs/node/pull/17388)
* [[`a333e71342`](https://github.com/nodejs/node/commit/a333e71342)] - **errors**: consistent format for error message (Anatoli Papirovski) [#16904](https://github.com/nodejs/node/pull/16904)
* [[`715baf8214`](https://github.com/nodejs/node/commit/715baf8214)] - **fs**: use rest param & Reflect.apply in makeCallback (Mithun Sasidharan) [#17486](https://github.com/nodejs/node/pull/17486)
* [[`7ebaf83602`](https://github.com/nodejs/node/commit/7ebaf83602)] - **fs**: use arrow functions instead of `.bind` and `self` (Weijia Wang) [#17137](https://github.com/nodejs/node/pull/17137)
* [[`24dc57bc71`](https://github.com/nodejs/node/commit/24dc57bc71)] - **http**: simplify checkIsHttpToken() (Rich Trott) [#17399](https://github.com/nodejs/node/pull/17399)
* [[`5a4b6c4bc0`](https://github.com/nodejs/node/commit/5a4b6c4bc0)] - **http**: do not assign intermediate variable (Jon Moss) [#17335](https://github.com/nodejs/node/pull/17335)
* [[`a6b6acb68c`](https://github.com/nodejs/node/commit/a6b6acb68c)] - **http, stream**: writeHWM -\> writableHighWaterMark (Matteo Collina) [#17050](https://github.com/nodejs/node/pull/17050)
* [[`658338e317`](https://github.com/nodejs/node/commit/658338e317)] - **http2**: use more descriptive names (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`4994d57890`](https://github.com/nodejs/node/commit/4994d57890)] - **http2**: remove unnecessary event handlers (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`67abc1e697`](https://github.com/nodejs/node/commit/67abc1e697)] - **http2**: reduce code duplication in settings (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`e5f92cda7e`](https://github.com/nodejs/node/commit/e5f92cda7e)] - **http2**: general cleanups (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`54cd7dfd88`](https://github.com/nodejs/node/commit/54cd7dfd88)] - **inspector**: Fix crash for WS connection (Eugene Ostroukhov) [#17085](https://github.com/nodejs/node/pull/17085)
* [[`94e0488a33`](https://github.com/nodejs/node/commit/94e0488a33)] - **inspector**: no async tracking for promises (Anna Henningsen) [#17118](https://github.com/nodejs/node/pull/17118)
* [[`8fd316f63b`](https://github.com/nodejs/node/commit/8fd316f63b)] - **internal**: add emitExperimentalWarning function (Cody Deckard) [#16497](https://github.com/nodejs/node/pull/16497)
* [[`1a8b0e9fa5`](https://github.com/nodejs/node/commit/1a8b0e9fa5)] - **lib**: replace string concatenation with template (Vijayalakshmi Kannan) [#16923](https://github.com/nodejs/node/pull/16923)
* [[`b719b77215`](https://github.com/nodejs/node/commit/b719b77215)] - **module**: print better message on esm syntax error (Ben Noordhuis) [#17281](https://github.com/nodejs/node/pull/17281)
* [[`5736dc4ab9`](https://github.com/nodejs/node/commit/5736dc4ab9)] - **module**: fix for #17130 shared loader cjs dep (Guy Bedford) [#17131](https://github.com/nodejs/node/pull/17131)
* [[`06da8a7f16`](https://github.com/nodejs/node/commit/06da8a7f16)] - **module**: be lazy when creating CJS facades (Bradley Farias) [#17153](https://github.com/nodejs/node/pull/17153)
* [[`7ae7124039`](https://github.com/nodejs/node/commit/7ae7124039)] - **(SEMVER-MINOR)** **module**: add builtinModules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* [[`caff930d47`](https://github.com/nodejs/node/commit/caff930d47)] - **module**: replace default paths in require.resolve() (cjihrig) [#17113](https://github.com/nodejs/node/pull/17113)
* [[`b833a5989c`](https://github.com/nodejs/node/commit/b833a5989c)] - **n-api**: use nullptr instead of NULL in node_api.cc (Daniel Bevenius) [#17276](https://github.com/nodejs/node/pull/17276)
* [[`8d222d42ab`](https://github.com/nodejs/node/commit/8d222d42ab)] - **(SEMVER-MINOR)** **n-api**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`8366a74bbf`](https://github.com/nodejs/node/commit/8366a74bbf)] - **path**: remove obsolete comment (Rich Trott) [#17023](https://github.com/nodejs/node/pull/17023)
* [[`a159a2c6ac`](https://github.com/nodejs/node/commit/a159a2c6ac)] - **process**: slight refinements to nextTick (Anatoli Papirovski) [#17421](https://github.com/nodejs/node/pull/17421)
* [[`347164a703`](https://github.com/nodejs/node/commit/347164a703)] - **(SEMVER-MINOR)** **process**: add flag for uncaught exception abort (Anna Henningsen) [#17159](https://github.com/nodejs/node/pull/17159)
* [[`9d657247df`](https://github.com/nodejs/node/commit/9d657247df)] - **process**: slightly simplify next tick execution (Anatoli Papirovski) [#16888](https://github.com/nodejs/node/pull/16888)
* [[`8d90db5120`](https://github.com/nodejs/node/commit/8d90db5120)] - **(SEMVER-MINOR)** **process**: Send signal name to signal handlers (Robert Rossmann) [#15606](https://github.com/nodejs/node/pull/15606)
* [[`9a9aa88797`](https://github.com/nodejs/node/commit/9a9aa88797)] - **process**: improve unhandled rejection message (Madara Uchiha) [#17158](https://github.com/nodejs/node/pull/17158)
* [[`8dcc40a84f`](https://github.com/nodejs/node/commit/8dcc40a84f)] - **src**: remove unused include node_crypto_clienthello (Daniel Bevenius) [#17546](https://github.com/nodejs/node/pull/17546)
* [[`fb3ea4c4dc`](https://github.com/nodejs/node/commit/fb3ea4c4dc)] - **src**: fix missing handlescope bug in inspector (Ben Noordhuis) [#17539](https://github.com/nodejs/node/pull/17539)
* [[`40acda2e6b`](https://github.com/nodejs/node/commit/40acda2e6b)] - **src**: use uv_os_getpid() to get process id (cjihrig) [#17415](https://github.com/nodejs/node/pull/17415)
* [[`9b41c0b021`](https://github.com/nodejs/node/commit/9b41c0b021)] - **src**: node_http2_state.h should not be executable (Jon Moss) [#17408](https://github.com/nodejs/node/pull/17408)
* [[`419cde79b1`](https://github.com/nodejs/node/commit/419cde79b1)] - **src**: use non-deprecated versions of `-\>To*()` utils (Leko) [#17343](https://github.com/nodejs/node/pull/17343)
* [[`ceda8c57aa`](https://github.com/nodejs/node/commit/ceda8c57aa)] - **src**: use nullptr instead of NULL (Daniel Bevenius) [#17373](https://github.com/nodejs/node/pull/17373)
* [[`7f55f98a84`](https://github.com/nodejs/node/commit/7f55f98a84)] - **src**: fix typo in NODE_OPTIONS whitelist (Evan Lucas) [#17369](https://github.com/nodejs/node/pull/17369)
* [[`9b27bc85ae`](https://github.com/nodejs/node/commit/9b27bc85ae)] - **src**: introduce USE() for silencing compiler warnings (Anna Henningsen) [#17333](https://github.com/nodejs/node/pull/17333)
* [[`0db1f87825`](https://github.com/nodejs/node/commit/0db1f87825)] - **src**: use NODE_BUILTIN_MODULE_CONTEXT_AWARE() macro (Ben Noordhuis) [#17071](https://github.com/nodejs/node/pull/17071)
* [[`6a7a59a8c1`](https://github.com/nodejs/node/commit/6a7a59a8c1)] - **src**: remove `ClearFatalExceptionHandlers()` (Anna Henningsen) [#17333](https://github.com/nodejs/node/pull/17333)
* [[`9c7a42a2e4`](https://github.com/nodejs/node/commit/9c7a42a2e4)] - **src**: explicitly register built-in modules (Yihong Wang) [#16565](https://github.com/nodejs/node/pull/16565)
* [[`4667c5e720`](https://github.com/nodejs/node/commit/4667c5e720)] - **src**: start heap object tracking after platform is initialized (Hannes Payer) [#17249](https://github.com/nodejs/node/pull/17249)
* [[`63f6947a41`](https://github.com/nodejs/node/commit/63f6947a41)] - **src**: make base64.h self-contained (Daniel Bevenius) [#17177](https://github.com/nodejs/node/pull/17177)
* [[`14ebda5218`](https://github.com/nodejs/node/commit/14ebda5218)] - **(SEMVER-MINOR)** **src**: add public API for managing NodePlatform (Cheng Zhao) [#16981](https://github.com/nodejs/node/pull/16981)
* [[`9832b8e206`](https://github.com/nodejs/node/commit/9832b8e206)] - **src**: add napi_handle_scope_mismatch to msg list (neta) [#17161](https://github.com/nodejs/node/pull/17161)
* [[`0b128842f6`](https://github.com/nodejs/node/commit/0b128842f6)] - **src**: fix compiler warning (cjihrig) [#17195](https://github.com/nodejs/node/pull/17195)
* [[`9c0c33625a`](https://github.com/nodejs/node/commit/9c0c33625a)] - **src**: remove unprofessional slang in assertions (Alexey Orlenko) [#17166](https://github.com/nodejs/node/pull/17166)
* [[`936c0b2b83`](https://github.com/nodejs/node/commit/936c0b2b83)] - **src**: implement v8::TaskRunner API in NodePlatform (Anna Henningsen) [#17134](https://github.com/nodejs/node/pull/17134)
* [[`a9be7bf35b`](https://github.com/nodejs/node/commit/a9be7bf35b)] - **src**: remove unused variable (cjihrig) [#17150](https://github.com/nodejs/node/pull/17150)
* [[`84b707089e`](https://github.com/nodejs/node/commit/84b707089e)] - **(SEMVER-MINOR)** **src**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`362b8c7d5d`](https://github.com/nodejs/node/commit/362b8c7d5d)] - **src**: inspector context name = program title + pid (Ben Noordhuis) [#17087](https://github.com/nodejs/node/pull/17087)
* [[`7ecec6704f`](https://github.com/nodejs/node/commit/7ecec6704f)] - **src**: abstract getpid() operation (Ben Noordhuis) [#17087](https://github.com/nodejs/node/pull/17087)
* [[`e7db034571`](https://github.com/nodejs/node/commit/e7db034571)] - **src**: add NODE_VERSION_IS_LTS to node_version.h (Gibson Fahnestock) [#16697](https://github.com/nodejs/node/pull/16697)
* [[`60423f5845`](https://github.com/nodejs/node/commit/60423f5845)] - **src**: use unique_ptr for http2_state (Franziska Hinkelmann) [#17078](https://github.com/nodejs/node/pull/17078)
* [[`e9000901ca`](https://github.com/nodejs/node/commit/e9000901ca)] - **src**: add missing include in node_platform.h (Anna Henningsen) [#17133](https://github.com/nodejs/node/pull/17133)
* [[`1b76cfe3c2`](https://github.com/nodejs/node/commit/1b76cfe3c2)] - **src**: use unique_ptr for scheduled delayed tasks (Franziska Hinkelmann) [#17083](https://github.com/nodejs/node/pull/17083)
* [[`af63df80b4`](https://github.com/nodejs/node/commit/af63df80b4)] - **src**: use std::unique_ptr in base-object-inl.h (Franziska Hinkelmann) [#17079](https://github.com/nodejs/node/pull/17079)
* [[`4387a73514`](https://github.com/nodejs/node/commit/4387a73514)] - **src**: remove superfluous check in backtrace_posix.cc (Anna Henningsen) [#16950](https://github.com/nodejs/node/pull/16950)
* [[`3ab3b0d4e2`](https://github.com/nodejs/node/commit/3ab3b0d4e2)] - **src**: fix size of CounterSet (Witthawat Piwawatthanapanit) [#16984](https://github.com/nodejs/node/pull/16984)
* [[`d74c7c5461`](https://github.com/nodejs/node/commit/d74c7c5461)] - **src**: rename req-wrap -\> req_wrap (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`5119bb1a6d`](https://github.com/nodejs/node/commit/5119bb1a6d)] - **src**: rename base-object -\> base_object (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`8ba513ee2e`](https://github.com/nodejs/node/commit/8ba513ee2e)] - **src**: rename async-wrap -\> async_wrap (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`da8414e09a`](https://github.com/nodejs/node/commit/da8414e09a)] - **src**: use smart pointer instead of new and delete (Franziska Hinkelmann) [#17020](https://github.com/nodejs/node/pull/17020)
* [[`17e31dc66a`](https://github.com/nodejs/node/commit/17e31dc66a)] - **src**: perf_hooks: fix wrong sized delete (Ali Ijaz Sheikh) [#16898](https://github.com/nodejs/node/pull/16898)
* [[`a1a99570aa`](https://github.com/nodejs/node/commit/a1a99570aa)] - **src**: make ownership of stdio_pipes explicit (Franziska Hinkelmann) [#17030](https://github.com/nodejs/node/pull/17030)
* [[`98a07709f4`](https://github.com/nodejs/node/commit/98a07709f4)] - **src**: use unique pointer for tracing_agent (Franziska Hinkelmann) [#17012](https://github.com/nodejs/node/pull/17012)
* [[`a05c49c48d`](https://github.com/nodejs/node/commit/a05c49c48d)] - **src**: use unique_ptr for requests in crypto (Franziska Hinkelmann) [#17000](https://github.com/nodejs/node/pull/17000)
* [[`6f805c6967`](https://github.com/nodejs/node/commit/6f805c6967)] - **src**: implement backtrace-on-abort for windows (Anna Henningsen) [#16951](https://github.com/nodejs/node/pull/16951)
* [[`7ac760b603`](https://github.com/nodejs/node/commit/7ac760b603)] - **src**: fix SetClientCertEngine() nullptr dereference (Ben Noordhuis) [#16965](https://github.com/nodejs/node/pull/16965)
* [[`f6ec5fa4e8`](https://github.com/nodejs/node/commit/f6ec5fa4e8)] - **src**: fix bad sizeof expression (Ben Noordhuis) [#17014](https://github.com/nodejs/node/pull/17014)
* [[`8522e2420d`](https://github.com/nodejs/node/commit/8522e2420d)] - **src**: use unique_ptr in platform implementation (Franziska Hinkelmann) [#16970](https://github.com/nodejs/node/pull/16970)
* [[`c2431d553b`](https://github.com/nodejs/node/commit/c2431d553b)] - **src**: cancel pending delayed platform tasks on exit (Anna Henningsen) [#16700](https://github.com/nodejs/node/pull/16700)
* [[`37a60a8c3c`](https://github.com/nodejs/node/commit/37a60a8c3c)] - **src**: prepare v8 platform for multi-isolate support (Anna Henningsen) [#16700](https://github.com/nodejs/node/pull/16700)
* [[`b36c726206`](https://github.com/nodejs/node/commit/b36c726206)] - **stream**: improve the error message of `ERR_INVALID_ARG_TYPE` (Weijia Wang) [#17145](https://github.com/nodejs/node/pull/17145)
* [[`78b82b03c5`](https://github.com/nodejs/node/commit/78b82b03c5)] - **stream**: use arrow fns for 'this' in readable (Vipin Menon) [#16927](https://github.com/nodejs/node/pull/16927)
* [[`edb9846884`](https://github.com/nodejs/node/commit/edb9846884)] - **(SEMVER-MINOR)** **stream**: remove usage of *State.highWaterMark (Calvin Metcalf) [#12860](https://github.com/nodejs/node/pull/12860)
* [[`e7ae8eb457`](https://github.com/nodejs/node/commit/e7ae8eb457)] - **test**: refactor test-child-process-pass-fd (Rich Trott) [#17596](https://github.com/nodejs/node/pull/17596)
* [[`5a9172fe06`](https://github.com/nodejs/node/commit/5a9172fe06)] - **test**: remove unnecessary use of common.PORT in addons test (Rich Trott) [#17563](https://github.com/nodejs/node/pull/17563)
* [[`39e2fb6ad4`](https://github.com/nodejs/node/commit/39e2fb6ad4)] - **test**: simplify common.PORT code (Rich Trott) [#17559](https://github.com/nodejs/node/pull/17559)
* [[`f45ef442bb`](https://github.com/nodejs/node/commit/f45ef442bb)] - **test**: refactor test-http-default-port (Anna Henningsen) [#17562](https://github.com/nodejs/node/pull/17562)
* [[`49d662846e`](https://github.com/nodejs/node/commit/49d662846e)] - **test**: replace assert.throws w/ common.expectsError (Anatoli Papirovski) [#17557](https://github.com/nodejs/node/pull/17557)
* [[`f7e5ab082d`](https://github.com/nodejs/node/commit/f7e5ab082d)] - **test**: refactored to remove unnecessary variables (Mithun Sasidharan) [#17553](https://github.com/nodejs/node/pull/17553)
* [[`bb780d2d84`](https://github.com/nodejs/node/commit/bb780d2d84)] - **test**: use Countdown in http-agent test (Federico Kauffman) [#17537](https://github.com/nodejs/node/pull/17537)
* [[`510116ebe6`](https://github.com/nodejs/node/commit/510116ebe6)] - **test**: update http test to use common.mustCall (Collins Abitekaniza) [#17528](https://github.com/nodejs/node/pull/17528)
* [[`39d8e4413a`](https://github.com/nodejs/node/commit/39d8e4413a)] - **test**: improve assert messages in repl-reset-event (Adri Van Houdt) [#16836](https://github.com/nodejs/node/pull/16836)
* [[`6576382eaa`](https://github.com/nodejs/node/commit/6576382eaa)] - **test**: update test-http-should-keep-alive to use countdown (TomerOmri) [#17505](https://github.com/nodejs/node/pull/17505)
* [[`f3d619882e`](https://github.com/nodejs/node/commit/f3d619882e)] - **test**: fix flaky test-benchmark-es (Rich Trott) [#17516](https://github.com/nodejs/node/pull/17516)
* [[`ff59d3a30e`](https://github.com/nodejs/node/commit/ff59d3a30e)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17483](https://github.com/nodejs/node/pull/17483)
* [[`28b2d8ac20`](https://github.com/nodejs/node/commit/28b2d8ac20)] - **test**: use common.expectsError in tests (Mithun Sasidharan) [#17484](https://github.com/nodejs/node/pull/17484)
* [[`d15cdc6fdb`](https://github.com/nodejs/node/commit/d15cdc6fdb)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17498](https://github.com/nodejs/node/pull/17498)
* [[`993b1cbc6d`](https://github.com/nodejs/node/commit/993b1cbc6d)] - **test**: use Countdown in http test (idandagan1) [#17506](https://github.com/nodejs/node/pull/17506)
* [[`1aae28b7c9`](https://github.com/nodejs/node/commit/1aae28b7c9)] - **test**: use Number.isNaN instead of global isNaN (Mithun Sasidharan) [#17515](https://github.com/nodejs/node/pull/17515)
* [[`2a5da9c2c9`](https://github.com/nodejs/node/commit/2a5da9c2c9)] - **test**: use Countdown in http-response-statuscode (Mandeep Singh) [#17327](https://github.com/nodejs/node/pull/17327)
* [[`919625bd6a`](https://github.com/nodejs/node/commit/919625bd6a)] - **test**: use Countdown in test-http-set-cookies (Shilo Mangam) [#17504](https://github.com/nodejs/node/pull/17504)
* [[`f399667784`](https://github.com/nodejs/node/commit/f399667784)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17497](https://github.com/nodejs/node/pull/17497)
* [[`c2ff36ed7f`](https://github.com/nodejs/node/commit/c2ff36ed7f)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17494](https://github.com/nodejs/node/pull/17494)
* [[`af8e27d10e`](https://github.com/nodejs/node/commit/af8e27d10e)] - **test**: Use common.mustCall in http test (sreepurnajasti) [#17487](https://github.com/nodejs/node/pull/17487)
* [[`7b8622f946`](https://github.com/nodejs/node/commit/7b8622f946)] - **test**: update http test to use Countdown (Francisco Gerardo Neri Andriano) [#17477](https://github.com/nodejs/node/pull/17477)
* [[`fb553b5b59`](https://github.com/nodejs/node/commit/fb553b5b59)] - **test**: improve crypto test coverage (Leko) [#17426](https://github.com/nodejs/node/pull/17426)
* [[`928aecc92c`](https://github.com/nodejs/node/commit/928aecc92c)] - **test**: replace fs.accessSync with fs.existsSync (Leko) [#17446](https://github.com/nodejs/node/pull/17446)
* [[`7d3a84388d`](https://github.com/nodejs/node/commit/7d3a84388d)] - **test**: fix flaky test-benchmark-querystring (Rich Trott) [#17517](https://github.com/nodejs/node/pull/17517)
* [[`50f120eaac`](https://github.com/nodejs/node/commit/50f120eaac)] - **test**: fix flaky test-benchmark-util (Rich Trott) [#17473](https://github.com/nodejs/node/pull/17473)
* [[`a407a48bdf`](https://github.com/nodejs/node/commit/a407a48bdf)] - **test**: expand coverage for crypto (Leko) [#17447](https://github.com/nodejs/node/pull/17447)
* [[`07547346a8`](https://github.com/nodejs/node/commit/07547346a8)] - **test**: add common.crashOnUnhandledRejection() (IHsuan) [#17247](https://github.com/nodejs/node/pull/17247)
* [[`8c32b4a37a`](https://github.com/nodejs/node/commit/8c32b4a37a)] - **test**: refactor code to use common.mustCall (Mithun Sasidharan) [#17437](https://github.com/nodejs/node/pull/17437)
* [[`fe9d9f732b`](https://github.com/nodejs/node/commit/fe9d9f732b)] - **test**: remove hidden use of common.PORT in parallel tests (Rich Trott) [#17466](https://github.com/nodejs/node/pull/17466)
* [[`cca3526faf`](https://github.com/nodejs/node/commit/cca3526faf)] - **test**: add more settings to test-benchmark-dgram (Rich Trott) [#17462](https://github.com/nodejs/node/pull/17462)
* [[`562007ce2a`](https://github.com/nodejs/node/commit/562007ce2a)] - **test**: add dgram benchmark test (jopann) [#17462](https://github.com/nodejs/node/pull/17462)
* [[`619cbc4364`](https://github.com/nodejs/node/commit/619cbc4364)] - **test**: fix flaky test-benchmark-events (Rich Trott) [#17472](https://github.com/nodejs/node/pull/17472)
* [[`d8018bc91d`](https://github.com/nodejs/node/commit/d8018bc91d)] - **test**: update test-http-request-dont-override-options to use common.mustCall (Mithun Sasidharan) [#17438](https://github.com/nodejs/node/pull/17438)
* [[`0ac87c2525`](https://github.com/nodejs/node/commit/0ac87c2525)] - **test**: replace assert.throws with common.expectsError (Leko) [#17445](https://github.com/nodejs/node/pull/17445)
* [[`07fd4cfbe0`](https://github.com/nodejs/node/commit/07fd4cfbe0)] - **test**: use common.mustCall in test-http-malformed-request (Mithun Sasidharan) [#17439](https://github.com/nodejs/node/pull/17439)
* [[`0ade4888f2`](https://github.com/nodejs/node/commit/0ade4888f2)] - **test**: forbid `common.mustCall*()` in process exit handlers (Rich Trott) [#17453](https://github.com/nodejs/node/pull/17453)
* [[`85e6271995`](https://github.com/nodejs/node/commit/85e6271995)] - **test**: use Countdown in http test (Mithun Sasidharan) [#17436](https://github.com/nodejs/node/pull/17436)
* [[`8c81ba0b1c`](https://github.com/nodejs/node/commit/8c81ba0b1c)] - **test**: remove common.PORT from parallel tests (Rich Trott) [#17410](https://github.com/nodejs/node/pull/17410)
* [[`5fecdbaca9`](https://github.com/nodejs/node/commit/5fecdbaca9)] - **test**: update test-http-response-multiheaders to use countdown (hmammedzadeh) [#17419](https://github.com/nodejs/node/pull/17419)
* [[`69e775d454`](https://github.com/nodejs/node/commit/69e775d454)] - **test**: update test-http-timeout to use countdown (Mithun Sasidharan) [#17341](https://github.com/nodejs/node/pull/17341)
* [[`9cbb0dadc0`](https://github.com/nodejs/node/commit/9cbb0dadc0)] - **test**: make common.mustNotCall show file:linenumber (Lance Ball) [#17257](https://github.com/nodejs/node/pull/17257)
* [[`259f2d331d`](https://github.com/nodejs/node/commit/259f2d331d)] - **test**: remove fixturesDir from common module (Rich Trott) [#17400](https://github.com/nodejs/node/pull/17400)
* [[`92b29cd659`](https://github.com/nodejs/node/commit/92b29cd659)] - **test**: remove common.fixturesDir from tests (Rich Trott) [#17400](https://github.com/nodejs/node/pull/17400)
* [[`0afcea280e`](https://github.com/nodejs/node/commit/0afcea280e)] - **test**: add test case for missing branch (Leko) [#17418](https://github.com/nodejs/node/pull/17418)
* [[`c9a4f4f8f1`](https://github.com/nodejs/node/commit/c9a4f4f8f1)] - **test**: update test-http-upgrade-client to use countdown (Mithun Sasidharan) [#17339](https://github.com/nodejs/node/pull/17339)
* [[`91d541627e`](https://github.com/nodejs/node/commit/91d541627e)] - **test**: update test-http-status-reason-invalid-chars to use countdown (Mithun Sasidharan) [#17342](https://github.com/nodejs/node/pull/17342)
* [[`4fb070873e`](https://github.com/nodejs/node/commit/4fb070873e)] - **test**: refactored test-http-allow-req-after-204-res to countdown (Mithun Sasidharan) [#17211](https://github.com/nodejs/node/pull/17211)
* [[`ef25de7493`](https://github.com/nodejs/node/commit/ef25de7493)] - **test**: update test/parallel/test-http-pipe-fs.js to use countdown (ChungNgoops) [#17346](https://github.com/nodejs/node/pull/17346)
* [[`1866b05042`](https://github.com/nodejs/node/commit/1866b05042)] - **test**: refactored test-http-response-splitting to use countdown (Mithun Sasidharan) [#17348](https://github.com/nodejs/node/pull/17348)
* [[`ee1c95f992`](https://github.com/nodejs/node/commit/ee1c95f992)] - **test**: expanded assertions for console.timeEnd() output (NiveditN) [#17368](https://github.com/nodejs/node/pull/17368)
* [[`8336e4f88e`](https://github.com/nodejs/node/commit/8336e4f88e)] - **test**: add test case for process.dlopen with undefined (Leko) [#17343](https://github.com/nodejs/node/pull/17343)
* [[`f0608814af`](https://github.com/nodejs/node/commit/f0608814af)] - **test**: add test case for throwing an exception with vm.Script (Leko) [#17343](https://github.com/nodejs/node/pull/17343)
* [[`78592a34c6`](https://github.com/nodejs/node/commit/78592a34c6)] - **test**: make CreateParams stack-allocated (Daniel Bevenius) [#17366](https://github.com/nodejs/node/pull/17366)
* [[`ca81d4bb3f`](https://github.com/nodejs/node/commit/ca81d4bb3f)] - **test**: use v8 Default Allocator in cctest fixture (Daniel Bevenius) [#17366](https://github.com/nodejs/node/pull/17366)
* [[`6e3a8be43a`](https://github.com/nodejs/node/commit/6e3a8be43a)] - **test**: replace function with arrow function (Leko) [#17345](https://github.com/nodejs/node/pull/17345)
* [[`f5a1e6cbc4`](https://github.com/nodejs/node/commit/f5a1e6cbc4)] - **test**: fix flaky async-hooks/test-graph.signal (Rich Trott) [#17509](https://github.com/nodejs/node/pull/17509)
* [[`f1b26be684`](https://github.com/nodejs/node/commit/f1b26be684)] - **test**: remove common.tmpDirName (Rich Trott) [#17266](https://github.com/nodejs/node/pull/17266)
* [[`047bac2475`](https://github.com/nodejs/node/commit/047bac2475)] - **test**: fixup test-http2-create-client-secure-session (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`3d45a94b56`](https://github.com/nodejs/node/commit/3d45a94b56)] - **test**: mock the lookup function in parallel tests (Joyee Cheung) [#17296](https://github.com/nodejs/node/pull/17296)
* [[`4e789a3bf8`](https://github.com/nodejs/node/commit/4e789a3bf8)] - **test**: add common.dns.errorLookupMock (Joyee Cheung) [#17296](https://github.com/nodejs/node/pull/17296)
* [[`71eb186572`](https://github.com/nodejs/node/commit/71eb186572)] - **test**: replace function with ES6 arrow function (Junichi Kajiwara) [#17306](https://github.com/nodejs/node/pull/17306)
* [[`36e2643d7b`](https://github.com/nodejs/node/commit/36e2643d7b)] - **test**: add es6 module global leakage tests (WhoMeNope) [#16341](https://github.com/nodejs/node/pull/16341)
* [[`afdfc4de8f`](https://github.com/nodejs/node/commit/afdfc4de8f)] - **test**: Enable specifying flaky tests on fips (Nikhil Komawar) [#16329](https://github.com/nodejs/node/pull/16329)
* [[`24d08fee45`](https://github.com/nodejs/node/commit/24d08fee45)] - **test**: refactored http test to use countdown (Mithun Sasidharan) [#17241](https://github.com/nodejs/node/pull/17241)
* [[`b033d38022`](https://github.com/nodejs/node/commit/b033d38022)] - **test**: Update test-http-parser-free to use countdown timer (Mandeep Singh) [#17322](https://github.com/nodejs/node/pull/17322)
* [[`4a749c3a70`](https://github.com/nodejs/node/commit/4a749c3a70)] - **test**: Update test-http-client-agent to use countdown timer (Mandeep Singh) [#17325](https://github.com/nodejs/node/pull/17325)
* [[`1e3aed0be3`](https://github.com/nodejs/node/commit/1e3aed0be3)] - **test**: fix flaky parallel/test-http2-client-upload (Anna Henningsen) [#17361](https://github.com/nodejs/node/pull/17361)
* [[`1adccc6a6a`](https://github.com/nodejs/node/commit/1adccc6a6a)] - **test**: fix isNAN-\>Number.isNAN (yuza yuko) [#17309](https://github.com/nodejs/node/pull/17309)
* [[`91e21171c7`](https://github.com/nodejs/node/commit/91e21171c7)] - **test**: make use of Number.isNaN to test-readfloat.js (Hiromu Yoshiwara) [#17310](https://github.com/nodejs/node/pull/17310)
* [[`97a279e375`](https://github.com/nodejs/node/commit/97a279e375)] - **test**: replace function with arrow function (spring_raining) [#17312](https://github.com/nodejs/node/pull/17312)
* [[`e35acedca5`](https://github.com/nodejs/node/commit/e35acedca5)] - **test**: refactor using template string (Yoshiya Hinosawa) [#17314](https://github.com/nodejs/node/pull/17314)
* [[`f51cb1c0cd`](https://github.com/nodejs/node/commit/f51cb1c0cd)] - **test**: replace function with arrow function (Hiroaki KARASAWA) [#17308](https://github.com/nodejs/node/pull/17308)
* [[`3f4d0fc76b`](https://github.com/nodejs/node/commit/3f4d0fc76b)] - **test**: replace function with arrow function (kou-hin) [#17305](https://github.com/nodejs/node/pull/17305)
* [[`d8e4d9593b`](https://github.com/nodejs/node/commit/d8e4d9593b)] - **test**: use arrow function (koooge) [#17318](https://github.com/nodejs/node/pull/17318)
* [[`b420209fc6`](https://github.com/nodejs/node/commit/b420209fc6)] - **test**: use common.hasIntl instead of typeof Intl (Aqui Tsuchida) [#17311](https://github.com/nodejs/node/pull/17311)
* [[`284dad7468`](https://github.com/nodejs/node/commit/284dad7468)] - **test**: use Number.isNaN() (MURAKAMI Masahiko) [#17319](https://github.com/nodejs/node/pull/17319)
* [[`94abefba93`](https://github.com/nodejs/node/commit/94abefba93)] - **test**: add test of stream Transform (Yoshiya Hinosawa) [#17303](https://github.com/nodejs/node/pull/17303)
* [[`e026132726`](https://github.com/nodejs/node/commit/e026132726)] - **test**: refactor concat string to template string (jimmy) [#17252](https://github.com/nodejs/node/pull/17252)
* [[`0e5ff6f44b`](https://github.com/nodejs/node/commit/0e5ff6f44b)] - **test**: use common.crashOnUnhandledRejection (yozian) [#17242](https://github.com/nodejs/node/pull/17242)
* [[`24b1839aed`](https://github.com/nodejs/node/commit/24b1839aed)] - **test**: use common.crashOnUnhandledRejection (Kcin1993) [#17235](https://github.com/nodejs/node/pull/17235)
* [[`497195a1a3`](https://github.com/nodejs/node/commit/497195a1a3)] - **test**: add common.crashOnUnhandledRejection() (Andy Chen) [#17234](https://github.com/nodejs/node/pull/17234)
* [[`c375816667`](https://github.com/nodejs/node/commit/c375816667)] - **test**: use common.crashOnUnhandledRejection (zhengyuanjie) [#17215](https://github.com/nodejs/node/pull/17215)
* [[`cb3348715b`](https://github.com/nodejs/node/commit/cb3348715b)] - **test**: use common.crashOnUnhandledRejection (Jason Chung) [#17233](https://github.com/nodejs/node/pull/17233)
* [[`8d1ec5d24a`](https://github.com/nodejs/node/commit/8d1ec5d24a)] - **test**: use common.crashOnUnhandledRejection() (sorarize@gmail.com) [#17232](https://github.com/nodejs/node/pull/17232)
* [[`e3db509b47`](https://github.com/nodejs/node/commit/e3db509b47)] - **test**: use common.crashOnUnhandledRejection (Kurt Hsu) [#17229](https://github.com/nodejs/node/pull/17229)
* [[`017379e89b`](https://github.com/nodejs/node/commit/017379e89b)] - **test**: add common.crashOnHandleRejection (jackyen) [#17225](https://github.com/nodejs/node/pull/17225)
* [[`ce284fcb5d`](https://github.com/nodejs/node/commit/ce284fcb5d)] - **test**: add crashonUnhandledRejection (danielLin) [#17237](https://github.com/nodejs/node/pull/17237)
* [[`5cbe0f2420`](https://github.com/nodejs/node/commit/5cbe0f2420)] - **test**: keep coverage reports after coverage-clean (Anatoli Papirovski) [#15470](https://github.com/nodejs/node/pull/15470)
* [[`2d2e7803b2`](https://github.com/nodejs/node/commit/2d2e7803b2)] - **test**: add test on unhandled rejection (Larry Lu) [#17228](https://github.com/nodejs/node/pull/17228)
* [[`a536b031d8`](https://github.com/nodejs/node/commit/a536b031d8)] - **test**: use common.crashOnUnhandledRejection (aryung chen) [#17221](https://github.com/nodejs/node/pull/17221)
* [[`2010b800b8`](https://github.com/nodejs/node/commit/2010b800b8)] - **test**: use common.crashOnUnhandledRejection (Zack Yang) [#17217](https://github.com/nodejs/node/pull/17217)
* [[`d50671b061`](https://github.com/nodejs/node/commit/d50671b061)] - **test**: add common.crashOnUnhandledRejection() (Scya597) [#17212](https://github.com/nodejs/node/pull/17212)
* [[`42a8f03a8b`](https://github.com/nodejs/node/commit/42a8f03a8b)] - **test**: remove unlink function which is needless (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`5c70cef403`](https://github.com/nodejs/node/commit/5c70cef403)] - **test**: dont need to remove nonexistent directory (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`696c962bf3`](https://github.com/nodejs/node/commit/696c962bf3)] - **test**: use common.crashOnUnhandledRejection() (Ivan Wei) [#17227](https://github.com/nodejs/node/pull/17227)
* [[`caa59b9a47`](https://github.com/nodejs/node/commit/caa59b9a47)] - **test**: add common.crashOnUnhandledRejection() (Kyle Yu) [#17236](https://github.com/nodejs/node/pull/17236)
* [[`c232542494`](https://github.com/nodejs/node/commit/c232542494)] - **test**: use crashOnUnhandledRejection (YuLun Shih) [#17220](https://github.com/nodejs/node/pull/17220)
* [[`63f9a13299`](https://github.com/nodejs/node/commit/63f9a13299)] - **test**: fix linting error (James M Snell) [#17251](https://github.com/nodejs/node/pull/17251)
* [[`dc4aa89224`](https://github.com/nodejs/node/commit/dc4aa89224)] - **test**: use common.crashOnUnhandledRejection (jimliu7434) [#17231](https://github.com/nodejs/node/pull/17231)
* [[`9bf2da3429`](https://github.com/nodejs/node/commit/9bf2da3429)] - **test**: use crashOnUnhandledRejection (Roth Peng) [#17226](https://github.com/nodejs/node/pull/17226)
* [[`582f1f01f8`](https://github.com/nodejs/node/commit/582f1f01f8)] - **test**: use common.crashOnUnhandledRejection (esbb48) [#17218](https://github.com/nodejs/node/pull/17218)
* [[`5cfd4ea3ed`](https://github.com/nodejs/node/commit/5cfd4ea3ed)] - **test**: use arrow function instead of bind (Lance Ball) [#17202](https://github.com/nodejs/node/pull/17202)
* [[`25ff8bef18`](https://github.com/nodejs/node/commit/25ff8bef18)] - **test**: use crashOnUnhandledRejection (Chiahao Lin) [#17219](https://github.com/nodejs/node/pull/17219)
* [[`965051dc14`](https://github.com/nodejs/node/commit/965051dc14)] - **test**: use common.crashOnUnhandledRejection (Whien) [#17214](https://github.com/nodejs/node/pull/17214)
* [[`72e480d85e`](https://github.com/nodejs/node/commit/72e480d85e)] - **test**: clean up inappropriate language (Gus Caplan) [#17170](https://github.com/nodejs/node/pull/17170)
* [[`c2bb4b211e`](https://github.com/nodejs/node/commit/c2bb4b211e)] - **test**: bypass dns for IPv6 net tests (Refael Ackermann) [#16976](https://github.com/nodejs/node/pull/16976)
* [[`417e7d1ac2`](https://github.com/nodejs/node/commit/417e7d1ac2)] - **test**: wrap callback in common.mustCall (suman-mitra) [#17173](https://github.com/nodejs/node/pull/17173)
* [[`b2c10cad51`](https://github.com/nodejs/node/commit/b2c10cad51)] - **test**: remove unused parameter in test-next-tick-error-spin.js (Francois KY) [#17185](https://github.com/nodejs/node/pull/17185)
* [[`2bbc1f070d`](https://github.com/nodejs/node/commit/2bbc1f070d)] - **test**: remove unused parameter (Fran Herrero) [#17193](https://github.com/nodejs/node/pull/17193)
* [[`c2b30a99b7`](https://github.com/nodejs/node/commit/c2b30a99b7)] - **test**: remove unused variable (Pierre-Loic Doulcet) [#17186](https://github.com/nodejs/node/pull/17186)
* [[`2e311266f7`](https://github.com/nodejs/node/commit/2e311266f7)] - **test**: remove unused variable (Guillaume Flandre) [#17187](https://github.com/nodejs/node/pull/17187)
* [[`a08bcaeca9`](https://github.com/nodejs/node/commit/a08bcaeca9)] - **test**: remove unused parameter (François Descamps) [#17184](https://github.com/nodejs/node/pull/17184)
* [[`36281f4003`](https://github.com/nodejs/node/commit/36281f4003)] - **test**: remove unused parameter (Xavier Balloy) [#17188](https://github.com/nodejs/node/pull/17188)
* [[`15b6bcf68b`](https://github.com/nodejs/node/commit/15b6bcf68b)] - **test**: make debugging of inspector-port-zero easier (Gibson Fahnestock) [#16685](https://github.com/nodejs/node/pull/16685)
* [[`9914bcaae9`](https://github.com/nodejs/node/commit/9914bcaae9)] - **test**: replace assert.throws w/ common.expectsError (sgreylyn) [#17091](https://github.com/nodejs/node/pull/17091)
* [[`e16d833076`](https://github.com/nodejs/node/commit/e16d833076)] - **test**: reduce benchmark cases in test-benchmark-buffer (Rich Trott) [#17111](https://github.com/nodejs/node/pull/17111)
* [[`79ba8637d0`](https://github.com/nodejs/node/commit/79ba8637d0)] - **test**: fs.write() if 3rd argument is a callback, not offset (Patrick Heneise) [#17045](https://github.com/nodejs/node/pull/17045)
* [[`23c98fa796`](https://github.com/nodejs/node/commit/23c98fa796)] - **test**: utilize common.mustCall() on child exit (sreepurnajasti) [#16996](https://github.com/nodejs/node/pull/16996)
* [[`2776816945`](https://github.com/nodejs/node/commit/2776816945)] - **test**: use arrow functions instead of bind (Tobias Nießen) [#17070](https://github.com/nodejs/node/pull/17070)
* [[`b9311697db`](https://github.com/nodejs/node/commit/b9311697db)] - **test**: move timing-sensitive test to sequential (Rich Trott) [#16775](https://github.com/nodejs/node/pull/16775)
* [[`acf6f24ef2`](https://github.com/nodejs/node/commit/acf6f24ef2)] - **test**: make REPL test pass in coverage mode (Anna Henningsen) [#17082](https://github.com/nodejs/node/pull/17082)
* [[`70060eef65`](https://github.com/nodejs/node/commit/70060eef65)] - **test**: --enable-static linked executable (Daniel Bevenius) [#14986](https://github.com/nodejs/node/pull/14986)
* [[`113dd2b573`](https://github.com/nodejs/node/commit/113dd2b573)] - **test**: add basic WebAssembly test (Steve Kinney) [#16760](https://github.com/nodejs/node/pull/16760)
* [[`f80cf5a33d`](https://github.com/nodejs/node/commit/f80cf5a33d)] - **test**: add coverage to tty module (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`121245f25f`](https://github.com/nodejs/node/commit/121245f25f)] - **test**: add tls clientcertengine tests (Rich Trott) 
* [[`3b1db7f54b`](https://github.com/nodejs/node/commit/3b1db7f54b)] - **test**: flag known flake (Refael Ackermann) 
* [[`0093840044`](https://github.com/nodejs/node/commit/0093840044)] - **test,doc**: do not indicate that non-functions "return" values (Rich Trott) [#17267](https://github.com/nodejs/node/pull/17267)
* [[`b6929e2aa9`](https://github.com/nodejs/node/commit/b6929e2aa9)] - **test,doc**: document where common modules go (Gibson Fahnestock) [#16089](https://github.com/nodejs/node/pull/16089)
* [[`89d31ee048`](https://github.com/nodejs/node/commit/89d31ee048)] - **timers**: improvements to TimersList management (Anatoli Papirovski) [#17429](https://github.com/nodejs/node/pull/17429)
* [[`bd79c3788b`](https://github.com/nodejs/node/commit/bd79c3788b)] - **timers**: clean up for readability (Anatoli Papirovski) [#17279](https://github.com/nodejs/node/pull/17279)
* [[`fd501b31c6`](https://github.com/nodejs/node/commit/fd501b31c6)] - **timers**: cross JS/C++ border less frequently (Anna Henningsen) [#17064](https://github.com/nodejs/node/pull/17064)
* [[`33c1e8b3d5`](https://github.com/nodejs/node/commit/33c1e8b3d5)] - **tls**: implement clientCertEngine option (joelostrowski) 
* [[`f7a1e39139`](https://github.com/nodejs/node/commit/f7a1e39139)] - **tools**: simplify no-let-in-for-declaration rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`e157e1c922`](https://github.com/nodejs/node/commit/e157e1c922)] - **tools**: simplify buffer-constructor rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`01e7b446d1`](https://github.com/nodejs/node/commit/01e7b446d1)] - **tools**: simplify prefer-assert-methods rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`d59b0a7c73`](https://github.com/nodejs/node/commit/d59b0a7c73)] - **tools**: simplify prefer-common-mustnotcall rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`aa32bd08a8`](https://github.com/nodejs/node/commit/aa32bd08a8)] - **tools**: prefer common.expectsError in tests (Anatoli Papirovski) [#17557](https://github.com/nodejs/node/pull/17557)
* [[`89964183c0`](https://github.com/nodejs/node/commit/89964183c0)] - **tools**: don't lint-md as part of main lint target (Refael Ackermann) [#17587](https://github.com/nodejs/node/pull/17587)
* [[`70cfe687ca`](https://github.com/nodejs/node/commit/70cfe687ca)] - **tools**: replace space with \b in regex (Diego Rodríguez Baquero) [#17479](https://github.com/nodejs/node/pull/17479)
* [[`e57af5aada`](https://github.com/nodejs/node/commit/e57af5aada)] - **tools**: lint for additional strings in docs (Rich Trott) [#17492](https://github.com/nodejs/node/pull/17492)
* [[`0e5dc8f925`](https://github.com/nodejs/node/commit/0e5dc8f925)] - **tools**: update markdown lint presets (Rich Trott) [#17382](https://github.com/nodejs/node/pull/17382)
* [[`6c65e04231`](https://github.com/nodejs/node/commit/6c65e04231)] - **tools**: enable no-return-await lint rule (Rich Trott) [#17265](https://github.com/nodejs/node/pull/17265)
* [[`1e34a0e9a8`](https://github.com/nodejs/node/commit/1e34a0e9a8)] - **tools**: add cpplint rule for NULL usage (Daniel Bevenius) [#17373](https://github.com/nodejs/node/pull/17373)
* [[`e41344f1b8`](https://github.com/nodejs/node/commit/e41344f1b8)] - **tools**: add docs for prefer-util-format-errors rule (Jon Moss) [#17376](https://github.com/nodejs/node/pull/17376)
* [[`1cc6df29a7`](https://github.com/nodejs/node/commit/1cc6df29a7)] - **tools**: add Boxstarter script (Bartosz Sosnowski) [#17046](https://github.com/nodejs/node/pull/17046)
* [[`6624ac3131`](https://github.com/nodejs/node/commit/6624ac3131)] - **tools**: update to ESLint 4.12.0 (cjihrig) [#16948](https://github.com/nodejs/node/pull/16948)
* [[`8e5b7117bc`](https://github.com/nodejs/node/commit/8e5b7117bc)] - **tools**: prohibit notDeepEqual usage (Ruben Bridgewater) [#16325](https://github.com/nodejs/node/pull/16325)
* [[`b7f81ae266`](https://github.com/nodejs/node/commit/b7f81ae266)] - **tools**: add lint fixer for `require-buffer` (Bamieh) [#17144](https://github.com/nodejs/node/pull/17144)
* [[`f0f32dccfe`](https://github.com/nodejs/node/commit/f0f32dccfe)] - **tools**: fix gitignore for tools/doc/ (Richard Littauer) [#17224](https://github.com/nodejs/node/pull/17224)
* [[`5247ab3792`](https://github.com/nodejs/node/commit/5247ab3792)] - **tools**: make doc tool a bit more readable (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`c8247a7c7d`](https://github.com/nodejs/node/commit/c8247a7c7d)] - **tools**: remove useless function declaration (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`34bfbfece4`](https://github.com/nodejs/node/commit/34bfbfece4)] - **tools**: avoid using process.cwd in tools/lint-js (Tobias Nießen) [#17121](https://github.com/nodejs/node/pull/17121)
* [[`c4eb683020`](https://github.com/nodejs/node/commit/c4eb683020)] - **tools**: use built-in padStart instead of padString (Tobias Nießen) [#17120](https://github.com/nodejs/node/pull/17120)
* [[`4954eef481`](https://github.com/nodejs/node/commit/4954eef481)] - **tools**: allow running test.py without configuring (Gibson Fahnestock) [#16621](https://github.com/nodejs/node/pull/16621)
* [[`16f181e3b9`](https://github.com/nodejs/node/commit/16f181e3b9)] - **tools**: bump remark-cli to 4.0 (Refael Ackermann) [#17028](https://github.com/nodejs/node/pull/17028)
* [[`4f518a4780`](https://github.com/nodejs/node/commit/4f518a4780)] - **tools**: fail tests if malformed status file (Rich Trott) [#16703](https://github.com/nodejs/node/pull/16703)
* [[`7fe6a8f5d5`](https://github.com/nodejs/node/commit/7fe6a8f5d5)] - **tools**: try installing js-yaml only once (Joyee Cheung) [#16661](https://github.com/nodejs/node/pull/16661)
* [[`4d0c70a6f6`](https://github.com/nodejs/node/commit/4d0c70a6f6)] - **tools**: speed up lint-md-build (Refael Ackermann) [#16945](https://github.com/nodejs/node/pull/16945)
* [[`03d2514b46`](https://github.com/nodejs/node/commit/03d2514b46)] - **tools,test**: throw if common.PORT used in parallel tests (Rich Trott) [#17559](https://github.com/nodejs/node/pull/17559)
* [[`8bd74c4061`](https://github.com/nodejs/node/commit/8bd74c4061)] - **tools,test**: use Execute instead of check_output (Refael Ackermann) [#17381](https://github.com/nodejs/node/pull/17381)
* [[`855bb8d486`](https://github.com/nodejs/node/commit/855bb8d486)] - **trace_events**: add executionAsyncId to init events (Andreas Madsen) [#17196](https://github.com/nodejs/node/pull/17196)
* [[`f321921573`](https://github.com/nodejs/node/commit/f321921573)] - **tty**: fix 'resize' event regression (Ben Noordhuis) [#16225](https://github.com/nodejs/node/pull/16225)
* [[`4e3aa9a899`](https://github.com/nodejs/node/commit/4e3aa9a899)] - **tty**: refactor exports (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`8383c348b8`](https://github.com/nodejs/node/commit/8383c348b8)] - **util**: fix negative 0 check in inspect (Gus Caplan) [#17507](https://github.com/nodejs/node/pull/17507)
* [[`c5d20b36e1`](https://github.com/nodejs/node/commit/c5d20b36e1)] - **util**: remove check for global.process (Gus Caplan) [#17435](https://github.com/nodejs/node/pull/17435)
* [[`a37eb32c32`](https://github.com/nodejs/node/commit/a37eb32c32)] - **util**: escaping object keys in util.inspect() (buji) [#16986](https://github.com/nodejs/node/pull/16986)
* [[`57ee0dd5e3`](https://github.com/nodejs/node/commit/57ee0dd5e3)] - **zlib**: remove unnecessary else branch (john) [#17057](https://github.com/nodejs/node/pull/17057)
* [[`45ca714005`](https://github.com/nodejs/node/commit/45ca714005)] - **zlib**: fix assert fail for bad write in object mode (Kevin Locke) [#16960](https://github.com/nodejs/node/pull/16960)
* [[`fa01fe6819`](https://github.com/nodejs/node/commit/fa01fe6819)] - **zlib**: fix decompression of empty data streams (Anna Henningsen) [#17042](https://github.com/nodejs/node/pull/17042)

<a id="9.2.1"></a>
## 2017-12-08, Version 9.2.1 (Current), @evanlucas

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/december-2017-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2017-15896
* CVE-2017-15897
* CVE-2017-3738 (from the openssl project)

### Notable Changes

* **buffer**:
  * buffer allocated with an invalid content will now be zero filled (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* **deps**:
  * openssl updated to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)

### Commits

* [[`15bf640668`](https://github.com/nodejs/node/commit/15bf640668)] - **buffer**: zero-fill buffer allocated with invalid content (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* [[`c0954f4ba1`](https://github.com/nodejs/node/commit/c0954f4ba1)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`dfd7cd3038`](https://github.com/nodejs/node/commit/dfd7cd3038)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`76e7ff2915`](https://github.com/nodejs/node/commit/76e7ff2915)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`593f21ee9c`](https://github.com/nodejs/node/commit/593f21ee9c)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`235c78f968`](https://github.com/nodejs/node/commit/235c78f968)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`b0ebe5cb4b`](https://github.com/nodejs/node/commit/b0ebe5cb4b)] - **deps**: upgrade openssl sources to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`99fc75e9bc`](https://github.com/nodejs/node/commit/99fc75e9bc)] - **doc**: warn against filling buffer with invalid data (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* [[`f0f9e1abf0`](https://github.com/nodejs/node/commit/f0f9e1abf0)] - **http2**: use correct connect event for TLS Socket (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`65f209ccf1`](https://github.com/nodejs/node/commit/65f209ccf1)] - **http2**: use 'close' event instead of 'streamClosed' (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`d3e2bf0c8d`](https://github.com/nodejs/node/commit/d3e2bf0c8d)] - **http2**: general cleanups in core.js (James M Snell) [#17209](https://github.com/nodejs/node/pull/17209)
* [[`6a76097fad`](https://github.com/nodejs/node/commit/6a76097fad)] - **http2**: major update to internals (James M Snell) [#17105](https://github.com/nodejs/node/pull/17105)
* [[`e14c0babe0`](https://github.com/nodejs/node/commit/e14c0babe0)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)

<a id="9.2.0"></a>
## 2017-11-14, Version 9.2.0 (Current), @evanlucas

### Notable Changes

* **crypto**:
  - Support building with both 1.1.0 and 1.0.2 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* **fs**:
  - fs.realpathSync.native and fs.realpath.native are now exposed (Ben Noordhuis) [#15776](https://github.com/nodejs/node/pull/15776)
* **process**:
  - expose process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)

### Commits

* [[`02ea0ee507`](https://github.com/nodejs/node/commit/02ea0ee507)] - **build**: fix cctest compilation (Daniel Bevenius) [#16887](https://github.com/nodejs/node/pull/16887)
* [[`a4557f294a`](https://github.com/nodejs/node/commit/a4557f294a)] - **build**: remove cctest extension (Yihong Wang) [#16680](https://github.com/nodejs/node/pull/16680)
* [[`1dc4fc1390`](https://github.com/nodejs/node/commit/1dc4fc1390)] - **build**: include src\tracing when linting on win (Daniel Bevenius) [#16720](https://github.com/nodejs/node/pull/16720)
* [[`4c11801ed7`](https://github.com/nodejs/node/commit/4c11801ed7)] - **build**: add missing options to help message (Daniel Bevenius) [#16707](https://github.com/nodejs/node/pull/16707)
* [[`bed0560fb5`](https://github.com/nodejs/node/commit/bed0560fb5)] - **console**: avoid adding infinite error listeners (Matteo Collina) [#16770](https://github.com/nodejs/node/pull/16770)
* [[`31dadd2007`](https://github.com/nodejs/node/commit/31dadd2007)] - **(SEMVER-MINOR)** **crypto**: deprecate {ecdhCurve: false} (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f952caa677`](https://github.com/nodejs/node/commit/f952caa677)] - **(SEMVER-MINOR)** **crypto**: clear some SSL_METHOD deprecation warnings (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`a5e7255385`](https://github.com/nodejs/node/commit/a5e7255385)] - **(SEMVER-MINOR)** **crypto**: make ALPN the same for OpenSSL 1.0.2 & 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`07102ace9e`](https://github.com/nodejs/node/commit/07102ace9e)] - **(SEMVER-MINOR)** **crypto**: remove deprecated ECDH calls w/ OpenSSL 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`627a15f9e5`](https://github.com/nodejs/node/commit/627a15f9e5)] - **(SEMVER-MINOR)** **crypto**: emulate OpenSSL 1.0 ticket scheme in 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`8a8ac8ce4d`](https://github.com/nodejs/node/commit/8a8ac8ce4d)] - **(SEMVER-MINOR)** **crypto**: hard-code tlsSocket.getCipher().version (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`c42935b79c`](https://github.com/nodejs/node/commit/c42935b79c)] - **(SEMVER-MINOR)** **crypto**: add compat logic for "DSS1" and "dss1" (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`5c24fc32c9`](https://github.com/nodejs/node/commit/5c24fc32c9)] - **(SEMVER-MINOR)** **crypto**: Make Hmac 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`fa1fc16c3e`](https://github.com/nodejs/node/commit/fa1fc16c3e)] - **(SEMVER-MINOR)** **crypto**: make SignBase compatible with OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`abe3dc48cc`](https://github.com/nodejs/node/commit/abe3dc48cc)] - **(SEMVER-MINOR)** **crypto**: make Hash 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`59acd27409`](https://github.com/nodejs/node/commit/59acd27409)] - **(SEMVER-MINOR)** **crypto**: make CipherBase 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`6c3ae36cab`](https://github.com/nodejs/node/commit/6c3ae36cab)] - **(SEMVER-MINOR)** **crypto**: remove locking callbacks for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`81760ffea9`](https://github.com/nodejs/node/commit/81760ffea9)] - **(SEMVER-MINOR)** **crypto**: use RSA and DH accessors (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`568d9d0eac`](https://github.com/nodejs/node/commit/568d9d0eac)] - **(SEMVER-MINOR)** **crypto**: test DH keys work without a public half (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`6a9c528a50`](https://github.com/nodejs/node/commit/6a9c528a50)] - **(SEMVER-MINOR)** **crypto**: account for new 1.1.0 SSL APIs (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`cc744b9b26`](https://github.com/nodejs/node/commit/cc744b9b26)] - **(SEMVER-MINOR)** **crypto**: remove unnecessary SSLerr calls (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`201393f655`](https://github.com/nodejs/node/commit/201393f655)] - **(SEMVER-MINOR)** **crypto**: estimate kExternalSize (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`efd9bc36fa`](https://github.com/nodejs/node/commit/efd9bc36fa)] - **(SEMVER-MINOR)** **crypto**: make node_crypto_bio compat w/ OpenSSL 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`8da4983cb4`](https://github.com/nodejs/node/commit/8da4983cb4)] - **(SEMVER-MINOR)** **crypto**: use X509_STORE_CTX_new (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`9c6f63bf3b`](https://github.com/nodejs/node/commit/9c6f63bf3b)] - **deps**: cherry-pick 3c8195d from V8 upstream (Franziska Hinkelmann) [#16897](https://github.com/nodejs/node/pull/16897)
* [[`6ddba2e08e`](https://github.com/nodejs/node/commit/6ddba2e08e)] - **deps**: patch V8 to 6.2.414.44 (Myles Borins) [#16848](https://github.com/nodejs/node/pull/16848)
* [[`f82d3e44c8`](https://github.com/nodejs/node/commit/f82d3e44c8)] - **deps**: upgrade libuv to 1.16.1 (cjihrig) [#16835](https://github.com/nodejs/node/pull/16835)
* [[`38ac50a084`](https://github.com/nodejs/node/commit/38ac50a084)] - **deps**: cherry-pick cc55747 from V8 upstream (Franziska Hinkelmann) [#16890](https://github.com/nodejs/node/pull/16890)
* [[`75405a1481`](https://github.com/nodejs/node/commit/75405a1481)] - **deps**: ICU 60 bump (Steven R. Loomis) [#16876](https://github.com/nodejs/node/pull/16876)
* [[`28b7bf062a`](https://github.com/nodejs/node/commit/28b7bf062a)] - **deps**: cherry-pick b8331cc030 from upstream V8 (Daniel Bevenius) [#16900](https://github.com/nodejs/node/pull/16900)
* [[`2266cafba5`](https://github.com/nodejs/node/commit/2266cafba5)] - ***Revert*** "**deps**: cherry-pick b8331cc030 from upstream V8" (Daniel Bevenius) [#16899](https://github.com/nodejs/node/pull/16899)
* [[`81f14bffff`](https://github.com/nodejs/node/commit/81f14bffff)] - **deps**: cherry-pick b8331cc030 from upstream V8 (Daniel Bevenius) [#16743](https://github.com/nodejs/node/pull/16743)
* [[`6922fda1b5`](https://github.com/nodejs/node/commit/6922fda1b5)] - **doc**: recommend node-core-utils for metadata (Rich Trott) [#16978](https://github.com/nodejs/node/pull/16978)
* [[`ccf1f6aa13`](https://github.com/nodejs/node/commit/ccf1f6aa13)] - **doc**: fix typo in http2 doc (Gus Caplan) [#16993](https://github.com/nodejs/node/pull/16993)
* [[`54768f5094`](https://github.com/nodejs/node/commit/54768f5094)] - **doc**: reorganize COLLABORATOR_GUIDE.md (Rich Trott) [#15710](https://github.com/nodejs/node/pull/15710)
* [[`c4e2343bfb`](https://github.com/nodejs/node/commit/c4e2343bfb)] - **doc**: drop support for VS2015 (Nikolai Vavilov) [#16868](https://github.com/nodejs/node/pull/16868)
* [[`74f33724a2`](https://github.com/nodejs/node/commit/74f33724a2)] - **doc**: clarify the prerequisites for building with VS2017 (Nikolai Vavilov) [#16903](https://github.com/nodejs/node/pull/16903)
* [[`1510fda1b0`](https://github.com/nodejs/node/commit/1510fda1b0)] - **doc**: outline commit message for breaking changes (Maton Anthony) [#16846](https://github.com/nodejs/node/pull/16846)
* [[`1fcd95e517`](https://github.com/nodejs/node/commit/1fcd95e517)] - **doc**: remove duplicate 'the' from http2 API doc (Vipin Menon) [#16924](https://github.com/nodejs/node/pull/16924)
* [[`b46714c023`](https://github.com/nodejs/node/commit/b46714c023)] - **doc**: fix typos in N-API (Swathi Kalahastri) [#16911](https://github.com/nodejs/node/pull/16911)
* [[`3ba52c1582`](https://github.com/nodejs/node/commit/3ba52c1582)] - **doc**: correct the spelling of omitting in dgram.md (Vidya Subramanyam) [#16910](https://github.com/nodejs/node/pull/16910)
* [[`e60eff6c01`](https://github.com/nodejs/node/commit/e60eff6c01)] - **doc**: fix a typo in the documentation (Mamatha J V) [#16909](https://github.com/nodejs/node/pull/16909)
* [[`6e9973e912`](https://github.com/nodejs/node/commit/6e9973e912)] - **doc**: improve documentation for the vm module (Franziska Hinkelmann) [#16867](https://github.com/nodejs/node/pull/16867)
* [[`15dcb96b28`](https://github.com/nodejs/node/commit/15dcb96b28)] - **doc**: fix a typo in n-api documentation (Vipin Menon) [#16879](https://github.com/nodejs/node/pull/16879)
* [[`928647c77c`](https://github.com/nodejs/node/commit/928647c77c)] - **doc**: fix typo in assert.md (Andres Kalle) [#16866](https://github.com/nodejs/node/pull/16866)
* [[`a184dbcb2c`](https://github.com/nodejs/node/commit/a184dbcb2c)] - **doc**: update subprocess.killed (cjihrig) [#16748](https://github.com/nodejs/node/pull/16748)
* [[`deff9f5527`](https://github.com/nodejs/node/commit/deff9f5527)] - **events**: remove emit micro-optimizations (Anatoli Papirovski) [#16869](https://github.com/nodejs/node/pull/16869)
* [[`8611e3b93b`](https://github.com/nodejs/node/commit/8611e3b93b)] - **(SEMVER-MINOR)** **fs**: expose realpath(3) bindings (Ben Noordhuis) [#15776](https://github.com/nodejs/node/pull/15776)
* [[`8dfd5a515a`](https://github.com/nodejs/node/commit/8dfd5a515a)] - **http2**: multiple smaller code cleanups (James M Snell) [#16764](https://github.com/nodejs/node/pull/16764)
* [[`8245e5a2d4`](https://github.com/nodejs/node/commit/8245e5a2d4)] - **http2**: simplify subsequent rstStream calls (Anatoli Papirovski) [#16753](https://github.com/nodejs/node/pull/16753)
* [[`afbdd017c1`](https://github.com/nodejs/node/commit/afbdd017c1)] - **lib**: replace string concatenation with template (Suryanarayana Murthy N) [#16933](https://github.com/nodejs/node/pull/16933)
* [[`6c0fd55488`](https://github.com/nodejs/node/commit/6c0fd55488)] - **lib**: guard inspector console using process var (Daniel Bevenius) [#15008](https://github.com/nodejs/node/pull/15008)
* [[`c1792544e8`](https://github.com/nodejs/node/commit/c1792544e8)] - **lib**: improve the usage of TypeError\[INVALID_ARG_TYPE\] (Weijia Wang) [#16401](https://github.com/nodejs/node/pull/16401)
* [[`44c3cc2bec`](https://github.com/nodejs/node/commit/44c3cc2bec)] - **lib**: change concatenated string to template (Pawan Jangid) [#16930](https://github.com/nodejs/node/pull/16930)
* [[`8eb32e1b35`](https://github.com/nodejs/node/commit/8eb32e1b35)] - **lib**: replace String concatenation with template (saiHemak) [#16922](https://github.com/nodejs/node/pull/16922)
* [[`678e738d70`](https://github.com/nodejs/node/commit/678e738d70)] - **lib**: change concatenated string to template (Nayana Das K) [#16925](https://github.com/nodejs/node/pull/16925)
* [[`df181745b8`](https://github.com/nodejs/node/commit/df181745b8)] - **lib**: replace string concatenation with template (Jayashree S Kumar) [#16921](https://github.com/nodejs/node/pull/16921)
* [[`a9358068db`](https://github.com/nodejs/node/commit/a9358068db)] - **lib**: replace string concatenation with template (Chandrakala) [#16920](https://github.com/nodejs/node/pull/16920)
* [[`16c622209a`](https://github.com/nodejs/node/commit/16c622209a)] - **lib**: replace string concatenation with template (subrahmanya chari p) [#16917](https://github.com/nodejs/node/pull/16917)
* [[`64a0c80773`](https://github.com/nodejs/node/commit/64a0c80773)] - **loader**: test search module (Cyril Lakech) [#16795](https://github.com/nodejs/node/pull/16795)
* [[`bfdaa28fdb`](https://github.com/nodejs/node/commit/bfdaa28fdb)] - **meta**: 32 bit linux is experimental (Refael Ackermann) [#16723](https://github.com/nodejs/node/pull/16723)
* [[`76e6422868`](https://github.com/nodejs/node/commit/76e6422868)] - **src**: fix compiler warning in process.ppid (cjihrig) [#16958](https://github.com/nodejs/node/pull/16958)
* [[`60a6caea76`](https://github.com/nodejs/node/commit/60a6caea76)] - **src**: turn inspector raw pointer into unique_ptr (Franziska Hinkelmann) [#16974](https://github.com/nodejs/node/pull/16974)
* [[`79648496ec`](https://github.com/nodejs/node/commit/79648496ec)] - **src**: explain implementation of vm module (Franziska Hinkelmann) [#16962](https://github.com/nodejs/node/pull/16962)
* [[`a79d86db21`](https://github.com/nodejs/node/commit/a79d86db21)] - **src**: use unrefed async for GC tracking (Anna Henningsen) [#16758](https://github.com/nodejs/node/pull/16758)
* [[`5df3dc1169`](https://github.com/nodejs/node/commit/5df3dc1169)] - **src**: make StreamBase prototype accessors robust (Joyee Cheung) [#16860](https://github.com/nodejs/node/pull/16860)
* [[`41937bedf9`](https://github.com/nodejs/node/commit/41937bedf9)] - **(SEMVER-MINOR)** **src**: add process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)
* [[`0b93bbb419`](https://github.com/nodejs/node/commit/0b93bbb419)] - **src**: add openssl-system-ca-path configure option (Daniel Bevenius) [#16790](https://github.com/nodejs/node/pull/16790)
* [[`43c5726028`](https://github.com/nodejs/node/commit/43c5726028)] - **src**: fix UB in InternalModuleReadFile() (Ben Noordhuis) [#16871](https://github.com/nodejs/node/pull/16871)
* [[`bce5db2225`](https://github.com/nodejs/node/commit/bce5db2225)] - **src**: CHECK() for argument overflow in Spawn() (cjihrig) [#16761](https://github.com/nodejs/node/pull/16761)
* [[`120db20a1a`](https://github.com/nodejs/node/commit/120db20a1a)] - **test**: reuse existing PassThrough implementation (Tobias Nießen) [#16936](https://github.com/nodejs/node/pull/16936)
* [[`9f0b0fbd0e`](https://github.com/nodejs/node/commit/9f0b0fbd0e)] - **test**: use fixtures module for path resolve (sercan yersen) [#16842](https://github.com/nodejs/node/pull/16842)
* [[`d5f2601bc8`](https://github.com/nodejs/node/commit/d5f2601bc8)] - **test**: refactor comments in test-child-process-spawnsync-maxbuf (ChrBergert) [#16829](https://github.com/nodejs/node/pull/16829)
* [[`93af193821`](https://github.com/nodejs/node/commit/93af193821)] - **test**: refactor addons-napi/test_promise/test.js (ka3e) [#16814](https://github.com/nodejs/node/pull/16814)
* [[`ad02676816`](https://github.com/nodejs/node/commit/ad02676816)] - **test**: used fixturesDir from fixtures modules (Klemen Kogovsek) [#16813](https://github.com/nodejs/node/pull/16813)
* [[`809dc099ac`](https://github.com/nodejs/node/commit/809dc099ac)] - **test**: refactor fs.write() test (Patrick Heneise) [#16827](https://github.com/nodejs/node/pull/16827)
* [[`35fc317d8f`](https://github.com/nodejs/node/commit/35fc317d8f)] - **test**: add a test description (Grant Gasparyan) [#16833](https://github.com/nodejs/node/pull/16833)
* [[`83f9604adc`](https://github.com/nodejs/node/commit/83f9604adc)] - **test**: use ES6 classes instead of util.inherits (Tobias Nießen) [#16938](https://github.com/nodejs/node/pull/16938)
* [[`7c364a269c`](https://github.com/nodejs/node/commit/7c364a269c)] - **test**: use common/fixtures module in hash-seed test (Javier Blanco) [#16823](https://github.com/nodejs/node/pull/16823)
* [[`3136578871`](https://github.com/nodejs/node/commit/3136578871)] - **test**: make test-tls-external-accessor agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`0be7f8c48c`](https://github.com/nodejs/node/commit/0be7f8c48c)] - **test**: make test-require-json engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`835ca63595`](https://github.com/nodejs/node/commit/835ca63595)] - **test**: make test-repl engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`f8337cea8e`](https://github.com/nodejs/node/commit/f8337cea8e)] - **test**: make test-repl-syntax-error-stack agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`c81b086928`](https://github.com/nodejs/node/commit/c81b086928)] - **test**: make test-repl-harmony engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`591a6927ee`](https://github.com/nodejs/node/commit/591a6927ee)] - **test**: make test-querystring-escape engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`e2f564821e`](https://github.com/nodejs/node/commit/e2f564821e)] - **test**: make test-process-env-symbols agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`9bf887475e`](https://github.com/nodejs/node/commit/9bf887475e)] - **test**: make test-os-eol engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`79e183186c`](https://github.com/nodejs/node/commit/79e183186c)] - **test**: make error stack test engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`b5b23bd3e8`](https://github.com/nodejs/node/commit/b5b23bd3e8)] - **test**: make test-http-outgoing-proto agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`bd7822b8f6`](https://github.com/nodejs/node/commit/bd7822b8f6)] - **test**: make test-error-reporting engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`4604294647`](https://github.com/nodejs/node/commit/4604294647)] - **test**: make test-console engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`025eadfcd5`](https://github.com/nodejs/node/commit/025eadfcd5)] - **test**: make test-console-count engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`c74467f938`](https://github.com/nodejs/node/commit/c74467f938)] - **test**: make test-cli-syntax engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`2e2e8020e7`](https://github.com/nodejs/node/commit/2e2e8020e7)] - **test**: make test-buffer-slow engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`7a5378377f`](https://github.com/nodejs/node/commit/7a5378377f)] - **test**: improve template value for test message (Stephan Smith) [#16826](https://github.com/nodejs/node/pull/16826)
* [[`6ea8768141`](https://github.com/nodejs/node/commit/6ea8768141)] - **test**: unmark flaky test (Anna Henningsen) [#16758](https://github.com/nodejs/node/pull/16758)
* [[`651fee4c54`](https://github.com/nodejs/node/commit/651fee4c54)] - **test**: change concatenated string to template (Deepthi Sebastian) [#16929](https://github.com/nodejs/node/pull/16929)
* [[`1ea546c9ee`](https://github.com/nodejs/node/commit/1ea546c9ee)] - **test**: change concatenated string to template (Anawesha Khuntia) [#16912](https://github.com/nodejs/node/pull/16912)
* [[`385f65826a`](https://github.com/nodejs/node/commit/385f65826a)] - **test**: change string concatenation to template (Suryanarayana Murthy N) [#16919](https://github.com/nodejs/node/pull/16919)
* [[`61fbd857d7`](https://github.com/nodejs/node/commit/61fbd857d7)] - **test**: use template string for concatenation (Vipin Menon) [#16918](https://github.com/nodejs/node/pull/16918)
* [[`fbec5ec4d9`](https://github.com/nodejs/node/commit/fbec5ec4d9)] - **test**: replace string concatenation with template (Kabir Islam) [#16916](https://github.com/nodejs/node/pull/16916)
* [[`407eb6f93e`](https://github.com/nodejs/node/commit/407eb6f93e)] - **test**: enable mustCall() during child exit (Vipin Menon) [#16915](https://github.com/nodejs/node/pull/16915)
* [[`26e4c587eb`](https://github.com/nodejs/node/commit/26e4c587eb)] - **(SEMVER-MINOR)** **test**: fix flaky test-http2-create-client-connect (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`8c294203cf`](https://github.com/nodejs/node/commit/8c294203cf)] - **(SEMVER-MINOR)** **test**: fix test-https-agent-session-eviction for 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`3d438f84b2`](https://github.com/nodejs/node/commit/3d438f84b2)] - **(SEMVER-MINOR)** **test**: configure certs in tests (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`08ac21423e`](https://github.com/nodejs/node/commit/08ac21423e)] - **(SEMVER-MINOR)** **test**: revise test-tls-econnreset for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`d95b608d98`](https://github.com/nodejs/node/commit/d95b608d98)] - **(SEMVER-MINOR)** **test**: test with a larger RSA key (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`85ffc2f960`](https://github.com/nodejs/node/commit/85ffc2f960)] - **(SEMVER-MINOR)** **test**: remove sha from test expectations (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`bec042183c`](https://github.com/nodejs/node/commit/bec042183c)] - **(SEMVER-MINOR)** **test**: update test expectations for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`b42013c31e`](https://github.com/nodejs/node/commit/b42013c31e)] - **test**: replace string concatenation with template (Sabari Lakshmi Krishnamoorthy) [#16914](https://github.com/nodejs/node/pull/16914)
* [[`fbc7451553`](https://github.com/nodejs/node/commit/fbc7451553)] - **test**: replace string concatenation with template (Tanvi Kini) [#16913](https://github.com/nodejs/node/pull/16913)
* [[`7f7dec8b08`](https://github.com/nodejs/node/commit/7f7dec8b08)] - **test**: cover vm.runInNewContext() (cjihrig) [#16906](https://github.com/nodejs/node/pull/16906)
* [[`8311561ed5`](https://github.com/nodejs/node/commit/8311561ed5)] - **test**: improve assertion messages (Neil Vass) [#16885](https://github.com/nodejs/node/pull/16885)
* [[`1ee6df9612`](https://github.com/nodejs/node/commit/1ee6df9612)] - **test**: pass process.env to child processes (Rod Vagg) [#16405](https://github.com/nodejs/node/pull/16405)
* [[`172652ba27`](https://github.com/nodejs/node/commit/172652ba27)] - **test**: improve assert messages in stream test (Katie Stockton Roberts) [#16884](https://github.com/nodejs/node/pull/16884)
* [[`271c89e569`](https://github.com/nodejs/node/commit/271c89e569)] - **test**: improve assertion in test-require-dot (Adam Wegrzynek) [#16805](https://github.com/nodejs/node/pull/16805)
* [[`5d3a4ad1cf`](https://github.com/nodejs/node/commit/5d3a4ad1cf)] - **test**: improve error emssage reporting in testNapiRun.js (Paul Ashfield) [#16821](https://github.com/nodejs/node/pull/16821)
* [[`f71f41d79b`](https://github.com/nodejs/node/commit/f71f41d79b)] - **test**: add values to error message (Adam Jeffery) [#16831](https://github.com/nodejs/node/pull/16831)
* [[`c1cdc658c0`](https://github.com/nodejs/node/commit/c1cdc658c0)] - **test**: replace common.fixtiresDir with fixtures.readKey() (woj) [#16817](https://github.com/nodejs/node/pull/16817)
* [[`c662cc0b70`](https://github.com/nodejs/node/commit/c662cc0b70)] - **test**: use internet.addresses in internet tests (Joyee Cheung) [#16390](https://github.com/nodejs/node/pull/16390)
* [[`a465f2bc78`](https://github.com/nodejs/node/commit/a465f2bc78)] - **test**: introduce test/common/internet.addresses (Joyee Cheung) [#16390](https://github.com/nodejs/node/pull/16390)
* [[`bc19a93093`](https://github.com/nodejs/node/commit/bc19a93093)] - **test**: use tmpDir in test-fs-utimes (Rich Trott) [#16774](https://github.com/nodejs/node/pull/16774)
* [[`4d55a1dc2f`](https://github.com/nodejs/node/commit/4d55a1dc2f)] - **test**: improve assert messages in napi exception test (Paul Blanche) [#16820](https://github.com/nodejs/node/pull/16820)
* [[`8ad4f768c0`](https://github.com/nodejs/node/commit/8ad4f768c0)] - **test**: remove message argument in cluster setup test (mbornath) [#16838](https://github.com/nodejs/node/pull/16838)
* [[`21e9888237`](https://github.com/nodejs/node/commit/21e9888237)] - **test**: check session timeout in http2 (Anatoli Papirovski) [#16754](https://github.com/nodejs/node/pull/16754)
* [[`be266bdbbd`](https://github.com/nodejs/node/commit/be266bdbbd)] - **test**: move test-http-keepalive-maxsockets to sequential (Rich Trott) [#16777](https://github.com/nodejs/node/pull/16777)
* [[`adcaddfce8`](https://github.com/nodejs/node/commit/adcaddfce8)] - **test**: improve assert messages in test-global (Mark McNelis) [#16843](https://github.com/nodejs/node/pull/16843)
* [[`535eb64e55`](https://github.com/nodejs/node/commit/535eb64e55)] - **tools**: enforce no unused trailing arguments tools directory (Rich Trott) [#16953](https://github.com/nodejs/node/pull/16953)
* [[`ad27e2c2e8`](https://github.com/nodejs/node/commit/ad27e2c2e8)] - **tools**: remove unused trailing function arguments (Rich Trott) [#16953](https://github.com/nodejs/node/pull/16953)
* [[`7ba35995a7`](https://github.com/nodejs/node/commit/7ba35995a7)] - **tools**: fix inspector-check reporting (Daniel Bevenius) [#16902](https://github.com/nodejs/node/pull/16902)
* [[`25dd8f66be`](https://github.com/nodejs/node/commit/25dd8f66be)] - **tools**: add direct anchors for error codes (Joyee Cheung) [#16779](https://github.com/nodejs/node/pull/16779)
* [[`625999b840`](https://github.com/nodejs/node/commit/625999b840)] - **tools**: don't lint files that have not changed (Joyee Cheung) [#16581](https://github.com/nodejs/node/pull/16581)
* [[`942a9ed6a8`](https://github.com/nodejs/node/commit/942a9ed6a8)] - **tools,build**: allow build without `remark-cli` (Refael Ackermann) [#16893](https://github.com/nodejs/node/pull/16893)

<a id="9.1.0"></a>
## 2017-11-07, Version 9.1.0 (Current), @cjihrig

### Notable Changes

* **CLI**:
  - `NODE_OPTIONS` now supports the `--stack-trace-limit` option. [#16495](https://github.com/nodejs/node/pull/16495)
* **deps**:
  - OpenSSL is upgraded to 1.0.2m [#16691](https://github.com/nodejs/node/pull/16691)
* **http**:
  - A `'connect'` event handler leak has been fixed. [#16725](https://github.com/nodejs/node/pull/16725)
  - The `103 Early Hints` status code is now supported. [#16644](https://github.com/nodejs/node/pull/16644)

### Commits

* [[`32417999ac`](https://github.com/nodejs/node/commit/32417999ac)] - **build**: suppress lint-md output (Gibson Fahnestock) [#16551](https://github.com/nodejs/node/pull/16551)
* [[`433745e7eb`](https://github.com/nodejs/node/commit/433745e7eb)] - **build**: add missing comma in sources list (Daniel Bevenius) [#16613](https://github.com/nodejs/node/pull/16613)
* [[`8bc5249223`](https://github.com/nodejs/node/commit/8bc5249223)] - **build**: make test-doc and lint addon docs (Joyee Cheung) [#16377](https://github.com/nodejs/node/pull/16377)
* [[`88ad01fce7`](https://github.com/nodejs/node/commit/88ad01fce7)] - **build**: make doc target quiet (Daniel Bevenius) [#16516](https://github.com/nodejs/node/pull/16516)
* [[`f3e01618f1`](https://github.com/nodejs/node/commit/f3e01618f1)] - **build,src**: Add CloudABI as a POSIX-like runtime environment. (Ed Schouten) [#16612](https://github.com/nodejs/node/pull/16612)
* [[`7349d42945`](https://github.com/nodejs/node/commit/7349d42945)] - **(SEMVER-MINOR)** **cli**: add --stack-trace-limit to NODE_OPTIONS (Anna Henningsen) [#16495](https://github.com/nodejs/node/pull/16495)
* [[`ed0fbd8d72`](https://github.com/nodejs/node/commit/ed0fbd8d72)] - **deps**: cherry-pick e7f4e9e from upstream libuv (Bartosz Sosnowski) [#16724](https://github.com/nodejs/node/pull/16724)
* [[`185229e258`](https://github.com/nodejs/node/commit/185229e258)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`162686f5f4`](https://github.com/nodejs/node/commit/162686f5f4)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`e0f6dee961`](https://github.com/nodejs/node/commit/e0f6dee961)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3d7eea5da8`](https://github.com/nodejs/node/commit/3d7eea5da8)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3438765781`](https://github.com/nodejs/node/commit/3438765781)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`b130febd1d`](https://github.com/nodejs/node/commit/b130febd1d)] - **deps**: upgrade openssl sources to 1.0.2m (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`90e8e81bbb`](https://github.com/nodejs/node/commit/90e8e81bbb)] - **doc**: mention constant-time in crypto doc (Mithun Sasidharan) [#16604](https://github.com/nodejs/node/pull/16604)
* [[`dee7800ae8`](https://github.com/nodejs/node/commit/dee7800ae8)] - **doc**: add links to EventEmitter in errors.md (Delapouite) [#16861](https://github.com/nodejs/node/pull/16861)
* [[`f097e2775b`](https://github.com/nodejs/node/commit/f097e2775b)] - **doc**: fix a link in dgram.md (Vse Mozhet Byt) [#16854](https://github.com/nodejs/node/pull/16854)
* [[`978aa8476b`](https://github.com/nodejs/node/commit/978aa8476b)] - **doc**: add isTTY property documentation (SonaySevik) [#16828](https://github.com/nodejs/node/pull/16828)
* [[`6739f41f2d`](https://github.com/nodejs/node/commit/6739f41f2d)] - **doc**: fix json generator warnings (Luigi Pinca) [#16742](https://github.com/nodejs/node/pull/16742)
* [[`2bb148f7bb`](https://github.com/nodejs/node/commit/2bb148f7bb)] - **doc**: make stream.Readable consistent (Sakthipriyan Vairamani (thefourtheye)) [#16786](https://github.com/nodejs/node/pull/16786)
* [[`e05d4f43b6`](https://github.com/nodejs/node/commit/e05d4f43b6)] - **doc**: correct effects to affects (gowpen) [#16794](https://github.com/nodejs/node/pull/16794)
* [[`d7df4dfa1c`](https://github.com/nodejs/node/commit/d7df4dfa1c)] - **doc**: correct EventEmitter reference (gowpen) [#16791](https://github.com/nodejs/node/pull/16791)
* [[`77e4ec8c51`](https://github.com/nodejs/node/commit/77e4ec8c51)] - **doc**: update license to include node-inspect (Myles Borins) [#16659](https://github.com/nodejs/node/pull/16659)
* [[`7388144dbc`](https://github.com/nodejs/node/commit/7388144dbc)] - **doc**: add 9.x to version picker and mark 8.x as LTS (Chris Young) [#16672](https://github.com/nodejs/node/pull/16672)
* [[`e585c41487`](https://github.com/nodejs/node/commit/e585c41487)] - **doc**: add docs for Zlib#close() (Luigi Pinca) [#16592](https://github.com/nodejs/node/pull/16592)
* [[`d5ea177652`](https://github.com/nodejs/node/commit/d5ea177652)] - **doc**: add nodejs/gyp team for GYP related issues (Gibson Fahnestock) [#16638](https://github.com/nodejs/node/pull/16638)
* [[`09181eb976`](https://github.com/nodejs/node/commit/09181eb976)] - **doc**: add details about rss on process.memoryUsage (Anthony Nandaa) [#16566](https://github.com/nodejs/node/pull/16566)
* [[`3fd7eddb44`](https://github.com/nodejs/node/commit/3fd7eddb44)] - **doc**: add windowsVerbatimArguments docs (Andrew Stucki) [#16299](https://github.com/nodejs/node/pull/16299)
* [[`1771bb5039`](https://github.com/nodejs/node/commit/1771bb5039)] - **doc**: fix Changelog link order (Gibson Fahnestock) [#16632](https://github.com/nodejs/node/pull/16632)
* [[`6ee28b2823`](https://github.com/nodejs/node/commit/6ee28b2823)] - **doc**: util.isDeepStrictEqual returns boolean (Lucas Azzola) [#16653](https://github.com/nodejs/node/pull/16653)
* [[`59a4789eee`](https://github.com/nodejs/node/commit/59a4789eee)] - **doc**: howto decode buffers extending from Writable (dicearr) [#16403](https://github.com/nodejs/node/pull/16403)
* [[`d733dd9468`](https://github.com/nodejs/node/commit/d733dd9468)] - **doc**: add *-inl.h include rule to C++ style guide (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`1cef9ef1de`](https://github.com/nodejs/node/commit/1cef9ef1de)] - **doc**: make default values and periods consistent (Matej Krajčovič) [#16563](https://github.com/nodejs/node/pull/16563)
* [[`77f0359708`](https://github.com/nodejs/node/commit/77f0359708)] - **http**: use 'connect' event only if socket is connecting (Luigi Pinca) [#16725](https://github.com/nodejs/node/pull/16725)
* [[`9c39d79908`](https://github.com/nodejs/node/commit/9c39d79908)] - **http**: use arrow fns for lexical `this` in Agent (Bryan English) [#16475](https://github.com/nodejs/node/pull/16475)
* [[`1b090c9b66`](https://github.com/nodejs/node/commit/1b090c9b66)] - **http, http2**: add 103 Early Hints status code (Yosuke Furukawa) [#16644](https://github.com/nodejs/node/pull/16644)
* [[`d6d461003f`](https://github.com/nodejs/node/commit/d6d461003f)] - **http, tls**: better support for IPv6 addresses (Mattias Holmlund) [#14772](https://github.com/nodejs/node/pull/14772)
* [[`762a11fab3`](https://github.com/nodejs/node/commit/762a11fab3)] - **http2**: improve errors thrown in header validation (Joyee Cheung) [#16718](https://github.com/nodejs/node/pull/16718)
* [[`72d0e7e70b`](https://github.com/nodejs/node/commit/72d0e7e70b)] - **http2**: refactor multiple internals (James M Snell) [#16676](https://github.com/nodejs/node/pull/16676)
* [[`e3283c71ce`](https://github.com/nodejs/node/commit/e3283c71ce)] - **http2**: allocate on every chunk send (James M Snell) [#16669](https://github.com/nodejs/node/pull/16669)
* [[`dfe56847ac`](https://github.com/nodejs/node/commit/dfe56847ac)] - **http2**: refactor settings handling (James M Snell) [#16668](https://github.com/nodejs/node/pull/16668)
* [[`bf7dc38ae4`](https://github.com/nodejs/node/commit/bf7dc38ae4)] - **http2**: make sessions garbage-collectible (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`3f529620cc`](https://github.com/nodejs/node/commit/3f529620cc)] - **http2**: remove unused assignment (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`b50c33470e`](https://github.com/nodejs/node/commit/b50c33470e)] - **http2**: track async state for sending (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`224ea159ae`](https://github.com/nodejs/node/commit/224ea159ae)] - **http2**: move uv_prepare handle to `Http2Session` (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`6074c8cdbb`](https://github.com/nodejs/node/commit/6074c8cdbb)] - **inspector**: include node_platform.h header (Alexey Kuzmin) [#16677](https://github.com/nodejs/node/pull/16677)
* [[`e0c7b3d13f`](https://github.com/nodejs/node/commit/e0c7b3d13f)] - **lib**: shuffle v8_prof_polyfill.js for unit testing (Ben Noordhuis) [#16769](https://github.com/nodejs/node/pull/16769)
* [[`c14030ec7a`](https://github.com/nodejs/node/commit/c14030ec7a)] - **lib**: fix version check in tick processor (Ben Noordhuis) [#16769](https://github.com/nodejs/node/pull/16769)
* [[`a0b94f4e12`](https://github.com/nodejs/node/commit/a0b94f4e12)] - **lib**: refactor ES module loader for readability (Anna Henningsen) [#16579](https://github.com/nodejs/node/pull/16579)
* [[`083a6e3830`](https://github.com/nodejs/node/commit/083a6e3830)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`05f90478fc`](https://github.com/nodejs/node/commit/05f90478fc)] - **repl**: avoid crashing from null and undefined errors (cPhost) [#16574](https://github.com/nodejs/node/pull/16574)
* [[`da66610798`](https://github.com/nodejs/node/commit/da66610798)] - **src**: fix -Winconsistent-missing-override warning (Ben Noordhuis) [#16726](https://github.com/nodejs/node/pull/16726)
* [[`6a2cb124e3`](https://github.com/nodejs/node/commit/6a2cb124e3)] - **src**: clean up uv_fs_t's in module_wrap.cc (cjihrig) [#16722](https://github.com/nodejs/node/pull/16722)
* [[`8a2b4ee7bb`](https://github.com/nodejs/node/commit/8a2b4ee7bb)] - **src**: remove unnecessary call to SetHiddenPrototype (Toon Verwaest) [#16554](https://github.com/nodejs/node/pull/16554)
* [[`a87f846cc1`](https://github.com/nodejs/node/commit/a87f846cc1)] - **src**: add method to compute storage in WriteWrap (Anna Henningsen) [#16727](https://github.com/nodejs/node/pull/16727)
* [[`a814786a06`](https://github.com/nodejs/node/commit/a814786a06)] - **src**: improve module loader readability (Anna Henningsen) [#16536](https://github.com/nodejs/node/pull/16536)
* [[`c40b3c6d2a`](https://github.com/nodejs/node/commit/c40b3c6d2a)] - **src**: add 'dynamic' process.release.lts property (Rod Vagg) [#16656](https://github.com/nodejs/node/pull/16656)
* [[`f3a65a85d9`](https://github.com/nodejs/node/commit/f3a65a85d9)] - **src**: pass context to Get() operations for cares_wrap (Evan Lucas) [#16641](https://github.com/nodejs/node/pull/16641)
* [[`4f8765d4c8`](https://github.com/nodejs/node/commit/4f8765d4c8)] - **src**: remove unused includes in string_bytes.h (Daniel Bevenius) [#16606](https://github.com/nodejs/node/pull/16606)
* [[`c4736cfcba`](https://github.com/nodejs/node/commit/c4736cfcba)] - **src**: fix etw provider include on Windows (Joyee Cheung) [#16639](https://github.com/nodejs/node/pull/16639)
* [[`f31b796175`](https://github.com/nodejs/node/commit/f31b796175)] - **src**: add `InternalCallbackScope` util constructor (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`97fd6df920`](https://github.com/nodejs/node/commit/97fd6df920)] - **src**: do not include x.h if x-inl.h is included (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`2294ba49be`](https://github.com/nodejs/node/commit/2294ba49be)] - **test**: tick processor version check regression test (Ben Noordhuis) [#16769](https://github.com/nodejs/node/pull/16769)
* [[`b44157378a`](https://github.com/nodejs/node/commit/b44157378a)] - **test**: use default assertion message (jonask) [#16819](https://github.com/nodejs/node/pull/16819)
* [[`a409b874d9`](https://github.com/nodejs/node/commit/a409b874d9)] - **test**: improve message in test-fs-readfile-pipe-large (fjau) [#16840](https://github.com/nodejs/node/pull/16840)
* [[`527dddac2f`](https://github.com/nodejs/node/commit/527dddac2f)] - **test**: remove custom message from assertion (Nicolas Morel) [#16824](https://github.com/nodejs/node/pull/16824)
* [[`a85d6e9be8`](https://github.com/nodejs/node/commit/a85d6e9be8)] - **test**: show incorrect value on test failure (Sean Karson) [#16818](https://github.com/nodejs/node/pull/16818)
* [[`50d505c188`](https://github.com/nodejs/node/commit/50d505c188)] - **test**: include file mode in assert message (Sascha Tandel) [#16815](https://github.com/nodejs/node/pull/16815)
* [[`5f88543778`](https://github.com/nodejs/node/commit/5f88543778)] - **test**: refactor tls test to use fixtres.readSync (Brian O'Connell) [#16816](https://github.com/nodejs/node/pull/16816)
* [[`d054e94fdc`](https://github.com/nodejs/node/commit/d054e94fdc)] - **test**: add detailed message for assertion failure (Attila Gonda) [#16812](https://github.com/nodejs/node/pull/16812)
* [[`6831e42988`](https://github.com/nodejs/node/commit/6831e42988)] - **test**: use fixtures module in test-repl (Maring, Damian Lion) [#16809](https://github.com/nodejs/node/pull/16809)
* [[`ef679803a0`](https://github.com/nodejs/node/commit/ef679803a0)] - **test**: update test to use fixtures.readKey (Dara Hayes) [#16811](https://github.com/nodejs/node/pull/16811)
* [[`219ac4bde6`](https://github.com/nodejs/node/commit/219ac4bde6)] - **test**: fix typos in read-buffer tests (Jimi van der Woning) [#16834](https://github.com/nodejs/node/pull/16834)
* [[`e4b3c00e48`](https://github.com/nodejs/node/commit/e4b3c00e48)] - **test**: replace fixturesDir with usage of fixtures module (Octavian Ionescu) [#16810](https://github.com/nodejs/node/pull/16810)
* [[`021ccb4011`](https://github.com/nodejs/node/commit/021ccb4011)] - **test**: use default assertion messages (John Byrne) [#16808](https://github.com/nodejs/node/pull/16808)
* [[`2156828f20`](https://github.com/nodejs/node/commit/2156828f20)] - **test**: clarified assert message for test-require-json.js (Matthias Reis) [#16807](https://github.com/nodejs/node/pull/16807)
* [[`ec1b1108af`](https://github.com/nodejs/node/commit/ec1b1108af)] - **test**: replace common.fixturesDir with fixtures module (Dumitru Glavan) [#16803](https://github.com/nodejs/node/pull/16803)
* [[`700c5e7795`](https://github.com/nodejs/node/commit/700c5e7795)] - **test**: replace common.fixturesDir with fixtures.readSync() (Adri Van Houdt) [#16802](https://github.com/nodejs/node/pull/16802)
* [[`bcd818af2a`](https://github.com/nodejs/node/commit/bcd818af2a)] - **test**: replace `common.fixturesDir` usage (Sascha Tandel) [#16800](https://github.com/nodejs/node/pull/16800)
* [[`f3e63f254c`](https://github.com/nodejs/node/commit/f3e63f254c)] - **test**: update test to use fixtures (Adam Wegrzynek) [#16799](https://github.com/nodejs/node/pull/16799)
* [[`0ab3d37be5`](https://github.com/nodejs/node/commit/0ab3d37be5)] - **test**: refactor exitedAfterDisconnect test (Rich Trott) [#16729](https://github.com/nodejs/node/pull/16729)
* [[`26f1a1d9e9`](https://github.com/nodejs/node/commit/26f1a1d9e9)] - **test**: fix test-cli-node-options on Windows (Anna Henningsen) [#16709](https://github.com/nodejs/node/pull/16709)
* [[`fc58c5231f`](https://github.com/nodejs/node/commit/fc58c5231f)] - **test**: fix malformed parallel.status line (Rich Trott) [#16702](https://github.com/nodejs/node/pull/16702)
* [[`689c9d401e`](https://github.com/nodejs/node/commit/689c9d401e)] - **test**: mark test-async-wrap-uncaughtexception as flaky (Refael Ackermann) [#16694](https://github.com/nodejs/node/pull/16694)
* [[`0b337cbee8`](https://github.com/nodejs/node/commit/0b337cbee8)] - **test**: fix flaky test-http2-server-rst-stream.js (Anatoli Papirovski) [#16690](https://github.com/nodejs/node/pull/16690)
* [[`5077faffaa`](https://github.com/nodejs/node/commit/5077faffaa)] - **test**: pause child until parent is ready (jBarz) [#15774](https://github.com/nodejs/node/pull/15774)
* [[`d178c6dc91`](https://github.com/nodejs/node/commit/d178c6dc91)] - **test**: update process-release for Node 8 Carbon (Jeremiah Senkpiel) [#16656](https://github.com/nodejs/node/pull/16656)
* [[`ffe4d7b468`](https://github.com/nodejs/node/commit/ffe4d7b468)] - **test**: increase coverage for ModuleMap (Rob Paton) [#16045](https://github.com/nodejs/node/pull/16045)
* [[`f9b2099d51`](https://github.com/nodejs/node/commit/f9b2099d51)] - **test**: use fixtures module in test-https-pfx (Ken Takagi) [#15895](https://github.com/nodejs/node/pull/15895)
* [[`6998591be7`](https://github.com/nodejs/node/commit/6998591be7)] - **test,net**: remove scatological terminology (Rich Trott) [#16599](https://github.com/nodejs/node/pull/16599)
* [[`87b4e3ed49`](https://github.com/nodejs/node/commit/87b4e3ed49)] - **tls**: accept array of protocols in TLSSocket (Mark S. Everitt) [#16655](https://github.com/nodejs/node/pull/16655)
* [[`e9396d28b1`](https://github.com/nodejs/node/commit/e9396d28b1)] - **tools**: remove unneeded parentheses in doc/html.js (Vse Mozhet Byt) [#16845](https://github.com/nodejs/node/pull/16845)
* [[`6e22dc817f`](https://github.com/nodejs/node/commit/6e22dc817f)] - **tools**: replace string concatenation with template literals (Kevin Yu) [#16804](https://github.com/nodejs/node/pull/16804)
* [[`e781d93bd0`](https://github.com/nodejs/node/commit/e781d93bd0)] - **tools**: replace string concatenation with template literals (Giovanni Lela) [#16806](https://github.com/nodejs/node/pull/16806)
* [[`422d3158ee`](https://github.com/nodejs/node/commit/422d3158ee)] - **tools**: replace string concetation with templates (Patrick Heneise) [#16801](https://github.com/nodejs/node/pull/16801)
* [[`fa5a8419c7`](https://github.com/nodejs/node/commit/fa5a8419c7)] - **tools**: update to ESLint 4.10.0 (cjihrig) [#16738](https://github.com/nodejs/node/pull/16738)
* [[`326a048a5c`](https://github.com/nodejs/node/commit/326a048a5c)] - **tools**: add fixer for no-let-in-for-declaration (Weijia Wang) [#16642](https://github.com/nodejs/node/pull/16642)
* [[`d6a0ffe367`](https://github.com/nodejs/node/commit/d6a0ffe367)] - **zlib**: warn before crash on invalid internals usage (Anna Henningsen) [#16657](https://github.com/nodejs/node/pull/16657)

<a id="9.0.0"></a>
## 2017-10-31, Version 9.0.0 (Current), @jasnell

### Notable Changes

* **Async hooks**
  * Older experimental APIs have been removed. [[`d731369b1d`](https://github.com/nodejs/node/commit/d731369b1d)] [#14414](https://github.com/nodejs/node/pull/14414)

* **Errors**
  * Improvements have been made to `buffer` module error messages. [[`9e0f771224`](https://github.com/nodejs/node/commit/9e0f771224)] [#14975](https://github.com/nodejs/node/pull/14975)
  * The assignment of static error codes to Node.js error continues:
    * `buffer`: [[`e79a61cf80`](https://github.com/nodejs/node/commit/e79a61cf80)] [#16352](https://github.com/nodejs/node/pull/16352), [[`dbfe8c4ea2`](https://github.com/nodejs/node/commit/dbfe8c4ea2)] [#13976](https://github.com/nodejs/node/pull/13976)
    * `child_process`: [[`fe730d34ce`](https://github.com/nodejs/node/commit/fe730d34ce)] [#14009](https://github.com/nodejs/node/pull/14009)
    * `console`: [[`0ecdf29340`](https://github.com/nodejs/node/commit/0ecdf29340)] [#11340](https://github.com/nodejs/node/pull/11340)
    * `crypto`: [[`ee76f3153b`](https://github.com/nodejs/node/commit/ee76f3153b)] [#16428](https://github.com/nodejs/node/pull/16428), [[`df8c6c3651`](https://github.com/nodejs/node/commit/df8c6c3651)] [#16453](https://github.com/nodejs/node/pull/16453), [[`0a03e350fb`](https://github.com/nodejs/node/commit/0a03e350fb)] [#16454](https://github.com/nodejs/node/pull/16454), [[`eeada6ca63`](https://github.com/nodejs/node/commit/eeada6ca63)] [#16448](https://github.com/nodejs/node/pull/16448), [[`a78327f48b`](https://github.com/nodejs/node/commit/a78327f48b)] [#16429](https://github.com/nodejs/node/pull/16429), [[`b8bc652869`](https://github.com/nodejs/node/commit/b8bc652869)] [#15757](https://github.com/nodejs/node/pull/15757), [[`7124b466d9`](https://github.com/nodejs/node/commit/7124b466d9)] [#15746](https://github.com/nodejs/node/pull/15746), [[`3ddc88b5c2`](https://github.com/nodejs/node/commit/3ddc88b5c2)] [#15756](https://github.com/nodejs/node/pull/15756)
    * `dns`: [[`9cb390d899`](https://github.com/nodejs/node/commit/9cb390d899)] [#14212](https://github.com/nodejs/node/pull/14212)
    * `events`: [[`e5ad5456a2`](https://github.com/nodejs/node/commit/e5ad5456a2)] [#15623](https://github.com/nodejs/node/pull/15623)
    * `fs`: [[`219932a9f7`](https://github.com/nodejs/node/commit/219932a9f7)] [#15043](https://github.com/nodejs/node/pull/15043), [[`b61cab2234`](https://github.com/nodejs/node/commit/b61cab2234)] [#11317](https://github.com/nodejs/node/pull/11317)
    * `http`: [[`11a2ca29ba`](https://github.com/nodejs/node/commit/11a2ca29ba)] [#14735](https://github.com/nodejs/node/pull/14735), [[`a9f798ebcc`](https://github.com/nodejs/node/commit/a9f798ebcc)] [#13301](https://github.com/nodejs/node/pull/13301), [[`bdfbce9241`](https://github.com/nodejs/node/commit/bdfbce9241)] [#14423](https://github.com/nodejs/node/pull/14423), [[`4843c2f415`](https://github.com/nodejs/node/commit/4843c2f415)] [#15603](https://github.com/nodejs/node/pull/15603)
    * `inspector`: [[`4cf56ad6f2`](https://github.com/nodejs/node/commit/4cf56ad6f2)] [#15619](https://github.com/nodejs/node/pull/15619)
    * `net`: [[`a03d8cee1f`](https://github.com/nodejs/node/commit/a03d8cee1f)] [#11356](https://github.com/nodejs/node/pull/11356), [[`7f55349079`](https://github.com/nodejs/node/commit/7f55349079)] [#14782](https://github.com/nodejs/node/pull/14782)
    * `path`: [[`dcfbbacba8`](https://github.com/nodejs/node/commit/dcfbbacba8)] [#11319](https://github.com/nodejs/node/pull/11319)
    * `process`: [[`a0f7284346`](https://github.com/nodejs/node/commit/a0f7284346)] [#13739](https://github.com/nodejs/node/pull/13739), [[`062071a9c3`](https://github.com/nodejs/node/commit/062071a9c3)] [#13285](https://github.com/nodejs/node/pull/13285), [[`3129b2c035`](https://github.com/nodejs/node/commit/3129b2c035)] [#13982](https://github.com/nodejs/node/pull/13982)
    * `querystring`: [[`9788e96836`](https://github.com/nodejs/node/commit/9788e96836)] [#15565](https://github.com/nodejs/node/pull/15565)
    * `readline`: [[`7f3f72c19b`](https://github.com/nodejs/node/commit/7f3f72c19b)] [#11390](https://github.com/nodejs/node/pull/11390)
    * `repl`: [[`aff8d358fa`](https://github.com/nodejs/node/commit/aff8d358fa)] [#11347](https://github.com/nodejs/node/pull/11347), [[`28227963fa`](https://github.com/nodejs/node/commit/28227963fa)] [#13299](https://github.com/nodejs/node/pull/13299)
    * `streams`: [[`d50a802feb`](https://github.com/nodejs/node/commit/d50a802feb)] [#13310](https://github.com/nodejs/node/pull/13310), [[`d2913384aa`](https://github.com/nodejs/node/commit/d2913384aa)] [#13291](https://github.com/nodejs/node/pull/13291), [[`6e86a6651c`](https://github.com/nodejs/node/commit/6e86a6651c)] [#16589](https://github.com/nodejs/node/pull/16589), [[`88fb359c57`](https://github.com/nodejs/node/commit/88fb359c57)] [#15042](https://github.com/nodejs/node/pull/15042), [[`db7d1339c3`](https://github.com/nodejs/node/commit/db7d1339c3)] [#15665](https://github.com/nodejs/node/pull/15665)
    * `string_decoder`: [[`eb4940e2d2`](https://github.com/nodejs/node/commit/eb4940e2d2)] [#14682](https://github.com/nodejs/node/pull/14682)
    * `timers`: [[`4d893e093a`](https://github.com/nodejs/node/commit/4d893e093a)] [#14659](https://github.com/nodejs/node/pull/14659)
    * `tls`: [[`f67aa566a6`](https://github.com/nodejs/node/commit/f67aa566a6)] [#13476](https://github.com/nodejs/node/pull/13476), [[`3ccfeb483d`](https://github.com/nodejs/node/commit/3ccfeb483d)] [#13994](https://github.com/nodejs/node/pull/13994)
    * `url`: [[`473f0eff29`](https://github.com/nodejs/node/commit/473f0eff29)] [#13963](https://github.com/nodejs/node/pull/13963)
    * `util`: [[`de4a749788`](https://github.com/nodejs/node/commit/de4a749788)] [#11301](https://github.com/nodejs/node/pull/11301), [[`1609899142`](https://github.com/nodejs/node/commit/1609899142)] [#13293](https://github.com/nodejs/node/pull/13293)
    * `v8`: [[`ef238fb485`](https://github.com/nodejs/node/commit/ef238fb485)] [#16535](https://github.com/nodejs/node/pull/16535)
    * `zlib`: [[`896eaf6820`](https://github.com/nodejs/node/commit/896eaf6820)] [#16540](https://github.com/nodejs/node/pull/16540), [[`74891412f1`](https://github.com/nodejs/node/commit/74891412f1)] [#15618](https://github.com/nodejs/node/pull/15618)

* **Child Processes**
  * Errors are emitted on process nextTick. [[`f2b01cba7b`](https://github.com/nodejs/node/commit/f2b01cba7b)] [#4670](https://github.com/nodejs/node/pull/4670)

* **Domains**
  * The long-deprecated `.dispose()` method has been removed [[`602fd36d95`](https://github.com/nodejs/node/commit/602fd36d95)] [#15412](https://github.com/nodejs/node/pull/15412)

* **fs**
  * The `fs.ReadStream` and `fs.WriteStream` classes now use `destroy()`. [[`e5c290bed9`](https://github.com/nodejs/node/commit/e5c290bed9)] [#15407](https://github.com/nodejs/node/pull/15407)
  * `fs` module callbacks are now invoked with an undefined context. [[`2249234fee`](https://github.com/nodejs/node/commit/2249234fee)] [#14645](https://github.com/nodejs/node/pull/14645)

* **HTTP/1**
  * A 400 Bad Request response will now be sent when parsing fails. [[`f2f391e575`](https://github.com/nodejs/node/commit/f2f391e575)] [#15324](https://github.com/nodejs/node/pull/15324)
  * Socket timeout will be set when the socket connects. [[`10be20a0e8`](https://github.com/nodejs/node/commit/10be20a0e8)] [#8895](https://github.com/nodejs/node/pull/8895)
  * A bug causing the request `'error'` event to fire twice was fixed. [[`620ba41694`](https://github.com/nodejs/node/commit/620ba41694)] [#14659](https://github.com/nodejs/node/pull/14659)
  * HTTP clients may now use generic `Duplex` streams in addition to `net.Socket`. [[`3e25e4d00f`](https://github.com/nodejs/node/commit/3e25e4d00f)] [#16267](https://github.com/nodejs/node/pull/16267)

* **Intl**
  * The deprecated `Intl.v8BreakIterator` has been removed. [[`668ad44922`](https://github.com/nodejs/node/commit/668ad44922)] [#15238](https://github.com/nodejs/node/pull/15238)

* **OS**
  * The `os.EOL` property is now read-only [[`f6caeb9526`](https://github.com/nodejs/node/commit/f6caeb9526)] [#14622](https://github.com/nodejs/node/pull/14622)

* **Timers**
  * `setTimeout()` will emit a warning if the timeout is larger that the maximum 32-bit unsigned integer. [[`ce3586da31`](https://github.com/nodejs/node/commit/ce3586da31)] [#15627](https://github.com/nodejs/node/pull/15627)

### Commits

#### Semver-Major

* [[`de4a749788`](https://github.com/nodejs/node/commit/de4a749788)] - **(SEMVER-MAJOR)** internal/util: use internal/errors.js (Sebastian Van Sande) [#11301](https://github.com/nodejs/node/pull/11301)
* [[`db2e093e05`](https://github.com/nodejs/node/commit/db2e093e05)] - **(SEMVER-MAJOR)** **assert**: handle enumerable symbol keys (Ruben Bridgewater) [#15169](https://github.com/nodejs/node/pull/15169)
* [[`b0d3bec95c`](https://github.com/nodejs/node/commit/b0d3bec95c)] - **(SEMVER-MAJOR)** **assert**: use Same-value equality in deepStrictEqual (Ruben Bridgewater) [#15398](https://github.com/nodejs/node/pull/15398)
* [[`e13d1df89b`](https://github.com/nodejs/node/commit/e13d1df89b)] - **(SEMVER-MAJOR)** **assert**: support custom errors (geek) [#15304](https://github.com/nodejs/node/pull/15304)
* [[`ea2e6363f2`](https://github.com/nodejs/node/commit/ea2e6363f2)] - **(SEMVER-MAJOR)** **assert**: use SameValueZero in deepStrictEqual (Ruben Bridgewater) [#15036](https://github.com/nodejs/node/pull/15036)
* [[`c53db1e8e9`](https://github.com/nodejs/node/commit/c53db1e8e9)] - **(SEMVER-MAJOR)** **assert**: show thrown message in doesNotThrow() (Ruslan Bekenev) [#12167](https://github.com/nodejs/node/pull/12167)
* [[`fc463639fa`](https://github.com/nodejs/node/commit/fc463639fa)] - **(SEMVER-MAJOR)** **assert**: fix assert.fail with zero arguments (Ruben Bridgewater) [#13974](https://github.com/nodejs/node/pull/13974)
* [[`07d71c94ef`](https://github.com/nodejs/node/commit/07d71c94ef)] - **(SEMVER-MAJOR)** **async_hooks**: enable runtime checks by default (Andreas Madsen) [#16318](https://github.com/nodejs/node/pull/16318)
* [[`d731369b1d`](https://github.com/nodejs/node/commit/d731369b1d)] - **(SEMVER-MAJOR)** **async_hooks**: remove deprecated APIs (Anna Henningsen) [#14414](https://github.com/nodejs/node/pull/14414)
* [[`97c43940c8`](https://github.com/nodejs/node/commit/97c43940c8)] - **(SEMVER-MAJOR)** **benchmark**: cover more nextTick() code (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`e79a61cf80`](https://github.com/nodejs/node/commit/e79a61cf80)] - **(SEMVER-MAJOR)** **buffer**: buffer.transcode to use internal/errors (Weijia Wang) [#16352](https://github.com/nodejs/node/pull/16352)
* [[`9e0f771224`](https://github.com/nodejs/node/commit/9e0f771224)] - **(SEMVER-MAJOR)** **buffer**: improve error messages (Weijia Wang) [#14975](https://github.com/nodejs/node/pull/14975)
* [[`70832bc353`](https://github.com/nodejs/node/commit/70832bc353)] - **(SEMVER-MAJOR)** **build**: add V8 embedder version string (Michaël Zasso) [#15785](https://github.com/nodejs/node/pull/15785)
* [[`c5eb5bfc2e`](https://github.com/nodejs/node/commit/c5eb5bfc2e)] - **(SEMVER-MAJOR)** **build**: enable runtime linking (jBarz) [#15286](https://github.com/nodejs/node/pull/15286)
* [[`2062a69879`](https://github.com/nodejs/node/commit/2062a69879)] - **(SEMVER-MAJOR)** **build**: stop support building addons with VS 2013 (Michaël Zasso) [#14764](https://github.com/nodejs/node/pull/14764)
* [[`f2b01cba7b`](https://github.com/nodejs/node/commit/f2b01cba7b)] - **(SEMVER-MAJOR)** **child_process**: defer error to next tick (Tristian Flanagan) [#4670](https://github.com/nodejs/node/pull/4670)
* [[`fe730d34ce`](https://github.com/nodejs/node/commit/fe730d34ce)] - **(SEMVER-MAJOR)** **child_process**: use internal/errors (Tobias Nießen) [#14009](https://github.com/nodejs/node/pull/14009)
* [[`448c4c62d2`](https://github.com/nodejs/node/commit/448c4c62d2)] - **(SEMVER-MAJOR)** **child_process**: do not extend result for *Sync() (Brian White) [#13601](https://github.com/nodejs/node/pull/13601)
* [[`1fcb76e8f2`](https://github.com/nodejs/node/commit/1fcb76e8f2)] - **(SEMVER-MAJOR)** **cluster**: remove deprecated property (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`4da8b99a74`](https://github.com/nodejs/node/commit/4da8b99a74)] - **(SEMVER-MAJOR)** **console**: coerce label to string in console.time() (James M Snell) [#14643](https://github.com/nodejs/node/pull/14643)
* [[`ee76f3153b`](https://github.com/nodejs/node/commit/ee76f3153b)] - **(SEMVER-MAJOR)** **crypto**: migrate setFipsCrypto to internal/errors (James M Snell) [#16428](https://github.com/nodejs/node/pull/16428)
* [[`df8c6c3651`](https://github.com/nodejs/node/commit/df8c6c3651)] - **(SEMVER-MAJOR)** **crypto**: use CHECK instead in getSSLCiphers (James M Snell) [#16453](https://github.com/nodejs/node/pull/16453)
* [[`0a03e350fb`](https://github.com/nodejs/node/commit/0a03e350fb)] - **(SEMVER-MAJOR)** **crypto**: migrate crypto.randomBytes to internal/errors (James M Snell) [#16454](https://github.com/nodejs/node/pull/16454)
* [[`eeada6ca63`](https://github.com/nodejs/node/commit/eeada6ca63)] - **(SEMVER-MAJOR)** **crypto**: migrate timingSafeEqual to internal/errors (James M Snell) [#16448](https://github.com/nodejs/node/pull/16448)
* [[`a78327f48b`](https://github.com/nodejs/node/commit/a78327f48b)] - **(SEMVER-MAJOR)** **crypto**: migrate setEngine to internal/errors (James M Snell) [#16429](https://github.com/nodejs/node/pull/16429)
* [[`b8bc652869`](https://github.com/nodejs/node/commit/b8bc652869)] - **(SEMVER-MAJOR)** **crypto**: migrate crypto sign to internal/errors (James M Snell) [#15757](https://github.com/nodejs/node/pull/15757)
* [[`7124b466d9`](https://github.com/nodejs/node/commit/7124b466d9)] - **(SEMVER-MAJOR)** **crypto**: refactor argument validation for pbkdf2 (James M Snell) [#15746](https://github.com/nodejs/node/pull/15746)
* [[`3ddc88b5c2`](https://github.com/nodejs/node/commit/3ddc88b5c2)] - **(SEMVER-MAJOR)** **crypto**: migrate Certificate to internal/errors (James M Snell) [#15756](https://github.com/nodejs/node/pull/15756)
* [[`c75f87cc4c`](https://github.com/nodejs/node/commit/c75f87cc4c)] - **(SEMVER-MAJOR)** **crypto**: refactor the crypto module (James M Snell) [#15231](https://github.com/nodejs/node/pull/15231)
* [[`484bfa2e37`](https://github.com/nodejs/node/commit/484bfa2e37)] - **(SEMVER-MAJOR)** **crypto**: accept decimal Number in randomBytes (Benjamin Gruenbaum) [#15130](https://github.com/nodejs/node/pull/15130)
* [[`c39caa997c`](https://github.com/nodejs/node/commit/c39caa997c)] - **(SEMVER-MAJOR)** **deps**: backport 0f1dfae from V8 upstream (Tobias Tebbi) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`2780f01392`](https://github.com/nodejs/node/commit/2780f01392)] - **(SEMVER-MAJOR)** **deps**: backport b096c44 from upstream V8 (Michaël Zasso) [#15785](https://github.com/nodejs/node/pull/15785)
* [[`3d1b3df948`](https://github.com/nodejs/node/commit/3d1b3df948)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.2.414.32 (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`acb9b8f73c`](https://github.com/nodejs/node/commit/acb9b8f73c)] - **(SEMVER-MAJOR)** **deps**: backport b096c44 from upstream V8 (Michaël Zasso) [#15785](https://github.com/nodejs/node/pull/15785)
* [[`d82e1075db`](https://github.com/nodejs/node/commit/d82e1075db)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.1.534.36 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`0a66b223e1`](https://github.com/nodejs/node/commit/0a66b223e1)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.0.286.52 (Myles Borins) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`2db2857c72`](https://github.com/nodejs/node/commit/2db2857c72)] - **(SEMVER-MAJOR)** **deps**: cherry-pick 6d38f89 from upstream V8 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`bc8e4878c0`](https://github.com/nodejs/node/commit/bc8e4878c0)] - **(SEMVER-MAJOR)** **deps**: add missing include to V8 i18n.cc (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`9b4a891ca2`](https://github.com/nodejs/node/commit/9b4a891ca2)] - **(SEMVER-MAJOR)** **deps**: run memory hungry V8 test in exclusive mode (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`3dc8c3bed4`](https://github.com/nodejs/node/commit/3dc8c3bed4)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.9.211.32 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`1a452f1928`](https://github.com/nodejs/node/commit/1a452f1928)] - **(SEMVER-MAJOR)** **dgram,process,util**: refactor Error to TypeError (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`758a17f1d5`](https://github.com/nodejs/node/commit/758a17f1d5)] - **(SEMVER-MAJOR)** **dns**: return TypeError on invalid resolve() input (Rich Trott) [#13090](https://github.com/nodejs/node/pull/13090)
* [[`1789dcfc87`](https://github.com/nodejs/node/commit/1789dcfc87)] - **(SEMVER-MAJOR)** **doc**: add missing changelogs to assert docs (Ruben Bridgewater) [#15036](https://github.com/nodejs/node/pull/15036)
* [[`8ca9338655`](https://github.com/nodejs/node/commit/8ca9338655)] - **(SEMVER-MAJOR)** **doc**: document missing error types (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`3fab9f2cd7`](https://github.com/nodejs/node/commit/3fab9f2cd7)] - **(SEMVER-MAJOR)** **doc**: EOL deprecated API and update notes (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`602fd36d95`](https://github.com/nodejs/node/commit/602fd36d95)] - **(SEMVER-MAJOR)** **domain**: remove `.dispose()` (Anna Henningsen) [#15412](https://github.com/nodejs/node/pull/15412)
* [[`219932a9f7`](https://github.com/nodejs/node/commit/219932a9f7)] - **(SEMVER-MAJOR)** **errors**: convert 'fs' (matzavinos) [#15043](https://github.com/nodejs/node/pull/15043)
* [[`11a2ca29ba`](https://github.com/nodejs/node/commit/11a2ca29ba)] - **(SEMVER-MAJOR)** **errors**: migrate _http_outgoing (Weijia Wang) [#14735](https://github.com/nodejs/node/pull/14735)
* [[`9cb390d899`](https://github.com/nodejs/node/commit/9cb390d899)] - **(SEMVER-MAJOR)** **errors**: migrate dns to use internal/errors (Weijia Wang) [#14212](https://github.com/nodejs/node/pull/14212)
* [[`a03d8cee1f`](https://github.com/nodejs/node/commit/a03d8cee1f)] - **(SEMVER-MAJOR)** **errors**: migrate socket_list to internal/errors (Bougarfaoui El houcine) [#11356](https://github.com/nodejs/node/pull/11356)
* [[`f67aa566a6`](https://github.com/nodejs/node/commit/f67aa566a6)] - **(SEMVER-MAJOR)** **errors**: migrate tls_wrap to use internal/errors (Bidisha Pyne) [#13476](https://github.com/nodejs/node/pull/13476)
* [[`b61cab2234`](https://github.com/nodejs/node/commit/b61cab2234)] - **(SEMVER-MAJOR)** **errors**: port internal/fs errors to internal/errors (Gunar C. Gessner) [#11317](https://github.com/nodejs/node/pull/11317)
* [[`1698c8e165`](https://github.com/nodejs/node/commit/1698c8e165)] - **(SEMVER-MAJOR)** **errors**: fix and improve error types (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`3e178848a5`](https://github.com/nodejs/node/commit/3e178848a5)] - **(SEMVER-MAJOR)** **errors**: improve ERR_INVALID_ARG_TYPE (Ruben Bridgewater) [#13730](https://github.com/nodejs/node/pull/13730)
* [[`0ecdf29340`](https://github.com/nodejs/node/commit/0ecdf29340)] - **(SEMVER-MAJOR)** **errors**: migrate lib/console (mskec) [#11340](https://github.com/nodejs/node/pull/11340)
* [[`7f3f72c19b`](https://github.com/nodejs/node/commit/7f3f72c19b)] - **(SEMVER-MAJOR)** **errors, readline**: migrate to use internal/errors.js (Scott McKenzie) [#11390](https://github.com/nodejs/node/pull/11390)
* [[`aff8d358fa`](https://github.com/nodejs/node/commit/aff8d358fa)] - **(SEMVER-MAJOR)** **errors, repl**: migrate to use internal/errors.js (Dan Homola) [#11347](https://github.com/nodejs/node/pull/11347)
* [[`dbfe8c4ea2`](https://github.com/nodejs/node/commit/dbfe8c4ea2)] - **(SEMVER-MAJOR)** **errors,buffer**: port errors to internal/errors (starkwang) [#13976](https://github.com/nodejs/node/pull/13976)
* [[`a9f798ebcc`](https://github.com/nodejs/node/commit/a9f798ebcc)] - **(SEMVER-MAJOR)** **errors,http_server**: migrate to use internal/errors.js (Bidisha Pyne) [#13301](https://github.com/nodejs/node/pull/13301)
* [[`a0f7284346`](https://github.com/nodejs/node/commit/a0f7284346)] - **(SEMVER-MAJOR)** **errors,process**: fix error message of hrtime() (Tobias Nießen) [#13739](https://github.com/nodejs/node/pull/13739)
* [[`062071a9c3`](https://github.com/nodejs/node/commit/062071a9c3)] - **(SEMVER-MAJOR)** **errors,process**: migrate to use internal/errors.js (sreepurnajasti) [#13285](https://github.com/nodejs/node/pull/13285)
* [[`28227963fa`](https://github.com/nodejs/node/commit/28227963fa)] - **(SEMVER-MAJOR)** **errors,repl**: migrate to use internal/errors.js (sreepurnajasti) [#13299](https://github.com/nodejs/node/pull/13299)
* [[`d50a802feb`](https://github.com/nodejs/node/commit/d50a802feb)] - **(SEMVER-MAJOR)** **errors,stream-transform**: migrate to use internal/errors.js (sreepurnajasti) [#13310](https://github.com/nodejs/node/pull/13310)
* [[`d2913384aa`](https://github.com/nodejs/node/commit/d2913384aa)] - **(SEMVER-MAJOR)** **errors,stream_wrap**: use internal/errors.js (LAKSHMI SWETHA GOPIREDDY) [#13291](https://github.com/nodejs/node/pull/13291)
* [[`473f0eff29`](https://github.com/nodejs/node/commit/473f0eff29)] - **(SEMVER-MAJOR)** **errors,url**: port url errors to internal/errors (starkwang) [#13963](https://github.com/nodejs/node/pull/13963)
* [[`1609899142`](https://github.com/nodejs/node/commit/1609899142)] - **(SEMVER-MAJOR)** **errors,util**: migrate to use internal/errors.js (Bidisha Pyne) [#13293](https://github.com/nodejs/node/pull/13293)
* [[`e5ad5456a2`](https://github.com/nodejs/node/commit/e5ad5456a2)] - **(SEMVER-MAJOR)** **events**: migrate to internal/errors (James M Snell) [#15623](https://github.com/nodejs/node/pull/15623)
* [[`e5c290bed9`](https://github.com/nodejs/node/commit/e5c290bed9)] - **(SEMVER-MAJOR)** **fs**: refactor close to use destroy (Matteo Collina) [#15407](https://github.com/nodejs/node/pull/15407)
* [[`2249234fee`](https://github.com/nodejs/node/commit/2249234fee)] - **(SEMVER-MAJOR)** **fs**: invoke callbacks with undefined context (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`f2f391e575`](https://github.com/nodejs/node/commit/f2f391e575)] - **(SEMVER-MAJOR)** **http**: send 400 bad request on parse error (mog422) [#15324](https://github.com/nodejs/node/pull/15324)
* [[`10be20a0e8`](https://github.com/nodejs/node/commit/10be20a0e8)] - **(SEMVER-MAJOR)** **http**: set socket timeout when socket connects (Luigi Pinca) [#8895](https://github.com/nodejs/node/pull/8895)
* [[`620ba41694`](https://github.com/nodejs/node/commit/620ba41694)] - **(SEMVER-MAJOR)** **http**: don't double-fire the req error event (fengmk2) [#14659](https://github.com/nodejs/node/pull/14659)
* [[`156549d8ff`](https://github.com/nodejs/node/commit/156549d8ff)] - **(SEMVER-MAJOR)** **http**: disable OutgoingMessage pipe method (Roee Kasher) [#14358](https://github.com/nodejs/node/pull/14358)
* [[`2fa2a60721`](https://github.com/nodejs/node/commit/2fa2a60721)] - **(SEMVER-MAJOR)** **http**: simplify if statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`80c9ef0b6b`](https://github.com/nodejs/node/commit/80c9ef0b6b)] - **(SEMVER-MAJOR)** **http**: edit _storeHeader to check for Trailer header (Artur G Vieira) [#12990](https://github.com/nodejs/node/pull/12990)
* [[`f55ee6e24a`](https://github.com/nodejs/node/commit/f55ee6e24a)] - **(SEMVER-MAJOR)** **http2**: make --expose-http2 flag a non-op (James M Snell) [#15535](https://github.com/nodejs/node/pull/15535)
* [[`bdfbce9241`](https://github.com/nodejs/node/commit/bdfbce9241)] - **(SEMVER-MAJOR)** **http_client, errors**: migrate to internal/errors (Weijia Wang) [#14423](https://github.com/nodejs/node/pull/14423)
* [[`4843c2f415`](https://github.com/nodejs/node/commit/4843c2f415)] - **(SEMVER-MAJOR)** **https**: convert to using internal/errors (Rami Moshe) [#15603](https://github.com/nodejs/node/pull/15603)
* [[`4cf56ad6f2`](https://github.com/nodejs/node/commit/4cf56ad6f2)] - **(SEMVER-MAJOR)** **inspector**: migrate to internal/errors (James M Snell) [#15619](https://github.com/nodejs/node/pull/15619)
* [[`668ad44922`](https://github.com/nodejs/node/commit/668ad44922)] - **(SEMVER-MAJOR)** **intl**: unexpose Intl.v8BreakIterator (Ben Noordhuis) [#15238](https://github.com/nodejs/node/pull/15238)
* [[`c885ea727d`](https://github.com/nodejs/node/commit/c885ea727d)] - **(SEMVER-MAJOR)** **lib**: deprecate fd usage for fs.truncate(Sync) (r1cebank) [#15990](https://github.com/nodejs/node/pull/15990)
* [[`095357e26e`](https://github.com/nodejs/node/commit/095357e26e)] - **(SEMVER-MAJOR)** **lib**: tweak use of internal/errors (Ruben Bridgewater) [#13829](https://github.com/nodejs/node/pull/13829)
* [[`8520e6f280`](https://github.com/nodejs/node/commit/8520e6f280)] - **(SEMVER-MAJOR)** **lib**: fix urlObject parameter name in url.format (Eduardo Leggiero) [#14031](https://github.com/nodejs/node/pull/14031)
* [[`9836cf5717`](https://github.com/nodejs/node/commit/9836cf5717)] - **(SEMVER-MAJOR)** **lib**: lazy instantiation of fs.Stats dates (Daniel Pihlstrom) [#12818](https://github.com/nodejs/node/pull/12818)
* [[`234353a1b8`](https://github.com/nodejs/node/commit/234353a1b8)] - **(SEMVER-MAJOR)** **lib,src**: refactor buffer out of range index (larissayvette) [#11296](https://github.com/nodejs/node/pull/11296)
* [[`9d7574eef5`](https://github.com/nodejs/node/commit/9d7574eef5)] - **(SEMVER-MAJOR)** **module**: deprecate Module._debug (Jackson Tian) [#13948](https://github.com/nodejs/node/pull/13948)
* [[`a517466aa7`](https://github.com/nodejs/node/commit/a517466aa7)] - **(SEMVER-MAJOR)** **module**: mark DEP0019 as EOL and remove compat code (Roman Reiss) [#3384](https://github.com/nodejs/node/pull/3384)
* [[`7f55349079`](https://github.com/nodejs/node/commit/7f55349079)] - **(SEMVER-MAJOR)** **net**: convert to using internal/errors (matzavinos) [#14782](https://github.com/nodejs/node/pull/14782)
* [[`b24e269a48`](https://github.com/nodejs/node/commit/b24e269a48)] - **(SEMVER-MAJOR)** **net**: multiple listen() events fail silently (Eduard Bondarenko) [#13149](https://github.com/nodejs/node/pull/13149)
* [[`75a19fb379`](https://github.com/nodejs/node/commit/75a19fb379)] - **(SEMVER-MAJOR)** **net,child_process**: improve naming in internal code (Anna Henningsen) [#14449](https://github.com/nodejs/node/pull/14449)
* [[`f6caeb9526`](https://github.com/nodejs/node/commit/f6caeb9526)] - **(SEMVER-MAJOR)** **os**: make EOL configurable and read only (XadillaX) [#14622](https://github.com/nodejs/node/pull/14622)
* [[`1f8d527e94`](https://github.com/nodejs/node/commit/1f8d527e94)] - **(SEMVER-MAJOR)** **path**: deprecate internal _makeLong, replace (James M Snell) [#14956](https://github.com/nodejs/node/pull/14956)
* [[`dcfbbacba8`](https://github.com/nodejs/node/commit/dcfbbacba8)] - **(SEMVER-MAJOR)** **path**: use internal/errors.js (Sebastian Van Sande) [#11319](https://github.com/nodejs/node/pull/11319)
* [[`a253704446`](https://github.com/nodejs/node/commit/a253704446)] - **(SEMVER-MAJOR)** **process**: make `this` value consistent (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`43e105f645`](https://github.com/nodejs/node/commit/43e105f645)] - **(SEMVER-MAJOR)** **process**: improve hrtime() error message (Rich Trott) [#14324](https://github.com/nodejs/node/pull/14324)
* [[`3129b2c035`](https://github.com/nodejs/node/commit/3129b2c035)] - **(SEMVER-MAJOR)** **process**: use internal/errors in internalNextTick (Tobias Nießen) [#13982](https://github.com/nodejs/node/pull/13982)
* [[`9788e96836`](https://github.com/nodejs/node/commit/9788e96836)] - **(SEMVER-MAJOR)** **querystring**: convert to using internal/errors (Rami Moshe) [#15565](https://github.com/nodejs/node/pull/15565)
* [[`7a29f44071`](https://github.com/nodejs/node/commit/7a29f44071)] - **(SEMVER-MAJOR)** **repl**: deprecate REPLServer.prototype.memory (Lance Ball) [#16242](https://github.com/nodejs/node/pull/16242)
* [[`e416b3ee36`](https://github.com/nodejs/node/commit/e416b3ee36)] - **(SEMVER-MAJOR)** **repl**: deprecate turnOffEditorMode (Lance Ball) [#15136](https://github.com/nodejs/node/pull/15136)
* [[`ed1ba4580b`](https://github.com/nodejs/node/commit/ed1ba4580b)] - **(SEMVER-MAJOR)** **repl**: remove REPLServer.createContext side effects (Lance Ball) [#14331](https://github.com/nodejs/node/pull/14331)
* [[`2ca9f94e33`](https://github.com/nodejs/node/commit/2ca9f94e33)] - **(SEMVER-MAJOR)** **repl**: make REPLServer.bufferedCommand private (Lance Ball) [#13687](https://github.com/nodejs/node/pull/13687)
* [[`3d9e7bb1d4`](https://github.com/nodejs/node/commit/3d9e7bb1d4)] - **(SEMVER-MAJOR)** **repl**: remove unused function convertToContext (Nikolai Vavilov) [#13434](https://github.com/nodejs/node/pull/13434)
* [[`33b2b10b68`](https://github.com/nodejs/node/commit/33b2b10b68)] - **(SEMVER-MAJOR)** **src**: fix rename of entry frame in v8abbr.h (geek) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`8f9e738a69`](https://github.com/nodejs/node/commit/8f9e738a69)] - **(SEMVER-MAJOR)** **src**: update ustack offset identifiers (geek) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`205a4d2331`](https://github.com/nodejs/node/commit/205a4d2331)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 59 (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`ddc16e505b`](https://github.com/nodejs/node/commit/ddc16e505b)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 58 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`5f22375922`](https://github.com/nodejs/node/commit/5f22375922)] - **(SEMVER-MAJOR)** **src**: add support to pass flags to dlopen (Ezequiel Garcia) [#12794](https://github.com/nodejs/node/pull/12794)
* [[`784c6d40f8`](https://github.com/nodejs/node/commit/784c6d40f8)] - **(SEMVER-MAJOR)** **src**: use proper errors as coming from StringBytes (Anna Henningsen) [#14579](https://github.com/nodejs/node/pull/14579)
* [[`80ebb4282d`](https://github.com/nodejs/node/commit/80ebb4282d)] - **(SEMVER-MAJOR)** **src**: adjust windows abort behavior (Jared Kantrowitz) [#13947](https://github.com/nodejs/node/pull/13947)
* [[`db476fc8b5`](https://github.com/nodejs/node/commit/db476fc8b5)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 57 (Myles Borins) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`24709b2e4a`](https://github.com/nodejs/node/commit/24709b2e4a)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 56 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`6e86a6651c`](https://github.com/nodejs/node/commit/6e86a6651c)] - **(SEMVER-MAJOR)** **stream**: complete migration to internal/errors (Matteo Collina) [#16589](https://github.com/nodejs/node/pull/16589)
* [[`88fb359c57`](https://github.com/nodejs/node/commit/88fb359c57)] - **(SEMVER-MAJOR)** **stream**: migrate _stream_readable use error codes (Ben Halverson) [#15042](https://github.com/nodejs/node/pull/15042)
* [[`db7d1339c3`](https://github.com/nodejs/node/commit/db7d1339c3)] - **(SEMVER-MAJOR)** **stream**: migrate to internal/errors (Ruben Bridgewater) [#15665](https://github.com/nodejs/node/pull/15665)
* [[`4536128e7c`](https://github.com/nodejs/node/commit/4536128e7c)] - **(SEMVER-MAJOR)** **stream**: remove dead code (Ruben Bridgewater) [#15665](https://github.com/nodejs/node/pull/15665)
* [[`eb4940e2d2`](https://github.com/nodejs/node/commit/eb4940e2d2)] - **(SEMVER-MAJOR)** **string_decoder**: Migrate to use internal/errors (Weijia Wang) [#14682](https://github.com/nodejs/node/pull/14682)
* [[`a7487c92e2`](https://github.com/nodejs/node/commit/a7487c92e2)] - **(SEMVER-MAJOR)** **test**: fix message test after V8 upgrade (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`fca7e49e44`](https://github.com/nodejs/node/commit/fca7e49e44)] - **(SEMVER-MAJOR)** **test**: adjust windows failed alloc test to V8 6.2 (Bartosz Sosnowski) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`95c8df18f1`](https://github.com/nodejs/node/commit/95c8df18f1)] - **(SEMVER-MAJOR)** **test**: add test to verify ErrnoException path (Daniel Bevenius) [#13958](https://github.com/nodejs/node/pull/13958)
* [[`0d3ef5b0f8`](https://github.com/nodejs/node/commit/0d3ef5b0f8)] - **(SEMVER-MAJOR)** **test**: check `this` value for `nextTick()` (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`c6126b1308`](https://github.com/nodejs/node/commit/c6126b1308)] - **(SEMVER-MAJOR)** **test**: refactor test-fs-stat (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`eaaec57332`](https://github.com/nodejs/node/commit/eaaec57332)] - **(SEMVER-MAJOR)** **test**: use worker.exitedAfterDisconnect consistently (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`839faae45a`](https://github.com/nodejs/node/commit/839faae45a)] - **(SEMVER-MAJOR)** **timers**: cleanup extraneous property on Immediates (Jeremiah Senkpiel) [#16355](https://github.com/nodejs/node/pull/16355)
* [[`ce3586da31`](https://github.com/nodejs/node/commit/ce3586da31)] - **(SEMVER-MAJOR)** **timers**: warn on overflowed timeout duration (Jeremiah Senkpiel) [#15627](https://github.com/nodejs/node/pull/15627)
* [[`11f7dcf91e`](https://github.com/nodejs/node/commit/11f7dcf91e)] - **(SEMVER-MAJOR)** **timers**: do not expose .unref()._handle._list (Jeremiah Senkpiel) [#8422](https://github.com/nodejs/node/pull/8422)
* [[`4d893e093a`](https://github.com/nodejs/node/commit/4d893e093a)] - **(SEMVER-MAJOR)** **timers**: Migrate to use internal/errors (Weijia Wang) [#14659](https://github.com/nodejs/node/pull/14659)
* [[`468110b327`](https://github.com/nodejs/node/commit/468110b327)] - **(SEMVER-MAJOR)** **tls**: deprecate parseCertString & move to internal (XadillaX) [#14249](https://github.com/nodejs/node/pull/14249)
* [[`0f7c06eb2d`](https://github.com/nodejs/node/commit/0f7c06eb2d)] - **(SEMVER-MAJOR)** **tls**: fix object prototype type confusion (Ben Noordhuis) [#14447](https://github.com/nodejs/node/pull/14447)
* [[`a7dccd040d`](https://github.com/nodejs/node/commit/a7dccd040d)] - **(SEMVER-MAJOR)** **tls**: type checking for `key`, `cert` and `ca` options (Jimmy Cann) [#14807](https://github.com/nodejs/node/pull/14807)
* [[`3ccfeb483d`](https://github.com/nodejs/node/commit/3ccfeb483d)] - **(SEMVER-MAJOR)** **tls**: migrate tls.js to use internal/errors.js (Michael Dawson) [#13994](https://github.com/nodejs/node/pull/13994)
* [[`c88ba036b4`](https://github.com/nodejs/node/commit/c88ba036b4)] - **(SEMVER-MAJOR)** **url**: ensure search property is consistently null vs empty (Justin Beckwith) [#13606](https://github.com/nodejs/node/pull/13606)
* [[`b1c8f15c5f`](https://github.com/nodejs/node/commit/b1c8f15c5f)] - **(SEMVER-MAJOR)** **util**: use constructor name (Ruben Bridgewater) [#14886](https://github.com/nodejs/node/pull/14886)
* [[`3b0e800f18`](https://github.com/nodejs/node/commit/3b0e800f18)] - **(SEMVER-MAJOR)** **util**: make util.debuglog() consistent with doc (Vse Mozhet Byt) [#13841](https://github.com/nodejs/node/pull/13841)
* [[`58831b2f24`](https://github.com/nodejs/node/commit/58831b2f24)] - **(SEMVER-MAJOR)** **uv**: improvements to process.binding('uv') (James M Snell) [#14933](https://github.com/nodejs/node/pull/14933)
* [[`ef238fb485`](https://github.com/nodejs/node/commit/ef238fb485)] - **(SEMVER-MAJOR)** **v8**: migrate setFlagsFromString to internal/errors (James M Snell) [#16535](https://github.com/nodejs/node/pull/16535)
* [[`b3e5c4621d`](https://github.com/nodejs/node/commit/b3e5c4621d)] - **(SEMVER-MAJOR)** **v8**: add new to the throw statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`88e55fe5e0`](https://github.com/nodejs/node/commit/88e55fe5e0)] - **(SEMVER-MAJOR)** **vm**: deprecate vm.runInDebugContext (Josh Gavant) [#12815](https://github.com/nodejs/node/pull/12815)
* [[`896eaf6820`](https://github.com/nodejs/node/commit/896eaf6820)] - **(SEMVER-MAJOR)** **zlib**: finish migrating to internal/errors (James M Snell) [#16540](https://github.com/nodejs/node/pull/16540)
* [[`74891412f1`](https://github.com/nodejs/node/commit/74891412f1)] - **(SEMVER-MAJOR)** **zlib**: migrate to internal/errors (James M Snell) [#15618](https://github.com/nodejs/node/pull/15618)

#### Semver-Minor

* [[`3e25e4d00f`](https://github.com/nodejs/node/commit/3e25e4d00f)] - **(SEMVER-MINOR)** **http**: support generic `Duplex` streams (Anna Henningsen) [#16267](https://github.com/nodejs/node/pull/16267)
* [[`af3aa682ac`](https://github.com/nodejs/node/commit/af3aa682ac)] - **(SEMVER-MINOR)** **util**: add callbackify (Refael Ackermann) [#12712](https://github.com/nodejs/node/pull/12712)
* [[`36732084db`](https://github.com/nodejs/node/commit/36732084db)] - **(SEMVER-MINOR)** **util,assert**: expose util.isDeepStrictEqual() (Rich Trott) [#16084](https://github.com/nodejs/node/pull/16084)

#### Semver-Patch

* [[`6e86a70da2`](https://github.com/nodejs/node/commit/6e86a70da2)] - **assert**: replace many if's with if-else statement (kuroljov) [#14043](https://github.com/nodejs/node/pull/14043)
* [[`f8063d51d7`](https://github.com/nodejs/node/commit/f8063d51d7)] - **benchmark**: fix punycode test for --without-intl (Timothy Gu) [#16251](https://github.com/nodejs/node/pull/16251)
* [[`095c0de94d`](https://github.com/nodejs/node/commit/095c0de94d)] - **benchmark,lib,test**: use braces for multiline block (Rich Trott) [#13828](https://github.com/nodejs/node/pull/13828)
* [[`8172f4547e`](https://github.com/nodejs/node/commit/8172f4547e)] - **buffer**: move setupBufferJS to internal (Bryan English) [#16391](https://github.com/nodejs/node/pull/16391)
* [[`355523fcfb`](https://github.com/nodejs/node/commit/355523fcfb)] - **buffer**: refactor module.exports, imports (James M Snell) [#13807](https://github.com/nodejs/node/pull/13807)
* [[`e0340af455`](https://github.com/nodejs/node/commit/e0340af455)] - **buffer**: fix indentation nits (Rich Trott) [#14224](https://github.com/nodejs/node/pull/14224)
* [[`aa011a111d`](https://github.com/nodejs/node/commit/aa011a111d)] - ***Revert*** "**build**: don't add libraries when --enable-static" (Ben Noordhuis) [#14893](https://github.com/nodejs/node/pull/14893)
* [[`be63c26e8c`](https://github.com/nodejs/node/commit/be63c26e8c)] - **build**: don't add libraries when --enable-static (Daniel Bevenius) [#14837](https://github.com/nodejs/node/pull/14837)
* [[`556ebab30e`](https://github.com/nodejs/node/commit/556ebab30e)] - **child_process**: restore exec{File}Sync error props (Michaël Zasso) [#16060](https://github.com/nodejs/node/pull/16060)
* [[`9bc4f86201`](https://github.com/nodejs/node/commit/9bc4f86201)] - **crypto**: make createXYZ inlineable (Matteo Collina) [#16067](https://github.com/nodejs/node/pull/16067)
* [[`43e7e8d106`](https://github.com/nodejs/node/commit/43e7e8d106)] - **crypto**: remove useless if statement (Weijia Wang) [#15041](https://github.com/nodejs/node/pull/15041)
* [[`237067d54e`](https://github.com/nodejs/node/commit/237067d54e)] - **deps**: manually add 9.x support to npm (Myles Borins) [#16509](https://github.com/nodejs/node/pull/16509)
* [[`0ea8ff3deb`](https://github.com/nodejs/node/commit/0ea8ff3deb)] - **deps**: backport 4ca695819 from npm upstream (Myles Borins) [#16509](https://github.com/nodejs/node/pull/16509)
* [[`664512678d`](https://github.com/nodejs/node/commit/664512678d)] - ***Revert*** "**deps**: update V8 to 6.2.414.33" (Michaël Zasso) [#16513](https://github.com/nodejs/node/pull/16513)
* [[`d4033c1547`](https://github.com/nodejs/node/commit/d4033c1547)] - **deps**: update V8 to 6.2.414.33 (Michaël Zasso) [#16412](https://github.com/nodejs/node/pull/16412)
* [[`801e61ad5a`](https://github.com/nodejs/node/commit/801e61ad5a)] - **deps**: cherry-pick 37a3a15c3 from V8 upstream (Franziska Hinkelmann) [#16294](https://github.com/nodejs/node/pull/16294)
* [[`34d125f16c`](https://github.com/nodejs/node/commit/34d125f16c)] - **deps**: c-ares float, win ipv6 bad fec0 prefix (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`af171b7ba2`](https://github.com/nodejs/node/commit/af171b7ba2)] - **deps**: c-ares float, manual ares_ssize_t definition (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`13c74706ef`](https://github.com/nodejs/node/commit/13c74706ef)] - **deps**: upgrade to c-ares v1.13.0 (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`d0d1eba872`](https://github.com/nodejs/node/commit/d0d1eba872)] - **deps**: update license-builder & LICENSE for c-ares (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`a9f125449e`](https://github.com/nodejs/node/commit/a9f125449e)] - **deps**: upgrade to c-ares v1.12.0 (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`8dce05fa71`](https://github.com/nodejs/node/commit/8dce05fa71)] - **deps**: backport rehash strings after deserialization (Yang Guo) [#14345](https://github.com/nodejs/node/pull/14345)
* [[`785a9e5a57`](https://github.com/nodejs/node/commit/785a9e5a57)] - **deps**: cherry-pick 6cb999b97b from V8 upstream (Igor Sheludko) [#14188](https://github.com/nodejs/node/pull/14188)
* [[`31349e2245`](https://github.com/nodejs/node/commit/31349e2245)] - **deps**: cherry-pick 3f4536894ac from V8 upstream (ochang) [#13985](https://github.com/nodejs/node/pull/13985)
* [[`0ba74dbcc6`](https://github.com/nodejs/node/commit/0ba74dbcc6)] - **deps**: backport c0f1ff2 from upstream V8 (Michaël Zasso) [#13517](https://github.com/nodejs/node/pull/13517)
* [[`7cdcca7623`](https://github.com/nodejs/node/commit/7cdcca7623)] - **deps**: cherry-pick 866ee63 from upstream V8 (Michaël Zasso) [#13630](https://github.com/nodejs/node/pull/13630)
* [[`8f907b6baf`](https://github.com/nodejs/node/commit/8f907b6baf)] - **deps**: update V8 to 5.9.211.37 (Michaël Zasso) [#13631](https://github.com/nodejs/node/pull/13631)
* [[`554fa24916`](https://github.com/nodejs/node/commit/554fa24916)] - **deps**: cherry-pick f5fad6d from upstream v8 (daniel.bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`36ba9e6e0c`](https://github.com/nodejs/node/commit/36ba9e6e0c)] - **deps**: cherry-pick bfae9db from upstream v8 (Ben Noordhuis) [#12722](https://github.com/nodejs/node/pull/12722)
* [[`863d1922df`](https://github.com/nodejs/node/commit/863d1922df)] - **doc**: add link for stream.pipe() (Jon Moss) [#16593](https://github.com/nodejs/node/pull/16593)
* [[`fb477f3fa5`](https://github.com/nodejs/node/commit/fb477f3fa5)] - **doc**: add missing error codes (James M Snell) [#16450](https://github.com/nodejs/node/pull/16450)
* [[`1261b94a3f`](https://github.com/nodejs/node/commit/1261b94a3f)] - **doc**: fix unassigned deprecation code (James M Snell) [#15741](https://github.com/nodejs/node/pull/15741)
* [[`cd1b55a942`](https://github.com/nodejs/node/commit/cd1b55a942)] - **doc**: delete link to removed doc part (Vse Mozhet Byt) [#15510](https://github.com/nodejs/node/pull/15510)
* [[`a5916107dd`](https://github.com/nodejs/node/commit/a5916107dd)] - **doc**: fix wrong history entry in deepStrictEqual (hisener) [#15381](https://github.com/nodejs/node/pull/15381)
* [[`8b2c61c169`](https://github.com/nodejs/node/commit/8b2c61c169)] - **doc**: fix api docs style (Daijiro Wachi) [#13970](https://github.com/nodejs/node/pull/13970)
* [[`102e1aa4e3`](https://github.com/nodejs/node/commit/102e1aa4e3)] - **doc**: fix ordering error in errors.md (Rich Trott) [#13274](https://github.com/nodejs/node/pull/13274)
* [[`8a8a6865c0`](https://github.com/nodejs/node/commit/8a8a6865c0)] - **doc,net**: assign deprecation code (Anna Henningsen) [#14576](https://github.com/nodejs/node/pull/14576)
* [[`55d49eb3cc`](https://github.com/nodejs/node/commit/55d49eb3cc)] - **errors**: replace `.split()` with `.replace()` (Rich Trott) [#15545](https://github.com/nodejs/node/pull/15545)
* [[`cef6e1c55f`](https://github.com/nodejs/node/commit/cef6e1c55f)] - **errors**: refactor `invalidArgType()` (Rich Trott) [#15544](https://github.com/nodejs/node/pull/15544)
* [[`324aa6488f`](https://github.com/nodejs/node/commit/324aa6488f)] - **errors**: alphabetize error codes (Jon Moss) [#15083](https://github.com/nodejs/node/pull/15083)
* [[`fa73087fcf`](https://github.com/nodejs/node/commit/fa73087fcf)] - **errors**: keep error codes in alphabetical order (Weijia Wang) [#14242](https://github.com/nodejs/node/pull/14242)
* [[`873e2f270f`](https://github.com/nodejs/node/commit/873e2f270f)] - **errors**: add missing ERR_ prefix on util.callbackify error (James M Snell) [#13604](https://github.com/nodejs/node/pull/13604)
* [[`5f469446e1`](https://github.com/nodejs/node/commit/5f469446e1)] - **errors,tools**: ASCIIbetical instead of alphabetical (Refael Ackermann) [#15578](https://github.com/nodejs/node/pull/15578)
* [[`fe13e0077f`](https://github.com/nodejs/node/commit/fe13e0077f)] - **events**: onceWrapper apply directly with arguments (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`d5fb78982a`](https://github.com/nodejs/node/commit/d5fb78982a)] - **events**: use spread function param in emit (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`fd166a8759`](https://github.com/nodejs/node/commit/fd166a8759)] - **events**: return values directly in listeners (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`c8d4ff1d52`](https://github.com/nodejs/node/commit/c8d4ff1d52)] - **events**: remove unnecessary console instantiation (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`f61cc15c6a`](https://github.com/nodejs/node/commit/f61cc15c6a)] - **events**: stricter prop & variable checks for perf (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`5d99a9bf65`](https://github.com/nodejs/node/commit/5d99a9bf65)] - **http**: emit close as the last event in the client (Robert Nagy) [#15588](https://github.com/nodejs/node/pull/15588)
* [[`f912080bf2`](https://github.com/nodejs/node/commit/f912080bf2)] - ***Revert*** "**http2**: refactor error handling" (Rich Trott) [#15047](https://github.com/nodejs/node/pull/15047)
* [[`a6973a3811`](https://github.com/nodejs/node/commit/a6973a3811)] - ***Revert*** "**inspector**: rewrite inspector test helper" (Anna Henningsen) [#14777](https://github.com/nodejs/node/pull/14777)
* [[`2296b677fb`](https://github.com/nodejs/node/commit/2296b677fb)] - **inspector**: rewrite inspector test helper (Eugene Ostroukhov) [#14460](https://github.com/nodejs/node/pull/14460)
* [[`e6dfd59be0`](https://github.com/nodejs/node/commit/e6dfd59be0)] - **lib**: pass internalBinding more implicitly (Anna Henningsen) [#16218](https://github.com/nodejs/node/pull/16218)
* [[`a577bde917`](https://github.com/nodejs/node/commit/a577bde917)] - **lib**: fix off-by-one indentation (Rich Trott) [#14064](https://github.com/nodejs/node/pull/14064)
* [[`c474f88987`](https://github.com/nodejs/node/commit/c474f88987)] - **lib**: fix typos (Ruben Bridgewater) [#13741](https://github.com/nodejs/node/pull/13741)
* [[`ae6c7044c8`](https://github.com/nodejs/node/commit/ae6c7044c8)] - ***Revert*** "**lib**: lazy instantiation of fs.Stats dates" (Anna Henningsen) [#13256](https://github.com/nodejs/node/pull/13256)
* [[`45873d24e4`](https://github.com/nodejs/node/commit/45873d24e4)] - **module**: revert #3384 DEP0019 EOL (Myles Borins) [#16634](https://github.com/nodejs/node/pull/16634)
* [[`44256bb0aa`](https://github.com/nodejs/node/commit/44256bb0aa)] - **path**: fix incorrect use of ERR_INVALID_ARG_TYPE (Tobias Nießen) [#14011](https://github.com/nodejs/node/pull/14011)
* [[`c5f54b1fad`](https://github.com/nodejs/node/commit/c5f54b1fad)] - **repl**: remove internal frames from runtime errors (Lance Ball) [#15351](https://github.com/nodejs/node/pull/15351)
* [[`da40050b59`](https://github.com/nodejs/node/commit/da40050b59)] - **repl**: fix deprecation code (Ruben Bridgewater) [#15668](https://github.com/nodejs/node/pull/15668)
* [[`766506a2e9`](https://github.com/nodejs/node/commit/766506a2e9)] - **repl**: deprecate REPLServer.parseREPLKeyword (Lance Ball)
* [[`f0b871bada`](https://github.com/nodejs/node/commit/f0b871bada)] - **src**: remove unused warning in node_contextify (Michaël Zasso) [#16408](https://github.com/nodejs/node/pull/16408)
* [[`f1d6b04ac9`](https://github.com/nodejs/node/commit/f1d6b04ac9)] - **src**: use new V8 API in vm module (Franziska Hinkelmann) [#16293](https://github.com/nodejs/node/pull/16293)
* [[`2146c88bc7`](https://github.com/nodejs/node/commit/2146c88bc7)] - **src**: fix NewContext for --without-intl (Timothy Gu) [#16251](https://github.com/nodejs/node/pull/16251)
* [[`a84c3be075`](https://github.com/nodejs/node/commit/a84c3be075)] - **src**: unset `NODE_VERSION_IS_RELEASE` (Anna Henningsen) [#14005](https://github.com/nodejs/node/pull/14005)
* [[`1b54371c50`](https://github.com/nodejs/node/commit/1b54371c50)] - **stream**: use more explicit statements (Ruben Bridgewater) [#13863](https://github.com/nodejs/node/pull/13863)
* [[`9702ac5088`](https://github.com/nodejs/node/commit/9702ac5088)] - **test**: add test for WrapStream readStop (Ashish Kaila) [#16356](https://github.com/nodejs/node/pull/16356)
* [[`a37a0ad5f6`](https://github.com/nodejs/node/commit/a37a0ad5f6)] - **test**: add test for prop interceptors on sandbox (Michaël Zasso) [#16409](https://github.com/nodejs/node/pull/16409)
* [[`ed116dc3c6`](https://github.com/nodejs/node/commit/ed116dc3c6)] - **test**: fix test for inherited properties on vm (Franziska Hinkelmann) [#16411](https://github.com/nodejs/node/pull/16411)
* [[`438e7fdaf2`](https://github.com/nodejs/node/commit/438e7fdaf2)] - **test**: remove --harmony-sharedarraybuffer usage (Ben Smith) [#16343](https://github.com/nodejs/node/pull/16343)
* [[`cd5ee52d70`](https://github.com/nodejs/node/commit/cd5ee52d70)] - **test**: add tests for eslint rules (Teddy Katz) [#16138](https://github.com/nodejs/node/pull/16138)
* [[`16ed116203`](https://github.com/nodejs/node/commit/16ed116203)] - **test**: clean up string concat in dlopen-ping-pong (agilbert) [#15820](https://github.com/nodejs/node/pull/15820)
* [[`2e215f169a`](https://github.com/nodejs/node/commit/2e215f169a)] - **test**: fix and refactor test-http-invalid-urls (Rich Trott) [#15678](https://github.com/nodejs/node/pull/15678)
* [[`44d486500d`](https://github.com/nodejs/node/commit/44d486500d)] - **test**: increase coverage for internal/errors.js (Weijia Wang) [#15044](https://github.com/nodejs/node/pull/15044)
* [[`467385a49b`](https://github.com/nodejs/node/commit/467385a49b)] - **test**: use invalid host according to RFC2606 (Tobias Nießen) [#14863](https://github.com/nodejs/node/pull/14863)
* [[`f417add1f4`](https://github.com/nodejs/node/commit/f417add1f4)] - **test**: add test-benchmark-zlib (Rich Trott) [#14763](https://github.com/nodejs/node/pull/14763)
* [[`3566195196`](https://github.com/nodejs/node/commit/3566195196)] - **test**: replace concatenation with template literals (xeodou) [#14281](https://github.com/nodejs/node/pull/14281)
* [[`b923b9dee1`](https://github.com/nodejs/node/commit/b923b9dee1)] - **test**: replace string concat in test-child-process-constructor (mac-haojin) [#14283](https://github.com/nodejs/node/pull/14283)
* [[`2a621d4051`](https://github.com/nodejs/node/commit/2a621d4051)] - **test**: validate more properties in expectsError (Ruben Bridgewater) [#14058](https://github.com/nodejs/node/pull/14058)
* [[`5ffb5b6fce`](https://github.com/nodejs/node/commit/5ffb5b6fce)] - **test**: improve the test common documentation (Ruben Bridgewater) [#14148](https://github.com/nodejs/node/pull/14148)
* [[`1b2733f272`](https://github.com/nodejs/node/commit/1b2733f272)] - **test**: common.expectsError should be a must call (Ruben Bridgewater) [#14088](https://github.com/nodejs/node/pull/14088)
* [[`d69ecc6f51`](https://github.com/nodejs/node/commit/d69ecc6f51)] - ***Revert*** "**test**: improve test-process-kill-null for Windows" (Refael Ackermann) [#14142](https://github.com/nodejs/node/pull/14142)
* [[`d6fece1436`](https://github.com/nodejs/node/commit/d6fece1436)] - **test**: add optional throw fn to expectsError (Ruben Bridgewater) [#14089](https://github.com/nodejs/node/pull/14089)
* [[`44483b6898`](https://github.com/nodejs/node/commit/44483b6898)] - **test**: improve test-process-kill-null for Windows (starkwang) [#14099](https://github.com/nodejs/node/pull/14099)
* [[`5723b5dbbc`](https://github.com/nodejs/node/commit/5723b5dbbc)] - **tls**: improve TLSSocket & Server performance (Anatoli Papirovski) [#15575](https://github.com/nodejs/node/pull/15575)
* [[`1403d28e7d`](https://github.com/nodejs/node/commit/1403d28e7d)] - **tls**: re-allow falsey option values (Anna Henningsen) [#15131](https://github.com/nodejs/node/pull/15131)
* [[`5723c4c5f0`](https://github.com/nodejs/node/commit/5723c4c5f0)] - **tls**: replace forEach with for (Brian White) [#15053](https://github.com/nodejs/node/pull/15053)
* [[`193926ecab`](https://github.com/nodejs/node/commit/193926ecab)] - **tls,doc**: fix unallocated deprecation code (James M Snell) [#15534](https://github.com/nodejs/node/pull/15534)
* [[`76b8803630`](https://github.com/nodejs/node/commit/76b8803630)] - **tools**: add eslint rule for documented errors (James M Snell) [#16450](https://github.com/nodejs/node/pull/16450)
* [[`50fe1a8409`](https://github.com/nodejs/node/commit/50fe1a8409)] - **tools, benchmark**: test util benchmark (Sarah Meyer) [#16050](https://github.com/nodejs/node/pull/16050)
* [[`44f5523260`](https://github.com/nodejs/node/commit/44f5523260)] - **v8**: fix stack overflow in recursive method (Ben Noordhuis) [#12460](https://github.com/nodejs/node/pull/12460)
* [[`241eb6122e`](https://github.com/nodejs/node/commit/241eb6122e)] - **zlib**: gracefully set windowBits from 8 to 9 (Myles Borins) [#16511](https://github.com/nodejs/node/pull/16511)
* [[`2421984727`](https://github.com/nodejs/node/commit/2421984727)] - **zlib**: check cleanup return values (Anna Henningsen) [#14673](https://github.com/nodejs/node/pull/14673)
* [[`add4b0ab8c`](https://github.com/nodejs/node/commit/add4b0ab8c)] - **zlib**: improve performance (Brian White) [#13322](https://github.com/nodejs/node/pull/13322)
