#include "error.h"

const char * const warning_name[35] = {
	NULL,
	"bnd",
	"environment",
	"float-denorm",
	"float-overflow",
	"float-toolong",
	"float-underflow",
	"hle",
	"label-orphan",
	"label-redef",
	"label-redef-late",
	"lock",
	"macro-defaults",
	"macro-params-legacy",
	"macro-params-multi",
	"macro-params-single",
	"negative-rep",
	"number-overflow",
	"obsolete-nop",
	"obsolete-removed",
	"obsolete-valid",
	"phase",
	"pragma-bad",
	"pragma-empty",
	"pragma-na",
	"pragma-unknown",
	"ptr",
	"regsize",
	"unknown-warning",
	"user",
	"warn-stack-empty",
	"zeroing",
	"zext-reloc",
	"other",
	"all"
};

const struct warning_alias warning_alias[38] = {
	{ "all",                      WARN_IDX_ALL },
	{ "bad-pragma",               WARN_IDX_PRAGMA_BAD },
	{ "bnd",                      WARN_IDX_BND },
	{ "environment",              WARN_IDX_ENVIRONMENT },
	{ "float-denorm",             WARN_IDX_FLOAT_DENORM },
	{ "float-overflow",           WARN_IDX_FLOAT_OVERFLOW },
	{ "float-toolong",            WARN_IDX_FLOAT_TOOLONG },
	{ "float-underflow",          WARN_IDX_FLOAT_UNDERFLOW },
	{ "hle",                      WARN_IDX_HLE },
	{ "label-orphan",             WARN_IDX_LABEL_ORPHAN },
	{ "label-redef",              WARN_IDX_LABEL_REDEF },
	{ "label-redef-late",         WARN_IDX_LABEL_REDEF_LATE },
	{ "lock",                     WARN_IDX_LOCK },
	{ "macro-defaults",           WARN_IDX_MACRO_DEFAULTS },
	{ "macro-params-legacy",      WARN_IDX_MACRO_PARAMS_LEGACY },
	{ "macro-params-multi",       WARN_IDX_MACRO_PARAMS_MULTI },
	{ "macro-params-single",      WARN_IDX_MACRO_PARAMS_SINGLE },
	{ "negative-rep",             WARN_IDX_NEGATIVE_REP },
	{ "not-my-pragma",            WARN_IDX_PRAGMA_NA },
	{ "number-overflow",          WARN_IDX_NUMBER_OVERFLOW },
	{ "obsolete-nop",             WARN_IDX_OBSOLETE_NOP },
	{ "obsolete-removed",         WARN_IDX_OBSOLETE_REMOVED },
	{ "obsolete-valid",           WARN_IDX_OBSOLETE_VALID },
	{ "orphan-labels",            WARN_IDX_LABEL_ORPHAN },
	{ "other",                    WARN_IDX_OTHER },
	{ "phase",                    WARN_IDX_PHASE },
	{ "pragma-bad",               WARN_IDX_PRAGMA_BAD },
	{ "pragma-empty",             WARN_IDX_PRAGMA_EMPTY },
	{ "pragma-na",                WARN_IDX_PRAGMA_NA },
	{ "pragma-unknown",           WARN_IDX_PRAGMA_UNKNOWN },
	{ "ptr",                      WARN_IDX_PTR },
	{ "regsize",                  WARN_IDX_REGSIZE },
	{ "unknown-pragma",           WARN_IDX_PRAGMA_UNKNOWN },
	{ "unknown-warning",          WARN_IDX_UNKNOWN_WARNING },
	{ "user",                     WARN_IDX_USER },
	{ "warn-stack-empty",         WARN_IDX_WARN_STACK_EMPTY },
	{ "zeroing",                  WARN_IDX_ZEROING },
	{ "zext-reloc",               WARN_IDX_ZEXT_RELOC }
};

const char * const warning_help[35] = {
	NULL,
	"invalid BND prefixes",
	"nonexistent environment variable",
	"floating point denormal",
	"floating point overflow",
	"too many digits in floating-point number",
	"floating point underflow",
	"invalid HLE prefixes",
	"labels alone on lines without trailing `:\'",
	"label redefined to an identical value",
	"label (re)defined during code generation",
	"LOCK prefix on unlockable instructions",
	"macros with more default than optional parameters",
	"improperly calling multi-line macro for legacy support",
	"multi-line macro calls with wrong parameter count",
	"single-line macro calls with wrong parameter count",
	"regative %rep count",
	"numeric constant does not fit",
	"instruction obsolete and is a noop on the target CPU",
	"instruction obsolete and removed on the target CPU",
	"instruction obsolete but valid on the target CPU",
	"phase error during stabilization",
	"malformed %pragma",
	"empty %pragma directive",
	"%pragma not applicable to this compilation",
	"unknown %pragma facility or directive",
	"non-NASM keyword used in other assemblers",
	"register size specification ignored",
	"unknown warning in -W/-w or warning directive",
	"%warning directives",
	"warning stack empty",
	"RESx in initialized section becomes zero",
	"relocation zero-extended to match output format",
	"any warning not specifially mentioned above",
	"all possible warnings"
};

const uint8_t warning_default[34] = {
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_OFF,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_OFF,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_OFF,
	WARN_INIT_ERR,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_OFF,
	WARN_INIT_OFF,
	WARN_INIT_OFF,
	WARN_INIT_OFF,
	WARN_INIT_OFF,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_OFF,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON,
	WARN_INIT_ON
};

uint8_t warning_state[34];	/* Current state */
