/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Copyright (C) 2010  Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Emmanuele Bassi <ebassi@linux.intel.com>
 */

#pragma once

#if !defined(__CLUTTER_H_INSIDE__) && !defined(CLUTTER_COMPILATION)
#error "Only <clutter/clutter.h> can be included directly."
#endif

#include "clutter/clutter-constraint.h"
#include "clutter/clutter-path.h"

G_BEGIN_DECLS

#define CLUTTER_TYPE_PATH_CONSTRAINT    (clutter_path_constraint_get_type ())
#define CLUTTER_PATH_CONSTRAINT(obj)    (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLUTTER_TYPE_PATH_CONSTRAINT, ClutterPathConstraint))
#define CLUTTER_IS_PATH_CONSTRAINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLUTTER_TYPE_PATH_CONSTRAINT))

typedef struct _ClutterPathConstraint           ClutterPathConstraint;
typedef struct _ClutterPathConstraintClass      ClutterPathConstraintClass;

CLUTTER_EXPORT
GType clutter_path_constraint_get_type (void) G_GNUC_CONST;

CLUTTER_EXPORT
ClutterConstraint *clutter_path_constraint_new        (ClutterPath           *path,
                                                       gfloat                 offset);

CLUTTER_EXPORT
void               clutter_path_constraint_set_path   (ClutterPathConstraint *constraint,
                                                       ClutterPath           *path);
CLUTTER_EXPORT
ClutterPath *      clutter_path_constraint_get_path   (ClutterPathConstraint *constraint);
CLUTTER_EXPORT
void               clutter_path_constraint_set_offset (ClutterPathConstraint *constraint,
                                                       gfloat                 offset);
CLUTTER_EXPORT
gfloat             clutter_path_constraint_get_offset (ClutterPathConstraint *constraint);

G_END_DECLS
